(*^

::[	frontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.1";
	macintoshStandardFontEncoding; 
	paletteColors = 128; alwaysUseMacCustomDithers; currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, R65535, e8,  28, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, cellOutline, groupLikeInput, M42, N23, bold, L-5, r58981, g58981, b58981,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; ;
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = leftheader, inactive, L2,  12, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; ;
	fontset = leftfooter, inactive, L2,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; ;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; ;
]
:[font = title; inactive; preserveAspect; ]
Schrdinger's Equation
(2-dimensional version)
:[font = subsubtitle; inactive; preserveAspect; ]
Terry Robb
<tdr@vaxc.cc.monash.edu.au>
:[font = text; inactive; preserveAspect; ]
This Notebook solves the two-dimensional time-dependent Schrdinger equation. Because some of the animations take up a large amount of space, I have only included the initial frame in all but the first experiment. Email to me <tdr@vaxc.cc.monash.edu.au> if you want the other animations, or if you want to see other experiments done.
:[font = text; inactive; preserveAspect; ]
Each of the numerical experiments took about 10 minutes to generate, with most of the time being taken up in rendering the animations.
:[font = text; inactive; preserveAspect; ]
See the Notebook on the one-dimensional time-dependent Schrdinger equation (also by me) for further comments relating to this application. This Notebook just contains the input and output lines, and no comments.
:[font = text; inactive; preserveAspect; ]
For yet more information about other symbolicnumeric applications involving the InterCall package and Mathematica just email a single line containing the words find InterCall to mathsource@wri.com.
;[s]
7:0,0;103,2;114,0;161,1;175,0;179,1;197,0;199,-1;
3:4,13,9,Times,0,12,0,0,0;2,13,9,Times,1,12,0,0,0;1,13,9,Times,2,12,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Setup
:[font = input; Cclosed; preserveAspect; startGroup; ]
<<InterCall.m
:[font = print; inactive; preserveAspect; endGroup; ]
  Loading InterCall version 2.0.
  Copyright (c) 1992 T. D. Robb.
:[font = input; preserveAspect; ]
InterCall["!schroedinger"];
:[font = input; preserveAspect; ]
AddDefault[
   SCHROED2D[$PSI->$PSI,$DT,$T->$T,
             $DX->($B-$A)/($N-1),$A,$B,$N->{$N1,$N2},
             $WRK:>Null,$TMP:>Null,
             $VFUNC->$VFUNC,$LINEARBC->$LINEARBC,
             $N1->ROWS[$PSI],$N2->COLS[$PSI],
             $M->Max[$N1,$N2] ],
   S[Z[$N1,$N2],R,R,R[2],R[2],R[2],I[2],Z[$M],Z[$M],
         RF[R,R],S[Z,Z,Z,Z,Z,Z,R,R[2],I],I,I,I],
   "schroed.o"];
:[font = input; Cclosed; preserveAspect; startGroup; ]
Import[{SCHROED2D}];
:[font = message; inactive; preserveAspect; ]
InterCall::opened: Opened connection to host (schroedinger)
:[font = message; inactive; preserveAspect; ]
InterCall::import: Importing: {SCHROED2D}
:[font = message; inactive; preserveAspect; endGroup; ]
InterCall::linked: 
   Using remote driver version 2.0 on host (schroedinger)
:[font = input; preserveAspect; startGroup; ]
AddDefault[CLAMP->Function[{a0,a1,ac,b0,b1,bc,t,x,k},
             a0=1; a1=0; ac=0; b0=1; b1=0; bc=0;],
           S[Z,Z,Z,Z,Z,Z,R,R[2],I] ];
SetDefault[schroed2d,
           $A->{0,0}, $B->{1,1}, $LINEARBC->CLAMP]
:[font = print; inactive; preserveAspect; ]
SCHROED2D[ (* TYPE=S *)
       $PSI -> $PSI,              (* DATA=Z[$N1, $N2] *)
       $DT -> In,                 (* DATA=R *)
       $T -> $T,                  (* DATA=R *)
       $DX -> ($B - $A)/($N - 1), (* DATA=R[2] *)
       $A -> {0, 0},              (* DATA=R[2] *)
       $B -> {1, 1},              (* DATA=R[2] *)
       $N -> {$N1, $N2},          (* DATA=I[2] *)
       $WRK :> Null,              (* DATA=Z[$M] *)
       $TMP :> Null,              (* DATA=Z[$M] *)
       $VFUNC -> $VFUNC,          (* DATA=RF[R, R] *)
       $LINEARBC -> CLAMP,        (* DATA=
         S[Z, Z, Z, Z, Z, Z, R, R[2], I] *)
       $N1 -> ROWS[$PSI],         (* DATA=I *)
       $N2 -> COLS[$PSI],         (* DATA=I *)
       $M -> Max[$N1, $N2]        (* DATA=I *)
      ] (* CODE="schroed.o" *)
:[font = output; output; inactive; preserveAspect; endGroup; ]
DefaultEntry[schroed2d, SCHROED2D, 
  {{$PSI, Hold[$PSI], None}, {$DT, Hold[In], None}, 
   {$T, Hold[$T], None}, 
   {$DX, Hold[($B - $A)/($N - 1)], None}, 
   {$A, Hold[{0, 0}], None}, {$B, Hold[{1, 1}], None}, 
   {$N, Hold[{$N1, $N2}], None}, 
   {$WRK, None, Keep[Null, #1 & ]}, 
   {$TMP, None, Keep[Null, #1 & ]}, 
   {$VFUNC, Hold[$VFUNC], None}, 
   {$LINEARBC, Hold[CLAMP], None}, 
   {$N1, Hold[ROWS[$PSI]], None}, 
   {$N2, Hold[COLS[$PSI]], None}, 
   {$M, Hold[Max[$N1, $N2]], None}}, S, 
  {Z[$N1, $N2], R, R, R[2], R[2], R[2], I[2], Z[$M], 
   Z[$M], RF[R, R], S[Z, Z, Z, Z, Z, Z, R, R[2], I], I, 
   I, I}, "schroed.o", {1, 12, 13, 5, 6, 7}]
;[o]
schroed2d[$DT_] -> Null
:[font = input; preserveAspect; ]
dx={0.01,0.01}; dt=dx.dx/4;
:[font = input; preserveAspect; endGroup; ]
plotit[] := Block[{psi=Peek[$PSI],t=Peek[$T]},
   ListDensityPlot[-Abs[psi]//Transpose, Mesh->False,
            PlotRange->{-7,0}, Epilog->drawpot,
            PlotLabel->PaddedForm[t/dt,{3,1}]];1; ];
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Experiment 1: Scattering
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Initial condition
:[font = input; preserveAspect; endGroup; ]
k = {64.0, 64.0}; a = 0.08^2; x0 = {0.25, 0.25};
psi0=Table[Block[{x={x1,x2}-x0}, Exp[I*k.x-x.x/(2*a)]],
           {x1,0,1,dx[[1]]},{x2,0,1,dx[[2]]}];
psi0=psi0/Sqrt[Plus@@(Plus@@(psi0*Conjugate[psi0]))*dx[[1]]*dx[[2]]];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Potential function
:[font = input; preserveAspect; ]
u0=4*k.k; {xp1,xp2}={0.5,0.5}; rpsqr=0.08^2;
potential = Function[{x,t},
   If[(x[[1]]-xp1)^2+(x[[2]]-xp2)^2 > rpsqr, 0, u0]];
:[font = input; preserveAspect; endGroup; ]
drawpot=Circle[{xp1,xp2}/dx,Sqrt[rpsqr]/dx];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; infiniteLoop; loopDistance = 1; ]
Animation
:[font = input; preserveAspect; ]
schroed2d[0, $PSI->psi0,$T->0,$VFUNC->potential];
:[font = input; preserveAspect; startGroup; ]
plotit[];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  0.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  0.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F8F8
F7F7F7F8F8F8F9F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F5
F4F4F4F5F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFBFAF8F7F6F5F4F3F2F1F1
F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F5F3F2F0EFEDECEC
EBEBEBECECEDEFF0F2F3F5F6F8F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E6E5
E5E5E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2F0EDEAE8E5E3E1DFDE
DDDDDDDEDFE1E3E5E8EAEDF0F2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F6F8F9FBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F1EDEAE6E2DED9D5D2CECCC9
C8C8C8C9CCCED2D5D9DEE2E6EAEDF1F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DBD6D1CCC7C3BFBD
BBBBBBBDBFC3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBF9F7F4F1EDE9E4DFD9D3CDC6C0BBB6B1AE
ACACACAEB1B6BBC0C6CDD3D9DFE4E9EDF1F4F7F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFBFAF8F5F2EEEAE5DFD9D2CAC3BBB4ADA7A29E
9C9B9C9EA2A7ADB4BBC3CAD2D9DFE5EAEEF2F5F8FAFBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFAF8F6F3F0EBE6E0D9D2C9C1B8AFA69E97918D
8A898A8D91979EA6AFB8C1C9D2D9E0E6EBF0F3F6F8FAFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F87807B
7877787B80878F98A2ACB7C1CAD3DBE2E8EDF1F5F7F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F6F3EFEAE5DED6CDC3B8ACA195897F756E68
646364686E757F8995A1ACB8C3CDD6DEE5EAEFF3F6F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFBFAF8F5F2EDE8E1D9D1C6BBAFA295887B6F645C55
515051555C646F7B8895A2AFBBC6D1D9E1E8EDF2F5F8FAFB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F7F4F0EBE5DED5CCC0B4A698897B6D5F544A43
3E3D3E434A545F6D7B8998A6B4C0CCD5DEE5EBF0F4F7F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F6F3EFE9E3DBD2C7BBAD9E8F7F6F5F51443A32
2D2B2D323A44515F6F7F8F9EADBBC7D2DBE3E9EFF3F6F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F2EDE8E1D8CEC3B6A7978775645444372B23
1E1C1E232B37445464758797A7B6C3CED8E1E8EDF2F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F1ECE6DFD6CCBFB1A291806E5C4A3A2B1F16
110F11161F2B3A4A5C6E8091A2B1BFCCD6DFE6ECF1F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF8F5F1ECE5DED4C9BDAE9E8D7B6855433223160D
0706070D1623324355687B8D9EAEBDC9D4DEE5ECF1F5F8FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9C8A7864513E2D1E1107
02000207111E2D3E5164788A9CACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9B897763503D2B1C0F06
000000060F1C2B3D506377899BACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9C8A7864513E2D1E1107
02000207111E2D3E5164788A9CACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF8F5F1ECE5DED4C9BDAE9E8D7B6855433223160D
0706070D1623324355687B8D9EAEBDC9D4DEE5ECF1F5F8FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F1ECE6DFD6CCBFB1A291806E5C4A3A2B1F16
110F11161F2B3A4A5C6E8091A2B1BFCCD6DFE6ECF1F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F2EDE8E1D8CEC3B6A7978775645444372B23
1E1C1E232B37445464758797A7B6C3CED8E1E8EDF2F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F6F3EFE9E3DBD2C7BBAD9E8F7F6F5F51443A32
2D2B2D323A44515F6F7F8F9EADBBC7D2DBE3E9EFF3F6F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F7F4F0EBE5DED5CCC0B4A698897B6D5F544A43
3E3D3E434A545F6D7B8998A6B4C0CCD5DEE5EBF0F4F7F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFBFAF8F5F2EDE8E1D9D1C6BBAFA295887B6F645C55
515051555C646F7B8895A2AFBBC6D1D9E1E8EDF2F5F8FAFB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F6F3EFEAE5DED6CDC3B8ACA195897F756E68
646364686E757F8995A1ACB8C3CDD6DEE5EAEFF3F6F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F87807B
7877787B80878F98A2ACB7C1CAD3DBE2E8EDF1F5F7F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFAF8F6F3F0EBE6E0D9D2C9C1B8AFA69E97918D
8A898A8D91979EA6AFB8C1C9D2D9E0E6EBF0F3F6F8FAFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFBFAF8F5F2EEEAE5DFD9D2CAC3BBB4ADA7A29E
9C9B9C9EA2A7ADB4BBC3CAD2D9DFE5EAEEF2F5F8FAFBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBF9F7F4F1EDE9E4DFD9D3CDC6C0BBB6B1AE
ACACACAEB1B6BBC0C6CDD3D9DFE4E9EDF1F4F7F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DBD6D1CCC7C3BFBD
BBBBBBBDBFC3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F1EDEAE6E2DED9D5D2CECCC9
C8C8C8C9CCCED2D5D9DEE2E6EAEDF1F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F6F8F9FBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2F0EDEAE8E5E3E1DFDE
DDDDDDDEDFE1E3E5E8EAEDF0F2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E6E5
E5E5E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F5F3F2F0EFEDECEC
EBEBEBECECEDEFF0F2F3F5F6F8F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFBFAF8F7F6F5F4F3F2F1F1
F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F5
F4F4F4F5F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F8F8
F7F7F7F8F8F8F9F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = input; Cclosed; preserveAspect; startGroup; ]
Do[Do[schroed2d[dt],{5}]; plotit[], {15}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  5.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  5.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFCFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3
F2F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECEBEBEBEBEBECEDEEF0F1F3F5F6F7F9FAFBFCFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9
E7E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2
E0DEDDDCDCDCDDDFE0E3E5E8EAEDEFF2F4F6F8F9FBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F3F1EEEBE7E4E1DDDA
D8D5D4D3D2D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E5E1DDD9D5D1
CDCBC9C7C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E4DFDAD5D0CAC6
C2BEBCBABABABCBFC2C6CBD0D5DBE0E5E9EDF0F4F6F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F7F4F1EDE9E4DED8D2CCC5BFB9
B4B0ADABABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F2EEE9E4DED8D1C9C1BAB2AC
A6A19D9B9A9B9EA1A6ADB3BBC2CAD1D8DFE5EAEEF2F5F7F9
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DFD8D1C8BFB6ADA59D
96908C8988898C91979EA6AFB8C1C9D1D9E0E6EBEFF3F6F8
FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F4F1EDE7E1DAD2C9BFB5ABA0968D
857E797675777A7F868E98A2ACB7C1CAD3DBE2E8EDF1F4F7
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFAF8F6F3EFEAE4DDD5CCC1B6AB9F93887D
746C66636263676D757E8995A0ACB8C3CDD6DEE4EAEFF3F6
F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE7E1D9D0C5BAADA09386796D
625A53504E50545B646F7B8795A2AFBBC6D0D9E1E8EDF1F5
F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE5DDD5CABFB2A59688796B5D
5248413D3C3D424A535F6D7B8998A6B4C0CBD5DEE5EBF0F4
F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFBF9F6F3EEE9E2DAD1C6B9AC9D8D7D6D5D4F
4338302C2A2C313A4451606F7F8F9FADBBC7D2DBE3E9EEF3
F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D8CDC2B4A6968574625243
352A221D1B1D232B37455465768798A7B6C3CED8E1E8EDF2
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DED5CBBEB0A1907E6C5A4838
2A1E15100F1117202C3A4B5C6E8092A2B2BFCCD6DFE6ECF1
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE5DDD4C9BCAD9D8C7966534130
22150C0705080E1724334456697C8E9FAFBDCAD4DEE5ECF1
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD3C7BAAB9B897663503D2C
1D100701000208121F2E405265798B9DADBCC8D4DDE5EBF0
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD2C7BAAB9A8875624E3C2A
1B0F0500000007101D2D3E5164788A9CACBBC8D3DDE5EBF0
F4F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD3C8BAAC9B897763503D2C
1D110802000309121F2F405366798B9DADBCC9D4DDE5EBF0
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF7F4F0EBE5DDD4C9BCAE9E8C7A67544231
23170E0807090F1825344557697C8E9FAFBDCAD5DEE5ECF1
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DFD6CBBFB1A1917F6D5B4A3A
2B201712101218212D3C4C5D6F8193A3B2C0CCD6DFE6ECF1
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D8CEC2B5A6978675645344
372C241F1D1F252D39465666778899A8B6C3CFD9E1E8EDF2
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFBF9F6F3EEE9E3DBD1C6BAAD9E8E7E6F5F51
453A332E2D2F343C465361718090A0AEBBC7D2DBE3E9EFF3
F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE5DED5CBC0B3A698897B6D60
544B44403E40454C56616E7C8B9AA8B5C1CCD6DEE5EBF0F4
F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE8E1D9D0C6BBAFA295877B6F
655C56525153575D66717C8996A3B0BCC7D1DAE1E8EDF2F5
F8FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFAF9F6F3EFEAE4DDD5CCC2B8ACA095897F
766E69656466696F77808B96A2AEB9C4CDD6DEE5EBEFF3F6
F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F
87807C7978797C8188909AA3AEB8C2CBD4DBE2E8EDF1F5F7
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C1B8AFA69F
98928E8B8A8B8E9399A0A8B0B9C2CAD2DAE0E6EBF0F3F6F8
FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F2EEEAE5DFD8D1CAC3BBB4AD
A7A29F9D9C9D9FA3A8AEB5BCC4CBD2D9DFE5EAEEF2F5F8FA
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CDC6C0BB
B6B2AFADACADAFB2B6BBC1C7CDD4DADFE5EAEEF1F4F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F0EDE9E5E0DBD6D0CBC7
C3BFBDBCBBBCBDC0C3C7CCD1D6DBE0E5EAEDF0F4F7F9FAFB
FCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DED9D5D2
CECCCAC8C8C9CACCCFD2D6DADEE2E6EAEEF0F4F7F8F9FAFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E4E1DEDB
D8D6D4D4D3D4D5D6D9DBDEE1E5E8EBEEF1F4F7F8F8FAFBFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE8E5E3
E1DFDEDDDDDDDEDFE1E3E5E8EBEDF0F2F4F7F8F8FAFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9
E8E6E5E5E5E5E5E6E8E9EBEDEFF1F3F5F7F9F9FAFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECECEBEBEBECECEDEFF0F2F3F5F6F8F9FAFAFCFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3
F2F1F1F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFBFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFDFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFDFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 10.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 10.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFD
FDFCFCFCFCFCFBFBFBFCFCFCFCFCFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAFAF9F9F9FAFAFAFBFBFBFCFCFDFDFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
F9F9F8F8F7F7F7F7F7F7F7F8F8F9FAFAFBFCFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F7F6F6F5F4F4F4F4F4F4F4F5F6F7F7F8F9FAFBFCFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F6
F4F3F2F1F0F0F0EFF0F0F1F1F2F3F5F6F7F8F9FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAF8F7F5F4F2
F1EFEEECEBEBEAEAEAEBECEDEEEFF1F3F4F6F7F9FAFBFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF9F8F6F4F2F0EE
ECEAE8E6E5E4E4E3E4E4E5E7E9EBEDEFF1F3F5F6F8F9FBFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF9F7F5F3F1EEECE9
E6E4E1DFDDDCDBDBDCDDDEE0E2E4E7EAECEFF1F4F6F8F9FB
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0EDEAE6E3
DFDCD9D6D4D3D2D1D2D3D5D7DADDE0E4E7EBEEF1F3F6F8F9
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F3F0ECE8E4E0DC
D7D3CFCCC9C7C6C6C6C8CACDD0D4D9DDE1E5E9EDF0F3F5F8
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F3F0ECE8E3DED9D3
CEC9C4C0BDBAB9B9B9BBBEC1C6CAD0D5DADFE4E9EDF0F3F6
F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFDFCFAF8F6F3F0ECE8E3DDD7D1CA
C4BDB8B3AFACAAA9AAACB0B4B9BFC5CCD2D8DEE4E9EDF1F4
F6F8FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F4F1EDE8E3DDD6CFC8C0
B8B1AAA49F9B99999A9CA0A5ACB3BAC2C9D1D8DEE4E9EEF1
F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7CFC7BEB5
ACA39B948E8A8787888B90969DA5AEB7C0C9D1D8DFE5EBEF
F3F6F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F0ECE6E0D9D1C8BEB3A9
9E948B837C78757475797E858E97A1ACB6C0CAD2DAE1E7EC
F1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F6F2EEE9E3DCD3CAC0B5A99D
91867B726A65616162666C747E8994A0ACB7C2CCD5DDE4EA
EFF3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBF9F7F4F1ECE6DFD7CEC4B8AC9E91
84776B6158524E4D4F545A636E7A8794A2AFBBC6D0D9E1E7
EDF1F5F7FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F6F3EFEAE4DCD3C9BDB1A39486
77695C5047403C3B3D4249535F6C7B8998A6B4C0CBD5DDE5
EBF0F3F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F6F2EEE8E1D9CFC4B8AA9B8B7B
6B5C4D4137302B2A2C313A4451606F7F8F9EADBAC7D1DAE2
E9EEF2F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1ECE6DFD6CCC0B3A4948372
6150413429211C1B1D232C37455565768798A7B6C3CED8E0
E7EDF1F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DDD4C9BDAF9F8E7C6A
584737291E15100F1117212D3B4C5D6F8192A3B2BFCBD6DF
E6ECF1F5F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DCD3C7BAAC9B8A7865
52403021150D0706090F18253445576A7C8E9FAFBDC9D4DD
E5EBF0F4F7F9FBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4F0EAE4DBD2C6B9AA99877561
4E3C2B1C10070201030A132030415366798C9DADBCC8D3DD
E4EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4EFEAE3DBD1C6B9A999877461
4D3B2A1B0F0601000208121F2F405266798B9DADBBC8D3DC
E4EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4F0EAE4DCD2C6B9AA9A887562
4F3D2C1D11090302040B1521314254677A8C9EADBCC9D4DD
E5EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DDD3C8BBAC9C8B7966
54423123170F0A080B111A273647586B7D8FA0B0BECAD5DE
E5EBF0F4F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF7F4F1ECE5DED5CABEB0A0907E6C
5A493A2C21181312151A24303E4E5F718394A4B3C0CCD6DF
E6ECF1F5F8FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1EDE7E0D7CDC1B4A5968574
635344372D25201F2127303B48586879899AA9B7C4CFD8E1
E8EDF2F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF8F6F2EEE9E2DAD0C6B9AC9D8E7E
6E5F51453B34302F31363E485563728292A1AFBCC8D2DBE3
E9EFF3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F7F3EFEBE4DDD4CABFB3A59789
7A6C60554C45414042474E5863707E8D9BA8B5C2CDD6DEE5
EBF0F3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBFAF7F5F1EDE7E0D9D0C5BAAEA194
877B6F655D57535254585F68727E8B97A4B1BDC8D1D9E1E7
EDF1F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F6F3EFEAE4DDD5CCC2B7ACA0
94897F766F6A6666676B7179828D97A3AEBAC4CDD5DDE5EB
F0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F1ECE7E1DAD2C9C0B6AC
A2988F87817C79797A7D8289929BA4AEB9C3CBD3DBE4EAEE
F2F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DFD8D1C9C0B7
AFA69E98928E8C8B8C8F949AA1A8B1BAC3CAD1DAE3E8EBEE
F1F4F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F5F1EEE9E4DED8D1CAC2
BBB4ADA7A39F9D9D9EA0A4A9AFB5BDC4CBD1DAE2E6E7E9EF
F3F6F8FAFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F4F1EDE9E4DED8D2CC
C6C0BAB6B2AFADADADB0B3B7BCC2C8CDD3DBE2E4E4E9EEF9
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E4DFDAD5
D0CBC7C3BFBDBCBBBCBEC0C3C8CDD1D5DBE3E5E4EAF7FBFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F6F3F0EDE9E5E1DD
D9D5D1CECBC9C8C8C9CACCCFD2D6D9DDE4E8E6E8F8FDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F5F3F1EEEBE7E4
E1DDDAD8D6D4D3D3D4D5D6D8DCDEE1E5EAEAE8EFFBFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F1EFECEA
E7E5E2E0DFDDDDDCDDDEDFE1E3E5E7EBEEEDEEFAFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F5F3F1EF
EDEBE9E7E6E5E4E4E5E5E6E8E9EBEDF0F2F0F2FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F6F4F3
F1F0EEEDECEBEBEBEBEBECEDEFEFF1F4F4F3F6FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6
F5F3F2F1F1F0F0F0F0F0F1F2F3F3F5F7F7F6F8FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F7F7F6F5F5F4F4F4F4F4F5F5F6F6F8F9F9F8FAFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
FAF9F8F8F7F7F7F7F7F7F8F8F8F9FAFBFAFAFCFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAF9F9F9F9FAFAFAFAFBFCFCFCFCFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFD
FCFCFCFCFBFBFBFBFBFBFBFCFCFCFDFDFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FDFDFDFDFDFDFCFCFCFDFDFDFDFDFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFDFDFDFDFDFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 15.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 15.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFCFCFCFCFBFBFBFBFCFCFCFCFCFDFDFDFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFCFBFBFAFAFAF9F9F9F9F9FAFAFAFBFBFCFCFDFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAFAF9F8F8F7F7F7F6F6F7F7F7F8F8F9F9FAFBFBFCFDFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFA
F9F9F8F7F6F5F4F4F3F3F3F3F3F4F5F5F6F7F8F9FAFBFBFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9
F7F6F5F4F2F1F0F0EFEFEFEFEFF0F1F2F3F4F5F7F8F9FAFB
FCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F6
F5F3F1F0EEEDEBEAEAE9E9E9EAEBECEDEFF0F2F4F5F7F8F9
FBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F3
F1EFEDEBE9E7E5E4E3E2E2E3E3E4E6E8EAECEEF0F2F4F6F8
F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F5F3F0
EDEBE8E5E2E0DEDCDBDADADADBDDDFE1E3E6E9ECEEF1F3F5
F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4F2EFEC
E9E5E2DEDBD8D5D3D1D0D0D1D2D4D6D9DCDFE3E6EAEDF0F3
F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF9F7F4F2EFEBE7
E3DFDAD6D2CECAC8C6C5C4C5C6C9CCCFD3D8DCE0E4E8ECF0
F2F5F7F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEBE6E2
DDD7D2CCC7C2BEBBB9B7B7B8B9BCC0C4C9CED4D9DEE3E8EC
EFF3F5F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F5F3EFEBE6E1DB
D5CFC8C2BBB6B1ADAAA8A8A9ABAEB3B8BEC4CBD1D7DDE3E8
ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F3F0ECE7E2DBD5
CDC6BEB6AFA8A29D9A9897989B9FA4AAB1B9C1C8D0D7DDE3
E9EDF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFCFBF9F7F5F1EDE9E3DDD5CD
C5BCB2A9A199928C888685878A8E959CA4ADB6BFC8D0D8DE
E5EAEEF2F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F3EFEBE5DFD7CFC6
BCB1A79C9289817B76737374787D848D96A0ABB5BFC9D1D9
E0E7ECF0F4F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE8E2DAD2C8BE
B2A79B8F8379706963605F61656C747D88939FABB6C1CBD4
DCE3E9EEF2F5F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFBF9F7F4F0EBE5DED6CCC2B6
A99C8F8175695F57514D4D4F535A636E7A8794A1AEBAC5CF
D8E0E6ECF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF8F6F2EEE9E2DBD2C7BBAF
A1928375675A4F463F3B3B3D4249535F6C7B8998A6B3BFCA
D4DDE4EAEFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE7E0D8CEC2B6A8
998979695A4C40362F2B2A2C323A4552606F7F8F9EADBAC6
D0DAE2E8EDF2F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DED5CABEB1A2
9281705F4F403329211D1C1E242D38465566768798A7B5C2
CDD7E0E7ECF1F5F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EAE4DCD3C8BBAD9D
8C7B69574636291E1611101319222E3C4D5E708192A2B1BF
CBD5DEE5EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFEAE3DBD1C6B9AA9A
887663513F2F21160D09080A111A273646586A7C8E9FAFBD
C9D4DDE4EAF0F3F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFE9E2DAD0C5B7A898
8673604D3B2B1D11090403050C1623324354677A8C9EADBB
C8D2DCE4EAEFF3F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFE9E2DAD0C4B7A897
85735F4D3B2A1C10080302040B1522304154677A8C9DACBA
C7D2DCE4EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFE9E3DAD1C5B8A998
8774614F3D2C1E130A0504070E1724334457697B8C9DADBC
C9D4DDE5EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCF9F7F3EFEAE3DBD2C6B9AB9B
8A78655342322419110C0B0E141D2939495A6B7D90A1B1BF
CAD4DDE4EAEFF3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DDD4C9BCAE9F
8E7D6C5A493A2D221A1615171D263341505F718496A6B3BF
CAD4DDE4EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1ECE6DFD6CCC0B3A4
958474635345382E2723222429333E4A58697C8D9BA7B4C1
CDD8E1E8EEF3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EDE8E1D9CFC4B8AA
9C8D7D6E5F52463C3632303339414A55657786919CABBBCA
D6E0E7ECF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEAE3DCD3C9BEB1
A496887A6C60554D464241444A50586575818A96A7BBC9D2
D8DEE3E8EDF1F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFBF9F7F4F0ECE6DFD8CEC4B9
ADA093877B6F665E585454575A5F6977818793A7BBC5C6CA
D0D7DEE5EBF0F4F7F9FBFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEE9E3DCD4CBC1
B6AB9F94897F77706A6767696B717C868992A7BABCB8BAC9
D5DEE5EBF0F4F7F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0ECE6E0D9D1C8
BFB5ABA1988F87817C7A7A7A7D858D9095A8BBB6B1BAC8EB
F4F8FAFBFCFDFCFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7D0
C8BFB6AEA69E98928E8D8C8C90979A9BA8BCBAAEBFE7F1FA
FCFEFEFEFFFFFFFFFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EDE8E3DDD7
D0C9C1BAB3ADA7A29F9E9C9DA2A6A6ABBDC4B4B8E8F7FBFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF8F6F3F0ECE8E3DD
D8D1CBC5BFBAB5B1AFADACADB1B3B3BCCBC3B7CAF2FCFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3F0ECE8E3
DED9D4CFCAC6C2BFBDBBBABCBFBEC0CCD2C6C7EEFAFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F7F5F2EFECE9
E5E0DCD8D4D0CDCBC9C7C7C9CAC9CDD8D7CDD4F5FDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0ED
EAE7E3E0DDDAD7D5D4D2D3D4D4D3D8E0DDD5DEF8FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1
EEECE9E6E4E2E0DEDDDCDCDDDDDCE1E7E3DDE5F9FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F8F6F4
F2F0EEECEAE8E7E5E4E3E4E5E4E4E9EDE8E4EBFBFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFBF9F8F7
F5F4F2F0EFEDECEBEAEAEBEBEAEAEEF1EDEAF0FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9
F8F6F5F4F3F2F1F0EFEFF0F0EFF0F3F4F1F0F4FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFB
FAF9F8F7F6F5F5F4F3F3F4F4F3F4F6F7F5F4F7FBFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFBFAF9F9F8F8F7F7F7F7F7F6F7F9F9F8F7F9FBFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFBFAFAFAF9F9F9F9F9F9F9FBFBFAFAFAFCFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFDFCFCFCFBFBFBFBFBFBFBFBFCFCFCFBFCFDFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFDFDFDFCFCFCFCFCFCFCFDFDFDFDFDFDFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 20.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 20.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFDFDFDFDFCFCFCFCFCFCFCFDFDFDFDFDFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFCFCFCFDFDFD
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFCFCFBFBFAFAF9F9F9F9F9F9F9F9FAFAFBFBFBFCFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFBFAF9F9F8F7F7F6F6F6F6F6F6F7F7F8F8F9FAFAFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FCFBFAF9F8F7F6F5F4F3F3F2F2F2F2F3F3F4F5F5F6F7F8F9
FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
FAF9F8F7F5F4F3F1F0EFEEEEEEEDEEEEEFF0F1F2F3F5F6F7
F8FAFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFA
F8F7F5F4F2F0EFEDEBEAE9E8E8E8E8E9EAEBECEEEFF1F3F5
F6F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8
F6F4F2F0EEECEAE7E5E4E2E1E1E1E1E2E3E5E6E9EBEDEFF1
F3F5F7F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6
F4F1EFECE9E6E3E1DEDCDAD9D8D8D9DADBDDE0E2E5E8EBED
F0F2F5F7F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F6F3
F1EEEBE7E3E0DCD9D6D3D1CFCECECFD0D2D4D7DBDEE2E5E9
ECEFF2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F1
EDEAE6E1DDD8D4CFCCC8C6C4C3C2C3C5C7CACED2D6DBDFE3
E7EBEFF2F4F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F4F1ED
E9E5E0DBD5D0CAC5C0BCB9B6B5B5B6B8BBBEC3C8CDD2D8DD
E2E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EEEA
E5DFD9D3CDC6BFB9B3AEAAA8A6A6A7A9ADB1B6BCC3C9D0D6
DCE2E7EBEFF2F5F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F2EFEBE6
E0D9D2CBC3BBB3ACA5A09B97969596999DA3A9B0B8BFC7CE
D6DCE2E8ECF0F3F6F8FAFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0ECE7E1
DBD3CBC2B9B0A79E968F8A86848485888D939BA3ACB4BEC6
CFD7DDE4E9EEF1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEE9E3DD
D5CDC3B9AFA49A90877F7974727173777C838B959FAAB4BE
C8D0D8DFE5EBEFF3F6F8FAFCFDFDFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBF9F7F4F0ECE6E0D8
D0C6BBB0A4988C81776E67625F5F61656B737C87939FAAB5
C0CAD3DBE2E8EDF1F5F7FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEAE3DCD4
CABFB3A79A8C7F73685D55504D4C4E5359636E7A8693A0AC
B9C4CED7DFE6EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE7E1D9CF
C5B9AC9E90817365584E453F3C3B3C424A54606C7A8897A5
B3BFCAD4DCE3E9EEF2F5F8FAFBFDFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF7F4F0EBE5DED6CC
C0B3A596877768584B3F362F2B2A2D333C46515F6F80909F
ADB9C5CFD8E0E6ECF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBF9F7F3EFEAE4DCD3C8
BCAEA08F7F6E5D4E3F3329211D1D21262E38465768788897
A5B3BFCBD5DEE6ECF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EEE9E2DAD1C6
B9AA9B8A7967554536291E1613131519223040505F6F7F8F
A0B0BFCBD6DFE6ECF1F4F7FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D9CFC4
B6A897867462503F2F2116100C0A0B111E2C394655687C90
A2B2C0CBD5DDE4EAEFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D8CEC3
B5A69684715F4D3C2B1D130C060307111C25303F556C8092
A0ADB9C4CED7DFE6ECF1F5F8FAFBFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EDE8E1D8CEC2
B5A69584715F4C3A2A1D130A03030A12161E2F475E6F7C88
96A4B3C0CDD7E0E7EDF2F5F8FAFBFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D9CFC3
B6A7968573614E3C2D21150B070B0E0E13253D505A627083
97ABBDCBD8E1E9EEF2F5F8FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EEE9E2DAD0C5
B8A99988776552423426191211120E0F203744454C607D98
AEBFCCD6DEE4EAEFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F3EFEAE3DBD2C7
BBAD9D8D7C6B594A3C2D221E1C161320353C373F5C839DA8
ACB2BAC3CCD5DEE6EDF2F6F9FBFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF7F4F0EBE5DDD4CA
BEB1A393837263544538302D251D25383C323A6088928584
8C99A7B4C1CED9E3EAF0F4F8FAFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF8F5F1ECE6E0D7CE
C3B6A99B8B7C6E60514641392F2F3F43353A63877A625F7D
96A9B8C5D1DCE2E8ECF1F5F8FAFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF8F5F2EEE9E2DBD2
C8BCB0A395877A6C5F5750453F4851433E62886C525F7ECF
E3EBEFF2F5F9F3F2F3F5F7F9FBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEBE5DED6
CDC3B8AB9F9386796F685F54565F58495F8C754C6DC6DEF2
F8FBFCFDFDFEFDFDFBFAFAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF7F5F1EDE8E2DB
D2C9BFB4AA9F938880786E686D6F5E60898F585CCAEBF6FB
FDFEFFFFFFFFFFFFFFFDFCFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DF
D8D0C7BEB4AAA09790887E7C827A6D80A27C5683E0F6FCFE
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F1EDE9E3
DDD6CEC6BEB5ACA59F968F919286829DA77A78D6F3FCFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3F0ECE7
E2DCD6CFC8C0B9B3ADA4A0A3A09498B3A98594E6F9FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2EFEB
E7E2DCD7D0CAC4BFB9B2B1B3ACA3ADC2AE94A8EBFBFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EF
EBE7E2DED8D3CECAC4BFBFC0B8B2BECEB7A4B8EFFCFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F4F2
EFEBE8E4DFDBD7D4CFCBCCCBC3C0CDD7C1B2C5F2FCFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4
F2EFECE9E5E2DFDCD8D5D7D5CDCCD9DECAC0D0F4FDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7
F5F2F0EEEBE8E6E3DFDEDFDDD7D7E2E4D4CEDBF6FDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9
F7F5F3F1EFEDECE9E6E6E7E4DFE0E9EADEDAE2EFFCFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFA
F9F8F6F5F3F1F0EEECECECEAE6E7EEEFE7E3E7F0FBFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
FAF9F8F7F6F5F4F2F1F1F1EFECEDF2F3EDEAECF2F8FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FCFBFAF9F8F8F7F5F4F4F5F3F1F2F5F6F3F0F1F4F8FCFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFCFBFAFAF9F8F7F7F7F6F5F5F8F9F6F5F5F7F9FCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFDFCFCFBFBFAF9FAFAF9F8F8FAFAF9F8F8F9FAFCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFDFDFDFCFCFBFBFBFBFBFAFAFBFCFBFAFAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFDFDFDFDFCFCFCFCFBFBFCFDFDFCFCFCFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFDFDFDFDFDFDFDFDFEFEFDFDFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFFFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 25.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 25.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFDFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFDFDFDFCFCFCFCFBFBFBFBFCFCFCFCFCFD
FDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFDFCFCFCFBFBFBFAFAFAFAFAFAFAFBFBFBFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFDFDFCFCFBFBFAFAF9F9F8F8F8F8F8F8F9F9F9FAFA
FBFBFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFCFBFAF9F9F8F7F7F6F6F5F5F5F5F5F6F6F7F8F8
F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFCFCFBFAF9F8F7F6F5F4F3F2F2F1F1F1F1F2F2F3F4F5F6
F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFD
FCFBFAF9F8F7F6F4F3F1F0EFEEEDECECECECEDEEEFF0F1F2
F4F5F6F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FBFAF9F8F6F4F3F1EFEDEBEAE8E7E6E6E6E6E7E8E9EBECEE
F0F2F4F5F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF9F7F5F3F1EFECEAE8E6E4E2E0DFDFDFDFE0E1E3E5E7E9
ECEEF0F3F4F6F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F9F7F5F3F0EDEAE7E4E2DFDCDAD8D7D6D6D7D8D9DBDEE1E4
E7E9ECEFF1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9
F7F5F2F0ECE9E5E2DEDAD6D3D1CFCDCCCCCCCED0D3D6D9DC
E0E3E7EBEEF1F4F6F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F7
F5F2EFECE8E4DFDBD6D1CDC9C6C3C1C0C0C1C3C5C8CBCFD4
D8DDE2E6EAEEF1F4F6F8FAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5
F3F0ECE7E3DED8D3CDC7C3BEB9B6B3B3B3B4B6B8BBC0C5CB
D1D7DCE1E6EAEDF1F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3
F0ECE8E3DDD7D1CAC3BDB7B1ABA8A6A4A4A4A6AAAFB5BBC2
C8CED4DADFE4E9EDF1F4F7F9FBFCFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1
EDE9E4DED7D0C8C1B9B1A9A29D9996939293979CA2A9AFB5
BCC4CBD3DAE1E7ECF0F3F6F8FAFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3EF
EAE5DFD8D1C8C0B7AEA49B948E8984808184898D92989FA8
B1BCC6CFD7DEE4E9EEF1F4F7F9FAFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EC
E7E2DBD3CAC1B7ACA1968E867E757070727577797F87939F
ABB6C0C8D0D7DDE3E8EDF1F4F7F9FBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEA
E4DED6CDC3B9AEA1958B81756A636162615F6066717E8B96
A0A9B2BBC4CDD6DEE4EAEFF3F6F8FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F5F1EDE8
E2DAD1C7BDB1A4968B7F71635A56544E4848505D69737B83
8D98A5B2BFCBD6DFE6ECF0F4F7F9FBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F4F0EBE6
DFD6CDC3B7A99B8E81716155504A3F35353F4B52555A6371
8295A6B7C5D0DAE1E7ECF1F4F7F9FBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F3EFEAE4
DCD3C9BEB0A294867563554E44352827323A39363A485D75
8A9BA9B4BEC6CED6DDE4EAEFF3F6F9FBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F6F2EEE8E2
DAD1C6B9AB9D8F7E6A5A504431211F292B21192138536977
8087909AA6B2BEC9D4DDE4EBF0F4F7F9FBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F6F2EDE7E0
D8CFC3B6A899897563574A35211D24200D0312314A525152
5B6A7B8DA0B1C0CDD7E0E6ECF0F4F7F9FBFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D7CDC1B3A696837062543F2720241C03000B2D3A2D22293E
5A7792A9BDCDD8E1E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D6CCC0B3A5938070624E35282A200200092A27090016406C
8DA4B4BFC6CCD4DCE4EAF0F4F7F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D6CCC0B3A4928173604735332B0C000A29190000195A7F80
78767A838F9EB0C0CFDBE5EDF2F6F9FBFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D6CCC1B4A49384755E48403B1F020D2C180000276D633425
2A394B5F758DA3B5C5D3DEE7EEF3F7FAFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F5F2EDE7E0
D7CEC3B6A69789765F514D38161331250000306A33000013
3A576F8398ADB7C2CBD5DEE6ECF2F6F9FBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F6F2EEE8E1
D9D0C5B8AA9D8E78665F523320353A02002D6B1900001BA8
CBD7DEE3E9F0DFDCDCE0E5EAEEF2F6F8FBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F6F3EFE9E3
DBD3C8BBAFA3927E726B54373B4E27001F742700079DC4E7
F2F6F8F9FBFCF9F9F1EEEEEFF2F4F7F9FBFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0EBE5
DED6CBC0B5A997878073574858501A16675A0000A3DDEEF8
FCFDFEFEFEFFFEFEFEF8F5F5F6F7F9FAFBFDFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F1ECE7
E1D9CFC6BCAF9E938C7961606C4B234888210024C8F0FAFD
FEFFFFFFFFFFFFFFFFFCFAF9F9F9FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F2EEE9
E4DCD4CBC2B5A7A097817078774C3D777A110CB7E9F9FDFF
FFFFFFFFFFFFFFFFFFFFFDFCFBFBFCFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0EC
E6E0D9D1C8BCB2ACA08B838D7D565D976D1B37D1F4FCFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F2EE
E9E3DDD7CEC3BCB7A897969D84667BAA6B2F56D9F7FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F4F0
ECE7E2DCD4CBC6C0B1A5A8AA8C7996B673456EDEF8FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F3
EFEBE7E1DAD3CFC8BAB2B9B4978CAEBF7D5B82E2F9FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4
F1EEEBE5DFDAD7D0C4C0C6BDA39FC1C58B7397E7FAFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6
F4F1EEEAE4E1DED6CDCCD2C5AFB1D0CC9D8DABE8FAFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F6F4F1EDE9E7E4DDD5D6DACDBCC0DAD4B0A4B7D5F6FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9
F8F6F4F0EDECE9E3DDDFE2D5C8CDE1DCC2B7C0D6F4FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFA
F9F8F6F3F1F0EEE8E4E6E8DDD3D7E7E4D1C7CBD9EBFAFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FBFAF8F6F4F4F1ECEAECEDE4DCDFEBEBDDD4D5DEEAF4FAFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFC
FCFBF9F8F7F6F4F0EFF1F1EAE4E6EFF0E6DFDFE4EBF2F8FC
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFAF9F9F7F4F3F4F4EFEBECF2F4EEE8E7E9EEF3F7FB
FDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFCFBFBFAF9F7F6F7F7F3F0F0F4F7F3EFEDEEF1F5F8FA
FCFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFCFCFAF9F8F9F9F6F4F4F7F9F7F4F2F3F4F6F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFDFDFDFDFCFAFAFBFBF9F7F7F8FAFAF8F6F6F7F8FAFB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFDFCFCFCFCFBF9F9FAFBFBFAF9F9F9FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFDFDFDFDFCFBFBFBFCFDFCFBFBFBFBFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFDFEFEFDFDFCFDFDFDFDFDFCFCFDFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFEFEFEFEFDFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFFFFFEFEFEFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 30.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 30.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFDFDFDFCFCFCFCFCFCFCFCFCFC
FDFDFDFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFB
FCFCFCFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFDFDFDFCFBFBFBFAFAFAF9F9F9F9F9F9FAFA
FAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFDFDFDFCFBFBFAFAF9F9F8F7F7F7F7F7F7F7F7F8
F8F9F9FAFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFCFCFBFAF9F9F8F7F6F5F5F4F4F4F4F4F4F4F5
F6F7F8F9FAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFDFDFCFBFAF9F8F8F6F5F3F2F2F1F1F0F0EFEFF0F1F2
F3F4F5F6F7F8F9F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFBFAF8F7F6F5F3F1F0EFEEEDEBEAEAEAEBECEDEE
EFEFF0F2F3F5F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FDFCFCFBF9F8F7F5F3F1EEEDECEAE8E6E4E4E4E5E6E6E6E7
E8E9ECEEF1F3F5F7F9FAFBFCFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FDFCFBF9F7F6F5F2EFECEBE9E7E3E0DEDEDEDFDEDDDCDDDF
E2E5E9ECEFF1F2F4F5F7F8F9FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFD
FCFBF9F7F6F4F1EDEBE9E7E3DEDAD8D8D8D6D3D1D1D3D7DB
DEE2E4E6E7E9EBEEF0F3F5F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FBF9F7F6F4F1EDEAE8E5E0D9D5D4D3D1CCC7C5C6CACED2D4
D5D6D8DADEE2E6EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF8F6F4F1ECE9E7E3DDD5D1D0CFC9C1BBBABDC2C4C4C3C2
C4C7CDD4DBE1E7ECF1F4F6F8FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFA
F8F7F5F1EDE9E7E3DBD2CECDCAC1B6B0B1B6B8B5B0ADAEB3
BAC4CDD6DCE1E5E8EAEDEFF2F4F6F8FAFBFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9
F7F5F2EDEAE7E3DAD1CCCBC6B9ACA7AAAEABA199979CA7B2
BCC4C8CBCDD0D3D8DCE1E6EBEFF2F5F7F9FBFCFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8
F6F3EFEBE8E3DBD1CBCAC3B3A5A1A6A79B8B838692A0A8AB
ABAAABAFB5BDC5CED7DEE5EAEFF2F5F8F9FBFCFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8
F5F1ECE9E5DDD2CCCAC2B0A19DA39E8A77727D8D95928984
858B96A4B2C1CED9E2E9EEF2F5F7F9FAFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F6
F3EEEBE7DFD5CECBC3B09F9CA1977B67687A87806D60606B
7C91A6B9C8D3DBE0E4E7EBEFF2F5F8FAFBFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5
F1EDEAE3D9D1CDC6B3A09CA093725D63797B60463E4C6581
98A7ADAFAFB1B5BCC4CDD5DDE5EBF0F4F7FAFBFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7F3
F0ECE7DED5D0CAB9A49EA1926E5861786B41262C4C708482
78716E70788492A1AFBDC9D3DCE4EAF0F4F7F9FBFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F6F2
EFEBE3DAD4CFC0ABA1A497715761775E2A12295873614231
2F38475B71889CADBBC7D1D9E0E6EBEFF3F6F9FAFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2
EEE8DFD9D4C9B5A7A79E7A5C6278591D092D645B24000011
32557797B2C7D4DDE2E6E9EBEDEFF2F4F6F8F9FBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F5F2
EDE5DED9D1C0B0ACA88865647A5D1C063366390000002965
90A7B1B2AEAFB6C1CED9E4ECF1F5F7F9FAFAFBFCFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F1
EBE4DED9CBBAB2B09974697C6A2608346623000005638D6F
4D3B35363F536C859DB2C5D4E0EAF1F6F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EAE4DFD6C6BAB7AB88727E7C3C10316920000023864C0000
0000000014375570889FB3C4D3DFE8EFF5F8FBFCFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4EF
E9E5DFD3C5BEB99F81808A5B212C6B330000337C02000000
00072036516F7B8794A3B3C1CFDAE4EBF1F6F9FBFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4EF
EAE6DED0C7C3B49687927D3F2D625700002C7B0000000088
B5C4CCD1D9E4C2B9B6BAC1C9D3DBE3EAF0F4F8FAFCFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4EF
EBE6DCD1CBC5AE969597673B537816000F8F0000007EB0DE
ECF2F4F5F7F9F2F3E1D7D5D7DBE0E6EBF0F4F7FAFBFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
ECE6DCD3D0C3AB9DA48F5A4E7B5800007937000086D2E9F6
FAFCFDFDFEFEFDFDFBEEE6E3E4E7EAEEF1F5F7FAFBFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F4F1
EDE6DDD7D2C1ACA9AB845D6C8834003892000000B6EAF8FC
FEFFFFFFFFFFFFFFFFF8F1EEEDEDEFF1F4F6F8FAFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2
EEE6DFDCD4C0B2B5AB7F6B8A7E2412795D00009EE2F7FDFE
FFFFFFFFFFFFFFFFFFFFF9F6F3F3F3F5F6F8F9FBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3
EEE7E2DFD4C2BBBFA8817F9F6F2639A0370000BEF0FBFEFF
FFFFFFFFFFFFFFFFFFFFFDFAF8F7F7F7F8F9FAFCFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F7F4
EFE9E6E2D5C7C6C5A68996A967325EAE290006C6F3FDFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFBFAFAFAFAFBFCFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5
F0ECE9E4D6CDCFC8A795ABAC654480B127001FCCF4FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFCFCFCFDFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F6
F1EEECE5D9D4D8C9ABA4BEAB68599FAE2C0035D1F5FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF7
F3F1EFE7DDDBDECBB2B4CDAA7271BAAA38114FD6F7FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF7
F5F3F1E9E1E2E2CDBBC3D6AC7F88CCAC50366CD5F6FEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF8
F6F6F2EBE6E8E5D1C4D0DCB18F9CD7B56D5778AFEEFCFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBF9
F8F7F4EDEBEDE7D6CEDBE0B99FADDEC2887283ACE9FBFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFA
FAF9F5F0EFF1EADBD6E3E3C2AEBBE2D0A18B92AFD3F4FCFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFB
FBFAF6F2F2F4ECE0DEEAE7CCBCC6E5DCB7A2A3B6CFE4F2FC
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFC
FCFBF8F5F5F7EFE6E5EFEBD5C9D0E7E6C9B6B4BFCFDFECF5
FAFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FDFCF9F7F8F8F1EAEAF2EFDED4D8E9EDD8C7C3C9D3DFEAF2
F7FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FDFCFAF9FAFAF4EEEFF5F2E5DDDFECF2E3D6D1D2D9E1E9F1
F6F9FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFBFAFBFBF6F2F2F7F5EBE4E6EEF5ECE1DCDCDFE5EBF1
F5F9FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFCFBFCFCF8F5F5F9F8F0EBEBF0F7F2EAE5E4E6E9EDF2
F5F8FBFCFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFCFDFDFAF7F8FAFAF4F0EFF3F8F6F1EDEBEBEDF0F3
F6F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFDFEFDFBF9F9FBFBF7F4F3F5F9F9F6F2F0F0F1F3F5
F8FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFCFBFBFCFDFAF7F6F7FAFBF9F7F5F4F5F6F7
F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFFFEFDFCFCFDFDFCFAF9F9FBFCFBF9F8F7F8F8F9
FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFDFDFDFEFDFBFBFBFCFDFDFCFAFAFAFAFB
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFDFCFCFDFDFDFDFCFCFBFCFC
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFFFEFEFDFDFDFEFEFEFDFDFDFDFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 35.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 35.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFFFFFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFEFEFEFDFDFEFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFDFEFE
FEFDFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFCFCFCFDFDFDFDFC
FCFCFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFEFEFEFDFCFBFBFCFDFDFCFBFAFA
FAFBFCFDFEFEFEFEFEFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFDFDFEFEFDFBFAFAFBFCFCFBF9F8F8F8F9
FBFCFDFDFCFBFBFBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFDFDFEFEFCFAF9FAFBFCFAF8F6F5F6F7F9FB
FBFAF8F8F7F7F8F9FAFBFCFDFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFDFDFDFFFDFBF9F9FAFCFBF7F4F3F3F5F8F9F8F6
F4F3F2F3F5F6F8FAFCFDFFFFFFFFFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFDFDFDFFFDFAF8F8FBFCF8F3F1F0F3F6F8F5F1EEED
EDEFF1F4F8FAFCFDFCFBFAFAFBFBFBFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFCFDFFFCF9F7F8FBFBF5F0EEEFF4F7F4EDE9E7E7EA
EEF3F7F9F7F5F4F3F3F3F4F5F7F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFDFCFDFFFCF8F6F8FCF9F1ECEBF0F6F4EBE3E0E0E5EBF1
F3F1EDEAE8E7E8EAECEFF1F4F6F8F9FBFCFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FDFDFDFFFBF8F6F8FDF7EEE9EAF1F6ECE0D9D9DFE7EEEDE6
E0DBD9DADCE0E5EAEFF3F7F9FBFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD
FDFDFFFCF8F6F8FDF5EBE7EAF4F2E2D6D2D7E2ECE7DBD1CB
CACDD3DBE3ECF4FAFCFBF9F8F8F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFD
FDFFFCF8F6F8FDF4E9E5EBF7ECD9CDCEDAE9E5D3C3BCBCC2
CDD9E6EFF1ECE7E4E3E3E5E7EAEDF0F3F5F8F9FBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FFFDF9F6F8FDF3E9E5EBF8E6D1C7CDE0E9D2BBAEAEB8C9DA
E4E1D7CEC7C4C4C7CCD1D7DDE2E7ECEFF3F5F8F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFE
FDF9F7F8FDF4E9E5ECF8E2CCC4CFE8DEBCA5A0ACC3D8DAC9
B7ABA4A3A7AEB7C1CBD4DCE2E7ECEFF2F5F7F9FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFEFE
FAF8F8FDF6EBE5ECF8E0C9C2D2EDD0A9959BB6D5D1B2998A
868A94A3B3C4D4E1EBF2F7FAFBFCFCFCFCFDFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFC
F9F8FCF8EDE6EBF8E1C9C1D4EDC49A8C9EC7D5A9826E6D79
8EA8C2DBEDECE3DDDADBDEE2E7ECF0F4F7FAFCFDFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFDFA
F8FBFBF0E8EAF8E5CBC2D4EDBD9187A5D7BA7E5A566B8FB5
CFD0BEAA9C959499A1ABB6C2CCD6DEE6ECF1F5F8FBFCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFBF9
FAFCF4EBEAF6EACFC3D3EEBC8E86ACDD9C5B415385BAC29E
7C63544D505A68788898A7B4C1CCD5DEE5EBF0F4F7FAFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFAFA
FDF7EFEBF3F1D7C6D0EFC19086B0DB88443662ADBC7A4427
1F222D3F566D8396A4B1BBC3CBD3D9E0E5EBEFF3F6F9FAFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFDFBFAFC
FAF2EDF1F7E0CCCEEBCC9787AFDB7F383475C9842C000012
35597DA1C1D8E7EEF0EFEDEBEAE9EAEBEDEFF2F4F7F9FAFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFCFBFBFC
F6F0F0F8EAD3CEE4DBA48AA9DF84373483C651000000458B
BDCCBEA5918C919EAFC0D0DEEAF3F9FAF9F8F8F8F9FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFDFCFCFDFA
F3F0F5F3DED1DDE9B792A1DE953F3486BF350000289CB76F
391A0600000F2A47637F98AFC3D4E2ECF3F8FBFCFCFCFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFDFCF7
F2F4F8E9D8D8EDCDA09CD0B253357CC531000052C8480000
0000000000000E2A455F7A93A9BDCEDCE7EFF5F9FBFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFDFAF5
F3F8F2E1D9E6E2B59EBDD2733D69D046000068A600000000
000000052040444C5767798DA1B3C3D2DEE7EEF4F8FBFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDF9F5
F6F8EBDEE0EECDAAAFDD9E5257BD7400005EA00000000082
AEBCC2C7CFDBA7958C8C919BA7B4C1CED9E2EAF0F5F8FBFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFEFCF8F6
F9F4E7E0EAE4BEADCACB775392B4190035C60000007CAEDD
EBF0F2F3F5F6EDEDCEBBB3B2B6BDC6CFD9E1E8EEF3F7FAFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFEFDFAF8F8
FAF0E5E6F1D6B8BBE0A86671CB650006B82B000083D1E9F5
FAFCFCFDFDFDFCFCF9E0D0C9C7C9CED5DBE2E8EEF2F6F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFAF8FA
F7EDE7EDECCCBBCFD78E6A9BBB300058A7000000B5EAF8FC
FEFFFFFFFFFFFFFFFEF1E5DCD8D7D8DCE0E5EAEFF2F6F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAFAFB
F5ECEAF3E3C8C3E1C1827CC48D1816A75000009AE1F7FDFE
FFFFFFFFFFFFFFFFFFFEF3EBE5E2E2E3E6E9EDF0F3F6F9FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAFBFB
F3EDEFF4DCC8D0E7AF8195D76A153FD11D0000B9EEFBFEFF
FFFFFFFFFFFFFFFFFFFEF9F3EEEBEAEAEBEDF0F2F5F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFDFBFBFCF9
F2EFF5F0D8CCDEDEA388B1CA541D66C8030000BFF1FCFFFF
FFFFFFFFFFFFFFFFFFFFFCF8F4F2F0F0F0F1F3F5F7F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFDFCFCFDF8
F2F2F9EBD6D3ECD19E94CDB2472A89B0000000C2F2FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFCF9F7F5F4F4F5F6F7F8FAFBFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFDFCF7
F3F5F9E7D8DCF3C79EA5E69E423EAC97000004C6F3FDFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFCFAF9F8F7F8F8F9FAFBFCFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFEFCF7
F4F9F6E5DBE6EFC1A3B7F2914756CA8600001ECBF4FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAFAFAFAFBFBFCFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFEFBF7
F6FCF4E5E0EFE8BFACC8E88B536EE0840B0039C6F3FDFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFCFCFCFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFEFEFBF8
F9FDF2E6E5F7E3C0B6D8DD8D6484EB8F2B103E8CE6FBFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFDFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFBF9
FBFCF1E8EBFCE0C4C1E4D8947596EFA04B2C4482DDF8FEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFDFBFA
FCFBF1EBF0FCE0C9CBEDD79E87A4EEB36947527FB8ECF9FE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFDFBFB
FEFAF2EEF4F9E1CFD4F4D9A997AFECC585636584ACCFE6F8
FDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFCFC
FFFAF3F1F7F7E3D6DBF8DDB6A6B9E9D69F7E7A8CA8C3DAEB
F4F9FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFCFD
FFFAF5F3FAF7E6DCE2FAE2C2B4C2E7E4B6988F98ABBFD3E3
EEF4FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFE
FEFAF6F6FCF7E9E2E7FBE7CDC1CAE6EEC9AFA4A6B1C1D1DF
E9F1F6FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFE
FEFBF7F8FDF8EDE7EBFCECD7CCD2E6F5D9C2B6B5BBC5D1DD
E7EEF4F8FBFCFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFF
FEFBF9F9FEF9F0EBEFFCF1DFD6D9E7F8E6D3C7C3C5CCD5DE
E6EDF3F7FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFF
FEFCFAFBFEFAF3EFF2FCF5E7DFDFE9F7EFE0D5CFCFD3D9E0
E7EDF2F6F9FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFF
FEFCFBFCFEFBF5F3F5FCF8EDE6E5ECF6F5EAE0DBD9DBDFE4
E9EEF2F6F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFDFCFCFFFCF8F5F7FCFBF2ECEBEFF6F9F1E9E4E2E2E5E8
ECF0F3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFDFDFDFFFDFAF8F8FCFDF6F1EFF1F6FAF6F0ECE9E9EAEC
EFF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFEFFFDFBFAFAFDFEF9F5F3F4F7FBFAF5F2EFEEEFF0
F2F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFFFEFCFBFBFDFFFBF8F6F7F8FBFCF9F6F4F3F3F3
F5F6F8F9FBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFFFFFDFCFCFDFFFDFAF9F9FAFBFDFBF9F7F6F6F6
F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFDFDFEFFFEFCFBFAFBFCFDFDFBFAF9F9F9
F9FAFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFFFEFDFCFCFCFDFDFEFDFCFBFBFB
FBFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFFFFFEFDFDFDFDFEFEFEFDFDFCFC
FCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFDFD
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFEFEFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 40.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 40.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFFFFFFFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFEFEFEFEFEFE
FEFFFFFFFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFDFEFE
FEFEFEFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFDFDFDFEFEFDFDFCFCFCFDFDFEFEFD
FCFCFCFCFCFCFDFDFDFEFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFDFDFDFDFDFDFCFCFBFBFCFDFDFDFCFBFA
FAFAFBFBFCFDFDFDFDFDFCFCFCFDFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFDFCFCFCFCFCFBFAFAFBFBFCFCFBF9F9F8F9
FAFBFCFCFCFBFBFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFCFCFCFCFCFBFAF9F9FAFBFBF9F8F7F6F7F8FA
FBFBFAF9F8F7F7F7F7F8F9F9FAFBFCFCFDFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFCFBFBFBFBF9F8F8F8F9F9F8F6F4F4F5F7F9FAF9
F7F5F3F3F3F3F4F6F7F8F9FAFAFBFBFCFCFCFDFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFCFCFBFBFAFAF8F7F6F7F8F7F4F2F1F2F5F7F8F6F3F0
EFEEEFF0F2F4F6F7F8F8F8F8F8F8F9F9FAFBFBFCFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFCFCFBFAFAF9F7F5F5F6F6F4F1EFEFF1F4F6F3EFECEAEA
EBEEF1F4F6F5F4F2F1F1F1F1F2F3F5F6F7F9FAFBFCFCFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FCFCFBFAF9F8F6F4F4F5F4F1EDEBEDF0F3F1EBE7E5E5E8ED
F1F4F3F0ECE9E7E7E7E8EAECEEF0F2F4F6F8F9FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFBFAF9F7F5F3F3F3F2EDE9E9EBEFEFE8E2DFE0E4EBF1F2
EDE7E1DDDBDCDDE0E3E6E9ECEFF1F3F5F7F8F9FBFBFCFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FBFAF9F7F5F3F2F2F0EAE6E6EAECE8DFDAD9DEE7EFEEE5DC
D5D2D1D3D6DBE1E5E9ECEEEFF1F2F3F5F6F7F9FAFBFCFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFB
FBFAF8F5F3F2F2EEE8E4E5E8E8E0D7D3D6E0EAE9DDD2CAC8
C9CED5DDE4E9E9E8E5E4E3E4E6E8EAEDF0F2F5F7F9FAFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFB
FAF8F5F3F2F1EDE7E3E3E7E4D9D0CED6E2E5D7C9C0BEC3CD
D9E5EAE5DCD4CECBCACCCED2D7DBE0E5E9EDF0F3F6F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFB
F9F6F4F3F2EEE7E2E2E6E0D3CACBD6E1D7C4B6B3BBCBDEEB
E4D4C4B8B1ADAEB1B7BDC4CBD1D7DDE2E7EBEFF2F5F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F7F5F3F3EFE8E2E2E5DECFC6C9D6DBC7B2A8AFC3DDE9D5BD
AB9E98979BA2ACB6BFC8D0D6DCE1E5E9ECEFF2F4F6F8F9FB
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9
F6F5F4F0E9E3E3E5DDCDC3C8D6D3B9A3A1B2D2E2C7A9958B
898E99A8B7C6D1D9DDDFE1E3E6E9ECEFF2F4F7F8FAFBFCFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF7
F6F5F3ECE5E4E6DFCEC3C7D5CCAE9A9EBADAC69E837A8192
A8C1D7E1D7C8BDB7B5B7BCC2CAD1D9E0E7ECF1F5F8FBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBF9F7
F6F5EFE8E5E7E2D1C4C7D5C9A8949EC1D2A67C6A7492BAE2
E9C8A88E7C7270747C87939FABB7C3CED7E0E7EDF2F6F9FB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F7
F7F2EBE7E9E6D6C8C8D5CBA7929EC5C48C646080B7ECC799
755A473D3D44515F6E7C8A97A3AFBBC5CFD8E0E7EDF1F5F8
FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F8
F5EFEAEAEADDCDC9D5D0AB939EC6BA7B566096DDBA784D38
30303744586C7F8F9BA5ACB3B9BFC6CDD3DAE0E6EBEFF3F6
F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F8
F3EDECEDE4D4CCD5D7B4979DC4B8755064AAD57F3B1E243D
5C7997B4CBD8DEE1E4E7E8E8E6E4E3E3E3E5E7EAEDF0F3F6
F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFBFAFAF6
F1EEEFEBDCD0D5DDC19F9DC1BE784F66B6BB5516103A7DC1
F8DAB18B736B707C8D9FB2C4D5E4F0F9FBF7F5F4F4F5F6F7
F9FAFBFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFBFBF9F4
F0F0F1E5D7D5E0D1AC9EBBCB845364B7AE40061767D5C174
4321040000000A213A536D87A0B6CADAE8F2FAFFFDFBFAFA
FBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFBF8F3
F1F3EDDFD7DFDFBDA4B3D69B5E60AEB43D012290DB550000
00000000000000071A3049627C95ABBFD0DEE9F2F8FCFEFE
FDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFBF6F3
F4F3E8DCDEE8D0B0AED3BA725E9BC94B0323A4B019000000
0001060C2038322F323C4B5D71869AAEBFCFDCE6EFF5F9FC
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFDFAF6F4
F6F0E4DEE7E2C2B0C5D8916484DB6E0D1999A80500000097
BAC4C6C8CFDA9D84726B6B707A8796A7B6C5D2DEE7EEF4F8
FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFCF8F6F6
F6ECE2E4EDD6BBBBDEB97974C0A52B0E72C70B000096BEE3
EEF2F3F3F5F6EBEAC3A6968F8F949DA8B5C2CED9E2EAF0F5
F8FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFBF8F7F8
F4E9E4EBE8CBBBCDDF9D7598E1631442E53B00009BDBEDF7
FBFCFDFDFDFDFBFBF8D5BCAEA7A6AAB1B9C3CDD7E0E7EDF2
F6F9FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFEFDFAF8F8F9
F1E8E8F0DFC5C3E0C88B81C5B13C228EA200000DC3EFF9FD
FEFFFFFFFFFFFFFFFDEBD8C9BFBABABCC2C8D0D8DFE6ECF1
F5F8FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFAF8FAF7
EEE8ECEED6C4CEE7B28496E8842C43D7560000ADE7F8FDFF
FFFFFFFFFFFFFFFFFFFDECDED3CCC9C9CBD0D5DBE1E7ECF1
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAF9FAF5
EDEBF1E8D0C7DBDAA186AFD7642A67EC280000C3F1FCFFFF
FFFFFFFFFFFFFFFFFFFEF5EAE1DBD6D5D5D7DBDFE4E9EDF1
F4F7F9FBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFBFAFAFAF3
EDEEF2E1CECDE4C9968EC8B54B2E86C20C0002C6F3FDFFFF
FFFFFFFFFFFFFFFFFFFEF9F2EBE6E1DFDEDFE1E4E8EBEFF2
F5F8FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAFBF8F2
EEF1F0DCCED5E5BA919AD9963B36A29C000006C7F3FDFFFF
FFFFFFFFFFFFFFFFFFFFFEF9F3EEEAE7E6E6E7E9EBEEF1F4
F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFDFBFBFBF7F1
EFF3ECD9D1DDDDAF92A9D87E3345BA7A00000CC8F3FDFFFF
FFFFFFFFFFFFFFFFFFFFFDFBF8F4F1EEEDECECEEEFF1F3F5
F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFBFCFBF6F1
F2F4E8D8D5E3D4A997B9CA6E3558CB6500001DCBF4FDFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFAF8F5F3F2F1F1F2F2F4F5F7
F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFAF6F2
F4F3E5D9DAE6CCA7A0C6BC673F6ED563000030C2F2FDFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFCFAF9F7F6F5F5F5F5F6F7F8
FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFDFAF5F3
F5F1E4DBDFE5C7A8AAD0B3684D80DA6E0B00297EE3FAFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F8F8F8F8F8F9FA
FBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCF9F6F5
F6F0E4DEE4E3C5ADB4D6AF6E5C8FDF7F2507256DD6F7FEFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFBFAFAFAFAFAFBFB
FCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCF9F6F6
F6EFE5E1E8E1C5B3BED9AF786C9AE4923F1B2B62A6E7F7FD
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFCFBFBFCFCFC
FDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCF9F7F7
F6EFE6E5EAE0C7BAC7DCB3847BA3E6A65A33385F92BFDCF5
FCFDFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFDFDFDFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAF8F8
F6EFE8E8ECE0CBC2CFDFB99189AAE7BA754D4A6287AAC9E1
EEF5FCFDFDFEFEFEFFFFFFFFFFFFFFFEFEFEFEFDFDFDFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAF9F9
F6F0EBEBEEE1D0C9D5E2C19F96B0E5CC8F685E6B83A0BCD2
E2ECF5F9FBFCFDFEFEFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFCFAFAFA
F7F1EDEEEFE4D5D0DBE5C9ACA3B7E3DDA8837477879CB4C9
D9E5EEF4F8FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFCFBFBFA
F7F2EFF0F0E6DAD6E0E9D2B8AFBEE1ECBE9C89868F9EB1C3
D2DFE9F0F5F8FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFB
F8F4F2F3F2E9DFDCE4ECDAC4BBC4E0F7D2B29F979AA5B3C2
CFDBE5EDF2F6F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFB
F9F5F4F5F4ECE4E2E8EFE2CFC6CCE0FCE1C6B2A9A8ADB7C3
CFD9E3EAF0F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFC
F9F7F6F6F5EFE9E7ECF2E8D9D0D3E1F7EED6C4B9B5B8BEC7
D0DAE2E9EFF4F7F9FBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFC
FAF8F7F8F7F2EDEBEFF5EEE1D9DAE3F4F7E3D3C8C3C3C6CD
D4DBE3E9EEF3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFD
FBF9F9F9F9F5F0EFF2F7F3E8E1E0E6F2FDEEE0D5CFCECFD3
D8DEE4EAEFF3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FCFBFAFAFAF7F4F2F4F8F6EEE8E6E9F2FCF5EAE1DBD8D8DA
DEE2E7EBF0F3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFCFBFBFBF9F6F5F6FAF9F3EEEBEDF2FAFAF1E9E4E1E0E1
E3E6EAEEF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFCFCFCFCFAF8F7F8FBFBF7F2F0F0F4F9FDF7F0EBE8E7E7
E8EAEDF0F3F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFDFDFCFAF9FAFCFDFAF6F4F3F5F9FDFAF6F1EEEDEC
EDEEF0F2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFDFEFEFDFBFBFBFCFEFCF9F7F6F7F9FCFDF9F6F3F2F1
F1F2F3F5F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFDFCFCFDFEFDFBF9F8F9FAFCFEFCF9F7F6F5
F5F5F6F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFDFDFDFDFEFEFDFBFAFAFBFCFEFDFBFAF9F8
F7F8F8F9FAFAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFDFEFFFFFEFCFCFCFCFDFEFEFDFCFBFA
FAFAFAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFFFFFEFDFDFDFDFDFEFEFEFDFCFC
FBFBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFFFFFFFFFEFEFDFDFEFEFFFFFEFDFD
FDFDFDFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFFFEFE
FEFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFFFFFFFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 45.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 45.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFDFDFDFDFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFDFDFDFCFCFCFCFBFBFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFAFAFAFAFBFBFBFBFCFCFCFDFDFDFDFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFCFCFCFBFBFBFBFAFAFAFAFAF9F9F9F9F9F9F9F9
F9F9F9F9F9F9F9F9F9FAFAFAFBFBFBFBFCFCFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFCFCFCFBFBFAFAF9F9F9F9F8F8F8F7F7F8F8F8F7F7F7
F6F6F6F6F7F7F7F8F8F8F8F8F9F9F9FAFAFBFBFCFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FDFCFBFBFAFAF9F9F8F8F7F7F6F6F5F5F5F5F5F5F5F4F4F4
F4F4F5F5F5F5F5F5F5F5F5F6F6F7F7F8F9FAFAFBFCFCFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFC
FCFBFAFAF9F8F7F7F6F5F5F4F3F3F3F3F3F2F2F1F1F1F1F2
F2F2F2F2F1F1F1F1F1F1F2F3F4F5F5F6F7F8F9FAFBFCFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAF9F8F7F6F5F4F3F2F2F1F0F0F0F0EFEEEEEEEEEFEFEF
EFEEEDECECECECEDEDEEEFF0F1F3F4F5F6F7F8F9FAFBFBFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFB
FAF9F8F6F5F4F3F2F0EFEEEEEDECECEBEAEAEAEBECEBEBE9
E8E7E7E7E7E8E9EAEBECEDEDEEEFF0F2F3F4F6F7F8F9FAFB
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFA
F9F7F6F4F3F2F0EEEDECEBEAE9E7E6E6E6E7E7E7E6E5E3E2
E2E2E3E4E5E5E6E6E6E6E6E7E8EAEBEDEFF1F3F5F6F8F9FA
FBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9
F7F6F4F2F0EEECEAE9E8E6E4E3E1E1E2E2E2E1DFDEDDDDDE
DFE0E1E0DFDEDDDCDCDDDEE0E2E4E7E9ECEEF0F3F5F6F8F9
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7
F6F4F2F0EDEBE9E7E5E3E0DEDDDDDDDDDCDAD8D7D8DADCDD
DCDBD8D5D3D2D1D2D4D6D8DBDEE1E4E7EAEDEFF2F4F6F7F9
FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6
F4F2F0EDEAE7E5E3E0DDDAD8D8D8D7D4D2D1D2D4D7D8D8D5
D1CDCAC8C8C9CBCED1D4D7DADCDFE2E5E8EBEEF0F3F5F7F9
FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF8F7F5
F3F0EDEAE7E4E1DEDAD7D5D4D3D0CDCACACDD0D2D1CECAC5
C3C2C2C4C7C9CCCECFD0D2D4D6D9DCDFE3E6EAEDF0F3F5F7
F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F3
F1EEEAE7E4E0DCD8D4D1D0CECAC5C3C4C8CBCAC7C2BEBDBE
C0C3C6C7C7C5C3C2C1C1C3C5C9CDD1D6DBE0E4E9ECF0F3F6
F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F2
EFECE8E4E1DCD7D2CFCDC9C4BFBDBFC2C3BFBAB6B6B9BFC4
C7C6C1BAB4AEABAAABAEB2B8BDC3C9CFD5DBE0E5E9EDF1F4
F6F8FAFBFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1
EDE9E6E2DDD7D2CECBC6C0BAB8BABCBAB3ADACB1BAC3C6C3
BAAFA59D9997999DA3A9B0B6BDC3CAD0D5DBE0E5E9EDF0F3
F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F7F5F3EF
EBE8E4DFD9D3CFCBC5BDB7B5B6B7B1A8A3A6B0BBC0BCB1A5
9B949091949AA1A8AFB5BBC0C6CBD0D5DADFE3E7EBEFF2F4
F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F4F1EE
EAE6E1DBD5D0CCC5BDB5B2B3B2A99F9BA2AEB7B3A79B9492
93989EA6ACB0B1B2B3B5B8BCC1C6CCD2D8DEE4E8EDF0F3F6
F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F0ED
E9E4DED8D3CEC8BEB6B2B2AFA498969FACAC9F918A8E98A6
B2B9B8AFA399928E8F92979EA6AFB8C1CAD3DBE2E8EDF2F5
F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3EFEC
E8E2DCD6D1CBC2B8B3B2AEA195939DA8A08D808292AAC0C5
B9A28B766961606369717B858F9AA5B1BCC6D0D9E0E7EDF2
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F2EFEB
E6E0DAD6D0C7BCB6B4B0A294919CA4967F76819DB9BEA990
7964544B4A4F58626C757F87909AA3ADB7C1CAD3DBE2E8ED
F2F5F8FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEB
E5DFDAD5CDC2BAB8B4A696929CA28F777184A6B59D7D6960
5B5A5C6572808C979EA3A7ABAEB2B7BCC1C7CED4DAE1E6EB
F0F3F6F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F2EEE9
E4DFDAD3C9C0BCB9AD9B949CA28E736F88ABA57C5D566379
8E9FADB7BABABBBEC2C7CBD0D4D6D7D8D9DADBDEE1E4E8EC
EFF3F6F8FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F7F4F1EEE8
E3DFDAD0C6C1BFB5A3989DA592756E89AB96674E587EAFD8
DDC29F7F6A63666E7A8796A7B7C7D6E2EAEDEEEDECEDEEF0
F2F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF9F6F4F1EDE8
E4DFD8CEC7C4BEAE9F9FA89B7B6F88AA8F5C49639FD7B788
674A2C130B111B283646586D8399AEC1D3E1ECF4F8F8F7F6
F6F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF8F6F4F1ECE8
E4DFD6CDC9C6B9A8A2ABA6877284A9925A486DB8C2753F27
1D110100000B13181F29394B60768CA1B5C7D6E3EEF5FBFD
FCFBFBFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F7F4F0ECE8
E5DED4CFCDC5B4A8ADB1977A80A69D61486EC2AD541E142F
414642424D5A4B4039393F495666798C9FB1C2D1DEE9F1F7
FCFEFFFEFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F7F4F0ECE9
E4DCD4D1CEC1B1AFB8AA897F9DAD724A65BBA94B212E55B9
CFD4D4D5D9E0A88E786A615F6169748393A3B4C3D1DDE7EF
F5F9FCFEFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F7F3EFECE9
E3DBD5D4CDBDB2B8BA9E8592B6905558A5B64C204FBAD5ED
F4F6F6F6F8F7EDECC4A48E7F78777C85909EACBBC8D4DFE8
EFF4F8FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF9F6F3EFEDE9
E2DAD7D5C9BAB7C0B4948CACB2705283CF651632BEE7F4FA
FDFDFDFEFEFEFCFCF8D2B5A1948D8C8F96A0ABB7C3CFD9E2
EAF0F5F8FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F2F0EDE8
E0DBD9D3C4B9BDC2A98F99BE9B6064B7A12D0E60D8F4FCFE
FFFFFFFFFFFFFFFFFCE9D2BFB0A5A09EA1A7AFB8C2CDD6DF
E7EDF2F6F9FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2F0EDE7
E0DCDAD0C1BBC2BC9E8FA8BE835B7FD8731B31C8EFFBFEFF
FFFFFFFFFFFFFFFFFFFDE9D6C7BBB3AFAEB1B6BDC5CDD6DE
E5EBF0F4F8FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F3F0ECE5
DFDDD9CCBFBEC3B29492B3AD6E5A97CD551444D6F6FDFFFF
FFFFFFFFFFFFFFFFFFFDF1E4D7CCC4BEBCBCBFC3C9D0D7DE
E4EAEFF3F7F9FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F3F0EBE4
E0DDD6C8BEC0C0A68E97B6965B5AA7B13C0C48D6F6FEFFFF
FFFFFFFFFFFFFFFFFFFDF7EDE3DAD2CCC9C7C8CBCFD4DAE0
E5EAEFF3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF8F5F3F0EAE4
E1DDD3C5BFC2BA9C8B9DB07E4C5DB090200043D5F6FEFFFF
FFFFFFFFFFFFFFFFFFFFFEF5EDE5DED8D4D2D2D3D6DADEE2
E7ECF0F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFAF8F5F3F0EAE4
E1DCD0C4C1C3B2958DA3A46A4565B4710A0041D5F6FEFFFF
FFFFFFFFFFFFFFFFFFFFFCF9F3EDE7E2DEDCDBDBDCDFE2E6
EAEDF1F4F6F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3EFE9E5
E2DBCEC4C3C1AB9291A8985E4572B35F04004AD5F6FEFFFF
FFFFFFFFFFFFFFFFFFFFFCFAF7F2EEEAE6E4E2E2E3E4E7E9
ECEFF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3EFE9E6
E2DACDC5C5BFA69197AA8E584C80B45D0E0A52CCF4FDFFFF
FFFFFFFFFFFFFFFFFFFFFDFBF9F6F3F0EDEBE9E8E8E9EBED
EFF1F4F6F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6F3EFEAE7
E2D9CDC8C7BDA4949EAB8859568DB7641C12418DE6FBFFFF
FFFFFFFFFFFFFFFFFFFEFDFCFAF9F6F4F2F0EEEEEDEEEFF0
F2F4F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F7F3EFEBE8
E2D8CECAC9BBA499A5AC875E6096BC702A163478D9F7FEFF
FFFFFFFFFFFFFFFFFFFFFEFDFBFAF9F7F5F4F3F2F2F2F2F3
F4F6F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F7F3EFEBE9
E2D9D0CDCABBA69FACAE89666A9DC27D391D3067A8E6F6FD
FFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F8F7F6F5F5F5F5F6
F7F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF9F7F3F0ECE9
E3DAD2D1CCBCAAA6B2B08D6F74A1C78C4A2A335C8FBBD9F4
FBFDFFFFFFFFFFFFFEFEFEFEFEFDFCFBFAF9F8F8F8F7F8F8
F8F9FAFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7F4F0EEEA
E4DBD5D4CEBEAFADB8B494797DA5CC9D5E3B3C577CA0C2DC
E9F1FBFCFCFDFDFEFEFEFDFDFEFEFDFCFBFBFAFAFAF9FAFA
FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F4F1EFEB
E5DDD9D7D0C2B4B4BEB99C8386A8D0AE745048577190AFC8
D9E5F0F6F8FAFBFCFDFEFEFDFDFEFEFDFDFCFCFBFBFBFBFB
FBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2F0EC
E6E0DCDAD3C6BBBBC4BFA58F8FACD3BF8B66575C6D86A1B9
CBDAE6EEF4F7F9FAFCFDFEFDFDFEFEFEFEFDFDFDFCFCFCFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F1EE
E8E2DFDDD6CBC1C2CAC5AF9A99B0D5CFA27D6966708299AE
C1D0DDE7EEF3F7F9FAFCFDFEFEFDFEFEFEFEFEFDFDFDFDFD
FDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F6F5F2EF
EAE5E2E0DAD0C8C8CFCCB9A6A3B5D5DDB7937C73778495A8
B9C9D6E1E9EFF4F7F9FBFCFDFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F7F6F4F0
ECE8E6E4DED5CECFD4D2C2B2ADBAD5E7CAA99184828996A5
B5C3D0DCE5ECF1F5F7FAFBFDFEFEFEFEFEFEFFFFFFFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F5F2
EEEBE9E7E2DAD4D5DAD9CCBDB7C0D6ECDBBDA49590939BA7
B4C1CDD8E1E9EEF3F6F8FAFCFDFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F8F6F3
F0EDECEAE6DFDADADFDFD5C8C1C7D7EDE8CEB7A79F9EA3AB
B6C1CCD6DFE6ECF1F5F8FAFBFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5
F2F0EFEDE9E4E0E0E3E4DDD2CBCDD9ECF2DDC8B8AEABACB2
BAC3CCD6DEE5EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F6
F4F2F1F0EDE8E5E5E8E9E4DBD4D4DCEAF7E9D7C8BDB8B7BA
C0C7CFD7DEE5EBEFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFBF9F8
F6F4F3F2F0EDE9E9EBEDEAE2DCDBE0EAF8F3E3D5CBC5C3C3
C7CCD2D9DFE5EBEFF3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9
F8F6F6F5F3F0EEEDEFF1EFE9E3E1E4EBF6FAEDE1D7D1CDCD
CFD2D7DCE2E7ECF0F3F6F8FAFCFDFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFA
F9F8F7F7F5F3F1F0F2F4F3EEEAE7E8EDF5FDF5EAE2DBD7D6
D7D9DCE0E4E9EDF0F4F6F8FAFCFDFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFB
FAF9F9F9F8F6F4F3F4F6F6F3EFECECEFF4FCFAF2EAE4E0DE
DEDFE1E4E8EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFC
FBFBFAFAF9F8F7F6F7F8F8F6F3F0F0F1F5FAFEF7F1ECE8E6
E5E5E7E9EBEEF1F3F6F8F9FBFCFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFBFBFAF9F8F8F9FAF9F6F4F3F4F6FAFFFBF6F2EEEC
EBEBEBEDEEF1F3F5F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFDFCFCFCFBFAFAFAFBFCFBF9F7F6F6F7FAFDFEFAF6F3F1
F0EFF0F0F2F3F5F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFDFCFCFBFBFCFDFCFBF9F8F8F9FAFDFFFCF9F7F5
F4F3F3F4F4F5F7F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFDFDFCFCFDFDFDFDFBFAFAFAFBFDFEFEFCFAF8
F7F6F6F6F7F8F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFDFDFDFEFEFEFDFCFBFBFCFDFEFFFDFCFB
FAF9F9F9F9F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFEFFFEFEFDFCFCFDFDFEFFFEFDFC
FBFBFBFAFBFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFFFFFEFEFDFDFDFEFEFFFFFEFD
FDFCFCFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFFFFFE
FEFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 50.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 50.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFDFDFDFDFDFDFDFDFCFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFDFDFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFDFDFDFCFCFCFCFCFCFCFBFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFCFCFDFDFDFDFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFD
FDFDFDFCFCFCFCFBFBFBFBFAFAFAFAFAFAFAFAFAFAF9F9F9
F9F9F9F9F9F9F9FAFAFAFAFAFAFAFBFBFBFCFCFCFDFDFDFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFD
FDFCFCFBFBFBFAFAFAF9F9F9F9F8F8F8F8F8F8F8F8F8F7F7
F7F7F7F7F7F7F7F8F8F8F8F8F8F9F9FAFAFAFBFBFCFCFDFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFC
FCFBFBFAFAF9F9F8F8F8F7F7F7F6F6F6F6F6F6F6F5F5F5F5
F5F5F5F5F5F5F5F5F5F5F6F6F6F7F7F8F8F9FAFAFBFBFCFC
FDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFB
FBFAF9F9F8F7F7F6F6F5F5F4F4F4F4F3F3F3F3F3F3F3F3F3
F2F2F2F2F2F2F2F2F2F3F3F4F4F5F5F6F7F7F8F9F9FAFBFB
FCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFA
F9F9F8F7F6F5F5F4F3F3F2F2F1F1F1F0F0F0F0F0F0F0EFEF
EFEFEEEEEEEEEFEFEFEFF0F0F1F2F2F3F4F5F6F7F8F9FAFA
FBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFAF9
F8F7F6F5F4F3F2F1F0EFEFEEEEEDEDEDEDEDECECECECEBEB
EBEBEAEAEAEBEBEBEBEBECECEDEEEFF0F1F2F4F5F6F7F8F9
FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAFAF9F7
F6F5F4F3F1F0EFEEEDECEBEAEAE9E9E9E9E8E8E8E7E7E7E7
E7E6E6E6E6E6E5E5E6E6E7E8E9EAEBEDEEF0F1F3F4F5F7F8
F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFBF9F8F7F6
F4F3F1F0EEEDEBEAE9E8E7E6E5E5E4E4E4E4E3E3E3E3E3E2
E2E1E1E0E0DFDFE0E0E1E2E3E4E6E7E9EBEDEEF0F2F4F5F7
F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF8F7F6F4
F2F0EFEDEBE9E7E6E4E3E2E1E0E0DFDFDEDEDEDEDEDEDEDD
DCDBDADAD9D9DADADBDCDDDEDFE1E3E5E7E9EBEDEFF1F3F5
F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F2
F0EEECE9E7E5E3E1DFDEDDDBDBDAD9D9D9D9D9D9D9D8D7D6
D5D5D4D4D4D4D4D4D5D5D6D8D9DBDDDFE2E4E7EAECEFF1F3
F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F6F4F2F0
EDEBE8E6E3E1DEDCDAD8D7D5D4D4D3D3D3D4D3D3D2D2D1D0
D0CFCFCECECDCCCCCCCDCED0D2D4D7DADDE0E3E6E9ECEFF1
F4F6F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F2F0ED
EBE8E5E2DFDCD9D7D4D2D0CFCECDCDCDCDCDCDCCCCCCCCCC
CBCAC8C6C5C3C3C3C3C4C6C9CBCED1D5D8DCE0E3E7EAEDF0
F2F5F7F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1EEEB
E8E5E1DEDAD7D4D1CECCCAC8C8C7C7C6C6C6C6C7C8C8C8C6
C4C1BFBCBBBABABBBCBEC1C3C7CACDD1D5D9DDE1E4E8EBEE
F1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF8F6F4F2EFECE9
E5E1DEDAD6D2CFCBC8C6C4C2C1C0BFBFBFC0C2C3C3C3C0BE
BBB8B6B5B4B5B5B7B8BABCBEC1C4C8CCD0D4D9DDE1E5E9ED
F0F3F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F7F5F3F0EDEAE6
E2DEDAD6D1CDC9C5C2BFBDBCBAB8B8B8BABCBDBDBCBAB8B6
B5B3B3B2B2B1B0B0B0B1B3B5B8BBBFC4C9CED3D8DDE2E6EA
EEF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F2EFECE8E4
E0DBD6D2CDC8C4C0BCBAB7B4B2B2B2B4B5B6B6B5B5B5B5B5
B4B3B1AEAAA7A5A3A3A4A6A9ADB2B7BCC2C8CDD3D9DEE3E8
ECEFF3F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEAE6E2
DDD8D3CEC8C3BFBBB7B4B0AEACACADAEAEAEAEB0B3B5B7B6
B2ADA7A19B989696989B9EA3A8ADB3B8BEC5CBD1D6DCE1E6
EAEEF1F4F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F8F5F3F0ECE9E4DF
DAD5D0CAC4BFBAB6B2ADAAA8A8A8A7A6A6A7ABB1B5B6B4AF
A79F999491919295989CA1A5AAAFB5BAC0C6CCD1D7DCE1E6
EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F7F5F2EFEBE7E2DD
D8D3CDC6C1BBB6B1ACA8A5A4A4A2A09FA1A7ADB1B1AEA9A3
9D99969596989A9D9FA2A5A9ADB1B6BBC1C7CDD3D8DDE2E7
EBEEF2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F4F1EEEAE6E1DC
D6D0CAC3BEB8B2ACA7A4A2A19E9B9A9DA3A8A9A8A5A4A3A3
A3A3A3A19F9D9B9999999B9EA2A7ADB4BAC2C9D0D6DDE2E7
EBEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DA
D4CEC7C1BBB5AEA9A5A29F9B97969A9FA2A19D9DA1A8AFB3
B3AEA59A908984818183868A90969DA5AEB7C0C8D0D8DFE5
EAEEF2F5F7F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE8E4DFD9
D3CCC6BFB9B2ABA6A3A09B9695989C9D999597A0ADB9BDB8
AC9C8B7E75706F7073777B80868C949CA5AEB7C1CAD2DAE0
E6ECF0F4F6F9FBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E3DED8
D1CBC4BEB7B0AAA6A29C9694979A9A949094A0AFB8B5ACA0
928479737275797E8286898D91959AA1A7AFB6BEC6CED6DD
E3E9EDF2F5F8FAFBFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3EFECE7E2DDD7
D1CAC4BDB5AEAAA59F9995979A98918D93A1AEAEA49B9693
908D8D90969CA2A6A9AAABACADAEB1B3B7BBBFC4CAD0D6DC
E1E7EBF0F3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEBE7E2DCD6
D0CAC3BCB4AFAAA49D98989B98908C93A2ACA5968F94A1AE
B7BCBCB8B3B0AFB0B2B4B7BBBFC4C7CACCCECFD1D4D7DADE
E3E7EBEFF2F5F8FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEBE7E2DCD6
D0CAC3BBB5B0AAA39C9A9D9B928C92A2AA9E8E8B99B3CEDA
D4C0A790817C7B7E82878F99A5B1BEC9D2D9DEE0E1E2E3E5
E7EAEDF0F2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7F5F2EFEBE6E1DCD6
D0CAC2BBB6B1AAA29EA09F968E92A2AA9B8B8CA2C3D3C1AA
97826A564E4F5153565B636E7C8C9CACBCCAD6E0E7EBEDEE
EEEFF1F2F4F6F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F7F5F2EEEBE6E1DCD6
D0C9C2BDB8B2A9A4A4A49C9292A1AA9C8A8DA9CCC5A1877B
7468594F4F54524E4A4B4F5763707F8FA0B0C0CEDBE5EDF2
F5F6F6F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F4F2EEEAE6E1DCD6
D0C9C3BFB9B2AAA8AAA599949FACA18C8CAACFBC927A7787
8F8E87858A8D7D6E635C595A5D646E7B8A99AABAC8D6E1EA
F2F7F9FAFAFAFBFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE6E1DCD6
D0C9C4C0B9B1ADAEADA3999EAEA9928AA4CDBA8F7E89A1D8
E4E5E4E4E6E9BFAA9585786E69686B737E8B9AA9B8C6D3DF
E8F0F6FAFCFDFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DCD6
CFC9C5C0B9B2B0B2ADA19FACB39E8C9AC5C08F7E9DD9E8F5
F9FAFAFAFAFAF2F1D1B49D8A7E7674767C85919EADBAC8D4
DFE8EFF5F9FCFEFFFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DBD5
CEC9C5BFB7B2B3B3AAA1A7B7AF9593B6CC98778CDBF2F9FD
FEFEFEFEFEFEFDFDFAD8BDA7978B84818388909AA6B3BFCB
D6E0E8EFF4F8FBFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F6F4F1EDE9E5E0DBD4
CEC9C4BDB5B2B4B0A5A2AFBAA693A3CEB57E75A7EAFAFDFF
FFFFFFFFFFFFFFFFFCEBD6C2B1A298918E8F949BA5AFBBC6
D1DAE3EAF0F5F8FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F4F1EDE9E4E0DAD3
CDC8C2BAB3B2B3AAA0A2B3B49B93B3D59F7589E0F7FDFFFF
FFFFFFFFFFFFFFFFFFFDE9D7C5B6AAA19C9A9CA0A7B0B9C3
CDD7DFE7EDF2F6F9FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F4F1EDE9E4DFD9D2
CCC7C0B7B1B1AEA29AA2B2A68E92BCCB8E7192E7FAFEFFFF
FFFFFFFFFFFFFFFFFFFDF1E2D4C6BBB1ABA7A6A8ADB3BBC3
CCD5DDE4EAF0F4F7FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F4F0EDE8E4DED8D1
CCC6BDB4B0AFA89A96A2AA95808FBEB77B6790E7FAFEFFFF
FFFFFFFFFFFFFFFFFFFDF6EBE0D4C9C0B9B4B2B2B4B9BFC6
CDD5DCE3E9EEF2F6F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6F4F0ECE8E4DED7D1
CBC4BAB2AFACA19493A09F84768EBA9E645889E5FAFEFFFF
FFFFFFFFFFFFFFFFFFFFFDF4EAE0D6CDC6C1BDBCBDC0C4CA
D0D6DDE3E8EDF2F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6F4F0ECE8E3DDD6D0
CAC2B7B0AEA89A8F929D93777090B387514D85E4FAFEFFFF
FFFFFFFFFFFFFFFFFFFFFBF7F0E8E0D8D2CCC8C6C6C8CBCF
D4D9DEE4E9EDF1F5F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6F4F0ECE8E3DCD6D0
C9C0B6B0ADA4958C939A896E7095AE7B4B4D87E4FAFEFFFF
FFFFFFFFFFFFFFFFFFFFFCF8F4EEE8E1DBD6D3D0CFD0D1D4
D8DCE1E5EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFBFAF9F6F3F0ECE8E3DCD6D0
C8BEB5B0ACA1928C9497816B739CAC784D5287DBF8FEFFFF
FFFFFFFFFFFFFFFFFFFFFCFAF6F2EEE9E4DFDBD9D7D7D8DA
DDE0E4E8ECEFF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFBFAF9F6F3F0EDE8E3DCD6D0
C8BEB5B1AB9E918E96957D6B78A1AD7A515075ACEDFCFFFF
FFFFFFFFFFFFFFFFFFFEFCFAF8F5F2EEEAE6E3E1DFDEDFE0
E2E4E7EAEDF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F6F4F0EDE8E3DDD7D0
C8BEB6B2AA9D919199947C6D7DA5AF7E534A6599E2F9FEFF
FFFFFFFFFFFFFFFFFFFEFDFBF9F7F4F2EFECE9E7E5E5E5E5
E7E8EBEDF0F2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFDFDFCFAF9F7F4F1EDE9E3DDD7D1
C8BFB8B3AB9D93959C947D7181A7B18357485B88BBEBF8FD
FFFFFFFFFFFFFFFFFEFEFDFDFBF9F6F4F2F0EEECEBEAEAEA
EBECEEF0F2F4F6F8F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EEE9E4DED8D2
C9C0BAB5AC9F97999F95807584A8B48A5D495679A2C4DDF5
FBFCFEFFFFFFFEFEFEFDFCFDFDFBF9F7F5F3F2F0EFEFEEEE
EFF0F1F2F4F5F7F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F2EEEAE4DFDAD3
CAC2BDB8AEA29B9EA298837987A8B7936650556D8DABC7DE
E9F0FBFBFBFCFCFDFDFDFCFCFCFCFBF9F8F6F5F4F3F2F2F2
F2F3F4F5F6F7F8FAFBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEAE5E0DBD4
CCC5C0BAB1A5A0A3A69C887E8AA9BC9E735957657D98B3C9
D8E4EEF4F7F8F9FAFCFDFCFBFBFCFCFBFAF9F7F6F6F5F5F5
F5F5F6F7F8F9FAFAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3EFEBE7E2DDD6
CEC8C3BEB4AAA5A8AAA08E848EAAC0AA82665C627289A2B8
C8D7E3EBF0F4F6F8FAFCFCFBFBFBFCFCFCFBFAF9F8F7F7F7
F7F7F8F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E4DED8
D1CBC7C1B8AFABADAFA6958B93ACC4B7937464636D7F95A9
BACAD7E2E9EFF3F5F7F9FBFCFBFBFBFCFCFCFCFBFAF9F9F9
F9F9FAFAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F4F1EDE9E5E1DA
D4CFCBC5BDB4B1B3B4AC9D9399AEC7C4A48470686D7A8C9E
AFBFCDD8E2E9EEF2F4F7FAFBFCFBFBFCFCFDFDFCFCFBFBFB
FBFBFBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F2EFEBE7E3DD
D7D3CFCAC2BAB7B9BAB3A69C9FB1CACEB4957E7271798796
A6B5C4D0DBE3EAEEF2F5F8FAFCFCFCFCFCFDFDFDFDFCFCFC
FCFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F8F6F3F0EDE9E5E0
DBD7D3CEC7C0BDBFC0BBAFA5A7B5CBD6C3A68E7F7A7D8692
A0AFBDC9D4DEE5EBEFF3F6F8FBFCFCFCFCFCFDFDFEFDFDFD
FDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEBE7E3
DEDBD7D3CDC7C4C5C6C2B8AFAEB9CCDBD1B79F8D85848992
9EABB8C4CFD9E1E8EDF1F4F7F9FBFCFDFDFDFDFDFEFEFEFE
FEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0EDEAE6
E2DEDCD8D2CDCACBCDCAC1B9B7BECDDEDCC7B09D928E9096
9FAAB5C1CBD5DEE5EBEFF2F5F8FAFCFDFDFDFDFEFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF8F6F4F2EFECE9
E5E2E0DCD7D3D0D1D3D1CAC2BFC3CFDFE5D5C0ADA19A999C
A2ABB5BFCAD3DBE3E9EDF1F4F7F9FBFDFDFDFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1EEEB
E8E6E4E1DDD9D6D7D9D8D2CBC7C9D2E0EAE1CFBDB0A7A4A4
A8AFB7C0C9D2DAE1E7ECF0F4F6F9FBFCFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EE
ECE9E8E5E2DEDCDCDEDEDAD4CFD0D6E0ECEADCCCBEB5AFAE
B0B5BBC3CAD2DAE1E7ECF0F3F6F8FAFCFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFAF9F8F6F5F3F1
EEEDEBE9E6E3E1E2E3E3E0DBD7D6DAE2ECF1E6D8CCC2BCB9
B9BCC1C7CDD4DBE1E7EBF0F3F6F8FAFBFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F5F3
F1F0EEEDEAE8E6E6E7E8E6E2DEDCDEE4EDF4EFE3D8CEC8C4
C3C4C7CCD1D7DCE2E7ECF0F3F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F6F5
F4F2F1F0EEECEBEBEBECEBE8E4E2E3E6EDF5F5ECE2DAD3CE
CCCCCED1D5DADFE4E8EDF0F3F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F8F7
F6F5F4F3F1F0EFEEEFF0EFEDEAE8E7E9EEF5F9F3EBE3DDD8
D5D5D5D7DADEE2E6EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F8F7F6F5F4F3F2F2F2F3F3F1EFECEBEDF0F5FAF9F2EBE5E1
DEDCDCDEE0E2E6E9ECEFF2F5F7F9FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFA
F9F9F8F7F7F6F5F4F5F5F6F5F3F1EFF0F2F5FAFCF7F1ECE8
E5E3E3E3E5E7E9ECEEF1F3F6F8F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFB
FAFAFAF9F9F8F7F7F7F7F8F7F6F4F3F3F4F6FAFDFBF6F2EE
EBEAE9E9EAEBEDEFF1F3F5F7F8FAFBFCFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFC
FCFBFBFBFAFAF9F9F9F9FAF9F8F7F6F5F6F7FAFDFDFAF6F3
F1EFEEEEEEEFF0F1F3F5F6F8F9FAFCFCFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFD
FDFCFCFCFBFBFBFAFAFBFBFBFAF9F8F8F8F9FAFDFFFDFAF7
F5F3F2F2F2F2F3F4F5F7F8F9FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFD
FDFDFDFDFCFCFCFCFBFCFCFCFCFBFAF9F9FAFBFCFEFEFCFA
F8F7F6F5F5F5F6F6F7F8F9FAFBFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFDFDFDFDFDFCFDFDFDFDFCFCFBFBFBFCFDFEFFFEFC
FAF9F8F8F7F8F8F8F9FAFAFBFCFCFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFDFDFDFDFEFEFDFDFCFCFCFCFDFEFFFFFD
FCFBFAFAFAFAFAFAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFDFDFEFFFFFE
FDFDFCFCFBFBFBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFFFFFFFEFEFEFEFEFEFEFFFFFF
FEFEFDFDFCFCFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFFFF
FFFEFEFEFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 55.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 55.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFDFDFDFDFDFDFDFDFDFDFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFDFDFDFDFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FDFDFDFDFDFDFCFCFCFCFCFCFCFCFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFCFDFDFDFDFDFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFD
FDFDFCFCFCFCFBFBFBFBFBFBFAFAFAFAFAFAFAFAFAFAFAFA
FAFAFAFAFAFAFAFAFAFAFAFAFAFAFBFBFBFBFCFCFCFDFDFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFC
FCFCFBFBFBFAFAFAFAF9F9F9F9F9F9F9F8F8F8F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F8F9F9F9FAFAFAFBFBFBFCFCFC
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFB
FBFBFAFAF9F9F9F8F8F8F7F7F7F7F7F7F6F6F6F6F6F6F6F6
F6F6F5F5F5F5F5F6F6F6F6F6F7F7F7F8F8F9F9F9FAFAFBFB
FCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFA
FAF9F9F8F8F7F7F6F6F6F5F5F5F5F4F4F4F4F4F4F4F3F3F3
F3F3F3F3F3F3F3F3F3F3F4F4F4F5F5F5F6F7F7F8F8F9FAFA
FBFBFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFAFAF9
F8F8F7F6F6F5F4F4F3F3F3F2F2F2F2F1F1F1F1F1F1F0F0F0
F0F0F0F0F0F0F0F0F0F0F0F1F1F2F2F3F3F4F5F6F7F7F8F9
FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F8F7
F7F6F5F4F3F2F2F1F0F0F0EFEFEFEEEEEEEEEEEDEDEDEDED
ECECECECECECECECECECEDEDEEEEEFF0F1F2F3F4F5F6F7F8
F8F9FAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F9F8F7F6
F5F3F2F1F0EFEFEEEDEDECECEBEBEBEAEAEAEAEAE9E9E9E9
E8E8E8E8E7E7E7E7E8E8E8E9EAEAEBECEDEFF0F1F2F3F5F6
F7F8F9FAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F6F5F3
F2F1F0EEEDECEBEAE9E9E8E8E7E7E7E6E6E6E6E6E5E5E5E4
E4E3E3E3E3E2E2E3E3E3E4E4E5E6E7E8EAEBECEEEFF1F2F4
F5F7F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F6F4F3F1
F0EEEDEBEAE8E7E6E5E4E4E3E3E2E2E2E2E1E1E1E1E0E0DF
DFDEDEDEDDDDDDDDDDDEDEDFE0E1E2E4E5E7E9EAECEEF0F2
F3F5F6F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F5F4F2F0EF
EDEBE9E7E6E4E3E1E0DFDFDEDEDDDDDDDDDDDDDCDCDBDBDA
DAD9D9D8D8D7D7D7D7D8D8D9DADCDDDFE1E3E5E7E9EBEDEF
F1F3F5F6F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF8F7F5F4F2F0EEEC
EAE7E5E3E1E0DEDDDBDAD9D9D8D8D8D8D8D8D7D7D7D6D6D5
D4D4D3D2D1D1D0D0D1D1D2D3D4D6D8DADCDEE0E3E5E8EAED
EFF1F3F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F2F0EDEBE9
E6E4E1DFDDDBD9D7D6D5D4D3D3D3D2D2D2D2D2D2D2D1D1D0
CFCDCCCBCBCACACACACBCCCDCED0D2D4D7D9DCDFE2E4E7EA
EDEFF2F4F6F7F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFCFCFBF9F8F6F4F2F0EEEBE8E6
E3E0DDDBD8D6D4D2D0CFCECDCDCDCDCDCDCDCECDCDCCCBCA
C9C8C6C5C4C4C4C3C4C4C5C6C8CACCCED1D4D7DADDE1E4E7
EAEDF0F2F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F5F3F1EEEBE8E5E2
DFDCD9D6D3D1CECCCBC9C8C7C7C7C7C8C8C9C9C9C8C7C6C5
C3C2C1C0BFBEBDBDBDBDBEBFC1C3C5C8CBCED2D6D9DDE1E4
E8EBEEF1F3F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFECE9E6E2DF
DBD8D4D1CECBC9C7C5C3C2C2C1C2C2C3C3C4C4C4C4C3C2C1
BFBDBBBAB8B7B6B5B5B6B7B8BABDBFC3C6CACED1D6DADEE2
E5E9ECEFF2F4F6F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F3F0EDEAE7E3DFDB
D8D4D0CCC9C6C3C1BFBEBDBCBCBCBDBEBFBFC0C0C0C0BEBD
BBB8B6B3B1B0AFAFAFB0B1B3B5B8BBBEC2C5C9CED2D6DBDF
E3E7EBEEF1F3F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF8F6F4F2EFECE8E4E1DCD8
D4D0CCC8C4C1BEBCBAB8B7B7B7B7B8B9BABCBDBDBDBDBBB9
B6B3B0AEACABAAAAAAABACAEB0B3B6B9BDC1C5CACFD3D8DD
E1E5E9EDF0F3F5F7F9FAFCFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F7F5F3F0EDEAE6E2DEDAD5
D0CCC8C4C0BCB9B7B5B3B2B2B2B2B3B5B7B9BABBBBBAB8B5
B2AFADABA9A8A7A6A6A6A7A9ABADB0B4B7BCC0C5CAD0D5DA
DFE3E7EBEFF2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F2EFECE8E4E0DCD7D2
CDC8C4BFBBB8B5B2B0AFAEADADAEB0B2B4B6B8B8B8B7B6B4
B1AFACA9A6A4A2A1A0A0A1A2A4A7AAAEB2B6BBC1C6CCD1D7
DCE1E6EAEDF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFCFBFAF8F6F4F1EEEBE7E3DED9D4CF
CAC5C0BCB7B4B1AEACABAAA9AAABADAFB1B3B5B7B8B8B7B5
B2AEAAA5A19E9C9A9A9A9B9D9FA2A6AAAEB3B8BDC3C9CFD5
DADFE4E8ECF0F3F5F8F9FBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFCFBFAF8F6F3F1EDEAE6E1DCD7D2CD
C7C2BDB8B4B0ADABA9A7A6A6A7A9AAACAFB1B4B7B9BAB8B5
B0ABA5A09C9A989898999B9D9FA2A6A9AEB2B7BDC2C8CED4
D9DEE3E8ECEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBF9F7F5F3F0ECE9E4E0DBD5D0CA
C5BFBAB5B1ADAAA8A6A4A4A4A5A6A8AAADB1B6B9BBBAB8B3
ADA8A39F9D9C9B9C9D9E9FA0A2A5A7ABAFB3B8BDC3C9CED4
D9DEE3E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFAF9F7F5F2EFECE8E3DED9D4CEC8
C3BDB8B3AFABA8A5A4A3A3A3A4A4A6A9AEB3B7B9BAB9B6B3
AFABA8A5A3A2A1A0A0A0A0A0A1A3A6A9ADB2B7BDC3C9CED4
DADFE3E8ECEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFCFAF9F7F4F2EFEBE7E2DDD8D2CDC7
C1BBB6B1ADA9A6A4A2A2A2A2A2A4A7ABAFB3B5B7B9BABAB9
B7B3AFABA6A29F9C9A9999999A9C9FA2A7ADB3B9C0C6CDD3
D9DEE3E8ECEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEAE6E1DCD7D1CBC5
C0BAB5B0ACA8A5A3A2A2A1A1A2A5A9ACAFB1B4B8BDC2C4C3
BEB7AEA59E999593919190919294979BA0A6ACB3BBC2C9D0
D7DDE2E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEAE6E1DCD6D0CBC5
BFB9B4AFABA7A5A3A2A1A1A2A4A8AAACADB0B6BEC6CAC9C3
BAAFA59D98959393939292929394979A9FA4AAB0B7BEC5CC
D3DAE0E5EAEEF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DBD6D0CAC4
BEB9B4AFABA8A5A4A2A1A2A4A7A9AAABAFB5BEC5C8C7C3BD
B4ACA5A2A1A2A3A4A4A3A2A1A1A1A2A4A7AAAEB3B8BEC4CA
D1D7DDE3E8ECF0F4F6F8FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBFAF8F6F3F0EDE9E5E0DBD5D0CAC4
BFB9B4AFACA9A6A5A3A3A4A7A9AAAAAEB5BDC1C2C0C0C0BF
BDB9B8B7B9BABBBBBAB9B7B6B5B5B5B5B6B8B9BCBFC3C7CC
D1D7DCE2E7EBEFF3F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBFAF8F6F3F0EDE9E4E0DBD5D0CAC4
BFBAB5B0ADAAA8A6A5A6A8AAAAAAAEB5BCBFBDBBBDC4CDD3
D4D2CCC6C1BDBBBAB8B7B7B8BABDC0C3C5C6C8C9CACCCED1
D5D9DDE2E6EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F8F5F3F0ECE9E4DFDAD5D0CAC5
C0BBB6B2AFADAAA8A8A9ABABABAEB5BCBEBBB9BDC9D7E1E3
DBCEBEB0A7A3A19F9D9D9EA1A6ADB5BCC3C9CED2D4D6D8DA
DCDEE1E4E8EBEEF1F4F7F9FAFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F8F5F3F0ECE8E4DFDAD5D0CAC5
C0BCB7B4B1AFACABACADADACAEB5BCBEBAB8BFCDDBDED5CC
C2B4A49893918E8B878586898E959EA7B1BAC4CDD4DADEE1
E3E5E7E8EBEDF0F2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F7F5F3F0ECE8E4DFDAD5D0CBC6
C1BDB9B6B4B1AFAFB1B1AFAFB5BCBEBAB8C0D0DDD6C8BEBA
B5ACA29A9999938C85807E7E80848A929BA6B1BCC7D1DAE1
E6EAECEEEFF0F2F4F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F7F5F2EFECE8E4DFDAD5D0CBC6
C1BDBAB8B5B3B3B4B5B3B2B5BDC0BCB8BFD0DDD4C3BABBC3
C6C3BEBBBDBCAFA2988F88837F7E7F848A939EAAB6C2CED8
E1E8EDF1F3F4F5F6F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F7F5F2EFECE8E3DFDAD5D0CBC6
C1BEBBB9B6B5B6B8B8B6B7BEC3C0BABDCDDCD3C3BDC5D1EC
F1F2F1F0F1F2D8C9B9AB9E9288827E7E8288909BA6B3BFCB
D6E0E8EEF3F6F8F9F9FAFBFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F7F5F2EFEBE7E3DED9D4CFCAC5
C1BEBBB9B7B6B8BAB9B8BDC5C5BEBCC9DBD4C2BECEEDF4FA
FCFCFCFCFDFCF7F6E0CBB7A6988E8682818489919BA6B3BF
CBD6DFE8EEF4F7FAFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F5F2EFEBE7E3DED9D4CFC9C4
C0BDBAB8B6B7B9B9B8BAC3C9C4BEC5D7DAC4B9C6EDF9FCFE
FFFFFFFFFFFFFEFEFBE3CEBCAC9F948C8786888D959EA9B5
C0CCD6E0E8EEF4F8FAFCFDFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F5F2EFEBE7E2DDD8D3CEC8C3
BFBCB9B5B4B6B7B6B6BBC5C8C1C0CEE0D0BABAD4F5FDFEFF
FFFFFFFFFFFFFFFFFDF0E0D0C0B1A499928D8C8E939AA4AE
B9C4CFD8E1E9EFF4F8FBFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F5F2EEEBE7E2DDD7D2CDC7C2
BEBAB6B3B2B3B3B2B2BAC3C2BCC1D5E0C7B8C4F0FBFEFFFF
FFFFFFFFFFFFFFFFFFFDEEDECFC0B3A79E979493969BA2AA
B4BFC9D3DCE4EBF0F5F8FBFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F2EEEAE6E1DCD7D1CBC5C0
BCB7B3B0AFB0AEACAEB7BDB8B4BFD6D8BEB4C8F3FDFFFFFF
FFFFFFFFFFFFFFFFFFFDF3E6D9CCC0B4AAA39D9B9B9EA3AA
B3BCC5CFD8E0E7EDF2F6F9FBFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE6E1DCD6D0CAC4BF
BAB5B0ADACABA8A6AAB3B4ADABBBD2CAB1ACC4F2FDFFFFFF
FFFFFFFFFFFFFFFFFFFEF7EDE3D7CCC1B7AFA8A4A3A4A7AD
B3BBC4CCD5DDE4EAEFF4F7FAFCFDFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DBD5CFC9C3BD
B8B2ADAAA9A6A2A1A6ADABA2A5B8CBBAA2A1BFF1FCFFFFFF
FFFFFFFFFFFFFFFFFFFFFEF5EBE1D6CCC3BAB4AFACACADB1
B6BDC4CCD4DBE2E8EDF2F5F8FAFCFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DBD5CEC8C1BC
B5AFAAA7A5A29D9DA3A8A29AA1B7C3AC969ABBF0FCFFFFFF
FFFFFFFFFFFFFFFFFFFFFBF7F0E8DFD6CDC5BEB9B6B4B5B7
BBC0C6CDD4DBE1E7ECF1F4F7FAFBFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DAD4CEC7C0BA
B4ADA8A5A29D999AA1A39B95A0B8BEA49198BBF0FCFFFFFF
FFFFFFFFFFFFFFFFFFFFFBF8F3EDE6DED7CFC9C3BFBDBDBE
C1C5CACFD5DBE1E7ECF0F4F7F9FBFCFDFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DAD4CDC6C0B9
B2ABA7A4A09A96999F9E9693A1B9BBA19098B8EAFBFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF9F5F1EBE5DFD8D2CDC9C6C5C5
C7CACED3D8DDE2E7ECF0F3F6F9FAFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DAD4CDC6BFB8
B1AAA6A29E9895999E9B9292A3BABAA08E91A9CCF4FDFFFF
FFFFFFFFFFFFFFFFFFFEFCF9F6F3EFEAE5E0DAD6D2CFCDCD
CED0D3D7DBDFE4E8ECF0F3F6F8FAFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F4F1EEEAE5E0DAD4CDC6BFB8
B1AAA6A29C9695999D999092A3BAB99F8A899CBEECFBFEFF
FFFFFFFFFFFFFFFFFFFEFDFAF7F4F1EEEAE6E1DDDAD7D5D4
D5D6D8DBDEE2E6EAEDF1F4F6F8FAFCFDFDFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFAF9F7F5F2EEEAE5E0DAD4CDC6BFB8
B1AAA6A29C96959A9D978F91A3B9B89D878292B0D1F1FAFE
FFFFFFFFFFFFFFFFFEFDFDFCFAF6F3F0EDEAE7E3E0DEDCDB
DBDCDDDFE2E5E8ECEFF2F4F7F9FAFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F7F5F2EEEAE6E1DBD4CDC7C0B9
B1ABA7A29C97979B9D968E91A2B7B79D857E8AA3BED5E7F7
FBFDFFFFFFFFFEFEFDFCFBFCFCF9F6F3F0EDEBE8E6E4E2E1
E1E1E2E4E6E8EBEEF0F3F5F7F9FAFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F7F5F2EFEBE6E1DBD5CEC8C1BA
B2ADA8A39D98989C9D968E90A0B5B79F877D8496ABC1D5E5
EDF2FBFBFBFBFBFCFDFBFAFAFAFBF9F6F3F1EEECEAE9E7E7
E6E6E7E8EAECEEF0F2F4F6F8FAFBFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFBF9F7F5F2EFEBE7E2DCD6D0C9C2BB
B4AFAAA59F9A9A9E9E978F909FB4B8A38B7E7F8A9BB0C4D4
DEE7F0F4F6F8F8F9FBFCFAF9F9FAFAF9F7F4F2F0EEEDECEB
EBEBEBECEDEFF0F2F4F6F7F9FAFBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBF9F8F6F3EFECE7E3DDD7D1CBC4BD
B7B1ADA7A19D9DA09F9890919FB3BBA991817C818EA1B4C4
D0DBE5EBF0F3F5F6F8FAFBF9F8F8F9FAFAF8F5F3F1F0EFEF
EEEEEFEFF0F1F3F4F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E4DED9D3CDC6BF
B9B4B0AAA4A0A0A2A19A92939FB3BEB199867C7C8594A5B5
C2CED9E2E8EDF0F2F4F7FAFAF8F7F8F9FAFAF8F7F5F3F3F2
F2F2F2F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DAD5CFC9C2
BCB8B3ADA7A3A3A5A49D9695A0B3C1B8A28C7E7A7F8A99A7
B5C2CED8E0E7EBEEF1F4F7FAF9F8F7F8F9FAFAF9F8F7F5F5
F4F4F4F5F5F6F7F8F9F9FAFBFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF9F7F4F1EEEBE6E1DCD7D1CBC5
C0BBB7B1ABA8A7A9A8A19A99A2B4C3C0AB95847B7C848F9C
A9B6C3CED7DFE6EAEDF0F4F7F9F9F8F8F8F9FAFBFAF9F8F7
F7F7F7F7F7F8F8F9FAFAFBFCFCFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBF9F7F5F2EFECE8E3DED9D4CEC9
C4BFBBB5B0ACACADACA7A09EA5B4C4C6B59F8C807D818994
A0ADB9C4CFD8E0E5EAEDF1F4F8F9F9F9F8F9FAFBFBFBFAFA
F9F9F9F9F9F9FAFAFBFBFCFDFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFCFBF9F8F6F3F0EDE9E5E0DCD7D2CC
C7C3BFBAB5B1B1B2B1ACA6A3A9B6C5CBBFAA96888181868E
99A5B1BCC7D1D9E1E6EAEEF1F5F8FAF9F9F9FAFBFBFCFCFB
FBFAFAFAFAFBFBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEBE7E3DFDAD5D0
CCC8C4BFBAB7B6B7B7B3ADAAADB7C6CFC8B6A2928884868C
959FAAB5C0CAD4DCE2E7EBEFF3F6F9FAFAFAFAFBFBFCFCFC
FCFCFCFCFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFCFAF9F7F5F2F0ECE9E5E1DDD8D4
D0CCC9C4C0BDBCBDBDBAB4B0B2BAC7D2D1C2AE9D918B8A8D
939CA6B1BBC5CFD7DEE4E9EDF1F4F7FAFBFBFBFBFBFCFDFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F1EEEBE8E4E0DCD8
D4D1CEC9C5C3C2C3C3C0BCB8B8BDC8D4D7CCBBAA9D949091
959CA4AEB8C1CBD4DBE2E7EBEFF2F6F9FAFBFBFBFCFCFDFD
FDFEFEFDFDFDFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBFAF8F7F5F2F0EDEAE7E3E0DC
D9D6D3CFCBC9C8C9C9C7C3BFBEC2CAD5DCD6C8B7A99F9997
999EA5ADB6BFC8D1D9DFE5EAEEF1F4F7FAFBFCFCFCFCFDFD
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFCFAF9F8F6F4F1EFECE9E6E3E0
DDDAD7D4D1CFCECECFCECAC6C4C6CDD6DFDED3C4B6ABA3A0
A0A3A8AFB6BFC7CFD7DEE4E8EDF0F3F6F9FBFCFCFDFDFDFD
FEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F5F3F1EEECE9E6E4
E1DFDCDAD7D5D4D4D5D4D1CECBCCD0D8E1E4DDD0C3B7AFAA
A8A9ADB2B9C0C7CFD6DDE3E8ECF0F3F6F8FAFCFDFDFDFDFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFCFCFBF9F8F6F5F3F1EEECEAE7
E5E3E1DFDCDAD9DADADAD8D5D2D1D4DAE2E8E5DBCFC4BBB5
B2B1B3B7BCC2C9D0D7DDE3E8ECEFF3F5F8FAFBFCFDFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F4F3F1EFEDEB
E9E7E5E3E1E0DFDFDFDFDEDBD8D7D9DDE4EAEBE4DACFC6C0
BCBABBBDC1C6CCD2D8DEE3E8ECEFF3F5F7F9FBFCFDFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F7F6F5F3F1EFEE
ECEBE9E8E6E4E4E4E4E4E3E1DEDDDDE0E6ECEFECE3DAD1CB
C6C4C3C4C7CBD0D5DADFE4E8ECF0F3F5F7F9FBFCFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F7F6F5F4F2F1
EFEEEDECEAE9E8E8E8E9E8E6E4E2E2E4E8EDF1F1EBE3DBD5
D0CDCCCCCED0D4D8DDE1E6EAEDF0F3F6F8F9FBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F4F3
F2F1F0EFEEEDECECECEDECEBE9E7E7E8EAEEF3F5F1EBE4DE
D9D6D4D3D4D6D9DCE0E4E7EBEEF1F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F5
F4F4F3F2F1F0F0EFF0F0F0EFEEECEBEBEDF0F4F7F6F1EBE6
E1DEDCDBDBDCDEE1E3E7EAEDF0F2F5F7F8FAFBFCFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F8F7
F7F6F5F5F4F3F3F2F3F3F3F2F1F0EFEFEFF2F5F8F9F6F1ED
E8E5E3E1E1E2E3E5E7EAECEFF1F4F6F7F9FAFBFCFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAFAF9
F8F8F7F7F6F6F5F5F5F5F6F5F4F3F2F2F2F3F6F8FBFAF6F2
EEEBE9E8E7E7E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFBFA
FAFAF9F9F8F8F7F7F7F7F8F8F7F6F5F5F5F5F7F9FBFCFAF6
F3F1EEEDECECECEDEEF0F1F3F5F6F8F9FAFBFCFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFB
FBFBFBFAFAFAF9F9F9F9F9F9F9F8F8F7F7F7F8FAFCFDFCFA
F7F5F3F1F0F0F0F1F1F2F4F5F6F8F9FAFBFCFDFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFC
FCFCFCFCFBFBFBFBFAFBFBFBFBFAFAF9F9F9F9FAFCFDFEFC
FAF8F6F5F4F4F3F4F4F5F6F7F8F9FAFBFCFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFD
FDFDFDFDFCFCFCFCFCFCFCFCFCFCFBFBFAFAFAFBFCFDFEFE
FCFAF9F8F7F6F6F6F7F7F8F9F9FAFBFCFCFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFDFDFDFDFDFDFDFDFDFDFDFDFDFCFCFCFBFCFCFDFEFFFF
FDFCFBFAF9F9F9F8F9F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFEFEFEFEFDFDFDFDFEFEFEFDFDFDFCFCFDFDFEFEFF
FEFDFDFCFBFBFAFAFAFAFBFBFCFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFDFEFEFEFF
FFFEFEFDFCFCFCFCFCFCFCFCFCFDFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFEFEFDFDFDFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFF
FFFFFFFFFEFEFEFEFEFDFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 60.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 60.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFDFDFDFDFDFDFDFDFDFDFCFCFCFCFCFCFCFCFCFCFC
FCFCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFDFDFDFDFEFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFD
FDFDFDFDFCFCFCFCFCFCFCFCFCFCFBFBFBFBFBFBFBFBFBFB
FBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFCFCFCFDFDFDFD
FDFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFD
FDFCFCFCFCFCFBFBFBFBFBFBFBFBFAFAFAFAFAFAFAFAFAFA
FAFAFAFAFAFAFAFAFAFAFAFAFAFBFBFBFBFBFBFCFCFCFCFD
FDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFC
FCFBFBFBFBFAFAFAFAF9F9F9F9F9F9F9F9F9F9F8F8F8F8F8
F8F8F8F8F8F8F8F8F8F8F8F9F9F9F9F9FAFAFAFAFBFBFBFC
FCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFB
FAFAFAF9F9F9F8F8F8F8F8F7F7F7F7F7F7F7F7F7F6F6F6F6
F6F6F6F6F6F6F6F6F6F6F6F6F7F7F7F7F8F8F9F9F9FAFAFB
FBFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFBFAFA
F9F9F8F8F7F7F7F6F6F6F6F5F5F5F5F5F5F5F4F4F4F4F4F4
F4F4F4F4F3F3F3F4F4F4F4F4F4F5F5F5F6F6F7F7F8F8F9F9
FAFBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFAFAF9F9F8
F8F7F6F6F5F5F4F4F4F3F3F3F3F2F2F2F2F2F2F2F1F1F1F1
F1F1F1F0F0F0F0F0F1F1F1F1F2F2F2F3F3F4F5F5F6F7F7F8
F9F9FAFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F7F6
F6F5F4F4F3F2F2F1F1F1F0F0F0F0EFEFEFEFEFEFEEEEEEEE
EEEDEDEDEDEDEDEDEDEDEEEEEEEFEFF0F0F1F2F3F3F4F5F6
F7F8F9F9FAFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F9F8F7F6F5F4
F3F3F2F1F0EFEFEEEEEDEDEDECECECECECECEBEBEBEBEAEA
EAEAE9E9E9E9E9E9E9E9EAEAEBEBECECEDEEEFF0F1F2F3F4
F5F6F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F5F4F3F2
F1F0EFEEEDECEBEBEAEAE9E9E9E9E8E8E8E8E8E7E7E7E6E6
E6E5E5E5E5E5E5E5E5E5E5E6E6E7E8E8E9EAEBEDEEEFF0F2
F3F4F5F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F4F3F2F1EF
EEEDECEAE9E8E8E7E6E6E5E5E5E4E4E4E4E4E3E3E3E2E2E2
E1E1E1E0E0E0E0E0E0E0E0E1E1E2E3E4E5E6E8E9EBECEEEF
F1F2F4F5F6F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F7F5F4F2F1EFEEEC
EBE9E8E7E5E4E3E3E2E1E1E1E0E0E0E0E0DFDFDFDEDEDEDD
DDDCDCDBDBDADADADADBDBDCDCDDDEDFE1E2E4E5E7E9EAEC
EEF0F1F3F5F6F7F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5F4F2F0EEEDEBE9
E7E6E4E3E1E0DFDEDDDDDCDCDCDCDBDBDBDBDBDADAD9D9D8
D8D7D6D6D5D5D5D5D5D5D5D6D7D8D9DADCDDDFE1E3E5E7E9
EBEDEFF1F3F5F6F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F5F3F2F0EEECEAE8E6
E4E2E0DEDDDBDAD9D8D8D7D7D7D7D7D7D7D7D6D6D5D5D4D3
D3D2D1D0D0CFCFCFCFCFCFD0D1D2D3D5D6D8DADCDFE1E3E6
E8EAEDEFF1F3F5F6F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFCFBFAF8F7F5F4F2F0EEEBE9E7E4E2
E0DEDCDAD8D6D5D4D3D3D2D2D2D2D2D2D2D2D2D2D1D0D0CF
CECDCCCBCACAC9C9C9C9C9CACBCCCDCFD1D3D5D8DADDE0E2
E5E8EAEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBFAF9F8F6F4F2F0EEEBE9E6E3E1DE
DCD9D7D5D3D1D0CFCECDCDCDCDCDCECECECECECDCDCCCBCA
C9C8C7C6C5C4C3C3C3C3C3C4C5C6C8C9CCCED0D3D6D9DCDF
E2E5E8EBEDF0F2F4F6F8F9FAFBFCFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EEEBE9E6E3E0DDDA
D8D5D2D0CECCCBCAC9C8C8C8C8C9C9CACACACACAC9C8C7C6
C5C3C2C0BFBEBDBDBDBDBDBEBFC1C2C4C6C9CBCED1D5D8DB
DFE2E5E8EBEEF1F3F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFCFBFAF9F7F6F4F1EFECE9E6E3E0DDD9D6
D3D0CECBC9C7C6C5C4C3C3C3C4C4C5C6C6C7C7C6C6C5C4C2
C0BFBDBCBAB9B8B8B8B8B8B9BABBBDBFC1C4C6CACDD0D4D7
DBDFE2E6E9ECEFF2F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFCFBFAF8F7F5F2F0EDEAE7E4E0DDD9D6D2
CFCCC9C7C5C3C1C0BFBFBFBFC0C0C1C2C3C4C4C4C3C2C1BF
BDBBB9B8B6B5B4B3B3B3B3B3B4B6B8BABCBFC2C5C8CCD0D4
D8DCE0E3E7EAEEF0F3F5F7F9FAFBFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFCFAF9F8F6F4F1EEECE8E5E1DEDAD6D2CF
CBC8C5C2C0BEBCBBBBBABABBBCBDBEC0C1C1C2C2C1C0BEBD
BBB9B7B4B3B1B0AFAEAEAEAFB0B1B3B5B7BABDC1C4C8CCD1
D5D9DDE1E5E9ECEFF2F4F6F8FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBFAF9F7F5F3F0EDEAE6E3DFDBD7D3CFCB
C7C4C1BEBCBAB8B7B7B6B7B7B9BABCBDBFC0C0C0C0BFBDBB
B9B6B4B2B0AEACABABAAABABACAEAFB1B4B7BABDC1C5C9CE
D2D7DBDFE3E7EBEEF1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFDFCFBFAF8F6F4F2EFECE8E5E1DCD8D4D0CBC7
C4C0BDBAB8B6B5B4B3B3B4B5B6B8BABBBDBFC0C0C0BEBDBA
B8B5B2B0ADACAAA9A8A8A8A9AAABACAEB1B3B6BABEC2C6CB
D0D4D9DEE2E6EAEDF0F3F5F7F9FAFCFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFBF9F8F6F3F1EEEAE7E3DFDAD6D1CDC8C4
C0BDBAB7B5B3B1B1B0B0B1B2B4B6B8BABDBFC0C0C0BFBDBA
B7B4B2AFADABA9A8A7A7A7A7A7A8AAABADB0B3B7BBBFC3C8
CDD2D7DCE0E5E9ECEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFAF9F7F5F3F0EDE9E5E1DDD8D4CFCAC6C1
BDBAB7B4B2B0AFAEAEAEAFB0B2B5B7BABDBFC0C1C1C0BEBB
B8B5B2B0ADABA9A7A6A5A5A5A5A6A7A8AAADB0B3B7BCC1C6
CBD0D5DADFE3E7EBEFF2F4F6F8FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF8F7F4F2EFECE8E4E0DBD6D1CDC8C3BF
BBB7B4B2AFAEADACACADAEAFB1B4B7BABDC0C2C3C3C2C0BD
BAB7B4B0ADABA9A7A5A4A4A3A4A4A5A6A8ABAEB1B5BABEC4
C9CED3D9DDE2E6EAEEF1F4F6F8FAFBFCFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF8F6F4F1EEEBE7E3DEDAD5D0CBC6C1BD
B9B5B2B0AEACABABABACADAFB1B4B7BBBEC1C3C5C5C5C3C0
BDB9B5B1AEABA9A7A6A5A5A4A4A4A5A6A8AAADB0B4B9BDC2
C8CDD2D7DCE1E6EAEDF0F3F6F8F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBF9F8F6F3F1EDEAE6E2DDD8D3CEC9C4BFBB
B7B3B0AEACABABAAABACADAFB2B5B8BBBFC3C6C8C9C8C6C2
BEBAB6B2B0ADACABAAA9A8A8A7A7A7A8A9ABAEB1B5B9BEC3
C8CDD2D7DCE1E5E9EDF0F3F5F7F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBF9F7F5F3F0EDE9E5E1DCD7D2CDC8C3BEBA
B6B2AFADACABAAAAABACAEB0B3B6B9BDC1C5C9CBCCCBC8C5
C1BDBAB7B4B3B1B0AFADACABAAA9A9AAABACAFB2B6BABEC3
C8CDD2D7DCE1E5E9EDF0F3F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFBFBF9F7F5F3F0ECE9E4E0DBD6D1CCC7C2BDB9
B5B1AFADABABAAABACAEAFB2B4B7BBBFC4C8CBCDCECECCC9
C6C3BFBDBAB8B5B3B1AFADABAAA9A8A9AAACAEB1B5BABEC3
C8CDD2D7DCE1E5E9EDF0F3F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFCFBFAF9F7F5F2EFECE8E4DFDAD5D0CBC6C1BCB8
B4B1AFADACABABACADAFB1B3B6BABEC2C6C9CDD0D2D3D2D0
CCC8C4C0BCB9B6B3B1AEABA9A7A6A6A6A7A9ACAFB3B8BDC2
C7CDD2D7DCE1E5E9EDF0F3F5F7F9FAFCFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF9F7F5F2EFEBE8E3DFDAD5D0CBC6C1BCB8
B5B2AFAEADACADAEAFB1B3B6B9BDC0C4C7CBCFD4D7D9D8D5
D0CBC5C0BBB8B5B3B1AEABA9A7A6A5A5A6A8AAAEB1B6BBC0
C5CBD0D6DBE0E5E9EDF0F3F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F7F4F2EFEBE7E3DEDAD5D0CAC6C1BDB9
B5B3B0AFAEAEAFB0B1B3B6B9BCBFC2C6C9CED3D8DCDDDBD7
D1CAC5C1BEBCBBB9B7B5B2AFADABAAAAAAABADAFB2B5BABE
C3C9CED4D9DFE4E8ECEFF3F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEBE7E3DED9D4CFCBC6C1BDBA
B6B4B2B1B0B0B1B2B4B6B9BCBFC2C5C8CDD2D7DBDDDDDBD7
D3CECAC8C8C7C7C6C4C1BEBBB9B7B6B5B4B4B4B5B6B8BBBF
C3C8CDD3D8DDE2E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEBE7E2DED9D4CFCBC6C2BEBB
B8B6B4B3B3B3B4B5B7B9BCBFC2C4C8CCD1D6D8DADCDDDEDD
DBD8D6D5D4D4D3D1CECBC9C6C4C3C2C1C0BFBEBEBEBFC0C3
C6CACED3D8DCE1E6EAEEF1F4F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEAE6E2DED9D4D0CBC7C3BFBC
BAB8B6B6B6B6B7B8BABDC0C2C5C8CCD1D5D7D8DADEE3E7E8
E7E3DED9D6D3D0CECBC8C6C5C4C5C6C6C7C7C7C7C7C8C8C9
CBCED1D5D9DDE1E5E9EDF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEAE6E2DED9D4D0CBC7C3C0BD
BBBAB9B9B9B9BABCBEC1C3C5C8CCD1D4D6D7D9DEE5EBEEED
E8E0D7D0CBC8C5C2BEBBB9B8B9BBBDC0C3C5C8CACCCECFD1
D2D4D6D8DBDFE2E6EAEDF0F3F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F3F1EDEAE6E2DDD9D4D0CCC8C4C1BF
BDBCBBBBBCBDBEC0C3C5C7C9CCD1D4D6D6D9DEE6EBEBE8E4
DFD7CEC8C5C3BFBAB5B1AEADADAEB0B2B6BABFC4C9CDD1D5
D7D9DBDDE0E2E5E8EBEEF0F3F5F8F9FBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F3F0EDEAE6E2DDD9D4D0CCC8C5C2C0
BEBDBDBEBFC0C2C5C7C9CACDD2D5D6D6D9DEE6EAE8E3E0DF
DCD6D0CDCCCAC4BEB7B2ADAAA7A5A5A6A8ACB1B7BEC5CBD2
D7DBDFE2E4E6E8EAEDEFF1F4F6F8F9FBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F3F0EDEAE6E1DDD8D4D0CBC8C5C2C0
BFBFBFC0C1C3C6C8CBCCCFD3D6D8D7D9DEE6EAE7E1DFE0E4
E5E3E0DEDFDDD4CCC4BDB6AFA8A3A09E9EA0A4A9B0B8C0C9
D0D7DEE3E6E9ECEDEFF1F3F5F6F8F9FBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F8F5F3F0EDE9E5E1DDD8D4CFCBC7C4C2C0
BFBFC0C1C2C5C8CBCDD0D4D8DAD9D9DEE6EAE6E1E1E5EBF7
F9F9F8F8F9F8EAE2D8CEC4B9AFA7A19C99999B9FA4ACB4BD
C6CFD7DEE4E9EDF0F2F3F5F6F7F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F7F5F3F0EDE9E5E1DCD8D3CFCAC7C4C1BF
BFBFBFC0C3C6C9CCCFD2D7DCDCDBDEE5EAE7E1E1EAF7FBFD
FEFEFEFEFEFEFBFAEEE0D3C6BAB0A7A09B9897989CA2A9B2
BBC4CED7DFE5EBEFF3F5F7F8F9FAFBFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F7F5F3F0ECE9E5E0DCD7D2CECAC6C3C0BE
BDBDBEBFC2C5C9CBCFD4DADDDDDDE3EBE9E1DFE6F8FDFEFF
FFFFFFFFFFFFFFFFFDEEE0D3C7BCB1A8A09A9796979BA1A8
B1BBC4CED7DFE6ECF1F5F7F9FAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F7F5F3F0ECE8E4E0DBD6D2CDC9C5C1BFBD
BCBBBCBDC0C3C6C9CDD3D9DBDBDFE8EDE6DFE0EDFBFEFFFF
FFFFFFFFFFFFFFFFFEF6EBE0D3C7BBB1A79F9A9796989CA2
A9B2BCC6CFD8E0E7EDF2F6F9FAFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F3EFECE8E4DFDBD6D1CCC7C3C0BDBB
B9B9B9BABDC0C2C5CAD1D6D7D8DEE9ECE3DEE5F9FEFFFFFF
FFFFFFFFFFFFFFFFFFFEF3E8DCD1C5BAAFA69F9A98989A9E
A5ACB5BFC8D1DAE2E9EEF3F7F9FBFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F2EFECE8E3DFDAD5D0CBC6C2BEBBB8
B7B6B6B7BABCBEC1C6CDD0D1D3DCE8E7DEDCE6FAFEFFFFFF
FFFFFFFFFFFFFFFFFFFEF6EDE3D8CDC3B8AFA7A19C9B9B9E
A3A9B1BAC3CCD5DDE4EBF0F4F8FAFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F2EFECE8E3DED9D4CFCAC5C0BCB9B6
B4B3B3B4B6B8B9BDC3C8CACACED9E3DED6D6E3F9FEFFFFFF
FFFFFFFFFFFFFFFFFFFEF9F2E9E0D6CCC1B8AFA8A3A09FA0
A3A8AFB7BFC8D0D9E0E7EDF1F5F8FBFCFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F2EFEBE7E3DED9D3CEC9C3BEBAB7B4
B1B0B0B1B2B3B5B9BFC3C4C4CBD6DDD5CDD0E0F8FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFEF7EFE7DDD4CAC1B8B1ABA7A4A4
A6AAAFB6BDC5CED6DDE4EAEFF3F7F9FBFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F2EFEBE7E2DED8D3CDC8C2BDB8B5B1
AFADADAEAFAFB1B6BCBFBEC0C9D5D8CEC7CCDEF8FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF8F3ECE4DBD2C9C1B9B3AEABAA
ABADB1B7BDC5CCD4DBE2E8EDF1F5F8FAFCFDFEFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAF9F7F5F2EFEBE7E2DDD8D2CCC7C1BCB7B3AF
ACABAAABABACAEB3B9BBBABEC8D4D4CAC4CBDEF8FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF9F5F0E9E1D9D1C9C2BBB6B2B0
B0B2B5B9BFC5CCD3DAE0E6EBF0F4F7F9FBFCFDFEFFFFFFFF
FFFFFFFFFF
FFFEFDFDFCFAF9F7F5F2EFEBE7E2DDD7D2CCC6C0BAB6B1AE
AAA9A8A8A8A9ACB2B6B7B7BCC8D3D2C7C2C9DAF4FDFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF9F6F2EDE7E0D9D1CAC4BFBAB8
B7B7B9BDC2C7CDD3DAE0E5EAEFF3F6F8FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFAF9F7F5F2EFEBE7E2DDD7D1CBC5BFBAB5B0AC
A9A7A7A6A6A7AAB0B4B4B5BBC7D2D0C5BFC3D1E4F9FEFFFF
FFFFFFFFFFFFFFFFFFFEFCF9F6F3EFEBE5DFD9D2CCC7C3C0
BEBEBFC2C5CACFD5DAE0E5EAEEF2F5F8FAFBFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFAF9F7F5F2EFEBE7E2DDD7D1CBC5BFB9B4AFAB
A8A6A5A5A4A5A9AFB2B2B2B9C5D0CDC1B9BCC8DCF5FDFFFF
FFFFFFFFFFFFFFFFFFFEFDFAF7F4F0EDE9E4DFD9D4CFCBC8
C6C5C5C7CACED2D7DCE1E6EAEEF2F5F7F9FBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFAF9F7F5F2EFEBE7E2DDD7D1CBC5BFB9B4AFAB
A7A5A4A4A3A4A8ADB0AFB0B6C3CDCABDB4B5C0D3E5F7FCFE
FFFFFFFFFFFFFFFFFEFDFDFCF9F6F2EEEBE7E3DFDAD6D2CF
CDCCCCCDCFD2D5DADEE2E7EBEFF2F5F7F9FBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F7F5F2EFEBE7E2DDD7D2CBC5BFB9B4AFAA
A7A5A4A3A2A3A7ACAEADADB4C0CAC7BAB0B0B9C9D8E6F0FA
FDFEFFFFFFFFFEFEFDFBFAFBFBF9F5F1EDE9E6E3DFDCD9D6
D4D3D2D3D4D6D9DDE0E4E8ECEFF2F5F7F9FBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBF9F7F5F2EFECE7E3DDD8D2CCC5BFBAB4AFAB
A7A5A4A2A1A3A6AAABAAAAB1BDC7C5B9AEACB2BECBD8E5EE
F2F6FCFCFCFCFBFCFDFBF9F8F9FAF9F5F1EDE9E6E3E1DEDC
DAD9D8D8D9DBDDE0E3E7EAEDF0F3F5F8F9FBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F5F3F0ECE8E3DED8D3CDC6C0BAB5B0AB
A8A6A4A2A1A2A6A9A9A7A7AEBAC5C4B9AEA9ABB3BFCCD8E1
E8EEF4F6F8F9F8F9FBFBF9F7F7F8F9F8F5F1EDEAE7E5E3E1
DFDEDEDEDFE0E2E4E6E9ECEFF1F4F6F8FAFBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F3F0ECE8E4DFD9D4CDC7C1BCB6B1AC
A9A7A5A2A1A2A5A8A8A6A5ABB7C3C5BAAEA6A5AAB3BFCBD5
DCE4EBEFF3F5F5F6F8FAFAF7F5F5F7F8F8F5F2EEEBE9E7E5
E4E3E3E3E3E4E6E7E9ECEEF0F3F5F7F8FAFBFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F3F0EDE9E4DFDAD5CFC9C3BDB8B2AE
ABA8A6A3A2A2A5A7A7A4A4AAB5C2C5BCAFA5A0A2A9B4BFC8
D1D9E1E7ECEFF1F2F4F7F9F9F6F4F4F6F8F8F6F3EFEDEBE9
E8E7E7E7E7E8E9EBECEEF0F2F4F6F8F9FAFCFCFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEAE5E0DBD6D0CAC4BFB9B4B0
ACAAA7A4A3A3A5A7A6A4A3A9B4C1C6BFB1A59D9CA1AAB3BC
C5CED7DEE4E9ECEEF0F3F6F9F7F5F4F4F5F7F8F6F4F1EFED
ECEBEBEBEBECEDEEEFF1F2F4F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF8F6F4F1EEEAE6E2DDD7D2CCC6C1BCB7B2
AFACA9A6A4A4A6A8A7A5A4A8B3BFC6C1B4A69C989AA0A8B1
BAC3CCD4DCE2E7EAECEEF2F6F8F7F4F3F4F5F7F8F7F5F3F1
F0EFEEEEEEEFF0F0F2F3F4F5F7F8F9FAFBFCFDFEFEFEFFFF
FFFFFFFFFF
FFFEFEFEFDFBFAF9F7F5F2EFEBE7E3DED9D4CEC9C3BEB9B5
B1AEABA8A6A6A8A9A8A6A5A9B2BEC7C4B8A99D9796999FA7
AFB9C2CBD3DAE0E5E7EAEEF2F6F7F6F4F4F4F6F7F8F8F6F5
F3F2F1F1F1F2F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBF9F7F5F3F0ECE8E4E0DBD6D0CBC6C1BCB8
B4B1AEABA9A8AAABAAA8A7AAB2BDC6C7BCAEA0979494989E
A6AFB8C1CAD2D9DFE3E6E9EEF2F6F7F6F4F4F5F6F8F9F9F8
F6F5F4F4F4F4F5F5F6F7F7F8F9FAFBFCFCFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBF9F8F6F3F1EDEAE6E1DDD8D3CEC9C4BFBB
B8B4B1AEACABADAEADABAAACB2BCC6C9C1B3A59A94929398
9EA7AFB8C1CAD2D9DEE2E6EAEEF3F6F7F6F5F5F6F7F8F9F9
F9F8F7F7F6F6F7F7F8F8F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF8F6F4F1EEEBE7E3DFDAD5D1CCC7C3BF
BBB8B5B2B0AFB0B1B1AFADAEB3BCC6CBC6BAAC9F97929194
99A0A8B1BAC2CBD3D9DEE2E6EBEFF4F6F7F6F6F6F7F8F9FA
FAFAF9F9F8F8F8F9F9FAFAFBFBFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF9F7F5F2F0ECE9E5E1DDD8D4CFCBC7C3
BFBCB9B6B4B3B4B5B5B3B1B1B5BCC5CCCBC1B3A69C959292
959BA2AAB3BCC5CDD4DADFE3E8ECF1F5F7F8F7F7F7F8F9FA
FBFBFBFBFAFAFAFAFAFBFBFCFCFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFBF9F8F6F3F1EEEBE7E3DFDBD7D3CFCAC7
C4C1BEBBB9B8B8B9B9B8B6B5B7BDC6CDCFC8BBAEA29A9593
94999FA6AEB7BFC8D0D6DCE1E5E9EEF2F6F8F8F8F8F8F9FA
FBFCFCFCFCFBFBFBFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFCFBFAF8F6F4F2EFECE9E5E2DEDAD6D2CFCB
C8C5C2C0BEBDBDBEBEBDBBB9BBBFC6CED2CEC4B7ABA19A96
96999DA4ABB3BBC4CCD3D9DEE3E7ECF0F4F7F8F9F9F9F9FA
FBFCFCFDFDFDFCFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBFAF9F7F5F3F1EEEBE8E4E1DDDAD6D3D0
CDCAC8C5C3C2C2C3C3C2C0BEBFC2C8CFD5D4CCC0B4A9A19C
9A9B9EA3A9B1B9C1C9D0D7DCE1E6EAEEF2F5F8F9FAFAFAFB
FBFCFCFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFCFBF9F8F6F4F2F0EDEAE7E4E1DDDAD7D4
D1CFCDCAC9C8C8C8C9C8C6C4C3C5CAD1D7D9D4CABEB3AAA4
A09FA1A5AAB0B7BFC7CED5DBE0E5E9EDF1F4F7F9FAFBFBFB
FCFCFDFDFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFCFBFAF9F7F5F3F1EFECEAE7E4E1DEDBD8
D6D4D2D0CECDCDCDCECDCBC9C8C9CDD3D9DDDAD2C8BDB4AC
A8A6A6A8ACB2B8BFC6CDD4DADFE4E8ECF0F3F6F8FAFBFCFC
FCFCFDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F7F5F3F1EEECEAE7E4E2DFDD
DBD9D7D5D4D3D2D3D3D3D1CFCECED0D5DBDFE0DBD1C7BEB6
B1ADACAEB0B5BAC0C6CDD4D9DFE4E8ECEFF2F5F8FAFBFCFC
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBFAF9F8F6F4F3F1EEECEAE8E5E3E1
DFDEDCDAD9D8D7D8D8D8D7D5D3D3D4D8DDE2E4E1DAD1C8C0
BAB6B4B4B6B9BDC2C8CED4DADFE4E8ECEFF2F5F7F9FBFCFD
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFCFBFAF9F7F6F4F2F1EFEDEBE9E7E5
E3E2E1DFDEDDDCDDDDDDDCDAD9D8D9DBDFE4E7E7E2DAD2CA
C4BFBDBCBCBEC2C6CBD0D6DBE0E4E8ECEFF2F5F7F9FBFCFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFBFAF8F7F6F4F3F1EFEEECEAE9
E7E6E5E4E3E2E1E1E1E1E1E0DEDDDDDFE2E6EAEBE8E2DBD4
CEC9C5C4C4C5C7CACFD3D8DDE1E5E9EDF0F3F5F7F9FBFCFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F6F5F3F2F0EFEEEC
EBEAE9E8E7E6E6E6E6E6E5E5E3E2E2E2E4E8EBEEEDE9E3DD
D7D2CECCCBCCCDD0D3D7DBDFE3E7EAEEF0F3F5F7F9FBFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFBFAFAF9F7F6F5F4F3F2F0EF
EEEDEDECEBEAEAEAEAEAEAE9E8E7E6E6E8EAEDF0F1EFEAE5
DFDAD7D4D3D2D3D5D7DBDEE1E5E8ECEFF1F4F6F8F9FBFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFDFCFBFBFAF9F8F7F6F5F4F3F2
F1F1F0EFEEEEEDEDEDEDEDEDECEBEAEAEBECEFF2F4F3F0EB
E6E2DEDCDAD9DADBDCDFE1E4E8EAEDF0F2F5F7F8FAFBFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFDFCFBFBFAF9F8F8F7F6F5F5
F4F3F3F2F2F1F1F0F0F0F1F0F0EFEEEEEEEFF1F3F5F6F4F1
EDE9E5E3E1E0E0E0E1E3E5E8EAEDEFF1F4F6F7F9FAFBFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFAFAF9F9F8F7F7
F6F6F5F5F4F4F3F3F3F3F3F3F3F2F1F1F1F1F3F5F7F8F8F5
F2EEEBE9E7E6E5E5E6E7E9EBEDEFF1F3F5F7F8F9FBFCFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFAF9F9F8
F8F8F7F7F6F6F6F6F6F6F6F6F5F5F4F4F3F4F5F6F8F9FAF8
F6F3F0EEECEBEAEAEAEBECEEF0F1F3F5F6F8F9FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFBFAFA
FAF9F9F9F8F8F8F8F8F8F8F8F8F7F7F6F6F6F6F7F9FAFBFB
F9F7F4F2F1EFEFEEEEEFF0F1F2F3F5F6F7F9FAFBFCFCFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFCFCFCFBFB
FBFBFAFAFAFAFAF9F9F9F9F9F9F9F9F8F8F8F8F9FAFBFCFC
FBFAF8F6F4F3F2F2F2F2F3F3F4F5F7F8F9FAFBFBFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFC
FCFCFCFBFBFBFBFBFBFBFBFBFBFBFAFAFAF9FAFAFBFBFCFD
FDFCFAF9F7F6F6F5F5F5F5F6F6F7F8F9FAFBFBFCFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFD
FDFDFDFCFCFCFCFCFCFCFCFCFCFCFCFBFBFBFBFBFBFCFDFE
FEFDFCFBFAF9F8F8F7F7F7F8F8F9FAFAFBFBFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFCFCFCFCFCFCFDFDFE
FEFEFDFCFCFBFAFAF9F9F9FAFAFAFBFBFCFCFDFDFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFE
FFFFFEFEFDFCFCFBFBFBFBFBFBFBFCFCFDFDFDFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFEFEFE
FFFFFFFEFEFDFDFDFCFCFCFCFCFCFDFDFDFDFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFEFEFEFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 65.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 65.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFC
FCFCFCFCFBFBFBFBFBFBFBFBFAFAFAFAFAFAFAFAFAFAFAFA
FAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFBFBFBFBFBFCFCFCFC
FDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFCFCFCFC
FBFBFBFBFBFAFAFAFAFAFAFAFAFAF9F9F9F9F9F9F9F9F9F9
F9F9F9F9F9F9F9F9F9F9F9F9F9F9F9FAFAFAFAFAFBFBFBFB
FCFCFCFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFCFC
FCFCFCFBFBFBFBFBFBFBFBFAFAFAFAFAFAFAFAFAFAFAFAFA
FAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFBFBFBFBFBFCFCFC
FCFCFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFCFCFBFBFA
FAFAF9F9F9F9F8F8F8F8F8F7F7F7F7F7F7F7F7F6F6F6F6F6
F6F6F6F6F6F6F6F6F6F6F6F6F7F7F7F7F8F8F8F9F9F9FAFA
FBFBFBFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFAFAFAF9F9
F8F8F8F7F7F7F6F6F6F6F5F5F5F5F5F5F5F5F4F4F4F4F4F4
F4F4F4F4F4F4F4F4F4F4F4F4F4F4F5F5F5F6F6F6F7F7F8F8
F9F9FAFAFBFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFBFBFAFAF9F9F8F8
F7F7F6F6F6F5F5F5F4F4F4F4F4F4F3F3F3F3F3F3F3F2F2F2
F2F2F2F2F2F2F2F2F2F2F2F2F2F3F3F3F4F4F5F5F6F6F7F7
F8F8F9FAFAFBFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFBFAFAF9F8F8F7F6F6
F5F5F4F3F3F3F2F2F1F1F1F1F1F0F0F0F0F0EFEFEFEFEFEF
EEEEEEEEEEEEEEEEEEEEEEEFEFEFF0F0F1F1F2F2F3F4F5F5
F6F7F7F8F9FAFAFBFBFCFDFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFDFCFCFBFAFAF9F8F7F6F6F5F4F3
F3F2F1F1F0F0EFEFEEEEEEEEEDEDEDEDEDECECECECECEBEB
EBEBEBEAEAEAEAEAEAEAEBEBEBEBECEDEDEEEEEFF0F1F2F3
F4F5F5F6F7F8F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F8F7F6F6F5F4F3F2F1
F0EFEFEEEDEDECECEBEBEBEBEAEAEAEAEAE9E9E9E9E8E8E8
E8E7E7E7E7E6E6E6E6E7E7E7E7E8E8E9EAEAEBECEDEEEFF0
F1F2F3F5F6F7F8F9F9FAFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFBFBFAF9F8F7F6F5F4F3F1F0EFEE
EDECEBEBEAE9E9E8E8E7E7E7E7E6E6E6E6E5E5E5E5E4E4E4
E3E3E3E2E2E2E2E2E2E2E2E3E3E3E4E5E6E6E7E9EAEBECED
EFF0F1F3F4F5F6F7F8F9FAFBFCFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFDFCFBFBFAF9F8F7F5F4F3F2F0EFEEECEB
EAE9E8E7E6E5E5E4E4E3E3E3E3E2E2E2E2E2E1E1E1E0E0DF
DFDEDEDEDDDDDDDDDDDDDDDEDEDFDFE0E1E2E3E4E6E7E9EA
ECEDEFF0F2F3F5F6F7F8F9FAFBFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFCFBFBFAF9F7F6F5F4F2F1EFEEECEBE9E8
E6E5E4E3E2E1E0E0DFDFDFDFDFDEDEDEDEDEDDDDDDDCDCDB
DADAD9D9D9D8D8D8D8D8D8D8D9DADADBDCDDDFE0E2E3E5E7
E8EAECEEF0F1F3F4F6F7F8F9FAFBFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFCFCFBFAF9F8F6F5F3F2F0EEEDEBE9E7E6E4
E3E1E0DFDEDDDCDCDBDBDBDADADADADADADAD9D9D8D8D7D7
D6D5D5D4D4D3D3D3D2D2D3D3D4D4D5D6D7D9DADCDDDFE1E3
E5E7E9EBEDEFF1F3F4F6F7F9FAFBFCFCFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFBFAF9F8F6F5F3F2F0EEECEAE8E6E4E2E0
DFDDDCDAD9D8D7D7D7D6D6D6D6D6D6D6D6D6D5D5D4D4D3D2
D1D1D0CFCFCECDCDCDCDCDCECECFD0D1D2D4D5D7D9DBDDDF
E1E4E6E8EBEDEFF1F3F5F6F8F9FAFBFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFDFEFDFCFBFBF9F8F7F5F3F2F0EEEBE9E7E5E2E0DEDC
DAD9D7D6D5D4D3D2D2D2D2D2D2D2D2D2D2D2D2D1D1D0CFCE
CDCCCBCACAC9C8C8C8C8C8C8C9CACBCCCDCFD0D2D4D6D9DB
DEE0E3E5E8EAEDEFF1F3F5F7F8F9FBFBFCFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFDFCFBFAF9F7F6F4F2F0EEEBE9E6E4E1DFDDDAD8
D6D4D3D1D0CFCECECECDCECECECECECFCFCFCECECDCCCBCA
C9C8C7C6C5C4C4C3C3C3C3C3C4C4C5C7C8CACBCDD0D2D5D7
DADDE0E2E5E8EBEDF0F2F4F6F7F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFDFDFCFBFAF9F8F6F4F2F0EEECE9E6E4E1DEDBD9D6D4
D2D0CECDCBCACAC9C9C9C9CACACBCBCBCCCCCBCBCAC9C8C7
C6C4C3C2C1C0BFBFBEBEBEBEBFBFC0C2C3C5C7C9CBCED0D3
D6D9DCDFE3E6E8EBEEF0F3F5F6F8F9FBFCFCFDFEFEFEFFFF
FFFFFFFFFF
FFFDFDFDFCFBFAF9F7F5F3F1EFECE9E7E4E1DEDBD8D5D2D0
CECCCAC8C7C6C6C5C5C5C6C6C7C8C8C9C9C9C9C8C8C7C5C4
C3C1C0BFBDBCBBBABABAB9BABABBBCBDBFC0C2C4C7CACCCF
D3D6D9DCE0E3E6E9ECEFF1F4F6F7F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFDFCFDFCFAF9F8F6F4F2F0EDEAE7E4E1DEDBD7D4D1CFCC
CAC8C6C4C3C2C2C1C1C2C2C3C4C5C6C7C7C7C7C7C6C5C3C2
C0BFBDBCBAB9B8B7B6B6B6B6B6B7B8B9BABCBEC0C3C6C9CC
CFD2D6DADDE1E4E7EAEDF0F2F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFDFCFDFBFAF9F7F5F3F1EEEBE8E5E2DFDBD8D4D1CECBC8
C6C4C2C0BFBEBEBEBEBFC0C1C2C3C4C5C6C6C6C6C5C4C2C1
BFBDBBB9B8B6B5B4B3B3B3B3B3B4B4B5B7B8BABDBFC2C5C8
CCCFD3D7DBDEE2E5E9ECEFF1F4F6F8F9FAFCFCFDFEFEFFFF
FFFFFFFFFF
FFFDFCFCFBF9F8F6F4F2F0EDEAE7E3E0DCD8D5D1CECAC7C5
C2C0BEBDBCBBBBBBBBBCBDBEC0C1C3C4C5C5C6C5C4C3C2C0
BEBCBAB8B6B5B4B2B2B1B1B0B0B1B1B2B4B5B7B9BCBEC1C5
C8CCD0D4D8DCE0E4E7EBEEF0F3F5F7F9FAFBFCFDFEFEFEFF
FFFFFFFFFF
FFFCFCFCFAF9F8F6F3F1EEEBE8E5E1DDD9D6D2CECBC7C4C1
BFBDBBBAB9B8B8B8B9BABBBDBFC0C2C4C5C6C6C5C5C3C2C0
BEBCBAB8B6B4B3B1B0B0AFAFAFAFAFB0B1B2B4B6B9BBBEC2
C5C9CDD2D6DADEE2E6E9EDF0F2F5F7F8FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFCFBFCFAF8F7F5F2F0EDEAE7E3DFDBD7D3CFCBC8C4C1BE
BCBAB8B7B6B6B6B6B7B8BABCBEC0C2C4C5C6C7C6C6C4C3C1
BFBCBAB8B6B4B2B1B0AFAEAEAEAEAEAEAFB0B2B4B6B9BCBF
C3C7CBCFD4D8DCE1E4E8ECEFF1F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFF
FFFCFBFCFAF8F6F4F2EFECE9E5E1DDD9D5D1CDC9C5C2BFBC
BAB8B6B5B4B4B4B5B6B7B9BCBEC0C3C5C7C8C8C8C7C6C4C2
C0BDBBB9B7B5B3B2B1B0AFAEAEADADAEAEAFB0B2B4B7BABD
C1C5C9CED2D7DBDFE3E7EBEEF1F3F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFF
FFFCFBFBF9F7F6F4F1EEEBE7E4E0DCD7D3CFCAC6C3BFBCBA
B7B6B4B3B3B3B3B4B5B7B9BCBEC1C4C6C8CACACACAC8C6C4
C2BFBDBBB8B7B5B3B2B1B0AFAEAEADADAEAEAFB1B3B5B8BB
BFC3C7CCD1D5DADEE2E6EAEDF0F3F5F7F9FAFBFCFDFEFEFF
FFFFFFFFFF
FFFBFAFBF9F7F5F3F0EDEAE6E2DEDAD6D1CDC8C4C1BDBAB8
B6B4B3B2B2B2B3B4B5B7BABCBFC2C5C8CACCCDCDCCCBC9C7
C4C2BFBDBBB9B7B6B4B3B2B0AFAEAEADADAEAEB0B1B4B7BA
BEC2C6CBCFD4D8DDE1E5E9EDF0F2F5F7F9FAFBFCFDFEFEFE
FFFFFFFFFF
FFFBFAFBF9F6F5F2EFEDE9E5E1DDD9D4D0CBC7C3BFBCB9B6
B4B3B2B2B2B2B3B4B6B8BABDC0C4C7CACDCFD0D0D0CECCCA
C8C5C3C0BEBCBAB8B7B5B3B2B1AFAEAEADADAEAFB1B3B6B9
BDC1C5C9CED3D7DCE0E4E8ECEFF2F4F7F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFBFAFBF8F6F5F2EFECE8E4E0DCD7D3CECAC5C1BEBAB8B5
B4B2B2B1B2B2B3B5B7B9BCBFC2C6C9CCCFD1D3D3D3D2D0CE
CBC8C6C3C1BFBDBBB9B8B6B4B3B1B0AFAEAEAFB0B1B3B6B9
BCC0C4C9CDD2D7DBE0E4E8EBEFF2F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFBFAFBF8F6F4F1EEEBE8E3DFDBD6D2CDC9C4C0BDBAB7B5
B3B2B2B2B2B3B4B6B8BBBEC1C4C8CBCFD2D4D6D7D7D6D4D1
CFCCC9C7C4C2C1BFBDBCBAB8B6B4B3B1B1B0B0B1B2B4B6B9
BDC0C4C8CDD2D6DBDFE3E7EBEEF1F4F6F8FAFBFCFDFDFEFE
FFFFFFFFFF
FFFBFAFBF8F5F4F1EEEBE7E3DFDAD5D1CCC8C4C0BCB9B7B5
B3B3B2B2B3B4B6B8BABDC0C3C6CACDD1D5D8DADBDBDAD8D5
D2CFCDCBC9C7C5C4C2C0BEBCBAB8B6B4B3B3B3B3B4B6B8BA
BEC1C5C9CDD2D6DADFE3E7EBEEF1F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAFAFAF7F5F4F1EDEAE6E2DED9D5D0CCC7C3BFBCB9B7B5
B4B3B3B4B5B6B8BABCBFC2C5C8CCD0D4D7DBDDDEDEDDDBD9
D6D4D1CFCECCCAC9C7C4C2BFBDBAB8B6B5B4B4B5B6B7B9BC
BEC2C5C9CED2D6DBDFE3E7EAEEF1F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF7F5F3F0EDEAE6E2DDD9D4D0CBC7C3BFBCBAB7B6
B5B4B5B5B6B8BABCBFC1C4C7CBCFD2D6DADDE0E1E2E1DFDD
DBD8D6D4D2D0CECCC9C7C4C1BEBBB9B7B6B5B5B5B6B8BABC
BFC2C6CACED2D6DBDFE3E7EAEEF1F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF7F5F3F0EDE9E5E1DDD9D4D0CBC7C3C0BDBAB8B7
B6B6B6B7B9BABCBFC1C4C7CACED1D5D9DCDFE2E4E5E5E4E2
DFDCD9D7D5D2D0CECBC8C5C2BFBCBAB8B7B6B6B6B7B8BABC
BEC2C5C9CDD2D6DADFE3E7EAEEF1F3F6F7F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF7F4F3F0ECE9E5E1DDD8D4D0CBC7C4C0BEBBBAB9
B8B8B9BABBBDBFC2C4C7CACDD0D4D7DBDEE2E5E7E9E9E8E5
E2DFDCD9D7D5D3D1CFCCC8C5C2BFBDBBBAB9B8B7B8B8BABB
BEC1C4C8CDD1D5DADEE3E7EAEEF1F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF6F4F3EFECE9E5E1DDD8D4D0CCC8C4C1BFBDBBBB
BABBBBBDBEC0C2C5C7CACDD0D3D6D9DDE0E4E8EAECECEAE7
E4E1DEDCDBDAD9D7D5D2CFCCC9C6C4C1C0BEBCBBBBBBBBBC
BEC1C4C8CCD0D5D9DEE2E6EAEDF0F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF6F4F3EFECE9E5E0DCD8D4D0CCC8C5C2C0BEBDBD
BDBDBEC0C1C3C6C8CBCDD0D3D6D9DCDFE3E6E9ECEDEDECEA
E7E5E3E2E2E1E0DFDCD9D6D3D1CECCCAC7C5C3C1C0BFBFBF
C0C2C5C8CBD0D4D8DDE1E6E9EDF0F3F5F7F9FBFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF6F4F2EFECE8E4E0DCD8D4D0CCC9C6C3C1C0BFBF
BFC0C1C3C5C7C9CCCED1D4D6D9DBDEE2E5E8EAECEEEFEFEE
ECEBEAE9E8E7E5E3E1DEDBD9D6D5D3D1CFCDCBC9C7C5C4C4
C4C5C7C9CCD0D4D8DCE1E5E9ECF0F3F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFAF9FAF6F4F2EFEBE8E4E0DCD8D4D0CCC9C7C4C3C2C1C1
C2C3C5C6C8CBCDD0D2D5D7D9DCDEE1E4E7E9EBEDF0F3F4F4
F2EFECEAE8E6E4E1DEDBD9D7D6D4D3D3D1D0CFCECDCBCACA
CACACBCDCFD2D5D9DDE1E5E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFF9F9FAF6F4F2EFEBE8E4E0DCD8D4D0CDCAC7C5C4C3C3C3
C4C6C8CACCCED1D4D6D8DADCDFE2E4E6E8EAEDF0F4F6F7F5
F2EEEAE6E4E2E0DCD9D6D4D2D0CFCECECECDCECECECECECE
CFCFD0D1D3D5D7DADEE1E5E8ECEFF2F4F7F9FAFBFCFDFEFE
FFFFFFFFFF
FFF9F9FAF6F4F2EEEBE8E4E0DCD8D4D0CDCAC7C6C5C4C4C5
C6C8CACDCFD2D5D7DADCDEE0E3E5E7E8EAECF0F3F5F5F4F3
EFEBE7E4E3E1DEDAD7D3D0CECCC9C8C7C6C6C7C8CACCCECF
D1D2D4D5D7D8DBDDE0E3E6E9ECEFF2F4F6F8FAFBFCFDFEFE
FFFFFFFFFF
FFF9F8F9F6F3F2EEEBE8E4E0DCD7D4D0CDCAC8C6C5C5C5C6
C8CACCCFD2D5D8DBDDDFE1E4E6E8E9EAECEFF3F4F3F2F2F1
EFECE9E8E7E5E2DDD9D5D1CECAC6C3C0BEBEBEC0C2C5C8CB
CFD2D5D7DADCDEE0E2E5E7EAEDEFF2F4F6F8FAFBFCFDFEFE
FFFFFFFFFF
FFF9F8F9F5F3F2EEEBE7E3DFDBD7D3D0CCCAC7C6C5C5C5C6
C8CBCDD0D3D7DADDE0E2E5E7E9EAEBECF0F3F4F3F1F1F2F4
F4F3F1F1F0EFEAE5E1DCD7D1CBC6C1BDBAB8B7B7B9BCBFC4
C8CDD2D6DADDE0E3E5E7EAECEEF0F3F5F7F8FAFBFCFDFEFE
FEFFFFFFFF
FFF9F8F9F5F3F1EEEAE7E3DFDBD7D3CFCCC9C7C5C5C4C5C6
C8CBCED1D4D8DBDFE2E5E8EAEBECEDF0F3F4F3F1F2F4F7FC
FDFDFCFCFCFCF5F1EBE5DED7D0C9C3BDB8B5B2B1B2B3B6BB
C0C5CBD1D6DBE0E4E7E9ECEEF0F2F4F5F7F9FAFBFCFDFEFE
FEFFFFFFFF
FFF9F8F9F5F3F1EEEAE7E3DEDAD6D2CECBC8C6C4C4C4C4C5
C7CACDD0D4D8DCDFE2E6EAECEDEEF0F3F5F3F1F2F6FCFEFF
FFFFFFFFFFFFFDFDF6EEE6DFD7CFC8C1BAB5B1AEADADAFB2
B7BCC3C9D0D7DDE2E6EAEDEFF1F3F5F6F8F9FAFBFCFDFEFE
FEFFFFFFFF
FFF9F8F9F5F3F1EDEAE6E2DEDAD5D1CECAC7C5C3C2C2C3C4
C6C9CBCFD3D7DADEE2E6EAECEEF0F3F6F5F2F1F5FCFEFFFF
FFFFFFFFFFFFFFFFFEF6EEE6DED6CEC6BEB7B1ACAAA8A9AB
AFB4BAC1C8D0D7DEE3E8ECF0F2F4F6F7F9FAFBFCFCFDFEFE
FEFFFFFFFF
FFF9F8F9F5F3F1EDEAE6E2DDD9D5D1CDC9C6C4C2C1C0C1C2
C4C6C9CDD1D5D8DCE0E5E8EBEDF0F5F7F4F1F2F8FEFFFFFF
FFFFFFFFFFFFFFFFFFFAF4EDE5DDD4CBC2BAB3ADA9A6A5A6
A9ADB3B9C1C8D0D8DFE5EAEFF2F5F7F8F9FAFBFCFDFDFEFE
FEFFFFFFFF
FFF9F8F9F5F3F1EDE9E6E1DDD9D4D0CCC8C5C2C0BFBFBFC0
C2C4C7CACED2D6DADEE3E6E8EBEFF4F5F2F1F4FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFF8F1EAE2D9D0C8BFB7B0ABA7A4A4
A5A8ADB3BAC2CAD2D9E0E6ECF0F4F7F9FAFBFCFDFDFEFEFE
FFFFFFFFFF
FFF9F8F9F5F3F1EDE9E5E1DCD8D3CFCBC7C3C1BEBDBCBDBE
BFC1C4C8CBCFD3D7DBE0E2E4E8EDF2F2EFEFF4FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFAF4EDE6DED6CDC4BCB4AEA9A5A3
A3A5A9AEB4BCC4CCD4DBE2E8EDF2F5F8FAFBFCFDFDFEFEFE
FFFFFFFFFF
FFF9F8F9F5F2F1EDE9E5E1DCD7D3CECAC5C2BFBDBBBABABB
BDBFC1C5C8CCD0D4D9DCDFE1E5EBEFEEEBEDF3FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF7F1EBE3DBD3CAC1B9B2ACA8A5
A4A4A7ABB1B7BFC7CFD6DEE4EAEFF3F6F9FBFCFDFEFEFEFF
FFFFFFFFFF
FFF9F8F9F5F2F0ECE9E5E0DBD7D2CDC8C4C0BDBBB9B8B8B9
BABCBFC2C6C9CDD2D6D9DBDEE4EAECE9E7EAF1FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFAF4EEE7E0D8CFC7BFB7B1ABA8
A6A5A7AAAFB4BBC3CBD2DAE1E7ECF1F5F8FAFCFDFEFEFFFF
FFFFFFFFFF
FFF9F8F9F5F2F0ECE8E5E0DBD6D1CCC7C3BFBCB9B7B6B6B6
B8BABCC0C3C6CBD0D4D7D9DDE3E9E9E6E4E8F0FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFAF6F1EBE4DCD4CCC4BDB6B0AC
A9A8A8AAAEB3B9C0C8CFD7DDE4EAEEF3F6F9FBFCFDFEFFFF
FFFFFFFFFF
FFF9F8F9F5F2F0ECE8E4E0DBD6D1CBC7C2BEBAB7B5B4B4B4
B5B7BABDC0C4C9CED2D4D7DBE2E8E7E3E2E7F0FCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFBF8F4EEE8E1DAD2CAC3BCB6B1
ADABABACAFB3B9BFC6CDD4DBE1E7ECF1F4F7FAFBFDFEFEFF
FFFFFFFFFF
FFF9F8F9F5F2F0ECE8E4DFDAD5D0CBC6C1BDB9B6B4B3B2B2
B3B5B8BBBEC2C7CCD0D2D5DAE1E7E6E2E1E5EEFAFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFBF8F5F1ECE6DFD8D1C9C2BCB7
B3B0AFB0B2B5BABFC5CCD3D9E0E5EBEFF3F6F9FBFCFDFEFF
FFFFFFFFFF
FFF9F8F9F5F2F0ECE8E4DFDAD5D0CAC5C0BCB8B5B3B1B0B0
B2B4B6B9BCC0C5CACED0D3D9E0E5E3DFDEE1E8F2FDFFFFFF
FFFFFFFFFFFFFFFFFFFEFDFAF8F5F2EEE9E4DED7D0C9C3BE
B9B6B4B4B5B8BCC0C6CCD2D9DFE4E9EEF2F5F8FAFBFDFEFE
FFFFFFFFFF
FFF9F8F9F5F2F0ECE8E4DFDAD5CFCAC5C0BBB7B4B1B0AFAF
B0B2B4B7BABFC4C8CBCED1D7DEE3E1DCDADCE3EEFAFEFFFF
FFFFFFFFFFFFFFFFFFFEFDFBF8F5F2EFEBE7E2DCD6D0CAC5
C0BDBABABABCBFC3C8CDD3D9DEE4E9EDF1F4F7F9FBFCFDFE
FEFFFFFFFF
FFF9F8F9F5F2F0ECE8E4DFDAD5CFCAC4BFBBB7B3B1AFAEAE
AFB1B3B6B9BDC2C6C9CBCED4DCE0DED9D6D8DFE8F2FBFEFF
FFFFFFFFFFFFFFFFFEFDFDFDFAF7F3EFECE8E4E0DBD6D1CC
C7C4C1C0BFC1C3C6CACFD4D9DFE4E8EDF0F4F6F9FAFCFDFE
FEFFFFFFFF
FFF9F8F9F5F2F0ECE8E4DFDAD5CFCAC4BFBAB6B3B0AEADAD
AEAFB2B4B7BBC0C4C6C8CBD1D8DDDBD6D3D4DAE2EAF1F7FC
FEFEFFFFFFFFFEFFFDFCFBFBFCFAF6F2EEEAE6E2DEDAD6D2
CECAC8C6C5C6C7CACDD1D6DBDFE4E9EDF0F3F6F8FAFCFDFD
FEFFFFFFFF
FFF9F8F9F5F2F0ECE8E4E0DAD5CFCAC5BFBAB6B3B0AEADAC
ADAEB0B2B5B9BDC1C3C4C7CED5DAD8D3D0D0D5DBE2EAF0F5
F7FAFDFDFDFDFCFDFDFBF9F8F9FAF9F5F1ECE8E4E1DDDAD6
D3D0CECCCBCBCCCED1D5D8DDE1E5E9EDF0F3F6F8FAFBFCFD
FEFEFFFFFF
FFF9F8F9F5F3F1EDE9E5E0DBD5D0CAC5C0BBB6B3B0AEACAC
ACADAFB1B3B7BBBEC0C1C4CBD2D8D7D2CDCCCFD4DAE2E9ED
F1F4F8F9FAFAFAFAFCFCF9F7F6F7F9F9F5F0ECE7E4E0DDDA
D8D5D3D2D1D1D2D3D5D8DBDFE3E7EAEEF1F4F6F8FAFBFCFD
FEFEFFFFFF
FFF9F8F9F6F3F1EDE9E5E0DBD6D0CBC6C0BBB7B3B0AEACAB
ACACAEAFB1B5B9BBBDBEC1C8D0D6D5D0CBC8C9CCD3DAE0E5
EAEEF2F4F6F7F7F7F9FBFAF7F5F4F6F7F8F5F0ECE7E4E1DE
DCDAD8D7D6D6D7D8D9DCDFE2E5E8ECEFF1F4F6F8FAFBFCFD
FEFEFFFFFF
FFFAF8F9F6F3F1EDE9E6E1DCD7D1CCC6C1BCB8B4B1AEACAB
ABACADAEB0B3B6B9BABBBEC5CDD4D4CFC9C5C3C6CBD1D7DD
E2E6EBEEF1F3F4F4F5F8FAF8F5F3F3F4F6F7F5F1ECE8E5E2
E0DEDDDCDBDBDBDCDEE0E2E4E7EAEDF0F2F5F7F9FAFBFCFD
FEFEFEFFFF
FFFAF9FAF6F3F2EEEAE6E2DDD7D2CDC7C2BDB9B5B2AFADAC
ABABACADAEB1B4B7B8B9BCC2CBD2D3CFC8C1BFBFC3C9CED4
D9DEE3E7EBEEF0F0F1F4F7F9F7F3F1F1F3F5F6F5F1EDE9E6
E4E2E1E0DFDFE0E0E2E3E5E7EAECEFF1F3F5F7F9FAFCFCFD
FEFEFEFFFF
FFFAF9FAF6F4F2EEEBE7E2DDD8D3CEC9C3BEBAB6B3B0AEAC
ACABABACADB0B3B5B6B7BAC0C8D0D2CEC7BFBBBABCC0C5CA
D0D6DADFE4E8EBECEDEFF3F6F8F5F2F0F0F2F4F6F5F2EEEB
E8E6E5E4E3E3E4E4E5E7E8EAECEEF0F2F4F6F8F9FBFCFDFD
FEFEFEFFFF
FFFAF9FAF7F4F2EFEBE8E3DEDAD5CFCAC5C0BCB8B4B1AFAD
ACABABABADAFB2B4B5B6B9BEC6CED1CEC6BEB8B6B6B9BDC1
C7CCD2D7DCE2E6E8E9EBEEF2F6F6F4F1F0F0F2F4F6F5F3F0
EDEBE9E8E7E7E7E8E9EAEBEDEEF0F2F4F6F7F9FAFBFCFDFD
FEFEFFFFFF
FFFAF9FAF7F5F3F0ECE9E4E0DBD6D1CCC7C2BDB9B6B3B0AE
ADACACABACAEB1B3B4B5B7BCC4CBD0CEC7BEB7B2B1B2B5B9
BEC3C9CED4DADFE3E5E7E9EDF2F5F5F3F0EFF0F1F4F6F6F4
F2EFEDECEBEBEBEBECEDEEEFF1F2F4F5F7F8F9FBFCFCFDFE
FEFFFFFFFF
FFFBFAFAF7F5F3F0EDE9E5E1DCD8D3CEC9C4C0BCB8B5B2B0
AEADACACADAFB1B3B4B5B7BBC1C9CECDC7BFB6B1ADADAEB1
B5BAC0C5CBD2D8DDE0E2E5E8EDF2F5F5F2F0F0F0F2F4F6F6
F5F3F1F0EFEEEEEEEFF0F1F2F3F4F5F7F8F9FAFBFCFDFDFE
FEFFFFFFFF
FFFBFAFBF8F5F4F1EEEAE7E2DED9D5D0CBC6C2BEBAB7B4B2
B0AFAEADAEB0B2B4B4B5B6BAC0C7CCCDC9C0B7B0ABA9A8AA
AEB2B7BDC3CAD1D7DBDEE1E4E8EDF2F4F4F2F1F0F1F3F5F6
F7F6F5F3F2F1F1F1F1F2F3F4F5F6F7F8F9FAFBFCFCFDFEFE
FEFFFFFFFF
FFFBFAFBF8F6F4F2EFEBE8E4E0DBD7D2CDC9C5C1BDB9B7B4
B2B1B0AFB0B1B3B5B5B6B6B9BEC5CBCDCAC3BAB1ABA6A5A5
A8ABB0B5BBC2C9D0D6DADDE0E4E8EDF2F4F4F2F1F1F2F4F5
F7F8F7F6F5F4F4F4F4F4F5F6F6F7F8F9FAFBFBFCFDFDFEFE
FFFFFFFFFF
FFFBFAFBF9F6F5F3F0EDE9E5E1DDD9D4D0CBC7C3C0BCB9B7
B5B4B2B2B2B3B5B6B7B7B7B9BDC3CACDCCC6BDB4ACA6A2A2
A3A6A9AEB4BBC2C9D0D5D9DCE0E4E9EEF2F4F4F3F2F2F3F5
F6F8F9F8F8F7F7F6F6F6F7F7F8F9F9FAFBFBFCFDFDFEFEFE
FFFFFFFFFF
FFFCFBFBF9F7F6F3F1EEEBE7E3DFDBD7D3CECAC7C3C0BDBA
B8B7B5B4B4B5B7B8B9B9B9BABDC2C9CDCEC9C1B7AEA7A2A0
A0A1A5A9AEB5BCC3CAD0D5D9DDE1E6EBEFF3F5F5F4F3F4F5
F6F8F9F9FAF9F9F8F8F8F8F9F9FAFAFBFCFCFDFDFEFEFEFE
FFFFFFFFFF
FFFCFBFCFAF8F6F4F2EFECE9E5E1DDD9D5D1CECAC6C3C0BE
BCBAB9B8B8B8BABBBBBBBBBBBEC2C8CDCFCDC5BCB3AAA4A0
9F9FA1A5AAAFB6BEC5CBD1D6DADEE2E7ECF1F4F6F5F5F5F5
F6F7F9FAFAFBFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFF
FFFFFFFFFF
FFFCFBFCFAF8F7F5F3F0EDEAE7E4E0DCD8D5D1CDCAC7C4C2
C0BEBDBCBBBCBDBEBEBEBDBDBFC3C8CDD1D0CAC1B8AFA8A3
A09FA0A2A6ACB2B9C0C7CDD3D7DCE0E5E9EEF2F5F6F6F6F6
F7F8F9FAFBFBFBFBFBFBFBFBFCFCFCFDFDFDFEFEFEFEFFFF
FFFFFFFFFF
FFFCFCFCFBF9F8F6F4F1EFECE9E6E2DFDBD8D4D1CECBC8C6
C4C2C1C0BFC0C1C1C2C1C1C0C1C4C8CED2D3CFC7BEB5ADA7
A3A1A0A2A5AAAFB6BDC4CAD0D5DADEE3E7ECF0F4F6F7F8F7
F8F8F9FAFBFCFCFCFCFCFCFCFCFDFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFF
FFFDFCFCFBF9F8F7F5F3F0EEEBE8E5E2DEDBD8D5D2CFCDCA
C9C7C6C4C4C4C4C5C5C5C4C4C4C6CACED3D5D3CDC5BCB3AC
A7A4A3A3A5A9AEB4BAC1C8CED3D8DDE1E6EAEEF2F5F7F8F9
F9F9FAFAFBFCFCFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFF
FFFFFFFFFF
FFFDFCFDFBFAF9F8F6F4F2EFEDEAE7E4E1DEDCD9D6D3D1CF
CDCCCAC9C8C8C9C9C9C9C8C8C7C9CBD0D4D7D7D3CCC3BBB3
ADA9A7A6A7AAAEB4B9C0C6CCD2D7DCE0E5E9EDF1F4F7F8F9
FAFAFAFBFBFCFDFDFDFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFAFAF8F7F5F3F1EFECEAE7E4E2DFDCDAD7D5D3
D2D0CFCECDCDCDCECECECDCCCBCCCED2D6D9DBD8D3CBC3BB
B4B0ACABABADB0B5BAC0C6CCD1D7DCE0E4E8ECF0F3F6F8FA
FAFBFBFBFCFCFDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFBFAF9F8F6F4F3F1EEECEAE7E5E2E0DEDCDAD8
D6D5D4D3D2D2D2D2D2D2D1D0D0D0D1D4D8DBDEDDD9D3CBC3
BDB7B3B1B0B1B4B7BCC1C6CCD1D7DCE0E4E8ECEFF2F5F8F9
FBFBFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFDFDFCFBFAF9F7F6F4F2F0EEECEAE8E6E4E2E0DEDC
DBDAD9D8D7D6D6D6D7D7D6D5D4D4D5D7DADDE0E1DFDAD3CC
C5BFBBB8B7B7B8BBBFC3C8CDD2D7DCE0E4E8ECEFF2F5F7F9
FBFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFEFDFCFBFBF9F8F7F6F4F2F1EFEDEBE9E7E5E4E2E1
DFDEDDDCDCDBDBDBDBDBDBDAD9D8D9DADCDFE3E4E4E0DAD4
CEC8C3C0BEBDBEC0C3C6CACFD4D9DDE1E5E9ECEFF2F5F7F9
FAFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFBFAF9F8F7F5F4F3F1EFEEECEAE9E7E6E5
E3E2E2E1E0DFDFDFDFDFDFDEDEDDDDDEDFE2E5E7E8E6E1DC
D6D0CBC8C5C4C4C5C7CACED2D6DADFE3E6EAEDF0F2F5F7F9
FAFCFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFCFCFBFAF9F8F7F6F4F3F2F0EFEDECEBE9E8
E7E6E6E5E4E4E3E3E3E3E3E3E2E1E1E1E2E4E7E9EBEAE7E3
DDD8D4D0CDCBCBCBCDCFD2D5D9DDE1E4E8EBEEF0F3F5F7F9
FAFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFCFCFBFAF9F8F7F6F5F4F2F1F0EFEEEDEC
EBEAE9E9E8E8E7E7E7E7E7E7E6E6E5E5E6E7E9ECEDEEECE9
E4E0DBD8D5D3D2D2D2D4D6D9DCDFE3E6E9ECEFF1F4F6F7F9
FAFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFDFDFCFCFBFAF9F8F8F7F6F5F4F3F2F1F0EF
EEEEEDECECEBEBEBEBEBEBEBEAEAE9E9E9EAECEEF0F1F0EE
EAE6E2DFDCDAD8D8D8D9DBDDE0E2E5E8EBEEF0F2F4F6F8F9
FBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFFFEFEFEFDFDFCFCFBFAFAF9F8F7F6F6F5F4F3F2F2
F1F1F0F0EFEFEEEEEEEEEEEEEEEDEDECECEDEEF0F1F3F3F2
EFECE9E5E2E0DFDEDEDFE0E1E3E6E8EBEDEFF2F4F5F7F8FA
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F7F7F6F5F5F4
F4F3F3F2F2F2F1F1F1F1F1F1F1F0F0F0EFF0F0F2F3F5F6F5
F3F1EEEBE8E6E5E4E3E4E4E6E7E9EBEDEFF1F3F5F6F8F9FA
FBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFAF9F9F8F8F7F7F6
F6F6F5F5F5F4F4F4F4F4F4F4F4F3F3F2F2F2F3F4F5F6F7F8
F7F5F2F0EEECEAE9E8E8E9EAEBECEEEFF1F3F4F6F7F9FAFB
FCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFBFAFAF9F9F9F8
F8F7F7F7F7F6F6F6F6F6F6F6F6F6F5F5F5F5F5F5F6F7F8F9
F9F8F6F4F2F0EFEEEDEDEDEDEEEFF0F2F3F5F6F7F8FAFAFB
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFBFBFAFAFA
F9F9F9F9F8F8F8F8F8F8F8F8F8F8F7F7F7F7F7F7F8F9FAFA
FBFAF9F7F5F4F3F1F1F0F0F1F1F2F3F4F5F6F7F8F9FAFBFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFCFCFCFCFBFBFB
FBFBFAFAFAFAFAFAF9F9F9FAFAF9F9F9F9F9F8F9F9FAFAFB
FCFCFBFAF8F7F6F5F4F4F3F4F4F4F5F6F7F8F9F9FAFBFCFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFCFCFC
FCFCFCFBFBFBFBFBFBFBFBFBFBFBFBFAFAFAFAFAFAFBFBFC
FDFDFCFCFAF9F8F7F7F6F6F6F6F7F7F8F8F9FAFAFBFCFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFD
FDFDFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFBFBFBFBFCFCFD
FDFDFDFDFCFBFAFAF9F9F8F8F8F9F9F9FAFAFBFBFCFCFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFCFCFCFCFCFDFD
FDFEFEFEFDFDFCFBFBFAFAFAFAFAFAFBFBFBFCFCFDFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFE
FEFEFEFEFEFEFDFDFCFCFCFBFBFBFCFCFCFCFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFEFEFEFDFDFDFDFCFCFDFDFDFDFDFDFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFFFFFFFFFFFFFEFEFEFDFDFDFDFDFDFDFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 70.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 70.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFDFCFCFCFBFBFAFAF9F8F8F7F7F6
F6F6F5F5F4F4F4F3F3F3F2F2F2F2F2F1F1F1F1F1F1F1F0F0
F0F0F0F0F0F0F0F0F0F0F0F1F1F1F1F2F2F3F3F4F4F5F5F6
F6F7F8F8F9F9FAFBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFCFBFBFAFAF9F8F8F7F7F6F6F5F4
F4F4F3F3F2F2F2F1F1F1F1F1F0F0F0F0F0F0F0EFEFEFEFEF
EFEEEEEEEEEEEEEEEEEEEEEFEFEFEFF0F0F0F1F1F2F2F3F4
F4F5F6F6F7F8F8F9FAFAFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFEFDFDFDFCFCFCFBFBFAFAFAF9F9F8F8F8F7
F7F7F6F6F6F6F6F5F5F5F5F5F5F5F5F5F4F4F4F4F4F4F4F4
F4F3F3F3F3F3F3F3F3F3F3F3F3F3F4F4F4F4F5F5F5F6F6F7
F7F7F8F8F9F9FAFAFBFBFCFCFDFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFCFBFBFAFAF9F8F7F7F6F5F5F4F3
F3F2F1F1F0F0EFEFEFEEEEEEEDEDEDEDECECECECECEBEBEB
EBEBEAEAEAEAEAEAEAEAEBEBEBECECEDEDEEEEEFF0F1F1F2
F3F4F5F6F7F7F8F9FAFAFBFCFCFDFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFCFCFCFBFAF9F9F8F7F6F5F4F3F2F2F1F0EF
EEEEEDEDECECEBEBEBEAEAEAEAEAE9E9E9E9E9E8E8E8E8E7
E7E7E7E6E6E6E6E6E6E6E6E6E7E7E7E8E8E9EAEAEBECEDEE
EFF0F1F2F3F4F5F6F7F8F9FAFBFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFDFEFDFDFCFCFBFAF9F9F8F7F6F5F4F3F2F1F1F0EFEE
EDEDECECEBEBEBEAEAEAEAEAE9E9E9E9E9E9E8E8E8E8E7E7
E7E6E6E6E6E5E5E5E5E5E5E5E6E6E6E7E7E8E9E9EAEBECED
EEEFF0F1F2F3F4F5F6F7F8F9FAFBFBFCFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFEFDFDFDFCFCFBFAF9F9F8F7F6F5F4F3F1F0EFEEEDECEB
EAE9E8E8E7E7E6E6E5E5E5E4E4E4E4E4E3E3E3E2E2E2E1E1
E1E0E0E0DFDFDFDFDFDFDFDFE0E0E1E1E2E3E4E5E6E7E8EA
EBECEDEFF0F1F3F4F5F6F7F8F9FAFBFCFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFDFDFDFDFCFBFAF9F8F7F6F5F4F2F1F0EEEDECEAE9E8E7
E6E5E4E3E2E2E1E1E1E1E0E0E0E0E0E0DFDFDFDEDEDEDDDD
DCDCDBDBDADADADADADADADADADBDBDCDDDEDFE0E1E2E3E5
E6E8E9EBEDEEF0F1F3F4F6F7F8F9FAFBFCFCFDFDFEFEFEFF
FFFFFFFFFF
FFFDFCFDFCFBFAF9F8F7F6F5F3F2F0EFEDECEAE9E7E6E5E4
E2E2E1E0DFDFDEDEDEDEDEDEDEDDDDDDDDDDDCDCDBDBDADA
D9D9D8D8D7D7D7D6D6D6D6D6D7D7D8D8D9DADBDCDDDFE0E2
E3E5E6E8EAECEDEFF1F2F4F5F7F8F9FAFBFCFCFDFEFEFEFF
FFFFFFFFFF
FFFDFCFCFCFAF9F9F7F6F4F3F2F0EEEDEBE9E8E6E4E3E1E0
DFDEDDDCDBDBDADADADAD9D9D9D9D9D9D9D8D8D8D7D6D6D5
D5D4D3D3D2D2D1D1D1D1D1D1D1D2D3D3D4D5D6D8D9DBDCDE
E0E2E3E5E7E9EBEDEFF1F2F4F6F7F8F9FAFBFCFDFDFEFEFE
FFFFFFFFFF
FFFCFBFCFBF9F8F8F6F4F3F1F0EEECEAE8E6E4E2E1DFDDDC
DAD9D8D7D7D6D6D5D5D5D5D5D5D5D5D5D5D5D4D4D3D3D2D1
D0D0CFCECECDCCCCCCCCCCCCCCCDCDCECFD0D1D3D4D6D8DA
DCDEE0E2E4E6E9EBEDEFF1F3F4F6F7F9FAFBFCFCFDFEFEFE
FFFFFFFFFF
FFFCFAFCFBF8F7F7F5F3F1F0EDEBE9E7E5E3E1DFDDDBD9D8
D6D5D4D3D3D2D2D2D2D2D2D2D2D3D3D3D2D2D2D1D1D0CFCE
CDCCCCCBCAC9C9C8C8C8C7C8C8C8C9CACACCCDCED0D2D3D5
D8DADCDEE1E3E6E8EBEDEFF1F3F5F6F8F9FAFBFCFDFDFEFE
FFFFFFFFFF
FFFBFAFBFAF8F7F6F3F1F0EEEBE9E7E4E2E0DEDBD9D7D6D4
D3D1D0CFCFCECECECECECFCFCFD0D0D0D0CFCFCECECDCCCB
CAC9C8C7C6C5C5C4C4C3C3C3C3C4C4C5C6C7C9CACCCECFD2
D4D6D9DBDEE0E3E6E8EBEDEFF1F3F5F7F8FAFBFCFCFDFEFE
FEFFFFFFFF
FFFBF9FBF9F7F5F4F2F0EEECE9E7E4E2DFDDDAD8D6D4D2D0
CECDCCCBCBCACACACBCBCBCCCCCDCDCDCDCDCDCCCBCAC9C8
C7C6C5C4C3C2C1C0C0BFBFBFBFC0C0C1C2C3C4C6C7C9CBCE
D0D2D5D8DBDDE0E3E6E9EBEEF0F2F4F6F8F9FAFBFCFDFDFE
FEFFFFFFFF
FFFAF9FAF9F6F5F3F1EEECEAE7E4E2DFDCD9D7D4D2D0CECC
CBC9C8C8C7C7C7C7C8C8C9CACACBCBCCCCCCCBCBCAC9C8C6
C5C4C3C1C0BFBEBEBDBCBCBCBCBCBDBDBEBFC0C2C3C5C7CA
CCCFD1D4D7DADDE1E4E7E9ECEFF1F3F5F7F8FAFBFCFDFDFE
FEFFFFFFFF
FFFAF8FAF8F5F4F2EFEDEAE8E5E2DFDCD9D6D3D1CECCCAC9
C7C6C5C4C4C4C4C5C5C6C7C8C9C9CACACBCACAC9C9C8C6C5
C4C2C1C0BEBDBCBBBBBAB9B9B9B9BABABBBCBDBEC0C2C4C6
C9CBCED1D4D8DBDEE1E4E8EAEDF0F2F4F6F8F9FAFBFCFDFD
FEFFFEFFFF
FFF9F7F9F7F4F3F1EEEBE9E6E2DFDCD9D6D3D0CECBC9C7C5
C4C3C2C1C1C1C1C2C3C4C5C6C7C8C9CACACACAC9C8C7C6C4
C3C1C0BEBDBCBBBAB9B8B8B7B7B7B7B8B8B9BABBBDBFC1C3
C5C8CBCED2D5D8DCDFE2E6E9ECEEF1F3F5F7F9FAFBFCFDFD
FEFEFEFFFF
FFF8F7F9F6F3F2F0ECE9E7E4E0DDDAD6D3D0CDCAC8C6C4C2
C1C0BFBFBEBFBFC0C1C3C4C5C7C8C9CACACACAC9C8C7C6C4
C3C1C0BEBDBBBAB9B8B7B6B6B6B6B6B6B6B7B8B9BABCBEC0
C3C5C8CBCFD2D6D9DDE1E4E7EAEDF0F2F5F6F8FAFBFCFDFD
FEFEFEFFFF
FFF8F6F8F6F2F1EFEBE8E5E2DEDBD7D4D0CDCAC8C5C3C1BF
BEBDBDBCBCBDBEBFC0C2C3C5C7C8C9CACBCBCBCAC9C8C7C5
C3C2C0BEBDBBBAB9B8B7B6B6B5B5B5B5B5B5B6B7B8BABBBE
C0C3C6C9CCD0D4D7DBDFE2E6E9ECEFF2F4F6F8F9FAFCFCFD
FEFEFEFFFF
FFF7F5F8F5F1F0EDE9E6E3E0DCD8D5D1CECBC8C5C3C0BFBD
BCBBBBBBBBBCBDBEC0C1C3C5C7C9CACBCCCCCCCCCBC9C8C6
C5C3C1BFBEBCBBBAB9B8B7B6B5B5B4B4B4B4B5B5B6B8B9BB
BEC0C3C7CACED1D5D9DDE1E4E8EBEEF1F3F5F7F9FAFBFCFD
FEFEFEFEFF
FFF7F5F7F4F0EFECE8E5E2DEDAD6D3CFCCC8C5C3C0BEBDBB
BABAB9B9BABBBCBEBFC1C4C6C8CACCCDCECECECECDCBCAC8
C6C5C3C1BFBEBCBBBAB9B8B7B6B5B5B4B4B4B4B4B5B6B8BA
BCBEC1C5C8CCD0D4D8DCDFE3E7EAEDF0F3F5F7F8FAFBFCFD
FDFEFEFEFF
FFF6F4F7F3EFEEEBE7E3E0DCD8D4D1CDC9C6C3C1BEBCBBBA
B9B8B8B9B9BABCBEC0C2C4C7C9CBCDCFD0D0D0D0CFCECCCB
C9C7C5C3C2C0BFBDBCBBBAB9B7B6B6B5B4B4B4B4B4B5B7B8
BABDC0C3C7CACED2D6DADEE2E6E9ECEFF2F4F6F8FAFBFCFD
FDFEFEFEFF
FFF6F3F7F2EEEDEAE5E2DFDAD6D3CFCBC7C4C1BFBDBBBAB9
B8B8B8B8B9BBBCBEC0C3C6C8CBCDCFD1D2D3D3D3D2D1CFCD
CCCAC8C6C4C3C1C0BFBDBCBBB9B8B7B6B5B4B4B4B4B5B6B8
BABCBFC2C5C9CDD1D5D9DDE1E5E8ECEFF1F4F6F8F9FBFCFC
FDFEFEFEFF
FFF5F3F6F2EDECE9E4E1DDD9D5D1CDC9C6C3C0BDBBBAB9B8
B7B7B8B9BABBBDBFC2C4C7CACDD0D2D4D5D6D6D6D5D4D2D0
CFCDCBC9C8C6C5C3C2C0BFBEBCBBB9B8B7B6B5B5B5B5B6B7
B9BBBEC1C4C8CCD0D4D8DCE0E4E8EBEEF1F3F6F8F9FAFCFC
FDFEFEFEFF
FFF5F2F6F1ECECE8E3E0DCD8D4D0CCC8C5C1BFBCBBB9B8B7
B7B8B8B9BABCBEC1C3C6C9CCCFD2D4D7D8D9D9D9D8D7D6D4
D2D0CECDCBCAC8C7C5C4C2C0BFBDBBBAB8B7B6B5B5B5B6B7
B9BBBEC0C4C7CBCFD3D7DBDFE3E7EAEEF0F3F5F7F9FAFBFC
FDFEFEFEFF
FFF4F2F6F0ECEBE7E2DFDBD6D2CFCBC7C4C0BEBCBAB9B8B8
B8B8B9BABCBDC0C2C5C8CBCED1D4D7D9DBDCDDDDDCDBD9D7
D6D4D2D0CFCDCCCAC9C7C6C4C2C0BEBCBAB9B7B7B6B6B7B8
B9BBBDC0C3C7CBCED2D7DBDFE3E6EAEDF0F3F5F7F9FAFBFC
FDFEFEFEFF
FFF4F1F5F0EBEAE6E1DEDAD6D2CECAC6C3C0BDBBBAB9B8B8
B8B9BABBBDBFC1C4C7CACDD0D4D7DADCDEDFE0E0DFDEDDDB
D9D7D6D4D3D1D0CECDCBC9C7C5C2C0BEBCBBB9B8B8B8B8B9
BABCBEC0C3C7CACED2D6DADEE2E6E9EDF0F2F5F7F8FAFBFC
FDFEFEFEFF
FFF3F1F5EFEAEAE6E1DEDAD5D1CDC9C5C2C0BDBBBAB9B9B9
B9BABBBDBFC1C3C6C9CCCFD3D6D9DCDFE1E3E3E3E3E2E0DE
DDDBD9D8D6D5D4D2D0CFCDCAC8C6C3C1BFBDBCBBBABABABA
BBBDBFC1C4C7CACED2D6DADEE2E5E9ECEFF2F4F7F8FAFBFC
FDFEFEFEFF
FFF3F1F5EEEAEAE5E0DDD9D4D0CDC9C5C2C0BDBCBBBABABA
BBBCBDBFC1C3C6C8CBCED2D5D8DCDFE1E4E5E6E7E6E5E3E2
E0DEDDDCDAD9D8D6D5D3D1CECCC9C7C4C2C0BFBDBCBCBCBC
BDBEC0C2C4C7CACED2D5D9DDE1E5E9ECEFF2F4F6F8FAFBFC
FDFEFEFEFF
FFF2F0F5EEEAE9E4DFDDD8D4D0CCC8C5C2C0BEBDBCBBBBBC
BDBEBFC1C3C6C8CBCED1D4D7DBDEE1E4E6E8E9EAE9E8E7E5
E3E2E1DFDEDDDCDAD9D7D4D2CFCCCAC7C5C3C2C0BFBEBEBE
BFC0C1C3C5C8CBCED2D6D9DDE1E5E8ECEFF2F4F6F8FAFBFC
FDFEFEFEFF
FFF2F0F5EEE9E9E4DFDCD8D3D0CCC9C6C3C1BFBEBDBDBDBE
BFC0C2C4C6C8CBCDD0D3D6D9DDE0E3E6E9EBECECECEBEAE8
E7E5E4E3E2E1E0DEDCDAD7D5D2CFCCCAC8C6C4C2C1C1C0C0
C0C1C2C4C6C8CBCED2D6DADDE1E5E8ECEFF1F4F6F8F9FBFC
FDFEFEFEFF
FFF2F0F4EDE9E9E4DFDCD8D3D0CCC9C6C4C1C0BFBFBFBFC0
C1C3C5C7C9CBCED0D3D6D9DCDFE2E5E8EBEDEEEFEFEEEDEC
EAE9E8E6E5E4E3E1DFDCDAD7D4D1CFCCCAC8C6C4C3C2C1C1
C1C2C3C4C6C9CCCFD2D6DADDE1E5E8ECEFF1F4F6F8F9FBFC
FDFEFEFEFF
FFF1EFF4EDE9E8E3DFDCD8D3D0CDC9C7C4C3C1C1C0C1C1C2
C4C6C7CACCCED1D3D6D8DBDEE1E4E7EAECEFF0F1F1F1F0EE
EDEBEAE9E8E6E5E3E1DFDCD9D7D4D1CFCCCAC8C6C5C4C3C2
C2C2C3C5C6C9CCCFD2D6DADDE1E5E8ECEFF1F4F6F8F9FBFC
FCFEFEFEFF
FFF1EFF4ECE8E8E3DEDCD8D3D0CDCAC7C5C4C3C2C2C3C4C5
C7C9CBCDCFD1D4D6D8DBDEE0E3E6E9EBEEF0F2F3F4F3F2F1
EFEEECEBEAE9E8E6E4E2DFDDDAD8D5D3D0CECBC9C7C6C4C3
C3C3C3C5C6C9CBCFD2D6D9DDE1E5E8ECEFF1F4F6F8F9FBFC
FCFEFEFEFF
FFF1EFF4ECE8E8E3DEDCD7D3D0CDCAC8C6C5C4C4C4C5C6C8
CACCCED0D2D5D7D9DBDEE0E3E5E8EAEDEFF2F4F5F5F5F4F2
F1F0EFEEEDEDEBEAE8E6E4E1DFDDDAD8D5D3D0CDCBC9C7C6
C5C4C5C5C7C9CBCED2D5D9DDE1E5E8EBEFF1F4F6F8F9FBFC
FCFEFEFEFF
FFF1EFF4ECE8E8E2DEDCD7D3D1CECBC9C7C6C6C6C6C7C9CB
CDCFD1D4D6D8DADCDFE1E3E5E7EAECEEF1F3F5F6F7F6F6F4
F3F2F2F1F1F0EFEEECEAE8E6E4E2DFDDDBD8D5D2D0CDCBC9
C8C7C7C7C8CACCCED2D5D9DDE0E4E8EBEEF1F4F6F8F9FBFC
FCFEFEFEFF
FFF0EFF4ECE8E8E2DEDCD7D4D1CECBCAC8C7C7C8C8CACBCD
D0D2D4D7D9DCDEE0E2E4E6E8E9EBEEF0F2F4F5F7F8F8F8F7
F6F5F5F4F3F3F1F0EEECEAE8E6E5E3E1DFDCD9D7D4D2CFCD
CCCACACACACBCDCFD2D5D9DCE0E4E8EBEEF1F4F6F8F9FBFC
FCFEFEFEFF
FFF0EFF4EBE8E8E2DEDBD7D4D1CECCCAC9C8C8C9CACBCDD0
D2D5D7DADCDFE1E3E5E7E8EAECEEEFF1F3F4F6F7F9FAFAF9
F8F7F6F4F3F2F1EFEDEBE9E7E6E4E3E1DFDDDBD9D7D5D3D1
D0CFCECDCDCECFD1D3D6D9DCE0E4E7EBEEF1F3F6F8F9FBFC
FCFEFEFEFF
FFF0EEF4EBE7E8E2DEDBD7D3D1CECCCAC9C9C9CACBCDCFD2
D4D7DADDDFE2E4E6E8EAEBEDEEF0F1F2F3F5F7F9FAFBFBFA
F9F7F5F3F2F1EFEDEBE9E7E5E4E2E0DEDDDBDAD8D7D6D5D4
D3D2D1D1D1D1D2D3D5D7DADDE0E4E7EAEEF0F3F5F7F9FBFC
FCFEFEFEFF
FFF0EEF4EBE7E7E1DDDBD7D3D1CECCCBCAC9CACBCCCED0D3
D6D9DCDFE1E4E7E9EBECEEEFF1F2F3F3F5F6F8FAFBFBFAFA
F8F6F4F3F2F1EFEDEBE8E6E4E2DFDDDBD9D7D6D5D4D4D3D3
D3D3D3D3D4D4D5D6D7D9DCDEE1E4E7EBEEF0F3F5F7F9FAFB
FCFEFEFEFF
FFF0EEF3EBE7E7E1DDDBD7D3D1CECCCACAC9CACBCCCED1D4
D7DADDE0E3E6E9EBEDEFF0F2F3F3F4F5F6F8F9FAFAFAFAF9
F8F7F6F5F5F3F1EFEDEAE8E5E2DEDBD8D5D3D1D0CFCFCFD0
D0D1D3D4D5D6D7D8DADCDEE0E3E5E8EBEEF0F3F5F7F9FAFB
FCFDFDFEFF
FFEFEEF3EAE7E7E1DDDAD6D2D0CDCBCAC9C9CACBCCCED1D4
D7DADEE1E4E7EAECEFF1F2F4F5F5F6F7F8F9F9F9F9FAFAFB
FBFAF9F9F9F8F5F3F1EEEBE7E3DFDBD7D4D0CECCCAC9C9CA
CBCDCFD1D3D6D8DADCDEE0E2E4E7E9ECEEF1F3F5F7F9FAFB
FCFDFDFEFF
FFEFEEF3EAE6E7E0DCDAD6D2D0CDCBC9C9C8C9CACCCED0D3
D7DADDE1E4E7EAEDEFF2F4F5F6F7F7F9FAFAF9F9FAFBFCFE
FEFEFEFEFEFEFBF9F6F2EEEAE6E1DDD8D4D0CCC9C6C5C4C4
C5C7C9CCCFD3D6D9DCDFE1E4E6E8EBEDEFF1F3F5F7F9FAFB
FCFDFDFEFF
FFEFEDF3EAE6E6E0DCDAD5D1CFCCCAC9C8C7C8C9CBCDD0D3
D6D9DDE0E4E7EAEDF0F2F4F6F7F8F9FAFAFAF9FAFCFEFFFF
FFFFFFFFFFFFFFFEFBF7F2EEEAE5E0DAD5D0CBC7C3C1BFBF
BFC0C3C6CACED2D6DADEE1E4E7EAECEEF0F2F4F6F7F9FAFB
FCFDFDFEFF
FFEFEDF3E9E6E6E0DBD9D4D1CECBC9C7C6C6C7C8C9CBCED1
D4D8DBDFE2E6E9ECEFF2F4F6F7F8FAFBFBFAF9FBFEFFFFFF
FFFFFFFFFFFFFFFFFFFAF6F2EEE9E3DDD7D1CCC7C2BEBCBA
BABBBCBFC3C8CCD2D7DBE0E4E7EAEDEFF1F3F5F7F8F9FBFB
FCFDFDFEFF
FFEFEDF3E9E6E6DFDBD8D4D0CDCAC8C6C5C5C5C6C8CACCCF
D3D6DADDE1E4E7EBEEF0F3F4F6F8FAFBFAFAFAFCFFFFFFFF
FFFFFFFFFFFFFFFFFFFDF9F5F1ECE6E0DAD4CDC7C2BDBAB7
B6B6B7B9BDC1C6CCD2D7DDE2E6EAEDF0F2F4F6F7F9FAFBFC
FCFEFDFEFF
FFEFEDF3E9E5E5DFDAD8D3CFCCC9C6C5C4C3C4C4C6C8CBCE
D1D4D8DCDFE2E6E9ECEFF1F3F5F8FAFAF9F9FBFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFBF8F3EEE9E3DDD7D0C9C3BEB9B6
B3B2B3B4B7BBC0C6CCD2D8DEE3E8ECF0F2F5F6F8F9FAFBFC
FDFEFDFEFF
FFEEEDF3E9E5E5DEDAD7D2CECBC8C5C3C2C2C2C3C4C6C9CC
CFD2D6DADDE1E4E7EBEDEFF1F4F7F9F9F8F8FBFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFCF9F5F1ECE6E0D9D3CCC5BFBAB6
B2B0B0B1B3B6BBC0C6CDD3DAE0E5EAEEF2F4F7F8FAFBFCFC
FDFEFEFEFF
FFEEEDF2E9E5E5DED9D6D1CDCAC7C4C2C1C0C0C1C2C4C7CA
CDD0D4D8DBDFE2E6E9ECEEF0F3F6F7F6F6F7FAFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFAF7F3EEE9E3DCD6CFC8C1BBB6
B2AFAEAEAFB2B6BBC1C8CFD5DCE2E7ECF0F3F6F8FAFBFCFD
FDFEFEFEFF
FFEEECF2E8E4E4DDD9D6D1CCC9C6C3C1BFBEBEBFC0C2C5C8
CBCFD2D6DADDE1E5E8EAECEFF2F5F5F5F4F6F9FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFCF9F5F0EBE5DFD8D1CAC4BDB8
B3B0AEADADB0B3B8BDC3CAD1D8DEE4E9EEF2F5F8FAFBFCFD
FDFEFEFEFF
FFEEECF2E8E4E4DDD8D5D0CBC8C4C1BFBEBDBDBDBEC0C3C6
C9CDD1D4D8DCE0E3E7E9EBEEF1F4F4F3F3F5F9FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFAF6F2EEE8E2DCD5CEC7C0BA
B5B1AEADADAEB1B5BAC0C6CDD4DBE1E7ECF0F4F7F9FBFCFD
FDFEFEFEFF
FFEEECF2E8E4E4DDD8D5CFCBC7C3C0BEBCBBBBBBBDBFC1C4
C7CBCFD3D7DBDFE2E5E8EAEEF1F3F3F2F2F4F9FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFBF8F5F0EBE6DFD8D1CAC4BD
B8B3B0AEADAEB0B3B8BDC4CAD1D8DEE4E9EEF2F5F8FAFCFD
FDFEFEFEFF
FFEEECF2E8E4E3DDD7D4CFCAC6C3BFBDBBBAB9BABBBDBFC2
C6CACDD1D5D9DDE1E4E7E9EDF0F2F2F1F1F3F7FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFAF8F6F2EEE9E3DDD6CFC8C1
BCB7B3B0AFAFB0B3B7BCC2C8CED5DBE1E7ECF0F4F7F9FBFC
FDFEFEFFFF
FFEEECF2E8E4E3DCD7D4CEC9C6C2BEBCBAB9B8B9BABCBEC1
C4C8CCD0D4D8DCE0E3E5E8ECEFF1F0EFEFF1F5F9FEFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFCFAF8F6F3EFEBE6E1DAD4CDC6
C0BBB7B3B1B1B2B4B7BBC1C7CDD3D9DFE5EAEEF2F5F8FAFC
FDFEFEFEFF
FFEEECF2E8E4E3DCD7D4CEC9C5C1BDBBB9B7B7B7B8BABCBF
C3C7CACED2D6DBDEE1E3E6EAEEEFEEEDECEEF2F7FDFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFAF8F5F2EFECE8E3DED8D2CC
C6C0BBB8B5B4B4B6B8BCC1C6CCD2D8DEE4E9EDF1F4F7F9FB
FCFDFEFEFF
FFEEECF2E8E4E3DCD7D3CEC9C5C1BDBAB8B6B6B6B7B9BBBE
C1C5C9CDD0D5D9DCDFE1E4E8EBEDECEBEAECF0F4F9FDFEFF
FFFFFFFFFFFFFFFFFEFDFDFDFCF9F6F3EFECE9E5E0DBD6D1
CBC6C1BDBAB8B8B9BBBEC2C7CCD2D8DDE3E8ECF0F3F6F9FA
FCFDFEFEFF
FFEEECF2E8E4E3DCD7D3CEC9C5C0BCBAB7B6B5B5B6B8BABD
C0C3C7CBCFD3D6DADCDEE1E5E9EBEAE9E8EAEDF1F5F8FBFE
FFFFFFFFFFFFFFFFFEFCFCFCFCFBF8F4F1EDE9E5E2DED9D5
D0CBC7C3C0BEBDBDBEC1C4C8CDD2D8DDE2E7EBEFF3F6F8FA
FBFDFDFEFF
FFEFECF2E9E4E3DDD7D3CEC9C4C0BCB9B7B5B4B4B5B7B9BB
BEC2C5C9CCD0D4D7D9DCDFE3E7E9E9E7E6E7E9EDF0F4F8FA
FBFCFEFEFEFDFDFEFEFCFAFAFAFBFBF8F3EFEBE7E3DFDCD8
D4D0CCC8C5C3C2C1C2C4C7CBCFD3D8DDE2E7EBEFF2F5F7F9
FBFCFDFEFF
FFEFEDF2E9E4E3DDD7D4CEC9C4C0BCB9B7B5B4B4B4B6B7BA
BDC0C3C6CACED1D4D6D9DCE1E5E8E7E5E4E4E5E8ECF0F3F6
F7F9FBFCFCFCFBFCFDFDFAF8F8F8FAFAF7F3EEE9E5E1DDDA
D7D3D0CDCAC8C7C6C7C8CACDD1D5DADEE3E7EBEFF2F5F7F9
FBFCFCFDFF
FFEFEDF2E9E4E4DDD7D4CEC9C5C0BCB9B7B5B4B3B4B5B6B8
BBBEC1C4C7CBCED1D3D6D9DEE3E6E6E3E1E0E1E4E7EBEEF1
F3F5F7F9FAFAF9F9FBFCFBF8F6F5F6F8F9F6F2EDE8E4E0DC
D9D6D4D1CFCDCCCBCCCDCED1D4D8DCE0E4E8EBEFF2F5F7F9
FBFCFCFDFF
FFEFEDF2EAE4E4DED8D4CFC9C5C1BDB9B7B5B3B3B3B4B5B7
B9BCBFC1C5C8CBCED0D3D7DCE1E4E4E2DFDDDDDFE2E6E9EC
EEF1F3F5F7F7F7F7F8FAFBF9F6F4F3F4F6F7F6F2EDE8E3DF
DCD9D7D5D3D2D1D0D0D1D2D4D7DADEE1E5E9ECEFF2F5F7F9
FBFCFCFDFF
FFF0EDF2EAE5E4DED8D5D0CAC6C2BDBAB7B5B3B3B3B3B4B6
B8BABDBFC2C5C9CBCED0D4D9DFE2E2E0DCDAD9DADDE0E3E6
E9EBEEF0F3F4F4F4F4F6F9FAF7F4F2F1F2F4F6F5F2EDE8E3
E0DDDAD8D7D6D5D4D5D5D6D8DADDE0E3E7EAEDF0F3F5F7F9
FBFCFCFDFF
FFF0EEF3EBE5E5DFD9D6D0CBC7C2BEBAB8B5B4B3B2B2B3B5
B6B8BABDC0C3C6C9CBCED2D7DCE0E1DEDAD7D5D6D8DADDE0
E3E5E8EBEEF0F1F1F1F2F5F8F8F5F2F0EFF1F3F5F5F2EDE8
E4E1DEDCDAD9D9D9D9D9DADCDEE0E3E6E8EBEEF1F3F6F8F9
FBFCFCFDFF
FFF1EEF3EBE6E5E0DAD6D1CCC8C3BFBBB8B6B4B3B2B2B3B4
B5B7B9BBBEC1C4C7C9CCCFD4D9DDDEDCD8D4D2D2D2D4D6D9
DCDFE2E5E8EBEDEEEEEEF1F4F7F7F4F0EEEEEFF2F4F4F2EE
E9E6E2E0DEDDDDDCDDDDDEDFE1E3E5E8EAEDF0F2F4F6F8F9
FBFCFCFDFF
FFF1EFF3ECE7E6E1DBD7D3CDC9C5C0BCB9B7B5B3B2B2B2B3
B4B5B7B9BCBFC2C5C7C9CDD1D6DBDCDAD7D2CFCDCDCED0D2
D5D8DBDEE2E5E8EAEAEAECF0F4F6F5F2EFEDEDEEF1F3F4F2
EFEBE7E5E3E1E0E0E0E1E2E3E4E6E8EAECEFF1F3F5F7F8FA
FBFCFCFDFF
FFF2EFF4EDE7E7E2DCD8D4CECAC6C2BEBAB8B6B4B3B2B2B2
B3B4B6B8BABDC0C3C5C7CACFD3D8DAD9D5D1CDCAC9C8C9CC
CED1D4D7DBDFE2E5E6E7E8EBEFF3F5F4F1EEECECEEF0F3F4
F2F0ECE9E7E5E4E4E4E4E5E6E7E9EBEDEEF0F2F4F6F8F9FA
FCFDFCFDFF
FFF2F0F4EEE8E7E3DDDAD5D0CCC7C3BFBCB9B7B5B3B2B2B2
B3B4B5B7B9BCBFC1C3C5C8CCD1D5D8D8D4CFCBC7C4C3C4C5
C7CACCD0D3D8DCDFE1E3E4E6E9EEF2F4F3F0EDECECEEF0F3
F4F3F1EEECEAE8E8E7E8E8E9EAECEDEFF0F2F4F5F7F8F9FA
FCFDFCFDFF
FFF3F0F4EEE9E8E4DFDBD7D2CDC9C5C1BEBBB8B6B4B3B3B2
B3B4B5B6B9BBBEC0C2C4C6C9CED2D6D6D4CFCAC5C1BFBEBF
C0C2C5C8CCD0D5D9DCDEE0E2E5E9EEF2F3F2EFEDECECEEF1
F3F4F4F2F0EEECEBEBEBEBECEDEEEFF1F2F4F5F6F8F9FAFB
FCFDFDFDFF
FFF3F1F5EFEAE9E5E0DCD8D3CFCBC7C3C0BCBAB8B6B4B3B3
B3B4B5B6B8BBBDBFC1C2C4C7CBD0D4D5D3CFC9C4BFBCBABA
BABCBEC1C5C9CED3D7DADCDEE0E4E9EEF2F3F1EFEDECEDEF
F1F4F5F5F4F2F0EFEEEEEEEFF0F1F2F3F4F5F6F8F9FAFBFB
FDFDFDFEFF
FFF4F2F5F0EBEAE7E1DEDAD5D1CDC9C5C2BFBCB9B7B6B5B4
B4B5B5B7B8BBBDBFC0C1C3C5C9CDD2D4D3CFC9C3BEB9B7B5
B5B6B8BABEC2C7CCD1D5D7DADCDFE4E9EEF2F2F1EFEEEDEE
F0F2F4F6F6F5F4F3F2F1F1F1F2F3F4F4F6F7F8F9FAFBFBFC
FDFDFDFEFF
FFF5F2F6F1ECEBE8E3E0DCD7D3CFCBC7C4C1BEBCBAB8B7B6
B6B6B6B7B9BBBDBFC0C1C2C4C7CBD0D3D3D0CAC4BEB8B4B2
B1B1B2B4B7BBC0C5CBCFD3D6D8DBDFE4E9EEF2F2F1F0EFEF
F0F1F3F5F7F7F6F6F5F4F4F4F4F5F5F6F7F8F9FAFAFBFCFC
FDFEFDFEFF
FFF5F3F6F2EDECE9E5E1DEDAD6D2CECAC7C4C1BEBCBAB9B8
B8B8B8B9BABCBEBFC0C1C1C3C6CACED1D3D1CCC5BFB8B4B0
AEADAEAFB2B5BABFC5CACED2D5D8DCE0E5EAEFF2F3F2F0F0
F0F1F3F5F6F8F8F8F7F7F6F6F6F7F7F8F8F9FAFAFBFCFCFD
FEFEFEFEFF
FFF6F4F7F3EEEDEBE6E3E0DCD8D4D1CDCAC6C4C1BFBDBCBB
BABABABBBCBDBFC0C1C1C2C3C5C9CDD0D2D2CDC7C1BAB4B0
ADABABACADB0B4B9BFC5CACED2D5D9DDE1E7ECF0F3F3F2F2
F1F2F3F4F6F8F9F9F9F9F8F8F8F8F9F9FAFAFBFBFCFCFDFD
FEFEFEFEFF
FFF7F5F7F4F0EFECE8E5E2DEDAD7D3D0CDCAC7C4C2C0BFBE
BDBDBDBDBEBFC0C1C2C2C2C3C5C8CCD0D2D2CFCAC3BCB6B1
ADAAA9A9AAADB0B5BAC0C6CBCFD2D6DADEE3E8EDF1F3F4F3
F3F3F4F5F6F7F9FAFAFAFAFAFAFAFAFAFBFBFCFCFCFDFDFE
FEFEFEFFFF
FFF7F5F8F5F1F0EEEAE7E4E1DDDAD6D3D0CDCAC8C5C3C2C1
C0C0BFBFC0C1C2C3C3C4C4C4C6C8CBCFD2D3D2CDC7C0B9B3
AEABA9A8A9AAADB1B6BCC2C7CCD0D4D8DCE1E6EAEFF2F4F5
F5F5F5F5F6F7F9FAFBFBFBFBFBFBFBFBFCFCFCFDFDFDFEFE
FEFFFEFFFF
FFF8F6F8F6F2F1EFECE9E6E3E0DCD9D6D3D0CECBC9C7C6C4
C4C3C3C3C3C4C4C5C6C6C6C6C7C9CCCFD2D4D4D0CBC4BDB7
B1ADAAA9A8A9ACAFB4B9BFC4C9CED2D6DADFE3E8EDF1F4F5
F6F6F6F6F7F8F9FAFBFCFCFCFCFCFCFCFCFDFDFDFDFEFEFE
FFFFFFFFFF
FFF9F7F9F7F3F2F1EDEBE8E5E2DFDCD9D6D4D1CFCDCBC9C8
C7C7C6C6C6C7C7C8C8C8C8C8C9CACCCFD3D5D6D4CFC9C2BB
B6B1ADABAAAAACAFB3B7BDC2C8CCD1D5D9DDE2E6EBEFF2F5
F7F7F7F7F8F8F9FAFBFCFCFDFDFDFDFDFDFDFDFEFEFEFEFE
FFFFFFFFFF
FFF9F8F9F8F4F3F2EFECEAE8E5E2DFDDDAD7D5D3D1CFCECC
CBCBCACACACACACBCBCBCBCBCBCCCED0D4D6D8D7D3CEC8C1
BBB6B1AEADACADAFB3B7BCC1C6CBD0D4D9DDE1E5E9EDF1F4
F6F8F8F9F9F9FAFAFBFCFDFDFDFDFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFF
FFFAF8FAF9F5F4F3F1EEECEAE7E5E2E0DDDBD9D7D5D3D2D1
D0CFCECECECECECECFCFCECECECFD0D2D5D8DADAD8D3CDC7
C1BBB7B3B1B0B0B1B4B8BCC1C6CBD0D4D9DDE1E5E9ECF0F3
F6F8F9F9FAFAFBFBFCFCFDFDFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFF
FFFBF9FBF9F7F6F5F2F0EEECEAE8E5E3E1DFDDDBD9D7D6D5
D4D3D2D2D2D1D2D2D2D2D2D2D1D2D2D4D6D9DBDCDBD8D3CE
C8C2BDB9B6B5B4B5B7BABEC2C7CBD0D5D9DDE1E5E8ECEFF3
F5F7F9FAFBFBFBFCFCFCFDFDFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFBFAFBFAF8F7F6F4F2F0EEECEAE8E6E4E2E0DEDDDBDAD9
D8D7D7D6D6D6D6D6D6D6D6D5D5D5D6D7D9DBDDDFDFDDD9D4
CEC9C4C0BCBAB9B9BABDC0C4C8CDD1D5DADEE1E5E9ECEFF2
F5F7F9FAFBFCFCFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFCFAFCFBF9F8F7F5F3F2F0EFEDEBE9E7E5E4E2E1DFDEDD
DCDCDBDADADADADADADADAD9D9D9D9DADBDDDFE1E2E1DEDA
D5D0CBC7C3C1BFBFBFC1C3C7CACED3D7DBDFE2E6E9ECEFF2
F5F7F9FAFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFCFBFCFBF9F9F8F7F5F4F2F1EFEDECEAE9E7E6E4E3E2E1
E0E0DFDEDEDEDEDEDEDEDEDDDDDDDDDDDEE0E2E4E5E5E3E0
DCD7D2CECAC8C6C5C5C6C8CACED1D5D9DCE0E4E7EAEDF0F2
F5F7F9FAFBFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFCFCFAF9F9F8F6F5F4F3F1F0EEEDECEAE9E8E7E6E5
E4E4E3E3E2E2E2E2E2E2E2E1E1E1E0E0E1E2E4E6E7E8E7E5
E2DED9D5D2CFCCCBCBCBCDCFD1D4D8DBDEE2E5E8EBEEF0F3
F5F7F9FAFBFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFDFCFBFAFAF9F8F7F6F5F3F2F1F0EEEDECEBEAE9E9
E8E7E7E6E6E6E5E5E5E5E5E5E5E4E4E4E4E5E7E8EAEBEBEA
E7E4E0DCD9D6D3D2D1D1D2D3D5D8DBDEE1E4E7EAECEFF1F3
F5F7F9FAFBFCFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFDFCFBFBFAF9F8F7F6F5F4F3F2F1F0EFEEEDEDEC
EBEBEAEAE9E9E9E9E9E9E9E9E8E8E8E8E8E8E9EBECEDEEED
ECE9E6E2DFDCDAD8D7D7D7D8DADCDEE1E3E6E9EBEEF0F2F4
F6F8F9FAFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFEFDFCFCFBFBFAF9F8F8F7F6F5F4F3F3F2F1F0F0EF
EFEEEEEDEDECECECECECECECECECEBEBEBEBECEDEEEFF0F1
F0EEEBE8E5E2E0DEDDDDDDDDDEE0E2E4E6E9EBEDEFF1F3F5
F7F8FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFCFCFCFBFAFAF9F8F8F7F6F5F5F4F3F3F2F2
F1F1F0F0F0F0EFEFEFEFEFEFEFEFEEEEEEEEEEEFF0F1F3F3
F3F2F0EDEBE8E6E4E3E2E2E2E3E4E5E7E9EBEDEFF1F3F5F6
F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFDFCFCFBFBFAFAF9F8F8F7F7F6F6F5F5F4
F4F3F3F3F2F2F2F2F2F2F2F2F2F2F1F1F1F1F1F1F2F3F4F5
F5F5F3F1EFEDEBE9E8E7E7E7E7E8E9EAECEEEFF1F3F4F6F7
F8FAFBFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFCFCFBFBFAFAF9F9F8F8F7F7F7F6
F6F6F5F5F5F5F4F4F4F4F4F4F4F4F4F4F3F3F3F4F4F5F6F7
F7F7F6F5F3F1EFEEEDECEBEBEBECECEEEFF0F1F3F4F6F7F8
F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFFFFFEFEFEFDFDFDFCFCFCFBFBFAFAFAF9F9F9F8F8
F8F8F7F7F7F7F7F6F6F6F6F6F6F6F6F6F6F6F6F6F6F7F7F8
F9F9F9F8F6F5F3F2F1F0EFEFEFEFF0F0F1F2F3F5F6F7F8F9
FAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFDFDFDFCFCFCFBFBFBFBFAFAFAFA
F9F9F9F9F9F8F8F8F8F8F8F8F8F8F8F8F8F7F7F7F8F8F9F9
FAFAFAFAF9F8F6F5F4F3F3F2F2F2F2F3F4F5F5F6F7F8F9FA
FBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFCFCFCFCFBFBFBFB
FBFAFAFAFAFAFAFAFAFAFAFAFAFAFAF9F9F9F9F9F9F9FAFA
FBFBFBFBFBFAF9F8F7F6F5F5F5F5F5F6F6F7F7F8F9FAFAFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFC
FCFCFCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFAFBFBFBFB
FCFCFDFDFCFCFBFAF9F8F8F7F7F7F7F7F8F8F9F9FAFAFBFC
FCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFDFDFD
FDFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFBFBFBFCFC
FCFDFDFDFDFDFCFCFBFAFAF9F9F9F9F9F9F9FAFAFBFBFCFC
FDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFCFCFCFCFCFCFD
FDFDFDFEFEFEFDFDFCFCFBFBFBFBFBFBFBFBFBFCFCFCFDFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFEFE
FEFEFEFEFFFEFEFEFDFDFDFCFCFCFCFCFCFCFCFDFDFDFDFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFDFD
FEFEFEFEFFFFFFFEFEFDFDFDFCFCFCFCFCFCFCFCFDFDFDFD
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFFFFFFFFFEFEFEFEFDFDFDFDFDFDFDFDFDFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; endGroup; endGroup; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 75.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 75.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFCFDFBFAFAF9F8F7F6F6F5F3F2F1F0EFEEEDECEBEB
EAE9E8E8E7E6E6E5E5E5E4E4E4E3E3E3E2E2E2E1E1E1E0E0
E0DFDFDFDFDFDFDFDFDFDFDFE0E0E1E1E2E3E3E4E5E6E7E8
EAEBECEDEEF0F1F2F3F4F6F7F8F9F9FAFBFCFCFDFDFEFEFE
FFFFFFFFFF
FFFCFAFBFCFAF8F8F7F6F4F3F2F1F0EFEDECEBEAE9E8E7E6
E5E5E4E4E3E3E2E2E2E1E1E1E1E1E0E0E0E0DFDFDFDEDEDE
DDDDDDDCDCDCDCDBDBDBDBDCDCDCDCDDDDDEDFE0E1E1E3E4
E5E6E7E9EAEBEDEEF0F1F2F4F5F6F7F8F9FAFBFCFCFDFDFE
FEFEFEFFFF
FFFCFBFCFCFBF9F9F9F8F7F7F6F5F4F4F3F3F2F1F1F1F0F0
F0EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEEEEEEEEEEEDED
EDEDECECECECEBEBEBEBEBEBEBEBEBEBEBECECECEDEDEEEE
EFEFF0F0F1F2F3F4F4F5F6F7F8F8F9FAFBFBFCFCFDFDFEFE
FEFFFEFFFF
FFFDFBFCFCFBFAFAF9F8F7F6F5F4F2F1F0EFEEEDECEAE9E8
E7E6E5E5E4E3E3E2E2E1E1E1E0E0E0DFDFDEDEDEDDDDDCDC
DBDBDBDADADADADADADADADBDBDCDCDDDEDFE0E1E2E3E5E6
E7E9EAECEDEFF0F1F3F4F5F6F7F8F9FAFBFCFCFDFDFEFEFE
FFFFFFFFFF
FFFBF9FAFBF8F7F6F5F3F2F1EFEEECEAE9E7E6E4E3E2E1DF
DFDEDDDCDCDBDBDBDBDBDADADADADADAD9D9D9D8D8D7D7D6
D6D5D5D4D4D4D3D3D3D3D3D3D3D3D4D4D5D5D6D7D8DADBDC
DEDFE1E3E5E7E8EAECEEF0F1F3F4F6F7F8F9FAFBFCFDFDFD
FEFEFEFFFF
FFFAF8F9FAF7F5F5F4F2F0EFEEECEBE9E8E7E6E5E4E3E2E1
E1E0E0E0DFDFDFDFE0E0E0E0E0E0E0E0E0DFDFDFDEDEDDDD
DCDCDBDBDADAD9D9D9D8D8D8D8D8D8D9D9D9DADBDBDCDDDE
DFE0E2E3E5E6E8E9EBECEEF0F1F3F4F6F7F8F9FAFBFCFCFD
FEFEFEFEFF
FFFAF7F9FAF6F5F5F4F2F0EFEEECEAE9E8E6E5E3E2E1E0DF
DEDDDCDBDBDADADAD9D9D9D9D9D9D8D8D8D7D7D6D6D5D4D4
D3D2D2D1D1D0D0D0D0D0D0D0D0D1D1D2D3D4D5D6D7D8DADB
DDDFE0E2E4E5E7E9EBECEEF0F1F3F4F6F7F8F9FAFBFCFCFD
FEFEFEFEFF
FFF9F7F9F9F5F4F4F2EFEEECEAE8E6E4E2E0DFDDDBDAD8D7
D6D5D4D4D3D3D3D3D3D3D3D3D3D3D3D3D3D2D2D1D1D0CFCE
CECDCCCBCBCACAC9C9C9C8C8C9C9C9CACACBCCCDCFD0D2D3
D5D7D9DBDEE0E2E4E7E9EBEDEFF1F3F4F6F7F9FAFBFCFCFD
FDFEFEFEFF
FFF8F5F8F8F3F2F1EFECEBE9E7E4E2E1DFDDDBD9D8D6D5D4
D4D3D3D3D2D3D3D3D3D4D4D4D4D5D5D5D4D4D4D3D3D2D1D0
CFCFCECDCCCCCBCACAC9C9C9C9C9C9C9CACACBCCCDCECFD1
D2D4D6D8DADCDEE1E3E5E8EAECEEF0F2F4F6F7F9FAFBFCFC
FDFEFEFEFF
FFF7F4F7F7F2F0F0EEEBE9E7E5E2E1DFDDDBD9D7D6D5D3D2
D2D1D0D0D0D0D0D0D0D1D1D1D1D1D1D1D1D1D0CFCFCECDCC
CBCAC9C9C8C7C6C6C5C5C5C5C5C5C5C6C7C7C8C9CACCCDCF
D0D2D4D6D8DADDDFE1E4E6E8EBEDEFF1F3F5F6F8F9FAFBFC
FDFEFDFEFF
FFF6F3F6F6F0EFEFECE9E7E5E3E0DEDCD9D7D5D3D2D0CFCE
CDCCCBCBCBCBCBCCCCCCCDCDCECECECECECECDCCCCCBCAC9
C8C7C6C5C4C3C2C1C1C0C0C0C0C0C0C0C1C2C3C4C5C6C8CA
CCCED0D2D5D7DADCDFE1E4E7E9ECEEF0F2F4F6F7F8FAFBFB
FDFDFDFEFF
FFF5F2F6F5EFEDEDEAE6E5E2DFDDDAD8D6D3D1CFCECCCBCA
C9C9C9C8C9C9CACACBCCCDCDCECECFCFCFCECECDCCCCCBCA
C8C7C6C5C4C3C2C1C1C0BFBFBFBFBFBFBFC0C0C1C2C3C4C6
C8CACCCED0D3D6D9DBDEE1E4E7EAECEEF1F3F5F6F8F9FAFB
FCFDFDFDFF
FFF4F0F5F3EDECECE8E4E2E0DDDAD8D5D3D0CFCDCBCAC9C8
C7C7C7C7C7C8C8C9CACBCCCCCDCECECECECECDCDCCCBCAC8
C7C6C5C4C3C2C1C0BFBFBEBEBDBDBDBDBEBEBFBFC0C1C2C4
C5C7C9CBCED0D3D6D9DCDFE2E5E8EAEDEFF2F4F5F7F9FAFB
FCFDFDFDFF
FFF3EFF4F2EBEAEAE6E2E0DEDAD7D5D3D0CECCCAC8C7C6C5
C4C4C4C4C5C5C6C7C8C9CACBCCCDCDCDCDCDCDCCCBCAC9C8
C6C5C4C3C1C0BFBEBEBDBCBCBBBBBBBBBBBBBCBDBDBEC0C1
C3C5C7C9CBCED1D4D7DADDE0E3E6E9ECEEF0F3F5F6F8F9FA
FCFDFCFDFF
FFF2EEF3F1EAE9E8E4E0DEDBD8D5D2D0CDCBC9C7C5C4C3C2
C2C2C2C2C3C4C5C6C8C9CACBCDCDCECECECECECDCCCBCAC9
C8C6C5C4C2C1C0BFBEBDBCBCBBBBBABABABABABBBBBCBDBE
C0C2C4C6C8CBCED1D4D7DBDEE1E4E7EAEDEFF2F4F6F8F9FA
FBFDFCFDFF
FFF1ECF2F0E8E7E7E2DEDCD9D5D2D0CDCAC8C6C5C3C2C1C0
C0C0C1C1C2C3C5C6C8C9CBCCCDCECFD0D0D0CFCFCECDCBCA
C9C7C6C5C3C2C1C0BFBEBDBCBCBBBBBABABABABABABBBCBD
BEC0C2C4C6C9CCCFD2D5D9DCDFE3E6E9ECEFF1F3F5F7F9F9
FBFDFCFDFF
FFEFEBF2EEE6E6E5E0DCDAD7D3D0CECBC8C6C4C3C1C0BFBF
BFBFC0C1C2C3C4C6C8CACBCDCECFD0D1D1D1D1D0CFCECDCB
CAC9C7C6C5C3C2C1C0BFBEBDBDBCBBBBBABABABABABABBBC
BDBEC0C2C4C7CACDD0D3D7DADEE1E5E8EBEEF0F3F5F7F8F9
FBFCFCFCFF
FFEEEAF1EDE5E4E4DEDAD8D5D1CECBC8C6C4C2C1C0BFBEBE
BEBEBFC0C1C3C5C6C8CACCCED0D1D2D3D3D3D3D2D1D0CFCE
CCCBC9C8C7C5C4C3C2C1C0BFBEBDBCBBBBBABAB9B9B9BABA
BBBDBEC0C3C5C8CBCED2D5D9DCE0E3E7EAEDEFF2F4F6F8F9
FAFCFCFCFF
FFEDE9F1ECE3E3E2DCD8D6D3CFCCC9C7C4C2C1BFBEBDBDBD
BDBEBFC0C2C3C5C7CACCCED0D2D3D5D5D6D6D5D5D4D3D2D0
CFCDCCCBC9C8C7C6C5C4C3C1C0BFBEBDBCBBBABAB9B9B9BA
BBBCBDBFC1C4C6CACDD0D4D7DBDFE2E6E9ECEFF1F3F6F8F8
FAFCFBFCFF
FFECE7F0EBE2E2E1DAD6D5D1CDCAC8C5C2C1BFBEBDBDBDBD
BDBEBFC1C2C4C6C9CBCED0D2D4D6D7D8D8D8D8D7D6D5D4D3
D2D0CFCECCCBCAC9C8C6C5C4C3C1C0BFBEBCBBBBBABABABA
BABBBDBEC0C3C5C8CBCFD2D6DADDE1E5E8EBEEF1F3F5F7F8
FAFCFBFCFF
FFEBE6F0E9E0E1E0D8D5D3CFCBC9C6C3C1C0BEBDBDBCBCBD
BDBEC0C1C3C5C8CACDCFD2D4D6D8D9DADBDBDBDAD9D8D7D6
D5D3D2D1D0CECDCCCBC9C8C7C5C4C2C1BFBEBDBCBBBABABA
BABBBCBEC0C2C4C7CACED1D5D9DCE0E4E7EAEDF0F2F5F7F8
FAFCFBFCFF
FFEAE5EFE8DFE0DED7D4D2CECAC8C5C2C0BFBEBDBCBCBCBD
BEBFC1C2C4C7C9CCCFD1D4D7D9DBDCDDDEDEDEDEDDDCDAD9
D8D7D5D4D3D2D1CFCECDCCCAC8C7C5C3C2C0BFBDBCBBBBBB
BBBBBCBEBFC2C4C7CACDD1D4D8DCDFE3E6EAEDF0F2F4F7F8
F9FCFBFCFF
FFE9E4EFE7DEE0DDD5D3D1CCC9C7C4C1C0BEBDBDBCBDBDBE
BFC0C2C4C6C8CBCED1D3D6D9DBDDDFE0E1E1E1E1E0DFDEDC
DBDAD9D8D7D5D4D3D2D0CFCDCCCAC8C6C4C2C1BFBEBDBCBC
BCBCBDBEC0C2C4C6C9CDD0D4D7DBDFE2E6E9ECEFF1F4F6F7
F9FBFBFBFF
FFE8E3EFE6DDDFDCD4D2D0CBC8C6C3C1BFBEBDBDBDBDBEBF
C0C1C3C5C8CACDD0D3D6D8DBDEE0E2E3E4E4E4E4E3E2E1E0
DEDDDCDBDAD9D8D7D5D4D3D1CFCDCBC9C7C5C3C1C0BFBEBD
BDBDBEBFC0C2C4C6C9CCCFD3D7DADEE2E5E8ECEFF1F4F6F7
F9FBFBFBFF
FFE7E3EEE5DCDFDBD3D1D0CAC7C6C3C1BFBEBEBDBEBEBFC0
C1C3C5C7CACCCFD2D5D8DBDEE0E2E4E6E7E7E7E7E6E5E4E3
E2E1E0DFDEDDDCDAD9D8D6D4D2D0CECCC9C7C5C3C2C1C0BF
BFBFBFC0C1C2C4C6C9CCCFD3D6DADDE1E5E8EBEEF1F3F6F7
F9FBFAFBFF
FFE6E2EEE4DBDEDBD2D1CFCAC7C5C3C1C0BFBEBEBFBFC0C2
C3C5C7C9CCCED1D4D7DADDE0E2E5E7E8E9EAEAE9E9E8E7E6
E5E4E3E2E1E0DFDEDDDBD9D7D5D3D1CECCCAC8C6C4C3C2C1
C0C0C0C1C2C3C5C7C9CCCFD2D6D9DDE1E4E8EBEEF0F3F6F7
F9FBFAFBFF
FFE6E1EEE3DADEDAD2D1CFC9C7C6C3C1C0C0BFC0C0C1C2C4
C5C7C9CBCED0D3D6D9DCDFE2E5E7E9EBECECECECECEBEAE9
E8E7E6E5E4E4E3E1E0DEDDDBD8D6D4D1CFCDCBC9C7C5C4C3
C2C2C2C2C3C4C5C7C9CCCFD2D6D9DDE0E4E7EBEEF0F3F5F7
F8FBFAFBFF
FFE5E1EEE2DADED9D1D1CFC9C7C6C3C2C1C1C1C1C2C3C4C6
C7C9CCCED0D3D5D8DBDEE1E4E6E9EBEDEEEFEFEFEEEDEDEC
EBEAE9E8E8E7E6E5E3E2E0DEDCD9D7D5D2D0CECCCAC8C7C6
C5C4C4C4C4C5C6C8CACCCFD2D5D9DCE0E4E7EAEDF0F3F5F6
F8FBFAFBFF
FFE4E0EEE2D9DED9D1D1CEC9C8C6C4C3C2C2C2C3C4C5C6C8
CACCCED0D3D5D8DADDE0E3E6E8EBEDEFF0F1F1F1F1F0EFEE
EDEDECEBEBEAE9E8E6E5E3E1DFDCDAD8D5D3D1CFCDCBC9C8
C7C6C5C5C5C6C7C8CACDCFD2D5D9DCE0E3E7EAEDF0F2F5F6
F8FBFAFBFF
FFE4E0EEE1D9DED9D1D1CFCAC8C7C5C4C4C4C4C5C6C7C9CB
CDCFD1D3D5D8DADDDFE2E5E7EAEDEFF1F2F3F3F3F3F2F1F1
F0EFEFEEEDEDECEBE9E7E6E3E1DFDDDAD8D6D4D2D0CECCCA
C9C8C7C7C7C7C8C9CBCDD0D2D6D9DCE0E3E7EAEDF0F2F5F6
F8FBFAFBFF
FFE3E0EEE1D9DED8D1D1CFCAC9C8C6C5C5C5C6C7C8CACCCE
D0D2D4D6D8DADDDFE2E4E7E9ECEEF0F2F4F4F5F5F5F4F3F3
F2F2F1F0F0EFEEEDEBEAE8E6E3E1DFDDDBD9D6D4D2D0CECC
CBCAC9C8C8C8C9CACCCED0D3D6D9DCE0E3E7EAEDEFF2F5F6
F8FBFAFBFF
FFE3DFEEE0D8DED8D1D2CFCACAC9C7C7C7C7C8C9CBCCCED0
D3D5D7D9DBDDDFE2E4E6E8EBEDEFF1F3F5F6F7F7F6F6F5F5
F4F3F3F2F2F1F0EFEDEBEAE8E6E4E1DFDDDBD9D7D4D2D0CE
CCCBCAC9C9C9CACBCCCED0D3D6D9DCE0E3E7EAEDEFF2F5F6
F8FBFAFAFF
FFE2DFEEE0D8DED8D1D2CFCBCBCAC8C8C9C9CACCCDCFD1D3
D6D8DADCDEE0E2E4E6E8EAECEFF1F3F4F6F7F8F8F8F8F7F6
F6F5F5F4F3F3F2F1EFEDECEAE8E6E4E2E0DEDBD9D6D4D2D0
CECCCBCACACACACBCDCED1D3D6D9DDE0E3E7EAEDEFF2F5F6
F8FBFAFAFF
FFE2DFEEDFD8DED8D1D3D0CCCBCBC9CACACBCCCED0D2D4D6
D8DBDDDFE1E3E5E7E8EAECEEF0F2F4F5F7F8F9F9F9F9F8F8
F7F6F6F6F5F5F4F2F1F0EEECEBE9E7E5E3E1DEDCD9D6D4D1
CFCECCCBCACACBCBCDCFD1D3D6D9DDE0E3E7EAEDEFF2F5F6
F8FBFAFAFF
FFE2DFEEDFD8DFD7D1D3D0CCCCCCCACBCCCDCED0D2D4D7D9
DBDEE0E2E4E6E7E9EBECEEF0F1F3F5F6F8F9FAFAFAFAF9F9
F8F8F8F7F7F6F6F5F3F2F1EFEEECEAE8E6E4E1DFDCD9D7D4
D2D0CECDCCCBCCCCCDCFD1D3D6D9DCE0E3E6EAEDEFF2F5F6
F8FBFAFAFF
FFE1DEEEDED8DFD7D1D3D0CCCDCCCBCCCDCED0D2D4D7D9DC
DEE0E3E5E6E8EAECEDEEF0F1F3F4F6F7F8F9FAFBFBFBFBFA
FAF9F9F9F9F8F7F6F5F4F3F1F0EFEDEBE9E7E4E2DFDCDAD7
D5D2D0CFCECDCDCDCECFD1D4D6D9DCE0E3E6EAEDEFF2F5F6
F8FBFAFAFF
FFE1DEEEDED8DFD7D1D3D0CDCDCDCCCDCECFD1D4D6D8DBDE
E0E3E5E7E9EBEDEEEFF1F2F3F4F5F7F8F9FAFBFBFCFCFCFB
FBFBFAFAFAF9F8F7F6F5F4F2F1F0EFEDEBE9E7E4E2DFDDDA
D8D5D3D2D0CFCFCFCFD0D2D4D6D9DCE0E3E6E9EDEFF2F5F6
F7FBFAFAFF
FFE1DEEEDED8DFD7D1D3D0CDCECDCDCECFD0D2D5D7DADDE0
E2E5E7E9EBEDEFF0F1F3F4F4F5F6F7F8F9FAFBFCFDFDFDFC
FCFBFBFAFAF9F8F7F6F4F3F2F1F0EEEDEBE9E7E5E3E1DFDD
DBD8D6D5D3D2D1D1D1D2D3D5D7DADCE0E3E6E9ECEFF2F5F6
F7FBFAFAFF
FFE0DEEEDDD7DED6D1D3D0CDCECECDCED0D1D3D6D8DBDEE1
E4E6E9EBEDEFF1F2F3F4F5F6F7F8F8F9FAFBFCFDFDFEFDFD
FCFBFAFAF9F9F8F6F5F4F3F2F0EFEDEBEAE8E6E5E3E1DFDE
DCDAD9D7D6D4D3D3D3D3D4D6D8DADDE0E3E6E9ECEFF1F4F6
F7FBFAFAFF
FFE0DDEEDDD7DED6D1D3D0CDCECECDCED0D1D4D6D9DCDFE2
E5E7EAECEFF1F2F4F5F6F7F8F8F9F9FAFAFBFCFDFDFDFDFD
FCFBFBFAFAF9F8F7F5F4F3F1F0EEECEAE8E6E4E3E1E0DEDD
DCDAD9D8D7D6D6D5D5D5D6D7D9DBDEE0E3E6E9ECEFF1F4F6
F7FBFAFAFF
FFE0DDEEDCD7DED6D0D3D0CCCECDCDCED0D1D4D6D9DCDFE2
E5E8EBEDEFF1F3F5F6F7F8F9F9FAFAFBFBFCFDFDFDFDFDFD
FCFCFBFBFBFAF9F8F7F5F4F2F0EEEBE9E7E4E2E0DFDDDCDA
D9D9D8D7D7D7D7D7D7D7D8D9DBDDDFE1E4E7E9ECEFF1F4F5
F7FAF9FAFF
FFDFDDEDDCD6DED5D0D3CFCCCDCDCCCECFD1D3D6D9DCDFE2
E5E8EBEDF0F2F4F5F7F8F9FAFAFBFBFCFCFCFDFDFDFDFDFE
FDFDFDFDFDFCFBFAF9F7F5F3F1EEECE9E6E4E1DEDCDAD8D7
D6D5D5D5D5D6D6D7D8D8DADBDCDEE0E2E5E7EAEDEFF1F4F5
F7FAF9FAFF
FFDFDCEDDBD6DDD5CFD2CECBCCCCCBCDCFD0D3D5D8DBDEE1
E4E7EAEDEFF2F4F6F7F9FAFBFBFCFCFDFDFDFDFDFDFEFEFF
FFFFFFFFFFFFFDFCFBF9F7F5F2F0EDEAE7E3E0DDDAD8D5D3
D2D1D1D1D2D3D4D5D7D8DADCDEDFE1E4E6E8EBEDEFF2F4F5
F7FAF9FAFF
FFDEDCEDDBD5DDD4CED1CDCACCCBCACCCECFD2D4D7DADDE1
E4E7EAECEFF1F3F5F7F8FAFBFBFCFDFDFDFDFDFDFEFFFFFF
FFFFFFFFFFFFFFFFFDFBF9F7F4F2EEEBE8E4E0DCD9D5D3D0
CECDCCCDCDCED0D2D4D7D9DCDEE0E2E5E7E9ECEEF0F2F5F6
F7FAF9FAFF
FFDEDBEDDAD5DCD3CED0CDC9CBCAC9CBCCCED0D3D6D9DCDF
E3E6E9EBEEF1F3F5F6F8F9FAFBFCFDFEFDFDFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFDFBF9F6F3F0EDE9E5E1DCD8D4D1CE
CBC9C8C8C8CACBCED1D4D7DADDE0E3E5E8EAEDEFF1F3F5F6
F7FBF9FAFF
FFDEDBECDAD4DCD2CDD0CCC8C9C9C8CACBCDCFD2D5D8DBDE
E1E5E8EAEDF0F2F4F6F7F9FAFBFCFDFDFDFDFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFCFAF8F5F2EEEAE6E2DDD9D4D0CC
C9C6C5C4C4C5C7C9CCCFD3D7DBDFE2E5E8EBEDF0F1F3F6F6
F8FBF9FAFF
FFDDDBECDAD4DBD2CCCFCBC7C8C7C7C8CACBCED0D3D6DADD
E0E3E7E9ECEFF1F3F5F7F8F9FAFCFDFDFDFDFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFDFBF9F6F3F0ECE8E3DED9D5D0CC
C8C4C2C1C0C1C2C4C7CBCFD3D8DCE0E4E8EBEEF0F2F4F6F7
F8FBFAFAFF
FFDDDAECD9D3DBD1CBCECAC6C7C6C5C7C8CACCCFD2D5D8DC
DFE2E5E8EBEEF0F3F4F6F7F9FAFBFCFCFCFCFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFCFAF7F4F1EDE9E4DFDAD5D0CB
C7C3C0BEBDBDBEC0C2C6CACFD4D9DEE2E6EAEDF0F2F4F7F7
F9FBFAFAFF
FFDDDAECD9D2DAD0CACDC9C5C6C5C4C5C7C8CBCDD0D4D7DA
DEE1E4E7EAEDF0F2F4F5F7F8FAFBFBFBFBFCFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFBF8F6F2EFEAE6E1DBD6D1CC
C7C2BFBCBABABABCBEC2C6CAD0D5DADFE4E8ECF0F2F4F7F8
F9FCFAFBFF
FFDCD9EBD8D2D9D0C9CCC8C4C5C4C3C4C5C7C9CCCFD2D6D9
DDE0E3E7EAECEFF1F3F5F6F8F9FAFBFAFBFBFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFDFCF9F7F3F0ECE7E2DDD7D2CC
C7C2BEBBB9B7B7B8BABEC2C6CBD1D7DCE1E6EAEFF1F4F7F8
F9FCFBFBFF
FFDCD9EBD8D1D9CFC9CBC7C3C3C2C1C3C4C5C8CBCED1D4D8
DCDFE2E6E9ECEEF1F3F4F6F7F9FAFAFAFAFBFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFCFAF8F5F1EDE9E4DED9D3CD
C8C3BEBBB8B6B5B6B8BABEC2C8CDD3D9DEE4E8EDF0F3F6F8
F9FCFBFBFF
FFDCD9EBD8D1D8CEC8CAC6C2C2C1C0C1C3C4C6C9CCD0D3D7
DADEE2E5E8EBEEF0F2F4F5F7F9FAFAF9FAFBFDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFEBE6E1DBD5CF
C9C4BFBBB8B5B4B4B5B8BBBFC4CACFD5DBE1E6EBEFF2F6F7
F9FCFBFCFF
FFDCD9EAD7D0D8CEC7C9C5C1C1C0BFC0C1C3C5C8CBCED2D6
D9DDE1E4E7EAEDEFF1F3F5F7F8F9F9F9F9FAFCFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFCFBF9F7F5F1EDE9E3DED8D2
CCC6C1BCB8B5B4B3B4B6B9BDC1C7CDD2D8DEE3E9EDF1F4F7
F8FBFBFCFF
FFDCD8EAD7D0D7CEC7C9C4C0C0BFBEBFC0C1C4C7CACDD1D5
D8DCDFE3E6E9ECEEF0F2F4F6F7F8F8F7F8F9FBFDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFCFAF9F7F5F2EFEBE6E1DBD5
CFC9C3BEBAB7B5B4B4B5B8BBBFC5CAD0D6DCE1E7EBEFF3F6
F8FBFBFCFF
FFDCD8EAD7D0D7CDC6C8C4BFBFBEBDBEBFC0C3C5C8CCD0D3
D7DBDEE2E5E8EBEDEFF1F3F5F6F7F7F6F6F8F9FCFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFCFAF8F6F4F2EFECE8E4DED9
D3CDC7C2BDB9B7B5B5B5B7BABEC3C8CED4DADFE5E9EEF2F4
F7FAFAFBFF
FFDCD8EAD7CFD6CDC6C7C3BEBEBDBCBDBEBFC1C4C7CBCED2
D6D9DDE0E3E7E9EBEDEFF1F3F5F6F5F5F5F6F8FAFCFEFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFBF9F7F4F1EFECE9E5E1DC
D6D0CBC6C1BDBAB7B7B7B8BBBEC3C7CDD3D8DEE3E8ECF0F3
F6F9F9FBFF
FFDCD8EAD7CFD6CDC5C7C3BEBEBDBBBCBDBEC0C3C6C9CDD1
D4D8DBDFE2E5E7E9EBEDEFF2F4F5F4F4F4F5F7F8FAFCFDFF
FFFFFFFFFFFFFFFFFEFDFDFDFDFDFBF8F5F2EFEBE8E5E1DD
D9D4CFC9C5C1BDBBB9B9BABCBFC3C7CCD2D7DDE2E7EBEFF2
F5F9F9FAFF
FFDCD8EAD8CFD6CDC5C6C2BDBDBCBABBBCBDBFC2C5C8CBCF
D3D6D9DDE0E3E5E7E9EBEEF0F2F3F3F3F3F3F5F6F8FAFCFD
FDFEFFFFFFFEFEFFFEFDFCFBFBFCFCFAF7F3EFECE8E5E1DE
DAD6D2CDC9C5C1BFBDBCBDBEC0C4C8CDD2D7DCE1E6EAEEF1
F5F8F8FAFF
FFDCD8EAD8CFD6CDC5C6C2BDBDBCBABABBBCBEC1C3C6CACD
D1D4D7DADEE1E3E5E7E9ECEFF1F2F2F1F1F1F2F4F6F8F9FA
FBFCFDFDFEFDFDFDFEFDFCFAF9FAFBFBFAF6F2EEE9E5E2DE
DBD7D4D0CCC9C5C3C1C0C0C1C3C6C9CDD2D7DCE1E5EAEEF0
F4F8F7F9FF
FFDDD8EAD8CFD6CEC5C6C2BDBCBBB9BABABBBDC0C2C5C8CB
CFD2D5D8DBDEE1E3E5E8EAEDF0F1F1F0EFEFF0F1F3F5F7F8
F9FAFBFCFCFCFBFCFDFEFCFAF8F7F8F9FAF9F5F1ECE7E3DF
DCD9D5D2CFCCC9C7C5C4C4C4C6C8CBCFD3D8DCE1E5EAEDF0
F4F7F7F9FF
FFDDD9EAD9D0D6CEC6C6C3BDBCBBB9B9BABBBCBEC1C3C6C9
CCD0D3D6D9DCDFE1E3E6E8ECEEF0F0EEEDEDEDEFF0F2F4F5
F6F7F8F9FAFBFAFAFAFCFDFBF8F6F5F6F7F9F8F5F0EBE6E2
DEDAD7D4D2CFCDCBC9C8C8C8C9CBCED1D5D9DDE1E5EAEDF0
F4F7F6F8FF
FFDED9EADAD0D6CFC6C6C3BDBCBBB9B9B9BABBBDBFC2C4C7
CACDD0D3D6D9DCDFE1E4E7EAEDEEEEEDEBEBEBECEDEFF0F2
F3F4F5F7F8F9F8F8F8F9FBFBF9F6F4F3F4F5F7F7F4EFEAE5
E1DDD9D7D4D2D0CECDCCCCCCCDCFD1D4D7DBDFE2E6EAEDF0
F4F7F6F8FF
FFDEDAEADAD1D6D0C6C6C3BEBCBBB9B8B9B9BABCBEC0C3C5
C8CBCED1D4D7DADCDFE1E4E8EBECECEBE9E8E8E9EAEBECEE
EFF1F2F3F5F6F6F6F5F6F9FBFAF7F4F2F1F2F4F6F6F4EFEA
E5E0DCD9D7D5D3D2D1D0D0D0D1D2D4D7D9DDE0E4E7EBEEF0
F4F7F6F8FF
FFDFDAEADBD1D7D0C7C7C4BEBDBBB9B8B8B9B9BBBCBEC1C3
C6C8CBCED1D5D8DADDDFE2E6E8EAEAE9E7E6E5E5E6E7E8EA
EBECEEEFF1F3F4F3F3F3F5F8FAF8F5F2F0EFF0F2F4F5F3EF
EAE5E1DDDAD8D6D5D4D3D3D4D4D6D7D9DCDFE2E5E8ECEFF0
F5F7F6F8FF
FFE0DBEADCD2D7D1C8C7C5BFBDBCB9B8B8B8B9BABBBDBFC1
C4C6C9CCCFD2D5D8DADDE0E3E6E8E9E7E6E4E3E2E2E3E4E5
E7E8E9EBEDEFF1F1F0F0F1F4F7F8F7F3F0EEEDEEF0F3F4F3
EFEAE6E1DEDBD9D8D7D7D7D7D8D9DBDCDFE1E4E7EAEDEFF1
F5F8F6F8FF
FFE1DCEBDED3D8D3C9C8C6C0BEBCBAB8B8B8B8B9BABBBDBF
C2C4C7CACDD0D3D6D8DADDE0E3E6E7E6E4E2E0DFDEDEDFE0
E2E3E4E6E8EBEDEEEDEDEDEFF3F6F7F5F1EEECECEDEFF2F3
F2EFEBE6E3DFDDDBDADADADADBDCDEDFE1E4E6E9EBEEF0F2
F6F8F6F8FF
FFE2DDEBDFD4D8D4CAC9C7C1BEBDBAB9B8B8B8B8B9BABCBE
C0C2C5C8CBCED1D3D6D8DADEE1E3E5E4E2E0DDDCDBDADBDB
DCDEDFE1E3E5E8EAEAEAEAEBEEF2F5F6F3EFECEAEAECEEF1
F2F2EFECE8E4E1DFDEDDDDDEDEDFE1E2E4E6E8EAEDF0F1F3
F6F8F7F9FF
FFE3DEEBE0D5D9D5CCCAC8C3BFBEBBB9B8B8B7B8B8B9BBBD
BFC1C3C6C9CCCFD1D3D5D8DBDEE1E2E2E1DEDBD9D7D6D6D6
D7D8D9DBDDE0E3E5E6E6E6E7E9EDF1F4F4F1EEEBE9E9EBED
F0F2F2F0EDE9E6E4E2E1E1E1E2E3E4E5E7E9EBECEFF1F2F4
F7F9F7F9FF
FFE4DFECE1D7DAD6CDCBC9C4C1BFBCBAB9B8B8B7B8B9BABC
BDBFC2C4C7CACDCFD1D3D5D8DBDEE0E0DFDCD9D6D4D2D1D1
D2D2D3D5D7DADDE0E2E2E2E3E4E7ECF0F3F3F0EDEAE9E9EB
EDF0F2F2F1EEEBE9E7E5E5E5E5E6E7E8E9EBEDEEF0F3F4F5
F8F9F8FAFF
FFE5E0ECE3D8DBD8CFCDCBC6C2C0BEBBBAB9B8B8B8B8B9BB
BDBEC1C3C6C8CBCDCFD0D2D5D8DBDEDFDEDBD8D4D1CFCDCD
CDCDCECFD1D3D7DADDDEDFDFE0E3E6EBF0F2F2EFECEAE9E9
EBEDF0F2F3F1EFEDEBE9E8E8E8E9EAEBECEDEFF0F2F4F5F6
F9FAF8FAFF
FFE6E1EDE4DADCDAD1CECCC8C4C2BFBCBBBAB9B8B8B8B9BA
BCBEC0C2C4C7C9CBCDCED0D2D5D9DBDDDCDAD6D2CFCCCAC8
C8C8C8C9CACDD0D4D7D9DBDBDCDEE1E6EBEFF2F1EEECEAE9
EAEBEEF1F3F3F3F1EFEDECECEBECECEDEEF0F1F2F4F5F6F7
F9FAF9FBFF
FFE8E2EDE6DBDDDBD3D0CECAC5C3C1BEBCBBBAB9B9B9B9BA
BCBDBFC1C3C6C8CACBCCCED0D3D6D9DBDBD9D5D1CDC9C7C5
C3C3C3C3C4C6CACDD1D4D6D7D8DADDE1E6EBEFF1F0EEECEA
EAEBECEFF1F3F4F4F3F1F0EFEFEFEFF0F0F2F3F4F5F7F7F8
FAFBFAFBFF
FFE9E4EEE7DDDEDDD5D2D0CCC7C5C3C0BEBCBBBABABABABB
BCBDBFC1C3C5C7C8CACBCCCED1D4D7D9DAD8D5D1CCC8C4C2
C0BFBEBEBFC1C3C7CBCED1D3D5D7D9DCE1E6EBEFF1F0EEEC
EBEBECEEF0F2F4F5F5F4F3F2F2F1F2F2F3F4F4F5F6F8F8F9
FBFBFAFCFF
FFEAE5EFE9DFE0DFD7D4D2CECAC7C5C2C0BEBDBCBBBBBBBC
BDBEBFC1C2C4C6C7C8CACBCCCFD2D5D7D8D7D5D1CCC7C3C0
BDBBBABABABBBEC1C5C9CCCFD1D3D6D9DCE1E6EBEFF1F0EF
EDECECEEEFF1F4F5F6F6F6F5F4F4F4F4F5F5F6F7F8F9F9FA
FCFCFBFCFF
FFECE7EFEBE1E1E1DAD6D4D0CCCAC7C4C2C0BFBEBDBCBCBD
BEBEC0C1C2C4C5C7C8C9CACBCDD0D3D5D7D7D5D1CCC7C3BF
BBB9B7B6B6B7B9BCBFC4C7CBCED0D3D5D9DDE2E7ECEFF1F1
EFEEEEEEEFF1F3F5F6F7F7F7F7F6F6F6F7F7F7F8F9FAFAFB
FCFCFCFDFF
FFEDE8F0ECE3E3E2DCD8D6D3CFCCCAC7C5C3C1C0BFBEBEBE
BFC0C0C1C3C4C5C7C8C8C9CACCCED1D4D6D6D5D2CDC8C3BF
BBB7B5B4B3B3B5B7BBBFC3C7CACDD0D3D6DADEE3E8EDF0F1
F1F0F0EFF0F1F3F5F6F8F8F9F9F8F8F8F8F9F9F9FAFBFBFB
FDFDFCFDFF
FFEEEAF1EEE5E4E4DEDAD9D6D2CFCCCAC7C5C4C2C1C1C1C0
C1C1C2C3C4C5C6C7C8C8C9CACBCDD0D3D5D6D5D3CFCAC4BF
BBB7B4B2B1B1B2B4B7BABFC3C7CACDD0D3D7DBE0E5EAEEF1
F2F2F2F1F1F2F3F5F6F8F9FAFAFAFAFAFAFAFAFAFBFBFBFC
FDFDFDFDFF
FFF0EBF2EFE7E6E6E1DDDBD8D4D2CFCDCAC8C7C5C4C3C3C3
C3C3C4C4C5C6C7C8C8C9CACACBCDCFD2D4D6D6D4D0CCC6C1
BCB8B5B2B0AFB0B1B4B7BBBFC4C8CBCED2D5D9DDE2E7ECEF
F2F3F3F3F3F3F4F5F6F8F9FAFBFBFBFBFBFBFBFBFCFCFCFD
FEFEFDFEFF
FFF1EDF3F1E9E8E8E3DFDEDBD7D5D2D0CECCCAC9C7C6C6C6
C6C6C6C6C7C7C8C9CACACBCBCCCDCFD1D4D6D6D5D3CEC9C4
BFBAB6B3B1AFAFB0B2B5B9BDC1C5C9CDD0D4D7DCE0E5E9EE
F1F3F4F5F5F5F5F6F7F8F9FAFBFBFCFCFCFCFCFCFDFDFDFD
FEFEFDFEFF
FFF2EEF4F2EBEAEAE6E2E0DEDAD8D6D3D1CFCDCCCBCAC9C9
C8C8C8C9C9CACACBCBCCCCCCCDCED0D2D4D6D7D7D5D1CDC7
C2BDB9B5B3B1B0B0B2B4B7BBBFC4C8CCCFD3D7DADFE3E7EC
F0F3F5F6F6F6F6F7F7F8F9FAFBFCFCFDFDFDFDFDFDFDFDFE
FEFEFEFEFF
FFF4F0F4F3EDEBECE8E4E3E1DDDBD9D7D4D3D1D0CECDCDCC
CCCBCBCBCCCCCCCDCDCECECECFCFD0D2D4D6D8D8D7D4D0CB
C6C1BDB9B5B3B2B2B2B4B7BABEC3C7CBCFD2D6DADEE2E6EA
EEF2F4F6F7F7F8F8F8F9FAFBFBFCFDFDFDFDFDFDFEFEFEFE
FEFEFEFFFF
FFF5F1F5F5EFEDEDEAE7E5E3E0DEDCDAD8D6D5D3D2D1D0D0
CFCFCFCFCFCFCFD0D0D0D0D0D1D1D2D3D5D7D9DAD9D8D4D0
CBC6C1BDB9B7B5B4B4B6B8BBBFC3C7CBCFD3D6DADEE1E5E9
EDF1F3F6F7F8F9F9F9FAFAFBFCFCFDFDFEFEFEFEFEFEFEFE
FFFFFEFFFF
FFF6F3F6F6F1EFEFEDE9E8E6E3E1DFDDDCDAD8D7D6D5D4D3
D3D2D2D2D2D2D2D2D3D3D3D3D3D3D4D5D7D8DADBDCDBD8D4
D0CBC6C2BEBBB9B8B8B8BABCC0C3C7CBCFD3D7DADEE2E5E9
ECF0F3F5F7F9F9FAFAFBFBFBFCFCFDFDFEFEFEFEFEFFFEFF
FFFFFFFFFF
FFF7F4F7F7F2F1F1EFECEAE9E6E4E2E1DFDDDCDBDAD9D8D7
D7D6D6D5D5D5D5D6D6D6D6D6D6D6D6D7D8DADCDDDEDEDCD9
D5D1CCC8C4C1BEBCBCBCBDBFC2C5C9CCD0D4D8DBDFE2E6E9
ECEFF2F5F7F9FAFAFBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFF8F5F8F8F4F2F2F1EEECEBE9E7E6E4E2E1E0DEDDDCDCDB
DADAD9D9D9D9D9D9D9D9D9D9D9D9D9DADBDCDEDFE0E1E0DD
DAD6D2CECAC6C4C2C1C0C1C2C5C7CBCED2D5D9DCE0E3E6E9
EDEFF2F5F7F9FAFBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFF9F7F9F9F5F4F4F2F0EFEDECEAE9E7E6E4E3E2E1E0DFDF
DEDEDDDDDDDCDCDCDDDDDDDDDDDCDCDDDDDEE0E1E2E3E3E2
DFDCD8D4D0CDCAC8C6C5C6C7C8CBCED1D4D7DBDEE1E4E7EA
EDF0F2F5F7F9FAFBFCFCFDFDFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFAF8F9FAF7F5F5F4F2F1F0EEEDEBEAE9E8E7E6E5E4E3E2
E2E1E1E1E0E0E0E0E0E0E0E0E0E0E0E0E0E1E2E3E5E6E6E5
E4E1DEDAD6D3D0CECCCBCBCBCDCED1D4D6DADDE0E3E6E8EB
EEF0F3F5F7F9FAFBFCFDFDFDFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFBF9FAFBF8F7F7F6F4F3F2F1EFEEEDECEBEAE9E8E7E7E6
E5E5E5E4E4E4E4E4E4E4E4E4E3E3E3E3E3E4E5E6E7E8E9E9
E8E6E3E0DDD9D6D4D2D1D0D1D1D3D5D7D9DCDFE2E5E7EAEC
EFF1F3F5F7F9FAFBFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFBFAFBFBF9F8F8F7F6F4F4F3F2F0F0EFEEEDECEBEAEAE9
E9E8E8E8E7E7E7E7E7E7E7E7E7E7E6E6E6E7E7E8E9EAEBEC
EBEAE8E5E2DFDDDAD8D7D6D6D6D7D9DBDDDFE2E4E7E9ECEE
F0F2F4F6F8F9FAFBFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFCFBFCFCFAF9F9F8F7F6F6F5F4F3F2F1F0F0EFEEEEEDEC
ECECEBEBEBEAEAEAEAEAEAEAEAEAEAE9E9EAEAEBECEDEEEE
EEEDECEAE7E5E2E0DEDDDCDBDBDCDDDFE0E2E5E7E9EBEDEF
F1F3F5F6F8F9FAFBFCFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFBFCFDFBFAFAFAF8F8F7F6F6F5F4F3F3F2F1F1F0F0EF
EFEFEEEEEEEEEDEDEDEDEDEDEDEDEDEDEDEDEDEDEEEFF0F1
F1F1F0EEECEAE8E6E4E2E1E0E0E1E1E2E4E5E7E9EBEDEFF1
F2F4F6F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFDFDFCFBFBFBFAF9F8F8F7F6F6F5F5F4F4F3F3F2F2
F1F1F1F1F0F0F0F0F0F0F0F0F0F0EFEFEFEFEFF0F0F1F2F2
F3F3F3F2F0EEECEAE9E7E6E5E5E5E5E6E7E9EAECEDEFF1F3
F4F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFDFEFDFCFCFCFBFAFAF9F9F8F8F7F7F6F6F5F5F5F4
F4F4F3F3F3F3F3F2F2F2F2F2F2F2F2F2F2F2F2F2F2F3F3F4
F5F5F5F4F3F2F0EEEDECEBEAEAEAEAEBEBECEEEFF0F2F3F4
F6F7F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFEFEFDFCFCFCFCFBFBFAFAFAF9F9F8F8F8F7F7F7F7
F6F6F6F6F6F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F6F6
F7F8F8F7F7F5F4F3F1F0EFEEEEEDEDEEEEEFF0F1F2F3F4F5
F6F7F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFEFDFDFDFCFCFBFBFBFAFAFAF9F9F9F8F8F8F8
F7F7F7F7F7F7F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F7
F8F8F9F9F8F8F7F5F4F3F2F1F0F0F0F0F0F1F1F2F3F4F5F6
F7F8F9FAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFFFEFEFEFDFDFDFDFCFCFCFBFBFBFBFAFAFAFAF9
F9F9F9F9F8F8F8F8F8F8F8F8F8F8F8F8F8F8F7F7F7F8F8F8
F9F9F9FAF9F9F8F8F7F6F5F5F4F4F4F4F4F5F5F6F7F8F8F9
FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFFFFFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFCFCFCFC
FCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFB
FCFCFCFCFCFCFBFBFAF9F9F8F8F7F7F7F7F7F8F8F9F9FAFA
FBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFFFEFEFEFEFEFDFDFDFDFDFCFCFCFCFCFBFBFBFB
FBFBFBFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFA
FAFBFBFCFCFCFCFBFAF9F9F8F7F6F6F6F6F6F6F6F7F7F8F9
F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFCFCFC
FCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFAFAFAFAFAFAFA
FBFBFBFCFCFCFCFCFBFBFAF9F9F9F8F8F8F8F8F9F9F9FAFA
FBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
newpath
.49524  .49524  .07616  0 365.73 arc
s
% End of Graphics
MathPictureEnd
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Experiment 2: Double slit
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Initial condition
:[font = input; preserveAspect; endGroup; ]
k = {64.0, 64.0}; a = 0.08^2; x0 = {0.25, 0.25};
psi0=Table[Block[{x={x1,x2}-x0}, Exp[I*k.x-x.x/(2*a)]],
           {x1,0,1,dx[[1]]},{x2,0,1,dx[[2]]}];
psi0=psi0/Sqrt[Plus@@(Plus@@(psi0*Conjugate[psi0]))*dx[[1]]*dx[[2]]];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Potential function
:[font = input; preserveAspect; ]
u0=4*k.k; dl = 0.025; dw=0.08; dh=0.15;
potential = Function[{x,t},
   If[ x[[1]]+x[[2]]> 1+dl ||
       x[[1]]+x[[2]]< 1-dl ||
       (x[[1]]-x[[2]]< dh && x[[1]]-x[[2]]> dw) ||
       (x[[1]]-x[[2]]<-dw && x[[1]]-x[[2]]>-dh),
      0, u0] ];
:[font = input; preserveAspect; endGroup; ]
px1= 0.00;         py1= 1-dl;
px2=(1-dl+ -dh)/2; py2=(1-dl- -dh)/2;
px3=(1+dl+ -dh)/2; py3=(1+dl- -dh)/2;
px4= 0+dl;         py4= 1.00;
qx1= 1-dl;         qy1= 0.00;
qx2=(1-dl+dh)/2;   qy2=(1-dl-dh)/2;
qx3=(1+dl+dh)/2;   qy3=(1+dl-dh)/2;
qx4= 1.00;         qy4= 0+dl;
rx1=(1-dl+ -dw)/2; ry1=(1-dl- -dw)/2;
rx2=(1+dl+ -dw)/2; ry2=(1+dl- -dw)/2;
rx3=(1+dl+dw)/2;   ry3=(1+dl-dw)/2;
rx4=(1-dl+dw)/2;   ry4=(1-dl-dw)/2;
drawpot={Line[{{px1,py1}/dx,{px2,py2}/dx,
               {px3,py3}/dx,{px4,py4}/dx}],
         Line[{{qx1,qy1}/dx,{qx2,qy2}/dx,
               {qx3,qy3}/dx,{qx4,qy4}/dx}],
         Line[{{rx1,ry1}/dx,{rx2,ry2}/dx,
               {rx3,ry3}/dx,{rx4,ry4}/dx,
               {rx1,ry1}/dx}]};
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; infiniteLoop; loopDistance = 19; ]
Animation
:[font = input; preserveAspect; ]
schroed2d[0, $PSI->psi0,$T->0,$VFUNC->potential];
:[font = input; preserveAspect; startGroup; ]
plotit[];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  0.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  0.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F8F8
F7F7F7F8F8F8F9F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F5
F4F4F4F5F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFBFAF8F7F6F5F4F3F2F1F1
F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F5F3F2F0EFEDECEC
EBEBEBECECEDEFF0F2F3F5F6F8F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E6E5
E5E5E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2F0EDEAE8E5E3E1DFDE
DDDDDDDEDFE1E3E5E8EAEDF0F2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F6F8F9FBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F1EDEAE6E2DED9D5D2CECCC9
C8C8C8C9CCCED2D5D9DEE2E6EAEDF1F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DBD6D1CCC7C3BFBD
BBBBBBBDBFC3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBF9F7F4F1EDE9E4DFD9D3CDC6C0BBB6B1AE
ACACACAEB1B6BBC0C6CDD3D9DFE4E9EDF1F4F7F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFBFAF8F5F2EEEAE5DFD9D2CAC3BBB4ADA7A29E
9C9B9C9EA2A7ADB4BBC3CAD2D9DFE5EAEEF2F5F8FAFBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFAF8F6F3F0EBE6E0D9D2C9C1B8AFA69E97918D
8A898A8D91979EA6AFB8C1C9D2D9E0E6EBF0F3F6F8FAFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F87807B
7877787B80878F98A2ACB7C1CAD3DBE2E8EDF1F5F7F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F6F3EFEAE5DED6CDC3B8ACA195897F756E68
646364686E757F8995A1ACB8C3CDD6DEE5EAEFF3F6F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFBFAF8F5F2EDE8E1D9D1C6BBAFA295887B6F645C55
515051555C646F7B8895A2AFBBC6D1D9E1E8EDF2F5F8FAFB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F7F4F0EBE5DED5CCC0B4A698897B6D5F544A43
3E3D3E434A545F6D7B8998A6B4C0CCD5DEE5EBF0F4F7F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F6F3EFE9E3DBD2C7BBAD9E8F7F6F5F51443A32
2D2B2D323A44515F6F7F8F9EADBBC7D2DBE3E9EFF3F6F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F2EDE8E1D8CEC3B6A7978775645444372B23
1E1C1E232B37445464758797A7B6C3CED8E1E8EDF2F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F1ECE6DFD6CCBFB1A291806E5C4A3A2B1F16
110F11161F2B3A4A5C6E8091A2B1BFCCD6DFE6ECF1F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF8F5F1ECE5DED4C9BDAE9E8D7B6855433223160D
0706070D1623324355687B8D9EAEBDC9D4DEE5ECF1F5F8FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9C8A7864513E2D1E1107
02000207111E2D3E5164788A9CACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9B897763503D2B1C0F06
000000060F1C2B3D506377899BACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF7F4F0EBE5DDD3C8BBAC9C8A7864513E2D1E1107
02000207111E2D3E5164788A9CACBBC8D3DDE5EBF0F4F7FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFBFAF8F5F1ECE5DED4C9BDAE9E8D7B6855433223160D
0706070D1623324355687B8D9EAEBDC9D4DEE5ECF1F5F8FA
FBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F1ECE6DFD6CCBFB1A291806E5C4A3A2B1F16
110F11161F2B3A4A5C6E8091A2B1BFCCD6DFE6ECF1F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFAF8F5F2EDE8E1D8CEC3B6A7978775645444372B23
1E1C1E232B37445464758797A7B6C3CED8E1E8EDF2F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F6F3EFE9E3DBD2C7BBAD9E8F7F6F5F51443A32
2D2B2D323A44515F6F7F8F9EADBBC7D2DBE3E9EFF3F6F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFDFCFBF9F7F4F0EBE5DED5CCC0B4A698897B6D5F544A43
3E3D3E434A545F6D7B8998A6B4C0CCD5DEE5EBF0F4F7F9FB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFBFAF8F5F2EDE8E1D9D1C6BBAFA295887B6F645C55
515051555C646F7B8895A2AFBBC6D1D9E1E8EDF2F5F8FAFB
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F6F3EFEAE5DED6CDC3B8ACA195897F756E68
646364686E757F8995A1ACB8C3CDD6DEE5EAEFF3F6F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FEFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F87807B
7877787B80878F98A2ACB7C1CAD3DBE2E8EDF1F5F7F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFAF8F6F3F0EBE6E0D9D2C9C1B8AFA69E97918D
8A898A8D91979EA6AFB8C1C9D2D9E0E6EBF0F3F6F8FAFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFDFCFBFAF8F5F2EEEAE5DFD9D2CAC3BBB4ADA7A29E
9C9B9C9EA2A7ADB4BBC3CAD2D9DFE5EAEEF2F5F8FAFBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBF9F7F4F1EDE9E4DFD9D3CDC6C0BBB6B1AE
ACACACAEB1B6BBC0C6CDD3D9DFE4E9EDF1F4F7F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFDFCFBFAF8F6F4F1EDE9E5E0DBD6D1CCC7C3BFBD
BBBBBBBDBFC3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F1EDEAE6E2DED9D5D2CECCC9
C8C8C8C9CCCED2D5D9DEE2E6EAEDF1F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F6F8F9FBFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2F0EDEAE8E5E3E1DFDE
DDDDDDDEDFE1E3E5E8EAEDF0F2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E6E5
E5E5E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F5F3F2F0EFEDECEC
EBEBEBECECEDEFF0F2F3F5F6F8F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFBFAF8F7F6F5F4F3F2F1F1
F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F5
F4F4F4F5F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F8F8
F7F7F7F8F8F8F9F9FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = input; Cclosed; preserveAspect; startGroup; ]
Do[Do[schroed2d[dt],{5}]; plotit[], {15}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  5.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  5.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFCFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3
F2F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECEBEBEBEBEBECEDEEF0F1F3F5F6F7F9FAFBFCFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9
E7E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2
E0DEDDDCDCDCDDDFE0E3E5E8EAEDEFF2F4F6F8F9FBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F3F1EEEBE7E4E1DDDA
D8D5D4D3D2D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E5E1DDD9D5D1
CDCBC9C7C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E4DFDAD5D0CAC6
C2BEBCBABABABCBFC2C6CBD0D5DBE0E5E9EDF0F4F6F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F7F4F1EDE9E4DED8D2CCC5BFB9
B4B0ADABABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F2EEE9E4DED8D1C9C1BAB2AC
A6A19D9B9A9B9EA1A6ADB3BBC2CAD1D8DFE5EAEEF2F5F7F9
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DFD8D1C8BFB6ADA59D
96908C8988898C91979EA6AFB8C1C9D1D9E0E6EBEFF3F6F8
FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F4F1EDE7E1DAD2C9BFB5ABA0968D
857E797675777A7F868E98A2ACB7C1CAD3DBE2E8EDF1F4F7
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFAF8F6F3EFEAE4DDD5CCC1B6AB9F93887D
746C66636263676D757E8995A0ACB8C3CDD6DEE4EAEFF3F6
F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE7E1D9D0C5BAADA09386796D
625A53504E50545B646F7B8795A2AFBBC6D0D9E1E8EDF1F5
F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE5DDD5CABFB2A59688796B5D
5248413D3C3D424A535F6D7B8998A6B4C0CBD5DEE5EBF0F4
F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFBF9F6F3EEE9E2DAD1C6B9AC9D8D7D6D5D4F
4338302C2A2C313A4451606F7F8F9FADBBC7D2DBE3E9EEF3
F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D8CDC2B4A6968574625243
352A221D1B1D232B37455465768798A7B6C3CED8E1E8EDF2
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DED5CBBEB0A1907E6C5A4838
2A1E15100F1117202C3A4B5C6E8092A2B2BFCCD6DFE6ECF1
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE5DDD4C9BCAD9D8C7966534130
22150C0705080E1724334456697C8E9FAFBDCAD4DEE5ECF1
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD3C7BAAB9B897663503D2C
1D100701000208121F2E405265798B9DADBCC8D4DDE5EBF0
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD2C7BAAB9A8875624E3C2A
1B0F0500000007101D2D3E5164788A9CACBBC8D3DDE5EBF0
F4F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD3C8BAAC9B897763503D2C
1D110802000309121F2F405366798B9DADBCC9D4DDE5EBF0
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF7F4F0EBE5DDD4C9BCAE9E8C7A67544231
23170E0807090F1825344557697C8E9FAFBDCAD5DEE5ECF1
F4F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DFD6CBBFB1A1917F6D5B4A3A
2B201712101218212D3C4C5D6F8193A3B2C0CCD6DFE6ECF1
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D8CEC2B5A6978675645344
372C241F1D1F252D39465666778899A8B6C3CFD9E1E8EDF2
F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFDFCFBF9F6F3EEE9E3DBD1C6BAAD9E8E7E6F5F51
453A332E2D2F343C465361718090A0AEBBC7D2DBE3E9EFF3
F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE5DED5CBC0B3A698897B6D60
544B44403E40454C56616E7C8B9AA8B5C1CCD6DEE5EBF0F4
F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE8E1D9D0C6BBAFA295877B6F
655C56525153575D66717C8996A3B0BCC7D1DAE1E8EDF2F5
F8FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFAF9F6F3EFEAE4DDD5CCC2B8ACA095897F
766E69656466696F77808B96A2AEB9C4CDD6DEE5EBEFF3F6
F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F5F1EDE8E2DBD3CAC1B7ACA2988F
87807C7978797C8188909AA3AEB8C2CBD4DBE2E8EDF1F5F7
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C1B8AFA69F
98928E8B8A8B8E9399A0A8B0B9C2CAD2DAE0E6EBF0F3F6F8
FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F2EEEAE5DFD8D1CAC3BBB4AD
A7A29F9D9C9D9FA3A8AEB5BCC4CBD2D9DFE5EAEEF2F5F8FA
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CDC6C0BB
B6B2AFADACADAFB2B6BBC1C7CDD4DADFE5E9EEF1F4F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F0EDE9E5E0DBD6D0CBC7
C3BFBDBCBBBCBDC0C3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DED9D5D2
CECCCAC8C8C9CACCCFD2D6DADEE2E6EAEEF1F4F6F8FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E4E1DEDB
D8D6D4D4D3D4D5D6D9DBDEE1E5E8EBEEF1F4F6F8FAFBFCFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE8E5E3
E1DFDEDDDDDDDEDFE1E3E5E8EBEDF0F2F4F6F8FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9
E8E6E5E5E5E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECECEBEBEBECECEDEFF0F2F3F5F6F8F9FAFBFCFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3
F2F1F1F0F0F0F1F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFDFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 10.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 10.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFD
FDFCFCFCFCFCFBFBFBFCFCFCFCFCFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAFAF9F9F9FAFAFAFBFBFBFCFCFDFDFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
F9F9F8F8F7F7F7F7F7F7F7F8F8F9FAFAFBFCFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F7F6F6F5F4F4F4F4F4F4F4F5F6F7F7F8F9FAFBFCFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F6
F4F3F2F1F0F0F0EFF0F0F1F1F2F3F5F6F7F8F9FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAF8F7F5F4F2
F1EFEEECEBEBEAEAEAEBECEDEEEFF1F3F4F6F7F9FAFBFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF9F8F6F4F2F0EE
ECEAE8E6E5E4E4E3E4E4E5E7E9EBEDEFF1F3F5F6F8F9FBFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFAF9F7F5F3F1EEECE9
E6E4E1DFDDDCDBDBDCDDDEE0E2E4E7EAECEFF1F4F6F8F9FB
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0EDEAE6E3
DFDCD9D6D4D3D2D1D2D3D5D7DADDE0E4E7EBEEF1F3F6F8F9
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F3F0ECE8E4E0DC
D7D3CFCCC9C7C6C6C6C8CACDD0D4D9DDE1E5E9EDF0F3F5F8
F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F3F0ECE8E3DED9D3
CEC9C4C0BDBAB9B9B9BBBEC1C6CAD0D5DADFE4E9EDF0F3F6
F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFDFCFAF8F6F3F0ECE8E3DDD7D1CA
C4BDB8B3AFACAAA9AAACB0B4B9BFC5CCD2D8DEE4E9EDF1F4
F6F8FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F4F1EDE8E3DDD6CFC8C0
B8B1AAA49F9B99999A9CA0A5ACB3BAC2C9D1D8DEE4E9EEF1
F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7CFC7BEB5
ACA39B948E8A8787888B90969DA5AEB7C0C9D1D8DFE5EBEF
F3F6F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F0ECE6E0D9D1C8BEB3A9
9E948B837C78757475797E858E97A1ACB6C0CAD2DAE1E7EC
F1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F6F2EEE9E3DCD3CAC0B5A99D
91867B726A65616162666C747E8994A0ACB7C2CCD5DDE4EA
EFF3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBF9F7F4F1ECE6DFD7CEC4B8AC9E91
84776B6158524E4D4F545A636E7A8794A2AFBBC6D0D9E1E7
EDF1F5F7FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F6F3EFEAE4DCD3C9BDB1A39486
77695C5047403C3B3D4249535F6C7B8998A6B4C0CBD5DDE5
EBF0F3F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F6F2EEE8E1D9CFC4B8AA9B8B7B
6B5C4D4137302B2A2C313A4451606F7F8F9EADBAC7D1DAE2
E9EEF2F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1ECE6DFD6CCC0B3A4948372
6150413429211C1B1D232C37455565768798A7B6C3CED8E0
E7EDF1F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DDD4C9BDAF9F8E7C6A
584737291E15100F1117212D3B4C5D6F8192A3B2BFCBD6DF
E6ECF1F5F7FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DCD3C7BAAC9B8A7865
52403021150D0706090F18253445576A7C8E9FAFBDC9D4DD
E5EBF0F4F7F9FBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4F0EAE4DBD2C6B9AA99877561
4E3C2B1C10070201030A132030415366798C9DADBCC8D3DD
E4EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4EFEAE3DBD1C6B9A999877461
4D3B2A1B0F0601000208121F2F405266798B9DADBBC8D3DC
E4EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4F0EAE4DCD2C6B9AA9A887562
4F3D2C1D11090302040B1521314254677A8C9EADBCC9D4DD
E5EBF0F4F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DDD3C8BBAC9C8B7966
54423123170F0A080B111A273647586B7D8FA0B0BECAD5DE
E5EBF0F4F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF7F4F1ECE5DED5CABEB0A0907E6C
5A493A2C21181312151A24303E4E5F718394A4B3C0CCD6DF
E6ECF1F5F8FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1EDE7E0D7CDC1B4A5968574
635344372D25201F2127303B48586879899AA9B7C4CFD9E1
E8EDF2F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF8F6F2EEE9E2DAD0C6B9AC9D8E7E
6E5F51453B34302F31363E485563728291A1AFBCC8D2DBE3
E9EFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F7F3EFEBE4DDD4CABFB3A59789
7A6C60554C45414042474E5863707E8C9BA8B5C2CCD6DEE5
EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBFAF7F5F1EDE7E0D9D0C5BAAEA194
877B6F655D57535254585F68727E8B97A4B1BDC8D1DAE1E8
EDF1F5F8FAFBFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F6F3EFEAE4DDD5CCC2B7ACA0
94897F766F6A6666676B7179828C97A3AEBAC4CED6DEE5EA
EFF3F6F9FAFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F1ECE7E1DAD2C9C0B6AC
A2988F87817C79797A7D8389919BA4AEB8C2CBD4DCE2E8ED
F1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DFD8D1C9C0B7
AFA69E98928E8C8B8C8F949AA1A8B1BAC2CBD3DAE0E6EBF0
F3F6F8FAFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F5F1EEE9E4DED8D1CAC2
BBB4ADA7A39F9D9D9EA0A4A9AFB5BDC4CBD3D9E0E5EAEEF2
F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F4F1EDE9E4DED8D2CC
C6C0BAB6B2AFADADADB0B3B7BCC2C8CED4DAE0E5E9EEF1F4
F7F9FAFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E4DFDAD5
D0CBC7C3BFBDBCBBBCBEC0C4C8CCD1D6DCE0E5E9EDF1F4F6
F8FAFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F6F3F0EDE9E5E1DD
D9D5D1CECBC9C8C8C9CACCCFD2D6DADEE2E6EAEEF1F3F6F8
FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F5F3F1EEEBE7E4
E1DDDAD8D6D4D3D3D4D5D6D9DBDEE1E5E8EBEEF1F4F6F8FA
FBFCFCFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F1EFECEA
E7E5E2E0DFDDDDDCDDDEDFE1E3E5E8EAEDF0F2F4F6F8FAFB
FCFCFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F5F3F1EF
EDEBE9E7E6E5E4E4E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFC
FCFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F6F4F3
F1F0EEEDECEBEBEBEBEBECEDEFF0F1F3F5F6F7F9FAFBFCFC
FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6
F5F3F2F1F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFCFCFCFD
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F7F7F6F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFCFDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
FAF9F8F8F7F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAF9F9F9F9FAFAFAFAFBFBFCFCFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFD
FCFCFCFCFBFBFBFBFBFBFBFCFCFCFDFDFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FDFDFDFDFDFDFCFCFCFDFDFDFDFDFDFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFDFDFDFDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFEFFFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 15.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 15.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFCFCFCFCFBFBFBFBFCFCFCFCFCFDFDFDFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFCFBFBFAFAFAF9F9F9F9F9FAFAFAFBFBFCFCFDFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAFAF9F8F8F7F7F7F6F6F7F7F7F8F8F9F9FAFBFBFCFDFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFA
F9F9F8F7F6F5F4F4F3F3F3F3F3F4F5F5F6F7F8F9FAFBFBFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9
F7F6F5F4F2F1F0F0EFEFEFEFEFF0F1F2F3F4F5F7F8F9FAFB
FCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F6
F5F3F1F0EEEDEBEAEAE9E9E9EAEBECEDEFF0F2F4F5F7F8F9
FBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F3
F1EFEDEBE9E7E5E4E3E2E2E3E3E4E6E8EAECEEF0F2F4F6F8
F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F5F3F0
EDEBE8E5E2E0DEDCDBDADADADBDDDFE1E3E6E9ECEEF1F3F5
F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4F2EFEC
E9E5E2DEDBD8D5D3D1D0D0D1D2D4D6D9DCDFE3E6EAEDF0F3
F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF9F7F4F2EFEBE7
E3DFDAD6D2CECAC8C6C5C4C5C6C9CCCFD3D8DCE0E4E8ECF0
F2F5F7F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEBE6E2
DDD7D2CCC7C2BEBBB9B7B7B8B9BCC0C4C9CED4D9DEE3E8EC
EFF3F5F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F5F3EFEBE6E1DB
D5CFC8C2BBB6B1ADAAA8A8A9ABAEB3B8BEC4CBD1D7DDE3E8
ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F3F0ECE7E2DBD5
CDC6BEB6AFA8A29D9A9897989B9FA4AAB1B9C1C8D0D7DDE3
E9EDF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFCFBF9F7F5F1EDE9E3DDD5CD
C5BCB2A9A199928C888685878A8E959CA4ADB6BFC8D0D8DE
E5EAEEF2F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F6F3EFEBE5DFD7CFC6
BCB1A79C9289817B76737374787D848D96A0ABB5BFC9D1D9
E0E7ECF0F4F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE8E2DAD2C8BE
B2A79B8F8379706963605F61656C747D88939FABB6C1CBD4
DCE3E9EEF2F5F8FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFBF9F7F4F0EBE5DED6CCC2B6
A99C8F8175695F57514D4D4F535A636E7A8794A1AEBAC5CF
D8E0E6ECF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF8F6F2EEE9E2DBD2C7BBAF
A1928375675A4F463F3B3B3D4249535F6C7B8998A6B3BFCA
D4DDE4EAEFF3F6F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE7E0D8CEC2B6A8
998979695A4C40362F2B2A2C323A4552606F7F8F9EADBAC6
D0DAE2E8EEF2F5F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DED5CABEB1A2
9281705F4F403329211D1C1E242D38465566768798A7B5C2
CDD7E0E7ECF1F5F7FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EAE4DCD3C8BBAD9D
8C7B69574636291E1611101319222E3C4D5E6F8192A2B1BF
CBD5DEE5EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFEAE3DBD1C6B9AA9A
887663513F2F21160D09080A111A273646586A7D8E9FAFBD
C9D4DDE4EBF0F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFE9E2DAD0C5B7A898
8673604D3B2B1D11090403050C1622324355677A8C9DADBB
C8D3DCE4EAEFF3F7F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFE9E2DAD0C4B7A897
85735F4D3B2A1C10080302040B1522314254677A8C9DADBB
C8D3DCE4EAEFF3F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFE9E3DAD1C5B8A998
8774614F3D2C1E130A0504070E1724334456687B8D9EAEBC
C8D3DCE4EAEFF4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCF9F7F3EFEAE3DBD2C6B9AB9B
8A78655342322419110C0B0E141D2A38495A6C7E90A0B0BD
CAD4DDE5EBF0F4F7F9FBFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DDD4C9BCAE9F
8E7D6C5A493A2D221A1615171D2632405061728494A4B3C0
CCD6DFE6ECF1F4F7FAFCFCFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1ECE6DFD6CCC0B3A4
958474635345382E272222242A323D4B5A6A7A8A9AA9B7C4
CFD8E0E7EDF1F5F8FAFBFCFDFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EDE8E1D9CFC4B8AA
9C8D7D6E5F52463C3632313338404B5765748392A1AFBCC8
D2DBE3E9EEF2F6F9FAFBFCFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEAE3DCD3C9BEB1
A496887A6C60554D4643424449505A65727F8D9BA9B6C2CC
D6DEE5EBEFF3F7F9FAFBFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFBF9F7F4F0ECE6DFD8CEC4B9
ADA093877B6F665E585554565A616A747F8C98A5B1BDC7D1
DAE1E7ECF1F5F8F9FAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEE9E3DCD4CBC1
B6AB9F94897F766F6A6767686C727A838D98A4AFBAC4CED7
DEE4EAEFF3F6F9FAFBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0ECE6E0D9D1C8
BFB5ABA1988F87817D7A7A7B7E848A929BA5AFB9C2CBD4DC
E1E7EDF1F5F7F9FAFCFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7D0
C8BFB6AEA69E98928E8C8C8D90949AA1A9B1BAC2CBD3DADF
E5ECF1F3F5F7F9FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EDE8E3DDD7
D0C9C1BAB3ADA7A29F9D9D9EA0A4A9AFB6BDC4CBD3D9DEE4
EBF0F1F2F6F9FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF8F6F3F0ECE8E3DD
D8D1CBC5BFBAB5B1AFADADAEB0B3B7BCC2C7CED4DADEE3EA
EFF0F0F4FCFEFDFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3F0ECE8E3
DED9D4CFCAC6C2BFBDBBBBBCBDC0C4C8CCD1D7DCDFE4EAEF
F0EFF3FBFEFFFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F7F5F2EFECE9
E5E0DCD8D4D0CDCBC9C8C8C8CACCCFD2D6DADEE1E5EBF0F0
EFF3FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0ED
EAE7E3E0DDDAD7D5D4D3D3D3D4D6D8DBDEE1E4E7ECF0F0EF
F3FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1
EEECE9E6E4E2E0DEDDDCDCDCDDDFE0E3E5E7EAEDF1F1F0F3
FBFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F8F6F4
F2F0EEECEAE8E7E5E4E4E4E4E5E6E7E9EBECEFF2F3F2F4FB
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFBF9F8F7
F5F4F2F0EFEEECEBEBEAEAEAEBECEDEEEFF1F3F5F4F5FCFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9
F8F6F5F4F3F2F1F0F0EFEFEFF0F1F1F2F3F5F6F7F7F8FDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFB
FAF9F8F7F6F5F5F4F4F3F3F4F4F4F5F6F7F8F9F9F9FAFDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFBFAF9F9F8F7F7F7F7F7F7F7F7F8F9F9F9FAFAFAFBFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFBFAFAFAF9F9F9F9F9F9FAFAFAFAFBFCFCFCFCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFDFCFCFCFBFBFBFBFBFBFBFCFBFAFBFEFFFEFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFDFDFDFCFCFCFCFCFDFCFCFCFEFFFFFFFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFDFDFDFDFDFEFDFDFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 20.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 20.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFDFDFDFDFCFCFCFCFCFCFCFDFDFDFDFDFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFCFCFCFDFDFD
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFCFCFBFBFAFAF9F9F9F9F9F9F9F9FAFAFBFBFBFCFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFBFAF9F9F8F7F7F6F6F6F6F6F6F7F7F8F8F9FAFAFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FCFBFAF9F8F7F6F5F4F3F3F2F2F2F2F3F3F4F5F5F6F7F8F9
FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
FAF9F8F7F5F4F3F1F0EFEEEEEEEDEEEEEFF0F1F2F3F5F6F7
F8FAFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFA
F8F7F5F4F2F0EFEDEBEAE9E8E8E8E8E9EAEBECEEEFF1F3F5
F6F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8
F6F4F2F0EEECEAE7E5E4E2E1E1E1E1E2E3E5E6E9EBEDEFF1
F3F5F7F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6
F4F1EFECE9E6E3E1DEDCDAD9D8D8D9DADBDDE0E2E5E8EBED
F0F2F5F7F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F6F3
F1EEEBE7E3E0DCD9D6D3D1CFCECECFD0D2D4D7DBDEE2E5E9
ECEFF2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F1
EDEAE6E1DDD8D4CFCCC8C6C4C3C2C3C5C7CACED2D6DBDFE3
E7EBEFF2F4F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F4F1ED
E9E5E0DBD5D0CAC5C0BCB9B6B5B5B6B8BBBEC3C8CDD2D8DD
E2E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EEEA
E5DFD9D3CDC6BFB9B3AEAAA8A6A6A7A9ADB1B6BCC3C9D0D6
DCE2E7EBEFF2F5F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F2EFEBE6
E0D9D2CBC3BBB3ACA5A09B97969596999DA3A9B0B8BFC7CF
D6DCE2E8ECF0F3F6F8FAFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0ECE7E1
DBD3CBC2B9B0A79E96908A86848485888D939BA3ACB5BEC6
CFD6DDE4E9EEF1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEE9E3DD
D5CDC3B9AFA49A90877F7974727173777C838C959FAAB4BE
C7D0D8DFE6EBEFF3F6F8FAFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBF9F7F4F0ECE6E0D8
D0C6BBB0A4988C81776E67625F5F60656B737C87939EAAB5
C0CAD3DBE2E8EDF1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEAE3DCD4
CABFB3A79A8C7F73675E56504D4C4E535A636D798693A0AD
B9C4CED7DFE5EBF0F3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE7E1D9CF
C5B9AC9E90817365594E453F3B3B3D424A545F6C7A8997A5
B2BEC9D3DCE3E9EEF2F5F8FAFBFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF7F4F0EBE5DED6CC
C0B3A596877767594B3F362F2B2B2D333B4652606F7F8E9E
ACB9C5CFD9E1E7ECF1F5F8F9FBFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBF9F7F3EFEAE4DCD3C8
BCAEA0907F6E5E4E3F3329221E1D20252E3A475666778797
A6B4C1CDD6DEE5ECF1F4F7F9FBFDFDFDFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EEE9E2DAD1C6
B9AA9B8A7967564536291E171312151B24303E4E5F708192
A2B1BECAD4DDE5EBF0F3F6F9FCFCFCFDFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D9CFC4
B6A897867462503F2F22170F0B0A0D131D293848596B7D8E
9FAEBCC8D2DCE4EAEEF2F7FAFAFBFCFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D8CEC3
B5A69684725F4D3B2B1E130B0605080F1925344556697B8C
9DADBBC7D2DCE3E8EEF4F8F8F9FBFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EDE8E1D8CEC2
B5A69584715F4C3B2B1D120A0505080E1824334456687A8C
9DADBAC7D2DBE2E8F0F5F6F6F9FEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F2EEE8E1D9CFC3
B6A7968573604E3D2D20150D08080B111A273646576A7C8E
9EADBBC8D3DBE2EBF1F2F2F6FDFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EEE9E2DAD0C5
B8A999887765534233251B130F0E1117212D3B4B5C6E8090
A0AFBDCAD4DCE5ECEEEFF4FCFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F3EFEAE3DBD2C7
BBAD9D8D7C6B5A4A3B2E241D19181A212A35425263748494
A4B3C1CCD4DDE6EAEBF1FBFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF7F4F0EBE5DDD4CA
BEB1A39383736354463A30292524272D35404D5C6C7B8A9A
AAB8C3CDD6E0E8EAEEFAFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF8F5F1ECE6E0D7CE
C3B6A99B8C7C6D5F52473E383433363B424D5A68758393A3
B0BAC5D0DBE4EAECF2FCFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF8F5F2EEE9E2DBD2
C8BCB0A39587796C60564E484544464B525C68737F8E9FAA
B3BECCD8E0E6EAECF2F8FCFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEBE5DED6
CDC3B8AC9F93867A70665F595656575C636C757F8D9CA7AD
B9CAD6DADEE3E8EBF1F6FAFCFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF7F5F1EDE8E2DB
D2C9BFB5AA9E93897F77706B6968696E747B828E9CA6ABB5
C7D5D4D4DEE7ECEFF2F6F9FCFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEBE5DF
D8D0C7BEB4AAA0978E87817D7B7A7C80848A939FA7AAB3C6
D5D0CDD9F2F9F7F6F6F8FAFCFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F1EDE9E3
DDD6CFC6BEB5ADA59D97928E8C8C8E90949AA4AAADB4C6D5
D0C9D5F1FBFEFEFCFAFAFBFCFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3F0ECE7
E2DCD6CFC7C0B9B2ACA6A29F9D9D9EA0A4ABB0B2B8C7D5D0
C9D4F0FAFEFFFFFEFDFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F2EFEB
E7E2DCD6D0CAC4BEB9B4B1AEADADADAFB3B8BABECAD6D0C9
D3F0FAFEFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EF
EBE7E2DDD8D3CEC9C5C1BEBCBBBABBBDC1C3C5CDD8D3CCD5
F0FAFEFFFFFFFFFFFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F4F2
EFEBE8E4DFDBD7D3CFCDCAC8C7C7C8CACCCCD0D9D9D2D9F1
FAFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4
F2EFECE9E6E2DFDCD9D6D4D2D2D2D3D4D4D6DBE0DBDCF3FB
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7
F5F2F0EEEBE8E5E3E1DEDDDCDCDBDBDCDDDFE5E6E1E6F8FE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9
F7F5F3F1EFEDEBE9E7E5E5E4E3E2E3E4E6E8EBEAE7EBF4FD
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFA
F9F8F6F5F3F1F0EEECECEBEAE8E8EBECEBEBEDECEBEEF4FA
FDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
FAF9F8F7F6F5F3F2F1F1F0EEEDF0F2EEEBEFF2F2F1F2F5F9
FCFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FCFBFAF9F8F7F6F5F5F4F3F2F4F6F2EEF0FAFDFAF7F6F8FA
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFCFBFAF9F9F8F8F6F6F7F8F5F2F3FBFEFFFDFBFAFAFB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFDFCFBFBFBFAF9F9F9FAF8F5F6FCFEFFFFFFFDFCFCFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFDFDFDFCFCFBFBFBFCFAF8F9FDFEFFFFFFFFFEFEFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFDFDFCFDFDFCFAFBFDFFFFFFFFFFFFFFFFFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFDFCFCFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFDFDFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 25.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 25.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFDFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFDFDFDFCFCFCFCFBFBFBFBFCFCFCFCFCFD
FDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFDFCFCFCFBFBFBFAFAFAFAFAFAFAFBFBFBFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFDFDFCFCFBFBFAFAF9F9F8F8F8F8F8F8F9F9F9FAFA
FBFBFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFCFBFAF9F9F8F7F7F6F6F5F5F5F5F5F6F6F7F8F8
F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFCFCFBFAF9F8F7F6F5F4F3F2F2F1F1F1F1F2F2F3F4F5F6
F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFD
FCFBFBF9F8F7F6F4F3F1F0EFEEEDECECECECEDEEEFF0F1F2
F4F5F6F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FBFAF9F8F6F4F3F1EFEDEBEAE8E7E7E6E6E6E7E8E9EBECEE
F0F2F4F5F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF9F7F5F3F1EFECEAE8E6E3E2E0DFDFDFDFE0E1E3E5E7E9
ECEEF0F2F4F6F8F9FBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F9F7F5F3F0EDEAE7E4E1DFDCDAD8D7D6D6D7D8D9DBDEE0E3
E6E9ECEFF1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9
F7F5F2EFECE9E5E1DEDAD6D3D1CECDCCCCCCCED0D2D5D9DC
E0E4E7EBEEF1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7
F5F2EFECE8E4DFDBD6D1CDC9C6C3C1C0C0C1C2C5C8CCD0D4
D9DDE2E6EAEEF1F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5
F3EFECE7E3DED8D3CDC8C2BEB9B6B4B3B2B3B5B8BCC1C6CB
D1D6DBE1E5EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3
F0ECE8E3DDD7D1CAC3BDB6B1ACA8A5A4A3A5A7ABAFB4BAC1
C8CED4DBE1E5EAEEF2F5F7F9FAFCFDFDFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1
EDE9E4DED7D0C8C1B9B1A9A39D9895939394979BA1A7AEB6
BDC5CDD4DBE0E6EBEFF2F5F8FAFBFCFDFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F6F3EF
EAE5DFD8D1C8C0B6ADA49C948D8884828283878B9299A1AA
B3BCC5CDD4DCE3E8ECF0F4F7F9FAFBFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EC
E7E1DBD3CAC1B6ACA1978D857D7773707072757B828B949E
A8B3BCC5CFD8DFE4E9EEF3F6F7F9FCFDFDFDFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFEA
E4DED6CDC3B9ADA1968A7F756C66615E5E60646A727C8691
9DA9B4BFCAD2D9DFE7EEF1F3F6F9FCFCFCFDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8F5F1EDE8
E1DAD1C8BDB1A4978A7D71665C554F4C4C4E535A636D7986
929FACB8C3CCD4DEE7EBEDF1F6FAFAFAFCFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F4F0EBE6
DFD6CDC2B6A99C8D7F7164574D453F3C3B3E434A545F6D7A
8896A4B1BCC6D3DDE3E5EBF2F8F7F7FAFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F3EFEAE4
DCD3C9BEB1A394857566574B3F36302C2C2F343C4754616F
7E8E9DAAB7C5D1D8DBE2EDF4F3F3F7FDFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F6F2EEE8E2
DAD1C6B9AC9D8D7D6C5C4D3F332A23201F2127303C495766
778897A5B4C2CBD0D9E7F1EEEEF3FCFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F6F2EDE7E0
D8CEC3B6A8988877665545362A20191514171E27323F4E60
728291A0B1BDC4CFE0EBE8E7EEFAFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE7DF
D7CDC1B4A5958473614F3F302319120D0C1017202A394A5D
6D7C8C9FAFB9C5D7E3DFDDE7F8FDFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D6CCC0B3A49382705E4C3B2C20150D090A0D121A27384958
67788DA0ADB8C9D7D5D3E0F6FCFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D6CCC0B2A39382705E4C3B2C1F140C0A0A0B0F1A2A394554
677D919FA8B6C9CECBD9F3FCFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8F5F1ECE6DF
D7CCC1B3A5948372604E3E2F2117100D0B0C14222E364359
70818E98A6BACACCD3F2FBFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F5F2EDE7E0
D8CEC2B5A797877564534334271E18120F131F282C374D66
737B899CB0C5D0D0DCF6FDFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9F6F2EEE8E1
D9D0C5B8AB9B8B7B6A5A4A3C3027201A1A22282930466068
6A7B97ADBBC6C9CCDAE9F3FCFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F6F3EFE9E3
DBD2C8BCAFA19282726354473C322A272A2E2C2F445D625D
6E94ADAAAEB7BFC6D3E0ECF5FAFCFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0EBE5
DED5CCC1B4A7998B7C6D5F54493F3938393636465D615765
91AD9A93AABFC8CED6E0E9F1F7FAFCFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F1ECE7
E0D9D0C6BAAEA19486796D61564E4B4945424E616357618D
AE91809EDEF0E7E2E2E6EBF1F6F9FCFDFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F2EEE9
E3DCD4CBC1B6AA9E91867A6F65605D58535967695C648DAF
8F7793DBF3FBFCF3EEEEF0F3F6F9FBFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0EC
E6E0D9D1C8BDB3A89D93887E77726D66677173686D91AF8F
748ED9F2FBFEFFFAF6F4F4F6F8FAFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F2EE
E9E4DDD6CEC5BCB3A99F968E88827B787E81797996AF9176
8ED8F2FBFEFFFEFDFBF9F8F9FAFBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F4F0
ECE7E2DBD4CDC5BCB4ABA49E97908B8D918C8799B0987D92
D8F2FBFEFFFEFEFEFDFCFBFBFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F2
EFEBE6E1DBD4CDC5BFB8B1ABA5A09FA19F979DB1A88C9CDB
F2FBFEFFFFFFFFFEFEFDFDFDFDFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4
F1EEEAE6E1DBD4CFCAC3BCB7B3B1B0AEA8A5B2BBA7A4E0F4
FBFEFFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6
F4F1EEEAE5E0DCD8D2CBC6C5C2BDBAB8B5B9C7C4B2BCEDFB
FEFFFFFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F6F4F1EEEAE6E3DFD9D4D3D2CBC5C5C8C7CBD2C8BDC8E0F8
FEFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9
F8F6F3F1EEECE8E4DFDEDED8CFCFD7D7CECFD3CCC5CDDDED
F7FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
F9F8F6F4F2F0ECE8E7E7E3DBD9E1E4D4CCD5DEDAD3D6DFEA
F3F8FBFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFC
FBF9F8F6F5F2F0EEEEEBE4E2E8ECDDD1D8F1FAEEE4E1E5EB
F2F7FAFCFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFC
FCFBFAF8F7F5F4F3F1ECEAEEF2E6DBDEF3FBFFF8EFEBECEF
F3F7FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFAF9F8F7F6F2F0F3F5EEE5E6F5FCFEFFFEF8F3F2F3
F5F8FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFCFBFAFAF9F7F5F7F8F3ECEDF8FCFEFFFFFEFBF8F7F7
F8F9FBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFCFBFAF9FAFBF6F2F2FAFDFFFFFFFFFEFDFBFAFA
FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFDFDFCFBFCFCF9F6F6FCFEFFFFFFFFFFFEFEFDFCFC
FCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFDFDFBF9F9FDFEFFFFFFFFFFFFFFFEFEFEFD
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFDFBFBFEFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFFFFFEFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 30.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 30.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFD
FEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFCFCFCFCFCFCFCFCFD
FDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFB
FCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFDFDFDFCFCFBFBFAFAF9F9F9F9F9F9F9F9FA
FAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFDFDFCFCFBFAFAF9F8F8F8F7F7F7F7F7F7F7F8
F8F9FAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFDFDFCFCFBFAF9F9F8F7F6F5F5F4F4F4F4F4F4F5F5
F6F7F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFDFDFCFBFAF9F8F7F6F5F4F3F2F1F0F0F0F0F0F0F1F2
F3F3F5F6F7F8F9FAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFCFCFBFAF9F7F6F4F3F1F0EFEDECEBEBEBEAEBEBECED
EEF0F1F3F4F5F7F8FAFAFBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FDFCFCFBF9F8F7F5F3F1EFEDEBE9E8E6E5E5E4E4E4E5E6E7
E9EBEDEFF0F2F5F6F7F9FAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FCFCFAF9F8F6F4F2F0EDEBE8E6E3E1DFDEDDDCDCDDDEDFE1
E3E5E7E9ECEFF2F3F5F7F9FAFBFCFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFD
FCFBF9F8F6F4F1EEECE8E5E2DFDCDAD7D6D4D4D4D4D5D7D9
DCDEE1E4E8EBEDEFF2F6F7F8F9FBFDFDFDFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FBF9F8F6F3F1EEEAE7E3DFDBD7D4D1CECCCAC9C9CACBCDD0
D3D6DADFE3E5E8ECF1F3F4F6F9FBFBFCFDFEFFFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF8F6F4F1EDEAE6E1DDD8D3CFCAC6C3C0BFBEBDBEC0C3C6
C9CED3D8DADEE4EAEDEFF1F5F8F9F9FBFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFA
F9F7F4F1EEEAE5E1DBD6D0CAC5BFBBB7B4B1B0AFB1B3B6B9
BEC4CACDD2DAE2E5E7EAF0F5F6F6F8FBFDFCFCFDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9
F7F5F2EEEAE6E1DBD4CEC7C0BAB3AEA9A6A2A1A1A3A5A8AC
B3B9BEC4CDD6DADCE0E9F0F1F1F4F9FCFBFBFCFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F6F3F0EBE7E1DBD4CDC6BEB6AEA7A09B969291929395989F
A6ACB2BCC7CCCED4E0EAEBEAEFF6FAF8F8FAFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7
F4F1EDE8E3DDD6CEC6BDB3AAA199928B8582818181848A92
989EA8B4BBBEC6D5E2E2E1E7F1F7F4F3F7FDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F6
F3EFEBE5DFD8D0C7BEB3A99F958B827A7572706E6F747C82
88919EA7ADB6C8D7D6D4DCEBF4EFEEF3FCFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5
F1EDE8E2DBD3CAC0B6AA9F94887C726B66615C5B60666B70
7886939AA4B7C7C6C3CEE3F0E8E6EEFAFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7F4
F0EBE6DFD7CFC5BAAEA195887A6E655D554D4A4D5255575E
6D7D868EA0B1B3B2C0DBEBDFDCE7F8FDFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F6F3
EFE9E3DCD4CABFB3A7998B7C6E63594D423D3F403F3F4756
666F758499A2A3B3D4E4D2CEDDF5FCFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F2
EDE8E1DAD1C6BBAEA092827265594A3C3534332D2A324150
565B68809297A6C7D5C0BBCFF1FBFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F1
ECE6DFD7CEC3B7A99B8B7A6B5D4D3C322F2B1F1921313B3C
404F6A838A92ACBFADA7BFEBF9FEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EBE5DED6CCC0B4A6968575665542352F28180D1526292328
3C5870767788A5A49AB3E7F8FDFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EBE5DDD4CABFB2A2928272604D3D352B18090F1F1E0E122E
4C585A5C6A8BA6A2ABE5F8FDFFFFFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EBE4DCD4C9BEB0A19181705C4A3F331F0D0F1E1800002345
4239465E7FA4AFAABEEEFAFEFFFDFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EAE4DCD4C9BDAFA192816E5B4E412C1815201800001C4331
192F6081929C9697B0CDE1F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EBE4DDD4CABEB1A393816F60523F2921271E000019432801
1862866C69757B849BB5CEE3EEF5F8FBFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0
EBE5DED5CBC0B3A595837467543F32332A0D001C44260006
5F8A48325C818E94A0B2C5D8E6EFF5F9FBFCFDFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F1
ECE6DFD7CDC3B6A8988A7C6C5647433B2110244628000059
90350B44BFE1CDBDB9BEC9D7E3ECF2F7FAFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F5F2
EDE7E1D9D0C6B9AC9F92836F5E57503B262F493100035994
31002EB9E8F6F9E3D5D1D4DBE4EBF1F6F9FBFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF8F6F3
EEE9E3DCD3C9BEB3A69887776D67563F3D50411415609330
0025B4E6F7FCFEF3E8E1E0E3E7EDF2F6F9FBFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7F3
F0EBE5DED6CDC4B9AC9E90867E70594F5B58332B668F3300
23B2E5F6FCFDFCF9F2ECEAEAECF0F3F6F9FBFCFDFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF7F5
F1EDE7E1DAD3CABEB2A89E938774676B705642668D41052B
B3E4F6FCFEFDFCFBF7F4F1F0F1F3F5F8FAFBFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF8F6
F3EFE9E4DFD8CDC3BCB4A89B8E8280857559628A642441B9
E6F6FCFEFEFDFDFCFAF8F6F5F5F6F7F9FAFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F7
F4F0ECE9E3DAD2CDC7BBADA49F98948C74698491594FC3E9
F7FCFEFEFDFDFDFDFCFBF9F9F8F9F9FAFBFCFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F5F2F0ECE5DEDAD7CCBDB6B7B1A29991848AA8966A7BDAF7
FEFEFDFDFDFDFDFDFDFDFCFBFBFBFBFCFCFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9
F7F5F2EDE8E4E2DACDC6C9C7B2A3A7A9A2A9B493778CBCEE
FBFCFCFCFDFDFDFDFEFEFDFDFCFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F8F6F3EFECEBE6DBD3D6D8C4B0B4C7BEA6A8AE958291B2D5
EAF4F9FBFCFDFDFDFDFEFEFEFEFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF7F5F2F1EEE6DFE0E4D5C0BFD6D5AC9CAFC1B19C9FB3CB
DFECF4F8FBFDFDFDFDFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FAF8F7F6F3EEE9E9EBE2D1CCDDE5BCA3B1E4F6D8BDB4BCCB
DAE7F0F5F9FCFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFC
FBFAF9F7F4F1F0F1EBDFDAE4EECFB6BDE7F7FEEBD6CACAD1
DCE6EEF3F8FAFCFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FCFCFAF8F6F5F5F1E9E6EBF2DDCACCEBF8FDFFFCEADED9DB
E1E7EEF3F7FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFCFBF9F9F9F6F0EEF2F5E6D9DAF0F9FDFEFEF9F3EBE6E5
E7EBF0F4F7FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFCFBFBFBF9F5F4F7F8EDE4E5F4FBFEFFFFFDFAF7F2EFED
EDEFF2F5F8FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFDFBF9F8FAFBF3ECECF8FCFEFFFFFEFDFBF9F7F5F3
F3F3F5F7F9FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFBFAFCFDF7F2F2FAFDFEFFFFFFFEFDFCFBFAF8F7
F7F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFDFCFDFEFAF7F7FCFEFFFFFFFFFFFEFEFDFCFCFBFA
FAFAFAFBFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFCFAFAFDFEFFFFFFFFFFFFFFFEFEFDFDFCFC
FCFBFCFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFFFFFDFCFCFEFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FDFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFDFDFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 35.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 35.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFD
FDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFCFCFC
FDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFCFCFBFBFB
FCFCFCFCFCFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFDFDFCFCFCFBFBFBFAFAFAFAFAFA
FAFAFAFBFCFCFCFCFDFDFEFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFCFBFBFAFAF9F9F9F8F8F8F8F8
F8F8F9FAFAFAFAFBFCFCFCFDFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFDFDFDFCFBFBFAF9F8F8F7F7F6F5F5F6F5F5
F5F6F8F8F7F7F9FBFBFBFBFDFEFDFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFDFDFCFCFBFAF9F8F7F6F5F5F4F3F2F3F2F2F2
F3F4F4F3F4F6F9F9F8F9FBFCFCFCFDFEFFFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFDFDFCFBFAF9F8F7F6F5F3F3F1F0EFEFEFEEEDEE
F0F0EEEFF2F6F6F4F5F8FAFAFAFBFDFEFEFDFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFCFBFAF9F8F6F4F3F1F0EFEDEBEAEAE9E8E8EA
EAE9E9EDF2F1EFF0F4F8F8F7F8FCFDFCFCFDFEFFFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFDFDFCFBFAF8F7F5F3F1EFEEECE9E7E6E5E4E2E1E3E3
E2E2E7EBEAE7E9EFF5F4F3F5F9FCFAFAFBFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFBF9F8F7F5F2F0EEECE9E5E2E1E0DEDBD9DADBDA
DADEE2E1DEE0E9F1EFECEFF5F9F7F6F8FCFEFCFCFDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FDFDFCFBFAF8F7F4F2EFEDEAE6E2DFDDDBD8D3D1D2D3D1D0
D3D7D6D3D7E2ECE7E2E6EFF6F3F1F5FBFDFBFAFCFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FDFCFBFAF8F7F4F1EFECE9E5E0DBD9D6D2CCC8C9CAC7C4C6
CBCBC9CDD9E2DBD5DAE8F3EEECF0F9FCF8F7FAFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FDFCFAF9F7F5F2EFECE8E3DED9D6D2CCC5C1C1C1BDB7B7BD
C0BDC0CCD4CDC6CDE1F0E8E3E9F5F9F3F3F7FDFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FCFBF9F8F5F2EFECE8E3DDD8D4CFC7BFBAB9B8B2AAA8AEB4
B1B0B9C2BDB7C1DBEBDCD5DEEFF5EDECF2FCFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFC
FBFAF8F6F3F0EDE9E3DDD7D3CDC4BAB4B3B0A79D9AA1A7A2
9CA2AFAFAAB6D2DFCAC1CDE6F2E5E3ECFAFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FBF9F7F4F1EEEAE5DED8D3CDC2B6B1AFAA9C908E95999187
8B9BA39EA6C1CAB3A9BADDEFDCD8E4F7FDFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FAF8F6F3EFECE6DFD9D4CDC2B5AFADA59385848B8B7F7275
8896908FA3B1A095AAD7EDD0C9D9F4FCFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
F9F7F4F1EEE9E2DBD6CFC3B6AFACA28D7D7D857F6C5E6378
867C728097938BA2D7E1BAB3CAEFFBFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFA
F8F6F3F0ECE5DFD9D2C7B9B1ADA28B78798275594C566B73
63545E7F8F8799CBC89C94B4E8F9FDFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F8F5F3EFE9E2DDD6CCBEB4B0A58D7878816F4A3C4E655E46
3A476D897E7DA0AA80759CE0F6FDFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9
F7F5F1ECE7E1DBD2C5BAB4AA927C7A826D413049634B2722
3C61776652668A7C678CD9F4FCFEFFFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9
F7F4F0EBE6E0D8CCC1BAB19B847E836F402B46653D090A38
5C56402F3B6B8E7F8ADAF4FCFEFEFDFCFCFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9
F6F3EFEAE5DED3C8C1B9A68F858775482E4668360000375F
3210193562979B89A6E6F6FDFDFAF9F9FAFBFCFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F5F2EFEAE4DAD1C9C1B29C8E8D7F573A4A68350000346915
0000486F7B7A615B7EA5C5EDF1F2F4F6F8FAFBFCFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F5F3EFE9E1D9D2CABDA99A968C694A4F673C000032730400
005978362832303653789EC4D9E6EDF2F5F8FAFBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F6F2EEE8E1DAD3C8B7A8A19A7D5C58694A03003575000000
577F00000F444E4E596F8DADC7D9E5EDF2F6F9FBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F5F2EDE8E3DBD1C4B6AFA89170646F5D21063A6F0200004D
8B000000A1D3B090828492A8BED0DEE8EFF4F7FAFBFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F5F2EEEAE3DACFC5BDB5A285747A73411F3D671000004C93
00000098DDF2F6CDB1A4A5B0BFCEDBE5EDF2F6F9FBFCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F5F3F0EAE2DAD2CAC1B19B898988603740642C0000588E00
000091DAF3FBFCE8D1C1BBBEC6D0DBE4EBF1F5F8FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F6F5F0E8E2DED7CCBEAFA19B987B50486752050060830000
008ED8F2FAFCF7F1E4D7CFCDD0D7DEE5ECF1F5F8FAFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF9
F8F4EEE9E7E3D6C9C0B8AFA5916E5C717737155480000000
8FD8F2FBFDFAF7F4EDE5DEDBDBDEE3E8EDF2F5F8FAFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F8F3EFEEECE0D3CDCCC2B0A08D7C808E622B3D7D25000098
DAF2FBFEFDFBF9F6F2EDE8E5E4E5E8EBEFF3F6F8FAFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFA
F7F3F3F2E9DDD7DAD4BDABA6A09695804C396C751000A7DF
F3FBFDFDFBFAFAF9F7F3EFEDEBEBEDEFF2F4F7F9FBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCF9
F7F6F7F1E6E0E4E3CBB6B6C1B0968C795D6A9F6F233CC8F4
FDFEFBFBFAF8F8FAFAF8F5F2F1F1F1F3F4F6F8FAFBFCFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFA
F9F9F6EEE8EAEDD9C3C1D5C99E8D9B998595A15A2A4A94E3
F8F9F7F9FAF9F7F8FAFBF9F7F6F5F5F6F7F8F9FBFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFB
FBF9F4EFEFF3E6D2CCDDDFAF93A4CCA7808B8E5732477DB4
D8E9F0F4F8FAF8F8F9FAFBFBF9F8F8F8F9FAFBFCFCFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFC
FBF8F5F4F6EFE0D8E2EDC5A4A9DCC47E6A90AB805656759E
C0D8E6EEF4F8FAF9F9FAFBFCFCFBFBFAFBFBFCFCFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFC
FAF9F8F9F4EBE4E9F3D9BBB7DADD94708AD8F5B884737E98
B4CBDCE7EFF5F9FAFAFAFBFCFDFDFCFCFCFCFDFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFC
FBFBFBF8F2EEEFF5E6D1CADEEDB38D99DAF3FBD6AB95939F
B2C6D6E2EBF1F7FAFBFBFBFCFDFDFEFDFDFDFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FDFDFAF6F4F5F7EDE0DCE8F1CAACB0E1F4FBFDF7D0B7ADAF
B9C7D4DFE8EFF4F9FBFCFCFCFDFDFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFCF9F8F9FAF2EAE8F0F3D9C4C6E8F6FCFDFCF1E1D0C4C1
C5CDD7E0E8EEF3F7FAFCFDFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFE
FDFBFBFCFCF6F0EFF6F6E2D4D6EEF8FDFEFEF8F2EADFD6D1
D2D6DCE2E9EEF3F7FAFCFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FDFCFDFEF9F5F4F9F9EBE0E2F3FAFDFFFFFCF8F4EFE9E3DE
DDDEE2E6EBEFF3F7F9FBFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFCF9F8FBFCF2EAEBF7FCFEFFFFFEFCF9F6F3EFEBE8
E6E6E8EBEEF1F4F7F9FBFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FFFFFDFBFBFDFDF7F1F1FAFDFEFFFFFFFEFCFAF8F6F4F1EF
EDEDEEEFF1F4F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFDFEFEFAF6F6FCFEFFFFFFFFFEFEFDFBFAF9F7F5F4
F3F2F2F3F4F6F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFFFEFCFAFAFDFEFFFFFFFFFFFEFEFDFCFBFAF9F8F7
F7F6F6F6F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFDFCFCFEFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAFA
F9F9F9F9F9FAFBFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFDFDFEFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFC
FBFBFBFBFBFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFD
FDFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 40.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 40.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFEFE
FEFFFFFEFEFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFEFDFE
FFFFFDFDFDFEFFFEFEFEFFFFFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFE
FEFDFCFDFEFFFEFDFEFFFFFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFEFDFEFEFDFCFDFEFD
FCFBFBFEFFFCFCFCFEFEFDFDFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFCFCFDFDFA
F9FAFDFEFAF9FAFDFEFDFCFDFFFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFDFCFCFDFCFBFBFCFCFAF8
F9FDFCF8F6F8FCFEFCFBFCFEFEFCFCFDFFFFFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFDFCFCFDFCFAF9FAFBF9F7F8
FCFBF5F3F5FBFEF9F8F9FDFDFBFBFCFEFFFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFCFBFBFCFCF9F8F8FAF8F6F6F9
F8F3F0F3FAFCF5F3F5FAFDFAF9FBFEFEFDFDFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFDFCFBFBFCFBF8F6F6F8F7F4F3F6F6
F1EDF1FAF9EFECEFF7FDF8F6F9FEFDFBFBFCFFFFFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFDFBFAFAFCFAF6F4F4F7F7F1EFF1F3EF
EBEEF8F4E9E4E9F4FEF5F2F6FCFBF8F7FAFEFEFDFDFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFDFBFAFAFCF9F5F2F3F6F5EFEAECF1EEE8
EAF3EFE3DDE4F3FAEDE9EEF8F9F4F3F7FCFEFBFBFDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFBF9FAFCF9F4F1F2F6F4EBE5E7EEEDE5E3
E9EADED9E1F5F3E1DBE3F2F9F0EEF3FBFDF9F9FBFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFBF9FAFCF8F2EFF1F5F1E7E1E2EBEBDFD9DE
E5DCD5DEF4E9D3CBD5EBFBEDE9EFFAFBF5F5F9FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFDFBF9FAFCF7F1EEF1F5EEE3DCDFE9E8D7CED3DF
DBD1D6E8DFC6BDCAE7F9E4DFE8F9F7EFEFF5FCFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFBFAFAFCF7F1EEF1F6EBDED9DEE9E3CFC3C8DADA
C9C7D5D5BEB5C6EAECD1CBD9F2F3E6E6EEFAFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFCFAFAFCF8F1EEF1F6E9DBD6DEE9DCC6BAC1D6D7BD
B2BECCBEB4C6F2D9B6AEC3E6F1DEDBE6F8FDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFCFAFAFCF8F2EEF1F6E8D9D4DFEAD5BCB2BDD4CFAF9E
A9C4C2B2BFE1C69D93ACDAF4D6CFDDF5FCFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFBFBFCF9F3EFF1F6E9D8D3E0EBCDB2ACBED5C39F8D99
BDC4A6A3BBB69184A0D8EBC6BFD2F1FBFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FDFCFBFCFAF5F0F1F6EBDAD4E0EBC9AAA6C1D8B38C7F92B9
BC917D92AA9689A7E7D1A6A2BFECFAFEFFFFFFFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFD
FCFCFCFBF6F2F2F6EEDDD5DFECC8A6A2C4DAA2777393B9AA
785D70A0A995ACE7B17B78A3E3F7FDFFFFFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFD
FCFDFCF8F3F3F6F1E2D8DFEBCCA8A2C5DB93626699BC8E5C
4A619AB38A83A7985E5384D9F4FCFEFFFEFDFDFDFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FDFCF9F5F4F7F4E6DCDEEBD3AFA5C5DB8C545AA0C26C393D
659AA067465D81674E76D2F1FBFEFFFDFCFBFBFCFCFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFAF7F6F8F6EAE0DFEADBB9ABC3DC905254A3C34C102976
9C7240212F69927C85D8F4FCFEFEFAF8F8F8F9FAFBFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFD
FBF9F8F9F7EEE4E2EBE2C3B1C0DB9D5D58A4C237000D849F
390E17366CAC9E83A1E0EFFAFBF6F3F2F3F5F7F8FAFBFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFDFC
FBFAFAF8F1E9E6ECE8CDB9BFD9AF7163A3C334000084A205
00066285846D4134567DA4E2E6E7E8EBEEF1F4F6F8FAFBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFC
FCFBF8F4EEEBEFECD6C1C1D7C087719EC445000080A30000
008383200D1003021B3D6A9FBDD0DBE2E8EDF1F4F7F9FBFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFD
FCF9F6F2F0F1EEDECBC7D8CE9B7D97C263060784A2000000
7E7A00000027291F2130507A9EB8CBD8E2E9EEF2F5F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFEFD
F9F7F6F5F4EFE4D7D1DBD8AC8A94BF862F2488A200000069
7F00000094CD9E70554B56708DA8BECEDBE4EBF0F4F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFDFA
F8F8F9F6EFE8E1DDE0DDBB9A99BEA5543A7FA20000006784
0000008BD8F1F4BC9077707A8DA2B6C7D5E0E8EEF2F6F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFBF9
F9FCF8F0EBEAE9E5DEC8AEA7C1BC72486EA32A00007C7E00
000082D5F1FAFADEBB9F908F97A5B5C5D2DDE5ECF1F5F8FA
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFCFAFA
FEFAF2EDEEF3EBDDD1C3BBC6C78B5964A36500008C760000
007ED3F0FAFAF2E9D4BEADA6A8AFBAC6D2DCE4EBF0F4F7FA
FBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFCFBFE
FCF5EFF1F9EFDED6D5D2CDC7A4766EA19B34167481000000
80D3F0FAFDF8F2EBDFD1C4BBB9BCC2CBD4DDE4EBF0F4F7F9
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFEFD
F7F2F2FBF3E1D8DEE8D5C1B49C8BA3B85F1D44920600008A
D5F0FAFEFBF9F5EFE6DCD3CCC8C8CCD1D8DFE6EBF0F4F7F9
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFEFEFA
F5F5FAF7E6DCE1F7DDBEB6BEB5ABB3863B2E7B7600009CDB
F2FAFDFCF8F5F6F4EEE6DED8D4D3D5D8DDE2E8EDF1F4F7F9
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFCF8
F7FBFAEDE2E3F6E6C2B4C9DFB69D9B79506AB65D0020C0F2
FDFDF9FAF6F2F1F4F4EFE8E2DEDDDDDFE2E6EAEEF2F5F8FA
FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFBFA
FCFDF3E9E7F3EECDB9C6F7C2908EAE9B7D9DA23700237BDB
F6F5F1F4F6F2EFEFF3F4F1ECE8E5E5E5E7EAEDF0F3F6F8FA
FCFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFD
FEF8F1EDF4F6DBC6C8EBD29682ABE4956F8B852E0015569B
C9DEE6EBF1F4F0EEEFF3F5F4F0EDECEBECEEF0F3F5F7F9FB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFEFF
FBF6F4F7FBE9D7D2E6E3AC8C9FEAA95B538CA75A1D1B4276
A3C3D5DFE8F1F3F0EFF0F4F6F6F4F2F1F1F2F3F5F7F8FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFC
FAF9FAFEF2E6E0EAF3C8A6A8D8C5714E77D6F6944C344264
8AACC3D3DEE9F1F3F1F0F2F5F7F8F7F6F5F5F6F7F8FAFBFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFC
FCFDFDF7F0EDF2FBDFC4BEDBE19A7083D5F3F5BB7B595566
819EB6C8D6E1ECF3F4F3F3F4F7F9F9F9F8F8F8F9FAFBFCFC
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FFFDF9F5F5F9FAEBDBD6E7F0BD989FDBF2FBFCEFB1887677
869BB0C1D0DBE6EFF4F5F5F5F6F8FAFBFBFBFBFBFBFCFCFD
FDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFF
FDFAF8F9FDF9EFE7E6F3F1D0B7BAE4F4FBFDF8E4CAAB9690
95A1B1C0CDD8E2EBF2F6F7F7F7F9FAFBFCFCFCFCFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFE
FCFAFAFEFAF2EDEEF9F1DACACEEBF7FCFEFCF2E6D6C2B1A8
A7ADB7C2CDD7E0E9F0F5F8F8F9F9FAFBFCFDFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD
FCFCFEFCF6F2F2FAF5E3D7DBF1F9FDFFFEF8F1E8DED2C5BC
B9BAC0C8D1D9E1E8EEF4F8F9FAFAFBFCFDFDFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFD
FDFEFEFAF6F6FBF9ECE3E5F5FBFEFFFFFBF7F2ECE5DDD4CD
C9C8CBD0D6DCE2E9EEF3F7FAFBFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FFFFFCFAFAFCFCF3EDEDF8FCFEFFFFFDFBF7F3EFEAE5DFD9
D6D4D5D8DCE0E5EAEFF3F7F9FBFCFDFDFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFCFCFEFDF8F4F4FAFDFFFFFFFEFDFBF8F5F2EEEBE7E3
E0DEDEDFE2E5E9EDF0F4F7F9FBFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFFFEFAF8F8FCFEFFFFFFFEFDFCFBF9F7F5F2EFEDEA
E8E6E6E6E8EAEDEFF2F5F7FAFBFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFFFEFCFBFBFDFFFFFFFFFFFEFDFDFCFAF9F7F5F3F1F0
EEEDECECEDEEF0F2F4F6F8FAFCFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFDFCFCFEFFFFFFFFFFFFFEFEFDFCFBFAF9F7F6F5F4
F3F2F1F1F1F2F3F5F6F8F9FBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F8F7
F6F5F5F5F5F5F6F7F8F9FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9
F9F8F8F8F8F8F8F9FAFBFBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFB
FBFAFAFAFAFAFAFBFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFCFCFCFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 45.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 45.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFEFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFD
FDFDFDFCFDFEFFFFFEFFFFFFFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFDFDFDFD
FDFCFBFBFCFDFEFEFEFFFFFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFEFEFFFFFEFDFDFDFC
FBFAFAFBFCFCFCFCFEFFFEFDFDFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFEFDFDFDFCFA
F8F8F9FAF9F9F9FCFEFEFDFDFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFEFEFDFDFEFDFAF8
F8F9F8F6F5F6F8FCFDFDFDFEFEFDFCFDFEFFFFFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFDFCFCFCFDFDFCFCFDFEFBF8F8
F9F7F4F1F2F5F8FAF9FBFEFEFBFAFBFDFFFFFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFDFDFCFBFBFCFCFBFAFBFEFCF9F9FA
F8F2EEEEF1F4F4F3F5F9FFFBF9F9FBFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFDFDFDFCFBFAFAFBFBF9F7F8FCFDF9F8FCFA
F3EDEDF0F1EDEBEDF3FAFDF9F9FAFCFCFCFDFEFFFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFDFDFDFCFBFAFAFBFAF7F5F6F9FBF7F5F9FEF5
EFEEF1EFE7E2E3EAF4FAF8F8FBFCF9F8FAFCFFFEFDFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFDFDFDFCFAF9F9FAF8F5F3F3F7F8F3F0F3FBF9F1
F1F5F1E4DBDBE3ECF0EFF2F9FDF6F4F5F9FEFEFCFCFDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFDFBFAF9F9F9F7F4F1F2F5F5EFEBECF5FCF3F0
F8F6E5D9D8DFE6E3DFE3EEFBF7F0F0F5FBFEFBFBFCFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFDFDFDFBFAF9F9F9F6F2F0F0F3F3EBE6E6EFF7EFE9EF
FBEBDDDAE2E3D7CDD0DEF1FCF0EEF3FAFCF9F9FBFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFDFCFAF9F8F8F5F1EEEFF2F0E7E1E2EBF2E7DEE1F1
F4E4E2ECE7CEBEBECEE5F5EFEDF3FAF7F3F4F8FDFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFAF9F8F8F4F0EDEEF1ECE3DDDFE8EDDFD3D4E5FF
E9E2F0F0CEB8B5C5DAE1DCE0EEFFF1EBEDF4FCFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFCFAF9F9F8F5EFECEDEFE8DED9DDE7E8D7C9C9DBF5E2
D3DAEDD7BEB9C9D6CABDC3D9F5EFE2E3EDFAFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFBFAF9F9F5F0EDEDEEE6DAD5DAE5E1CEC1C2D6EED6BF
C0D9E6CFC9DCDCB79EA1BCE5F4DDDAE5F8FDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFBFAFAF9F7F1EEEEEEE5D8D2D7E1D7C3B7BED6E9C9ACAA
C5F1DDCFE4E6AF8B88A5D4F4DAD2DEF5FCFFFFFFFFFFFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FCFBFAFAF8F3EFEFF0E7D9D1D5DDCEB6ADBAD8DFBB9E9CBA
F0D5B4BAD1B68E86A2CDD7C4C2D5F2FBFEFFFFFEFEFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFD
FBFBFBF9F4F0F0F1EBDDD4D6DCC9ADA2B3D2CBA58F95BAF3
C3938DADC5ABA1BCD7B4989EC0EDFAFEFFFFFEFDFDFDFDFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFC
FCFCFAF6F2F1F3EEE1D7D9DFCBAC9DACC7B2897A91C4F2B0
7C7092CED1BBD6E2986C70A0E3F7FDFFFFFDFCFCFBFCFCFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFD
FDFBF8F4F2F4F1E5DBDCE3D3B2A0ABC0A06E6084CBD2926B
678DD6D19A97B18E585183D8F4FCFFFFFDFBFAFAFAFAFBFC
FCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFAF6F4F5F3E9DFDEE6DDBEA9B0C39D614B71B8A5644F68
A0E6B56D526D8D735D7FD4F2FBFEFEFBF8F7F7F7F8F9FAFB
FCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFE
FBF9F7F8F6EDE3E0E7E5CAB4B7CEAA684866A17A2E205BBF
D38851364985AF9DA2E0F7FDFEFDF7F3F2F2F3F4F5F7F8FA
FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFEFC
FBFAFBF9F1E9E4E9EAD3BDBDD6C27F596C9E65070036BFA4
482F3F5F97D6B194AADBE9F8FAF1ECEAEAECEEF0F3F5F7F8
FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFEFEFDFC
FDFDFCF6EEEAEDEFDBC5C0D6D89C727EB071010012967102
003C9BB49F76453549668EDADDDBDCDEE2E5E9ECEFF2F5F7
F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFE
FEFCF8F4F1F3F4E3CEC6D5E4B3898EC79620000E7D4B0000
10C28F32211E0D030C1F4984A6BAC7D0D7DEE3E8ECF0F3F6
F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFDFD
FBF9F8F7F9FAEBD9D0D9E9C39994C8C354112C8C44000000
A46B00000637342315132A547B99B0C0CCD5DDE3E9EDF1F4
F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFCFCF9
F8F9FBFFFAF1E5DDE2EFD0A699BDE7854354B5620000007D
5F0000009ED1A3724A31314664829BB0C0CCD7DFE5EBEFF3
F6F8FAFBFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFCFBF9F7
F8FAFAF5F2EFEBEEFADDB7A4B9F0A66468C793000000785C
00000096DDF3F5BC865F4D5061778FA4B6C5D1DAE2E8EEF2
F5F7FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFCFAF7F7
F8F7F2EEF1F7FAF8E7CDB9C1EEBA7567ABC63300039A5900
00008EDAF3FAF9DCB28C72686D7A8C9EB0BFCCD7DFE6ECF1
F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBF9F7F8
F6F1ECEDF5F7ECE6DFD4D5F3CD8A6B92EE762036C45E0000
008AD8F2FAFAEFE3CAAD94858186919FAEBCC9D4DDE5EBF0
F3F6F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F8F7
F2ECEBF0EFE4DDE3EEEBEDDEAA838FDEA84841B07F000000
8CD7F2FBFDF7EEE3D4C0AD9E97969CA5B1BDC9D3DCE4EAEF
F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAFAF8F4
EFECEEECE1D7DAEEF0DAD5CCAFA6D3CA62356FB715000096
D9F2FBFEFAF7F2E8DACBBDB1A9A6A8AEB7C0CAD4DCE3EAEF
F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF7F3
EFEFEDE3D8D5E1E4CCC0CEE0CCCBDA8E464AA88B0700A7DF
F4FBFDFBF4F1F2F0E6D7CABFB8B4B4B8BEC5CED6DDE4EAEF
F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFAF7F4
F3F1E9DDD7DCDEC9B4BAE0E3B9B6BC876188DE651133C5F4
FEFCF8F9F2EBE9EDEEE6D9CEC5C1C0C1C6CBD2D8DFE5EAEF
F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBF8F7
F6F0E6DFDFE0CFB7B1C8D7AB90A9D4A48CBDAD39052D81DC
F6F2EDF1F3EBE4E4E9EDE7DDD4CECBCBCDD1D6DCE2E7ECF0
F3F6F8FAFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFA
F7F0E9E7E7DBC5B7C0CEAD8486C2DB8D7DAB922D00165699
C6DADEE3ECEEE6E1E2E7ECEAE2DBD7D5D6D8DCE0E5E9EDF1
F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFEFC
F7F2F0F1EAD8C9C8D3BE9381A1D1905764A9B14D0E0C3469
98B8C8D2DEEAEBE4DFE1E7EDECE8E3DFDEDFE1E4E8EBEFF2
F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFEFC
F9F8F9F6EADDD9E0D6B297A0C8A7624F82DEF07C2D142348
7397B0BFCDDDE9E9E3E0E3E8EEEFECE9E7E6E7E9EBEEF1F4
F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFC
FDFEFCF6EEEBEFEDD3BAB7D1CA8C6A86D8F6F0A75B322C3F
5E809BAFBFCEDEE9E8E4E3E6EBEFF1F0EEEDEDEEEFF1F3F5
F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFE
FEFBF8F7F7FBFAEADAD5E4E9B8969FDCF3FCFAE998634B4B
5C758EA3B3C3D3E2EAE9E7E6E9EDF2F4F4F3F2F2F3F4F5F7
F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFDFD
FBF8F8FBFDF6EFEAEBF6F1D2B9BCE4F5FBFCF6D9B48B6E63
67778A9DADBBCBDAE6ECEBEAEAEDF0F4F6F6F6F6F6F6F7F8
FAFBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
F9F8F9FAF5EFECF1FCEDD9CCD0ECF7FCFEFAEBD9C2A68C7D
7A818E9DABB8C5D3E0EAEEEEEDEEF0F3F6F8F9F9F9F9F9FA
FBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFB
FAFAFBF7F2EFF1F8EEDFD6DCF1FAFDFFFDF3E8DBCBB8A596
8F9098A2ADB9C4D0DCE6EEF1F1F1F2F4F6F8FAFAFBFBFBFB
FCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFC
FCFDFBF7F3F4F8F4E8E1E4F5FBFEFFFEF8F1E8DED3C5B7AB
A3A1A4ABB3BCC6CFDAE4ECF1F3F4F4F5F6F8FAFBFCFCFCFC
FDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFBF9F8FBFAF1EBECF8FCFEFFFEFBF6F0EAE2D9D0C5BC
B5B1B2B5BBC2C9D1DAE2EAF0F4F6F6F7F8F9FAFBFCFDFDFD
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFDFCFCFEFDF7F3F3FAFDFFFFFEFCF9F6F1ECE6DFD8D1CA
C4C0BFC1C4C9CFD5DCE3EAF0F4F7F8F8F9FAFBFCFDFDFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFFFDFAF8F8FCFEFFFFFFFDFBF9F6F2EEE9E5DFDAD4
D0CDCBCBCDD1D5DADFE4EAEFF4F7F9FAFAFBFBFCFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFFFDFBFAFAFDFFFFFFFFFEFCFBF9F7F4F1EDE9E5E1DD
DAD7D6D5D6D8DBDFE3E7ECF0F4F7F9FBFBFCFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FFFFFEFDFCFCFEFFFFFFFFFFFDFCFBF9F8F6F3F0EDEAE7E4
E2E0DEDEDEDFE1E4E7EAEEF1F4F7FAFBFCFDFDFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFDFDFFFFFFFFFFFFFEFDFCFBFAF9F7F5F3F1EFECEA
E8E7E6E5E5E6E7E9EBEDF0F3F5F8FAFBFCFDFDFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFFFFFFFFFFFFFFFEFDFDFCFBFAF9F7F6F4F2F1EF
EEECECEBEBEBECEDEFF1F3F5F7F9FAFCFDFDFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAF9F8F6F5F4F3
F2F1F0F0F0F0F0F1F2F3F5F6F8F9FBFCFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F8F7F6
F5F4F4F4F3F4F4F4F5F6F7F8F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFBFBFAF9F9F8
F8F7F7F7F6F7F7F7F8F8F9FAFAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFBFAFA
FAF9F9F9F9F9F9F9F9FAFAFBFCFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFCFB
FBFBFBFBFBFBFBFBFBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFD
FCFCFCFCFCFCFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFD
FDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 50.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 50.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFD
FDFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFCFC
FCFCFDFDFEFEFFFFFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFB
FBFBFCFCFCFDFEFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFDFDFCFBFAFA
FAFAFAFAFBFCFDFFFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFDFCFBFAF9F8
F8F8F8F8F9FBFCFEFFFFFEFDFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFDFDFDFDFDFDFDFDFDFEFDFCFAF9F8F7
F6F5F5F6F7F9FAFCFEFFFDFCFCFCFDFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFCFCFCFCFCFCFDFDFCFBFAF9F7F5
F3F2F2F3F4F5F7FAFDFFFDFCFCFCFDFDFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFDFCFCFBFBFAFAFAFAFBFCFCFCFBFAF8F5F3
F1F0EFEFEFF1F4F8FCFFFEFCFBFBFBFCFDFEFFFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFDFDFCFCFBFBFAF9F9F8F8F8F9FAFAFBFCFAF7F4F1
EFEDEBEAEAEDF1F5F9FCFFFDFAF9F9FBFDFEFFFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFDFDFCFCFBFAF9F8F7F7F6F6F6F6F7F8FAFBFAF7F4F1
EEE9E6E5E6E9ECF0F4F9FEFBF8F7F8FAFDFFFFFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFBFAFAF9F8F6F5F4F3F3F3F2F3F4F7F9F9F8F6F1
EBE5E2E2E2E3E5E8EEF6FDFBF8F7F8FAFCFEFFFFFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFCFBFAF9F8F7F6F4F3F2F0EFEEEEEFF1F3F5F7F9F8F0
E9E4E1DFDBDADBE1EAF4FCFDFAF8F7F8F9FCFEFEFDFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFAF9F8F6F5F3F2F0EFEDEBE9E9EAECEDEFF3F9F8F0
EBE6E0D8D2D0D5DDE6EFF6FDFBF6F3F4F7FBFEFDFCFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFD
FCFBFAF9F8F6F4F2F0EFEDEAE8E6E5E5E5E4E5E8EFF6F6F4
F1E8DCD1CBCCD1D7DCE3EDF9F9F2EFF1F6FCFEFCFCFDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFC
FBFAF9F8F6F4F2F0EDEBE8E5E3E1E0DFDCDBDDE3E9EDEFF6
F7E7D8CFCCCBC9C9CDD8E8F8F7F0EFF3F8FDFDFCFDFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFC
FBF9F8F6F4F2EFEDEAE6E3E0DEDDDAD6D3D3D7DCDEE0E6F4
F8E7DDD7CFC4BAB8C2D4E9FAF8F3F3F5F8F9FAFCFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFB
FAF8F7F4F2EFECE9E5E1DEDBD9D6D1CDCCCED1D1CFD3E0F1
F5EEEBDFCAB6ADB1C1D3E3EDF6FBF5F1F0F4F9FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFA
F9F7F5F3F0EDE9E5E0DCD8D5D1CBC8C7C8C8C5C1C2CDDDE5
E6EFF9DCC0B1AFB7BFC5CEDDF1F8ECE8EBF4FCFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFA
F8F6F3F1EEEAE6E0DBD7D2CCC5C1C1C2C1BCB5B5BECBD0CD
D2E5F4D9C6BFBDB5ABABBBD6F3EFE3E4EDFAFEFFFFFFFFFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF9
F7F4F2EFECE7E2DDD7D1CAC1BBB9BAB8B1ABACB4BFBFB7B6
C7E5F9E5E1D7BA9C909BB9E0FCE6E1E9F8FDFFFFFFFFFEFE
FEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8
F6F3F1EDE9E4DFDAD4CBC0B8B3B1ABA49FA2ADB6B2A6A2B0
CDE3E0E5F6CDA28A8CA6CBE6E4DFE7F7FDFFFFFFFEFDFDFD
FDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7
F5F2EFEBE6E1DDD7CFC3B9B2ACA2958F94A1AAA49995A3BE
CCBDB8CADABDA09AA9BCC2C4CDE0F6FCFFFFFFFEFCFCFCFC
FCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7
F4F1EEE9E4DFDBD3C9BFB7AEA08E83848E938D868A9EB9BF
A695A1C6E1CEC6CBBDA297A7CAF1FBFEFFFFFDFBFAFAFAFA
FBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBF9F7
F4F1ECE7E2DED8CEC5BEB6A792817B7D796C677696B6B69A
848BB1E5EAE0F4C8917580ADE7F9FEFFFFFCFAF9F8F8F8F9
F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFAF8
F4F0EBE7E2DCD3CAC4BFB39E8A807B6C5346557C9E9B877E
8BB1DBC2A5AAB698716E98DFF6FDFFFFFBF8F6F5F5F5F6F7
F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFCFBF8
F5F0ECE7E1D9D0C9C5BDAC9A8F88734F3439586E665C6B93
C7E1AA7C728BA598899EDDF5FCFEFEF9F5F2F1F1F2F3F4F5
F7F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFBF9
F6F2EEE8E0D7CFCBC4B7A79E9B8B633E3543462C1E3C83CF
C69571647AABD4CDCDEDFBFEFEFDF5EFECEBEBECEDEFF1F3
F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFDFCFBFA
F8F5F0E9E0D8D3CCC0B1A8A9A3835D4C4F400F00024F9C8A
65647A99C8F6C4AAB2DAE8F7FAEFE7E3E2E3E4E6E9EBEEF1
F3F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFCFCFBFBFBFB
FAF7F2EBE3DDD7CABBB0B0B19D7E6E72612000001F59421E
3580D4D9B58F695557698ED9D9D5D4D5D7D9DCE0E4E7EBEE
F1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAFAFAFAFA
FAF8F4EFEAE4D8C8BCB8B9AC92859191540E0018370B0000
56DA9A5D51504334292B4B819FB1BBC2C9CED4D9DEE3E7EB
EFF2F4F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F8F8F7
F7F8F8F6F1E7D9CCC6C4B89F919CB18D4C2D414C0300001B
A56D140E4367675436232E4F708B9FADB9C2CAD2D8DEE4E8
ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F7F6F4F3
F4F6F8F8F4EAE0D9D4C7AE9B9FB7AE7D6279882F0000007B
5800002DB7DCBC94653E323E566F8699A9B6C1CAD2DAE0E5
EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFBFAF9F7F5F3F1F0
F1F1F1F2F4F2EEE9DCC3ADA9B9B8937A93C5740A0010754D
000013B2E6F6FACB96684D46506176899BAAB8C3CDD5DCE3
E8EDF1F4F6F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4F1EFEE
ECEAE9ECF2F9FAF1DEC8BEC5C29D7F8CCCB4522449974F00
0004ADE4F6FBF9E2B98F6F5E5B62708192A2B0BDC8D1D9E0
E6EBF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F6F3F0EEEB
E7E3E3E6E9E9EBEFE8DDDDD8B18B87B4D8885A7BCA5F0000
01A9E3F6FCFBF0E3CBAC8E796F6E75818F9DABB8C4CED7DE
E5EAEFF2F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3F0EDE8
E3DFDFDEDAD9DFEFFEF8F8D4AB97ADD6A16D7FE38602000D
AAE2F6FCFDF8EEE1CFB9A390847F8087919DAAB6C2CCD5DD
E4E9EEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F4F0ECE6
E1DEDAD4CECED7E1DFDFEBDABEBFDDB57366A7CC46002AB2
E4F6FCFFF9F7F3E6D5C2AFA0948E8D9097A1ABB6C1CBD4DC
E3E9EDF1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFBFAF7F5F1ECE6
E2DDD6CCC7C9CDC7C1CAE8F0D9E9DE96697CD6A3413CBEE8
F7FCFEFBF2EEF0EFE1CEBCACA19A98999EA6AFB8C2CBD4DC
E2E8EDF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFCFBF9F7F3EEE9
E4DDD3CAC6C5BEB1AFC1DACFC4DBD69B84AFED814766D4F7
FEFCF9F9F0E7E4E8EBE0CEBCAFA6A2A3A6ACB3BBC4CDD5DC
E3E8EDF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBF8F5F1ED
E7DFD5CECAC1B1A6ABBAB6A1A5D1E8AFA7E0BA5F3D60A1E5
F8F2EDF1F2E6DDDBE1E7E0D0C1B6AFADAEB2B8BFC7CFD6DD
E3E9EDF1F4F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFAF8F5F2
EBE3DCD7CEBFAFAAB0AC95869DD0C599A2D8A6502E477BAF
D1DDDCE1EBEBDED5D4DCE4E1D5C8BFBAB8BABEC4CBD1D8DE
E4E9EEF1F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFAF6
F0EAE6E0D4C4BAB9B59F8788A8B78D7490D3B95B292C4F7B
A3BBC5CCD8E6E4D8D0D1D9E2E3DBD1C9C5C4C6CACFD5DBE0
E6EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFFFFFFFEFA
F7F4F1E9DDD2CDCBBAA093A1B5987070A3ECE97B35202F51
7797ABB6C3D5E3DFD4CED0D8E1E5E0D9D3D0CFD1D5D9DEE3
E7ECEFF3F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFEFF
FDFDFAF2E9E4E4DBC5B3B4C5B88F7E9DE2FAEEA45A322B3C
5A7A92A1AFC0D5E1DCD3CED1D9E2E7E5E0DCD9D9DBDEE2E6
E9EDF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFCFC
FBFBFDFBF8F8F6E7D7D3DEDDBAA2AFE3F6FDFAE7945C413F
4F687F919FAFC3D7E0DBD4D1D4DCE4E9E9E6E3E2E2E4E6E9
ECEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFBFBF9
F8F7F9FBF9F7F6F3F0F5F6DBC6C8EAF7FCFCF5D5AC7F5E50
5463768794A3B4C8DAE1DCD6D5D9E0E7ECEDECEAE9E9EBEC
EFF1F4F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAF8
F6F6F7F5F1EFF2F9F9EEE2D9DBF0F9FDFEF9E7D2B8977966
616774828F9CAABCCFDEE2DEDADADEE4EAEEF0F0EFEFEFF0
F2F3F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF8
F7F7F6F2EEEEF2F3EAE1DEE4F5FBFEFFFBF0E2D2BFA78F7C
73737A848F99A5B4C6D6E2E4E1DFE0E3E8EDF1F3F3F3F3F4
F4F6F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFBFA
FAF9F6F2F0F2F4EEE6E3E8F7FCFEFFFDF5ECE1D4C5B3A190
8582848B939BA5B1BFCFDDE5E7E5E4E5E8EDF1F4F6F6F6F7
F7F8F9FAFBFBFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFC
FCFBF8F6F6F8F6EFEAEEF9FDFEFFFDF8F2EAE1D6CABDAFA1
979291959AA1A8B2BDCBD8E3E9EAE9E9EAEDF0F4F6F8F9F9
F9FAFAFBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFF
FFFDFBFBFCFCF7F3F4FBFEFFFFFEFAF6F0EAE2D9D0C5BAB0
A7A19FA0A3A8AEB5BEC9D5E0E8EDEDEDEDEFF1F4F6F8FAFA
FBFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFFFEFBF9F9FCFEFFFFFEFBF8F4F0EAE4DDD5CDC4BC
B5AFACACAEB1B5BBC2CAD4DEE6EDF0F1F1F1F3F5F7F9FAFB
FCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFFFEFDFCFBFBFEFFFFFFFFFDFAF7F4F0ECE6E1DAD4CDC6
C1BCB9B8B9BBBEC2C7CED5DDE5ECF1F3F4F4F5F6F8F9FAFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFCFCFCFEFFFFFFFFFDFCF9F7F4F1EDE9E4DFDAD5D0
CBC7C4C3C3C4C6C9CDD2D8DFE5ECF1F4F6F6F7F8F9FAFBFC
FDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFDFFFFFFFFFFFEFDFBF9F7F5F2EFECE8E4E0DCD8
D4D1CECDCDCDCFD1D4D8DCE1E7ECF1F4F7F8F9F9FAFBFBFC
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFFFFFFFFFFFEFEFCFBF9F8F6F4F1EEEBE8E5E2DF
DCD9D7D6D5D6D7D8DADDE0E4E9EDF1F5F7F9FAFAFBFBFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F7F5F3F1EFECEAE7E5
E2E0DFDEDDDDDEDFE0E2E5E8EBEFF2F5F8FAFBFBFCFCFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFDFCFBFAF9F8F7F5F3F2F0EEECEA
E8E6E5E4E4E4E4E5E6E7E9EBEEF1F3F6F8FAFBFCFDFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F4F3F1EFEE
EDECEBEAE9E9E9EAEBECEDEFF1F3F5F7F9FAFCFDFDFDFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F8F7F6F5F4F3F2
F1F0EFEEEEEEEEEEEFF0F1F2F3F5F6F8FAFBFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAFAF9F8F7F6F6F5
F4F3F3F2F2F2F2F2F3F3F4F5F6F7F8F9FAFBFCFDFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAFAF9F8F8F7
F7F6F6F5F5F5F5F5F5F6F6F7F8F9F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFBFBFAFAF9
F9F8F8F8F8F8F8F8F8F8F8F9F9FAFBFBFCFDFDFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFBFBFB
FAFAFAFAFAFAFAFAFAFAFAFAFBFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFCFC
FCFBFBFBFBFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFD
FDFDFCFCFCFCFCFCFCFCFDFDFDFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 55.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 55.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFDFDFD
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFCFCFCFBFC
FCFCFDFDFEFFFFFFFFFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFFFFFEFEFEFDFDFCFBFBFAFAFA
FAFBFBFCFDFEFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFDFDFCFBFAFAF9F9F9
F9F9FAFBFCFDFEFFFEFEFDFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFDFDFDFDFDFDFEFEFEFDFDFCFAF9F8F8F7F6
F6F7F8F9FAFCFDFEFEFDFDFDFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFDFDFDFCFCFCFCFCFDFDFDFDFCFBFAF9F7F6F5F4
F4F4F5F6F8F9FBFDFEFDFDFCFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFDFCFCFBFBFBFBFBFBFCFDFDFCFBFAF8F6F4F3F2
F1F1F2F3F5F7FAFCFEFDFCFBFBFBFCFDFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFCFCFBFBFAFAF9F9F9FAFAFBFCFCFBFAF7F5F3F1EF
EEEDEEEFF1F4F7FAFCFDFCFAFAFAFBFCFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFDFCFBFBFAF9F8F8F7F7F7F7F8F9FAFBFCFAF7F4F1EFEC
EAE9E9EBEDEFF3F7FAFCFBFAF9F9FAFBFCFDFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFAF9F8F7F6F6F5F4F4F4F5F6F8FAFBFAF8F4F1EDE9
E7E5E5E5E7EAEEF3F8FBFBFAF8F8F9FAFBFDFDFDFDFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFC
FCFBFAF9F8F7F5F4F3F2F1F0F0F1F2F4F6F9FAF9F5F0ECE7
E4E1E0DFE1E4E9EFF4F9FBF9F7F6F7F8FAFCFDFDFDFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAF9F8F6F5F3F2F0EEEDECECECEDEFF2F5F8FAF7F1ECE7
E2DDDAD9DADEE3E9EFF6F9F8F6F4F5F6F9FBFDFDFDFDFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFB
FAF9F7F6F4F2F1EFEDEBE9E7E7E7E7E9ECF0F4F8F8F4EDE7
E0DAD6D4D4D7DBE1E9F1F7F8F5F3F4F5F8FBFDFDFDFDFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFA
F8F7F6F4F2F0EEEBE9E6E4E2E1E0E0E2E5E9EEF4F8F7F0E7
DFD8D3CFCDCED2D9E2ECF5F8F6F3F3F4F6F9FCFDFDFDFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9
F7F5F4F1EFEDEAE7E5E2DFDCDAD9D9DADDE1E6ECF4F9F4EA
E1D9D1CAC6C5C9D1DCE7F1F8F7F3F1F1F4F8FBFCFCFCFDFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7
F6F4F1EFECE9E6E3E0DDD9D6D3D1D0D1D4D7DCE4EDF5F7F0
E6DBCFC6C0BFC3CAD4DFEAF4F5F1EEEFF2F7FBFDFCFCFDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F6
F4F2EFECE9E5E2DEDBD7D3CFCCC9C8C8C9CCD2DAE3EDF5F7
ECDED0C4BEBBBCC0C8D4E2EFF4F0EDEEF2F8FDFEFDFDFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F6F4
F2EFECE9E5E1DDD9D5D0CCC8C4C1BFBEBEC1C7CFD8E1ECF9
F3E3D4C8BEB7B3B4BDCBDDEEF6F2EFF0F3F8FDFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3
F0EDEAE6E1DDD8D3CEC9C4C0BCB9B5B3B4B7BCC2CAD4E1F1
FAECDECFBFB1A9ABB6C7DAECF9F8F2F0F2F5FAFDFFFFFFFF
FFFFFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F6F3F1
EEEBE7E2DED8D3CDC7C1BCB8B3AFACAAAAACAFB4BCC8D7E6
F2FAEBD4BEAEA7AAB4C1D1E1F1F8F0ECEDF2F9FEFFFFFFFF
FFFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF9F7F5F2EF
ECE8E4DFDAD4CDC6BFB9B3ADA8A5A3A2A1A1A2A8B1BECBD5
E1F3F2D9C3B4ADABADB4C2D6EAF3ECE8ECF4FCFFFFFFFFFF
FEFEFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F4F1ED
E9E5E0DBD6CFC8C0B8B0A8A29D9A99989695989FA9B3BBC3
D2E8F9E5D3C4B4A69FA5B8D2EDF4EAE9F0FBFEFFFFFFFEFE
FDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEC
E7E2DDD8D1CAC3BBB2A89E96918E8C8A8A8C9299A0A4AAB7
CAE0F2FDE9CDB09B96A2BBDAF6F5EDF0FAFEFFFFFFFEFDFC
FCFCFCFCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EFEA
E5E0DAD4CDC6BEB6ABA0958C857F7B7B7F868D919397A2B3
C5CFD7E6E7C9AC9D9FAEC5DAE7EDF2FBFEFFFFFFFDFCFBFA
FAFAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F2EEE9
E4DED8D1C9C2BAB1A69A8F84786E6A6C737C81848994A5B4
B7B6BFD3E1D0BDB4B4B7BBC5D6E9FAFEFFFFFFFDFBFAF9F8
F8F9F9FAFAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F6F3EEE9
E3DDD5CEC6BEB6ACA2978B7C6C615C5D62676E78889BA9AA
A4A5B7D3EFEEE1CFB7A5A4B6D5F4FDFFFFFFFCFAF8F7F6F6
F7F7F8F9F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFCFAF7F4EFEA
E4DCD5CCC4BBB2A99F9588776659514B484C5B738D9EA09B
9CAAC3D8DDE2E0C2A1929EC0EDFBFEFFFFFBF8F6F4F4F4F4
F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFBF9F5F1EC
E5DED5CCC3B9AFA69E948675665848382F374D697E898F9A
ADC5CABAB1B8C0B19C9CB7E8F9FEFFFEFAF6F3F1F0F0F0F1
F2F3F5F6F7F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFCFAF7F4EE
E8E0D8CEC3B8AEA69D9285796D5A412B232C3C4A576D8CB1
CFCCAF9A9AACC2C3BCC5E9F8FDFEFEF8F3EFEDECECECEDEE
F0F1F3F4F6F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFBFBFBF9F6F2
ECE4DBD1C6BBB0A69C918881755E432F27241E1F336199C1
BEAB9D9CACCAEBF7F1FAFEFFFEFDF5EEEAE7E6E6E6E7E9EB
EDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFBFAFAF9F9FAFAF9F6
F0E9E0D6CBC0B4A89C928D887B655143331902032760898F
8E9CB3CCE9EED0BBBBDFEBF8FAF0E7E2DFDEDEDFE0E2E4E7
E9ECEFF1F3F6F7F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFCFBFAF9F8F7F7F7F8F9F9
F5EFE7DDD2C7BAACA098948C7F726B5E3D1400092D484B55
7BB6F1E0C5B099837984A2DFDDD8D4D3D2D3D5D7D9DCDFE3
E6E9ECEFF2F4F6F8FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F6F5F4F4F4F5F7
F8F5EEE6DCCFC1B3A9A1998D8484867249261D2726151641
91D2AD8C878C89755E576D95ABB7BCC0C3C7CACED2D6DADE
E2E6EAEDF0F3F6F8F9FBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFBF9F8F6F4F3F1F0F0F0F2
F5F7F6F0E5D8CBBFB5AA9C919098977E6054523B0E00115F
A98B6061839FA6926C52546A8194A1ABB2B9BFC4CACFD5DA
DFE3E7EBEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F3F1EFEDEBEBEC
EEF2F5F6EFE4D8CDC1B0A19BA0A59A89868E783B0A0C4587
7445457BD1E9DDBE8F67565A68788895A1AAB3BAC2C9CFD5
DBE0E5E9EDF1F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEDEAE7E6E5
E6E8ECF2F8F3E9DCCBB9ADACADA49798B0B57E4535578267
34316CD0EFF9FFDDB0856A5F616A7785919DA8B1BAC2CAD1
D7DDE3E8ECEFF3F5F8F9FBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFEBE7E4E1DF
DEDEE2E8F0F7F8E9D7C8C0BCAE9D99AECEB3826F879D6C31
2862CCEFFAFCF9E7C7A38471696A717B87939EA9B3BCC5CD
D4DBE1E6EAEEF2F5F7F9FBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF7F5F2EEEAE6E2DDDA
D7D6D8DBE0E6F2F8EADFD6C4AC9EA7C4C7A497B2C57F3B2C
5FCAEEFAFDFBF0E4D0B69B867973757A838E99A4AEB8C1CA
D1D8DFE4E9EDF1F4F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEAE6E0DBD6
D1CFCECECFD6E2F1F8F8E7CBB4AFBFC5AA9CB7EC9E533D68
CBEEFAFEFEF9EFE1D0BCA89688807D7F858D96A1ABB5BEC7
CFD7DDE3E8EDF0F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFCFBF9F7F4F0EBE7E1DAD4
CECAC5C2C2C8D1D7DEEEF7DBCBCDCFB1969ED6D27E587AD0
EFFAFEFEF9F7F4E7D4C1AE9E92898585898F97A0A9B3BCC5
CED5DCE2E7ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFBF9F6F2EEE9E2DBD5
CEC7C0BAB9BBBDBEC6D9EFE7E2EBD0A796B0F2B97F81D6F1
FAFDFFFAF2EEEFEFE1CDB8A699908B8A8D9299A1A9B3BCC4
CDD4DBE2E7ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFCFAF8F5F1ECE6DFD8
D0C7BEB8B4B1ACABB5C6D0CED8F9D6AFAACEE6A7879FE5FB
FEFDFAFAF0E6E2E6EADFCAB5A498918F90949BA2AAB3BCC4
CCD4DBE1E7EBEFF3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFCFAF8F4F0EAE4DD
D4CBC2BBB4ABA3A2AAB1AFAFC3EADBBDC4EFC89284A1CBF1
FBF3EFF3F2E5D9D6DDE4DECBB7A79C9796989DA4ACB4BCC5
CDD4DBE1E7EBEFF3F5F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFBF8F4F0EBE4
DBD2CAC2B7ABA3A3A59F979DB7D1C2B4CAFAB8817288ACCB
DFE1DEE2ECEADACECDD4DFDECFBCADA49F9FA2A7AEB6BEC6
CDD5DBE1E7EBEFF3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFEFEFEFDFCF9F6F2EC
E4DDD6CCC0B4AEACA497919DB3B4A0A0C2F3C07D5D647E9D
B8C6C9CDD9E7E2D1C6C5CEDADED3C3B6ADA9A9ACB2B8C0C7
CFD6DCE2E7ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFBF8F3
EEE9E2D9CEC5C0B9AB9E9DABB2A1919FC9F7E8915D4E5A73
90A7B1B7C2D4E2DAC9C0C0CAD6DDD7CBC0B8B5B5B8BDC3CA
D0D7DDE3E8ECF0F3F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFCFBFCFBF9
F7F4EFE6DED9D4CABBB2B7C0B5A19FBDEEFEF0B377564F5B
738B9BA3ACBDD2DED4C4BDBEC8D5DDDBD2C9C3C0C1C3C8CD
D3D9DFE4E9EDF0F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F9F9F8
F8F9F8F3EFEDE8DDD2D0D8D4C0B5C4EDFAFEFBEAA3735B57
647788929AA8BCD2DBCFC2BCBFC8D4DEDFD9D2CECBCCCED2
D7DCE1E6EAEEF1F4F7F9FAFBFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBFAF9F8F7F6F5
F5F6F7F6F6F9F9F0EBEFF3E1D2D6F0FAFDFDF6D9B58C6E5F
616D7B868D98A9BFD4D8CDC2BEC1CBD6DFE2DFDAD7D5D6D8
DBDFE3E8EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F7F5F3
F2F2F2F0F0F3F9F9F6F6F1E8E7F5FBFEFEF9E8D4BB9C806D
676C767F868D9AAEC4D6D7CDC4C2C6CED9E1E5E4E2DFDEDF
E1E3E7EAEDF0F3F6F8F9FBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F4
F2F1EFEDECEEF2F0ECEAEBEFF8FDFEFFFBEFE2D2BFA78F7C
7271767D838892A1B5CAD8D7CEC8C7CCD3DCE4E9E9E8E6E6
E6E8EAEDEFF2F4F6F8FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5
F4F3F0EDEDEFEFEBE8E9F0FAFDFFFFFCF4EADFD1C1AF9B8A
7E7A7B7F84888E99AABDD0DAD8D2CDCED2D9E1E8ECEDEDEC
ECECEEF0F2F4F6F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8
F7F5F3F1F2F3F1EDECF1FBFEFFFFFDF7EFE7DDD1C4B5A596
8B858385888B8F97A3B4C6D6DDDBD6D3D4D9DFE5EBEFF0F1
F1F1F1F2F4F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFB
FBF9F7F7F8F8F5F2F5FCFEFFFFFDF9F3EDE5DCD2C7BBAEA1
97908D8D8E909399A2AFBFCFDBE0DEDBDADBDFE4EAEEF2F4
F4F4F5F5F6F7F8F9FBFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FDFCFBFCFDFCF9F9FDFEFFFFFEFAF6F1EBE4DDD4CBC0B6AB
A29B989697989A9DA4AEBBC9D7E0E3E2E0E0E2E5E9EEF2F4
F6F7F7F8F8F9FAFAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FEFDFDFDFEFDFCFEFFFFFFFEFBF8F4F0EBE5DED6CEC6BDB4
ACA6A2A0A0A0A2A4A9B0BAC6D3DEE5E7E6E5E6E7EAEEF2F5
F7F8F9F9FAFAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FDFDFCFCFDFEFFFFFFFFFFFCFAF7F3EFEBE5E0D9D2CBC4BD
B6B1ADABAAAAAAACAFB4BCC6D0DBE4E9EBEAEAEBEDEFF2F5
F7F9FAFBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFD
FDFDFCFCFDFFFFFFFFFFFDFBF8F6F3EFEBE7E2DCD7D1CAC5
BFBAB7B5B3B3B3B5B7BBC0C8D0DAE2E9EDEEEEEFEFF1F3F5
F7F9FBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFDFDFEFFFFFFFFFFFEFCFAF8F5F3F0ECE9E4E0DBD6D1CC
C7C3C0BEBDBCBDBDBFC2C6CBD2DAE2E9EEF1F2F2F2F3F5F6
F8FAFBFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFFFFFFFFFFFEFDFBFAF8F6F3F1EEEBE7E3DFDBD7D3
CFCCC9C7C6C5C5C6C7C9CCD0D6DCE2E8EEF1F4F4F5F6F6F8
F9FAFBFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFCFBFAF8F6F4F2EFEDEAE7E3E0DCD9
D6D3D1CFCECECECECFD0D3D6DADFE4E9EEF2F5F6F7F8F8F9
FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBFAF8F7F5F3F1EFEDEAE7E4E2DF
DCDAD8D7D6D5D5D5D6D7D9DBDEE2E6EAEFF2F5F7F8F9FAFA
FBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF9F8F6F5F3F1EFEDEBE9E6E4
E2E0DFDEDDDCDCDCDDDEDFE1E3E6E9ECF0F3F6F8F9FAFBFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFCFBFAF8F7F6F5F3F2F0EEECEBE9
E7E6E5E4E3E2E2E2E3E3E4E6E7E9ECEFF1F4F6F8FAFBFCFC
FCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F1F0EEED
ECEAE9E9E8E8E8E8E8E8E9EAEBEDEFF1F3F5F7F9FAFCFCFD
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFCFBFAFAF9F8F7F6F5F4F3F2F0
EFEEEEEDEDECECECECEDEDEEEFF0F2F3F5F7F8FAFBFCFDFD
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F8F8F7F6F5F4F3
F3F2F1F1F0F0F0F0F0F1F1F2F2F3F4F5F7F8F9FAFBFCFDFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFAFAF9F9F8F7F7F6
F5F5F4F4F4F3F3F3F4F4F4F4F5F6F6F7F8F9FAFBFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFBFAFAF9F9F8
F8F7F7F7F6F6F6F6F6F6F7F7F7F8F8F9FAFAFBFCFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFCFCFBFBFBFAFA
F9F9F9F9F8F8F8F8F8F8F9F9F9FAFAFAFBFBFCFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFCFCFCFBFB
FBFBFAFAFAFAFAFAFAFAFAFAFBFBFBFCFCFCFDFDFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFCFC
FCFCFCFCFBFBFBFBFBFBFCFCFCFCFCFDFDFDFDFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFDFDFD
FDFDFDFDFDFCFCFCFCFDFDFDFDFDFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 60.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 60.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFDFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFCFCFCFC
FDFDFEFEFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFFFFFFFFFFFEFEFEFDFDFCFCFBFBFBFBFBFB
FCFCFDFEFEFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFEFDFDFCFBFBFAFAF9F9F9FA
FAFBFCFDFDFEFEFEFEFDFDFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFDFDFEFEFEFEFEFEFDFCFCFBFAF9F8F8F8F8F8
F8F9FAFBFCFDFEFEFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFDFDFDFDFDFDFDFEFEFDFCFBFAF9F8F7F6F6F5F6
F6F7F8F9FBFCFDFDFDFCFCFCFCFDFDFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFCFCFCFCFBFBFCFCFCFDFDFDFCFBF9F8F6F5F4F3F3F3
F3F4F5F7F9FBFCFDFCFCFBFBFBFCFCFDFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FDFCFCFBFBFAFAFAFAFAFBFCFCFDFCFBF9F7F5F4F2F1F0F0
F0F1F2F4F6F8FAFBFCFBFBFAFAFBFCFCFDFDFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFC
FCFBFAFAF9F9F8F8F8F8F9FAFBFCFCFBF9F7F5F2F0EEEDEC
ECEDEEF0F3F5F8FAFBFAFAF9F9FAFAFBFCFDFDFDFDFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFB
FBFAF9F8F7F7F6F6F5F6F6F7F9FAFCFCFAF7F4F1EEECEAE8
E8E8EAECEEF2F5F8FAFAF9F8F8F8F9FAFBFCFCFDFDFDFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFB
FAF9F8F7F5F4F3F3F2F2F3F4F5F7FAFBFBF8F4F1EDEAE7E5
E4E3E4E6E9EDF1F5F8F8F8F7F6F7F7F9FAFBFCFCFDFDFDFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9
F8F7F6F4F3F2F0EFEEEEEEEFF1F3F6F9FBF9F5F1ECE8E4E1
DFDEDFE1E4E8ECF1F5F7F7F6F5F5F6F7F9FAFBFCFCFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8
F7F5F4F2F0EFEDEBEAE9E9EAECEEF1F5F9FBF7F2EDE7E2DE
DBD9D9DADDE1E7ECF1F5F6F5F4F4F4F6F8F9FBFBFCFCFDFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7
F5F3F2F0EDEBE9E7E5E4E3E4E5E8EBF0F5F9FAF4EEE8E2DC
D8D5D3D4D6DBE0E7EDF2F4F4F3F2F2F4F6F8FAFBFBFCFCFD
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5
F3F1EFEDEAE7E5E2E0DEDDDDDEE0E4E9EEF5FAF8F1E9E2DB
D6D1CECECFD3D9E0E8EEF2F3F1F0F1F2F4F7F9FAFBFBFCFD
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F5F3
F1EFECEAE7E3E0DDDAD7D6D5D6D8DBE0E6EEF5FAF5EDE4DC
D4CECAC8C9CCD2D9E1E9EFF1F0EFEFF0F3F6F9FAFBFBFCFD
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBF9F8F7F5F3F1
EFECE9E6E3DFDBD8D4D1CECDCCCED1D6DDE5EEF7FAF2E8DE
D5CDC7C3C2C4C9D1DAE4ECF0F0EEEEEFF2F5F8FAFBFBFCFD
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EF
ECE9E6E2DEDAD6D2CECAC6C4C3C4C6CBD2DAE4EEF8F8EEE2
D8CEC6C0BDBDC1C9D3DEE8EEEFEEEDEDF0F3F7F9FBFBFCFD
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F6F4F1EFEC
E9E5E2DEDAD5D1CCC7C3BEBBB9B9BBBFC6CFD9E4F0FBF5E9
DDD1C6BEB8B7BBC2CCD7E2EBEEEDEBECEEF2F6F9FBFBFCFD
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFECE9
E6E2DED9D5D0CBC6C0BBB7B2AFAEAFB3B9C2CCD9E5F2FCF2
E4D6C9BEB7B4B5BBC4CFDCE7EDECEBEBEEF2F7FAFCFCFDFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F2F0EDEAE6
E2DED9D4CFCAC4BFB9B4AFAAA6A4A4A6ACB4BFCCD9E7F4FC
ECDDCEC2B8B2B0B3BBC8D6E4EDEEECECEFF3F8FCFEFEFFFF
FFFFFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F1EEEAE7E3
DEDAD5CFCAC4BEB8B2ACA7A29E9B999B9FA7B2BFCCDAE9F8
F7E7D7C8BBB1ACADB5C2D2E2EDF1EFEEEFF3F8FCFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFECE8E4DF
DAD5D0CAC4BDB7B0AAA49E9995929090949BA5B1BFCEDDED
FCF3E2D0BFB2ABABB2BFCEDEEBF2F0EEEEF2F7FCFFFFFFFF
FFFFFEFEFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EEEAE5E1DC
D6D1CBC5BEB7B0A8A19B95918C8987878A8F98A4B2C2D2E0
EEFBECD7C5B7AFADB1BAC7D7E6F0EFECEDF2F8FDFFFFFFFF
FEFEFDFDFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EDE8E3DED8
D2CCC6BFB8B1A9A199928C878381807F81858D99A8B7C5D2
E0F0F4E2D0C1B5AEADB3C0D1E4F0F0EDEFF5FCFFFFFFFFFE
FDFCFCFCFCFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F0ECE7E1DBD5
CEC8C1BAB3ABA39A9189827D79787778797E86919EABB9C7
D6E7F6F0DFCCBAADA9AFBED2E7F6F4F1F4FCFEFFFFFFFEFD
FCFBFAFAFAFBFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFAF7F4F0ECE7E0DAD3
CBC4BCB4ADA59D948A8179736E6D6D6F7379818A95A1B0BF
CFDCE8F2E7D1BCAEABB3C3D7ECFBF9F8FCFEFFFFFFFDFCFB
FAF9F9F9F9FAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFCFBF8F5F1EDE7E0D9D1
C9C0B8B0A8A0988F857B7269636061656C747C848E9CACBC
C7CFD8E3E5D6C5BAB7BDC8D6E5F2FAFEFFFFFFFFFDFBF9F8
F8F7F7F7F8F8F9FAFAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFBF9F7F3EEE8E1D9D1
C8BEB5ACA39B938A81776C625955555A626B75808C9CACB8
BEC3CCDBE7E3D7CCC4C0C3CDDDEEFCFFFFFFFFFCFAF8F7F6
F5F5F5F6F6F7F8F9FAFAFBFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFCFBF8F5F0EAE3DBD2
C8BEB4A9A0978F877F756A5E534C4A4D545E6D7D8F9FABB2
B7BFCCDBE8EFE7D6C4B9BBC9DFF7FDFFFFFFFCF9F7F5F4F3
F3F3F3F4F5F6F7F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFCFCFCFCFCFAF7F3EEE7DFD5
CBC0B4A99F958C847D74695E5248413F4350647A8E9DA7B0
BBC7D2D6D7DADBCEBEB6BFD5F2FCFFFFFFFBF8F5F3F1F0F0
F0F0F1F2F3F4F5F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFCFBFBFBFBFBFBFAF7F2EBE3DA
CFC4B8ACA0958B847C756C6256493C353744576D8294A6B7
C9D4D0C7C3C8D0CFC6C5D4F0FBFEFFFEFAF6F3F0EEEDECEC
EDEDEEF0F1F2F4F6F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFCFBFAF9F9F9F9FAFAF9F6F1E9E0
D6CABEB1A4988E857D7670685D4E3F34333946576E8BAAC6
D6D3C7BEBFC9D9E4E2E3F3FBFEFFFEF9F4F0EDEAE9E8E8E8
E9EAECEDEFF1F3F4F6F8F9FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F7F7F7F8F9F9F6F0E8
DED3C6B9AB9F9388807A767067594A3E363234425F85ABC4
CAC8C7CBD3DFECF1F4FFFFFFFFFEF7F0ECE8E6E4E3E3E3E4
E5E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF9F8F7F5F4F4F4F4F6F8F9F7F0
E7DCD0C3B6A89B9086807D7871675D503F302C3A587B97A7
B5C8DCEDF7ECD9C8C9E7F1FBFCF3EBE6E2E0DEDDDCDDDEDF
E1E3E5E8EAEDEFF2F4F6F8F9FAFBFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF9F7F5F4F2F1F0F0F1F3F6F9F8
F1E7DCCFC2B4A79A918A85807C7974654E3B36415465758D
AFD7EDDFD5D0C2ADA2ABC0E9E7E1DDD9D7D5D4D4D5D6D8DA
DCDFE2E5E8EBEEF0F3F5F7F9FAFBFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F2F0EEEDECEBECEFF2F7
F9F2E9DDD0C2B4A89E968E89898C897A655651504D4F6187
B9D5C2B3B6C2C3AE968E9CB6C3C8CACACACACACBCDCFD1D4
D7DBDEE2E5E9ECEFF2F4F6F8FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EFECE9E8E6E6E7EAEF
F4FAF5EADED1C4B8ADA39A96989C998F847D725D4B4B6898
BBB09EA1B7CEDAC4A18B8A97A3ADB3B7BABCBFC1C4C7CACE
D2D6DBDFE3E7EAEEF1F3F6F8F9FBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F1EDEAE7E4E2E0E0E2E5
EAF1F8F8EDE0D4C8BBB0A8A5A7A7A4A3A6A38C6C5A6587A6
A09095B5E6F4F6D9B39688888F979FA5AAAFB3B7BBBFC4C8
CDD2D7DCE0E4E8ECEFF2F5F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFAF8F6F3F0EDE9E5E1DEDBDADADB
DFE4ECF6FCF1E4D6C9BEB7B5B2AEADB6C3BB9D838193A397
868BAEE5F7FCFCE4C4A79288878A90969DA3A8ADB3B8BDC3
C8CED3D9DEE2E7EBEEF1F4F6F8FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EDE9E4E0DBD7D4D3D2
D4D8DFE7F2FDF4E5D8CEC7BFB7B3B8C8D3C3AEA8B2B49B83
85A8E4F6FCFDF9E7D1B8A3938B898A8E949A9FA6ACB2B8BE
C4CAD0D6DBE0E5E9EDF1F3F6F8FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEE9E4DFDAD5D0CDCB
CACDD1D8E0ECFAF6E9DFD4C7BCBBC5D2D0C5C4D2CCA88A88
A7E2F6FCFEFCF0E4D4C2B0A1958F8C8D90959AA0A6ADB3BA
C1C7CDD4D9DFE4E8ECF0F3F5F8F9FBFCFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F6F3EFEBE5E0DAD4CEC9C5
C3C3C5C9D0DBE7F2F7F0E0D0C6C7CECDC5C7DDE5BA9791AC
E3F6FCFFFEF9EFE1D2C3B4A89D9691909193989DA3A9B0B7
BEC5CBD2D8DDE3E7EBEFF2F5F7F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFDFCFAF8F5F1EDE8E2DCD5CEC7C2
BEBBBABCC1C9D2DCE8F6EDDDD6D6D0C3BDCDF1D7AD9DB4E5
F6FCFFFEF8F6F4E7D6C4B5A89E9893919193979CA1A7AEB5
BCC3CAD0D6DCE2E6EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFBFAF7F4F0EBE5DFD8D0C9C2
BCB6B3B3B5B9BFC7D4E4EAE6E6E3D0BFBFD6F5CEB2B7E8F7
FDFEFFFAF1EDEEF0E3CFBCAB9F9792909092969AA0A6ACB3
BAC1C8CFD5DBE1E6EAEEF1F4F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFEAE3DCD5CDC5
BDB6B1AEADADAFB7C2CED4DAE8ECD5C5CAE2E8CBBFCFF4FE
FEFDFBFAEFE4E1E5EBE1CDB8A69A928E8D8F93989EA4ABB2
B9C0C7CED5DBE0E5EAEEF1F4F6F9FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFBF9F6F3EEE9E2DBD3CB
C2BAB3AEAAA6A7ACB4BABEC8DCE8D8CFDAEBD6C0C2D7EAF8
FCF3EFF4F2E4D8D5DBE5E0CDB8A699918D8E91959BA2A9B1
B8BFC7CED4DAE0E5EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFCFBF9F6F3EEE9E2DBD3
CAC2BBB3ACA7A6A8AAABAEBBCFD7CFD2E7EEC9AEACBDCFDD
E5E3DFE3EEEAD9CCCAD2DEDFD0BBA99C939091949AA0A8AF
B7BFC6CDD4DAE0E5E9EEF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFBFAF9F7F3EFEAE4DD
D5CDC5BDB5AFACABA8A5AAB7C4C4C0CAE7F2CCA5959AA9BA
C9CFCED0DBE9E1CFC2C1C9D7DED3C0AFA29A96979BA0A7AF
B6BEC6CDD4DAE0E5EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFAF9F8F6F4F0ECE6
E0DAD2CAC2BDB9B4ADABB1BBBEB8B8C9E6FBEDB392878D9B
ADB9BDBEC6D7E5D9C5BAB9C2D1DBD6C6B6AAA29F9FA3A9AF
B7BEC6CDD4DAE0E5EAEEF1F4F6F8FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F8F7F6F5F4F1EE
EAE5DFD8D3CECAC2BCBBC1C6C1BAC1D9F6FFF4CBA28B8389
97A5ACADB2C1D6E0D1BEB3B3BDCCD8D8CCBEB3ACA9AAADB2
B9C0C7CED4DBE0E5EAEEF1F4F7F9FAFBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F7F6F5F4F3F2F1
F0EEEAE6E3E0DBD4CFD1D6D4CCCAD9F4FCFFFCF1BF9C8883
8A969FA1A3ACBFD5DBCAB8AFB0BAC8D6D9D2C6BDB6B4B4B8
BCC2C9CFD6DCE1E6EAEEF2F4F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F4F3F2F1F0
F0F0EFEDEEEEEBE6E5E9EBE3DDE2F6FCFEFEF8E3C9AA9286
858D9497979CABC1D5D6C4B4ADAFB9C7D5DBD7CEC6C1BFBF
C2C7CCD2D7DDE2E7EBEFF2F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F6F4F2F1EFEE
EEEDEDEDEFF2F3F2F3FAF9EFEEF8FDFEFEFAEDDECAB29B8C
86898E9190919AACC4D5D1C1B3ADB0BAC7D5DCDBD5CFCBC9
CACDD0D5DADFE4E8ECF0F3F5F7F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F6F5F3F1EFEE
EDECEBEAECEFF0F0F1F4F7F7FBFEFFFFFCF2E7DACAB7A393
8A888B8D8C8B8F9CB1C8D5CEBFB4B0B4BDCAD6DEDFDCD7D4
D3D4D6D9DDE1E6E9EDF0F3F6F8F9FBFCFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F5F3F1EF
EEECEBEAECEDEDECEDF1F7FCFEFFFFFCF5EDE3D7CAB9A899
8F8B8B8C8B898A91A1B7CCD5CDC0B7B4B9C2CDD8E0E3E1DE
DCDCDCDEE1E4E8EBEEF1F4F6F8FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F2
F1EFEEEDEEEFEEEDF0F5FDFEFFFFFDF7F0E9E0D5C9BBADA0
95908E8E8C89888C97A8BDCFD5CDC2BBBABFC7D1DBE3E6E6
E5E3E3E4E6E8EBEDF0F3F5F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F8F7F6
F4F3F2F2F3F3F2F2F6FDFFFFFFFDF8F3EDE6DDD4C9BDB1A5
9B9592918F8C8A8B919EB1C4D3D5CEC6C1C1C6CED7DFE6EA
EAEAE9E9EAECEEF0F2F4F6F8F9FBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F7F7F8F9F9F8F9FDFFFFFFFEFAF5F0EAE4DCD3CABFB4AA
A19B979593918E8D9099A8BACBD7D7D1CBC8C9CDD4DCE4E9
EDEEEEEEEEEFF0F2F4F5F7F9FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFA
FAFAFAFBFDFDFCFEFFFFFFFEFBF7F3EEE9E2DBD3CBC2B8AF
A7A19D9B999693929399A3B2C3D2DADAD5D0CFD0D5DBE1E8
EDF0F1F2F2F3F3F4F6F7F8F9FBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFBFB
FBFBFBFDFEFFFFFFFFFFFEFBF8F5F1ECE7E2DBD4CCC4BCB4
ADA8A4A19F9C9A98989BA3AEBCCBD7DDDDD9D6D6D8DCE1E7
ECF0F3F4F5F5F6F7F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFDFCFCFCFBFB
FBFBFCFDFEFFFFFFFFFFFCFAF7F3F0ECE7E2DCD5CFC8C0BA
B3AEAAA7A5A3A19F9FA0A5AEB9C6D3DDE1E0DEDCDDDFE2E7
EBF0F3F5F7F7F8F8F9FAFAFBFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFC
FCFCFDFEFFFFFFFFFFFDFBF8F5F2EFEBE7E2DDD7D1CBC5BF
B9B5B1AEACABA9A7A6A7AAB0B9C4D0DAE2E5E4E3E2E3E5E8
ECF0F3F6F8F9F9FAFAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFD
FDFDFEFFFFFFFFFFFDFCFAF7F5F2EFEBE8E3DFDAD4CFC9C4
C0BBB8B6B4B2B1AFAEAFB0B5BBC4CED8E1E6E9E8E8E8E9EB
EDF0F3F6F8F9FAFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFFFFFFFFFFFFFEFCFBF9F7F4F2EFECE9E5E1DCD8D3CECA
C6C2BFBDBBB9B8B7B6B6B8BBC0C6CED7DFE6EAECECECEDEE
EFF2F4F6F8FAFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F7F4F2F0EDEAE7E3DFDBD7D3CF
CCC9C6C4C2C1C0BFBEBEBFC1C5CAD0D8DFE6EBEEF0F0F0F1
F2F3F5F7F9FAFBFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFCFBFAF8F7F5F3F0EEEBE9E6E2DFDBD8D5
D2CFCDCBC9C8C7C7C6C6C7C8CBCFD4D9E0E6EBEFF2F3F3F4
F4F5F6F8F9FBFCFCFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFDFCFBFAF8F7F5F3F2EFEDEBE8E5E3E0DDDA
D7D5D3D1D0CFCECECECECECFD1D4D8DCE1E6EBEFF3F4F5F6
F6F7F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFDFCFBFAF9F7F6F4F3F1EFEDEBE9E6E4E1DF
DDDBD9D8D7D6D5D5D4D5D5D6D7D9DCE0E4E8ECF0F3F5F7F8
F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFDFCFBFAF9F8F7F6F4F3F1EFEDECEAE8E5E4
E2E0DFDDDCDCDBDBDBDBDBDCDDDFE1E4E7EAEEF1F4F6F8F9
FAFAFBFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFDFCFCFBFAF9F8F7F5F4F3F1F0EEEDEBE9E8
E6E5E4E3E2E1E1E1E1E1E1E2E2E4E5E7EAEDEFF2F5F7F9FA
FBFBFCFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFDFDFCFBFAFAF9F8F7F6F5F3F2F1F0EEEDEC
EAE9E8E7E7E6E6E6E6E6E6E7E7E8EAEBEDEFF1F3F6F8F9FA
FBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFDFDFCFCFBFAFAF9F8F7F6F5F4F3F2F1F0EF
EEEDECECEBEBEAEAEAEAEBEBECECEDEFF0F2F3F5F7F8FAFB
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFDFDFCFCFBFBFAF9F9F8F7F6F6F5F4F3F2
F1F1F0EFEFEFEEEEEEEEEFEFEFF0F1F2F3F4F5F7F8F9FAFB
FCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFDFDFDFCFCFBFBFAFAF9F9F8F7F7F6F5F5
F4F4F3F3F2F2F2F2F2F2F2F2F2F3F4F4F5F6F7F8F9FAFBFC
FDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFDFDFDFCFCFBFBFAFAF9F9F8F8F7F7
F6F6F6F5F5F5F5F4F4F5F5F5F5F6F6F7F7F8F9F9FAFBFCFC
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFDFDFDFCFCFCFBFBFBFAFAFAF9F9
F8F8F8F7F7F7F7F7F7F7F7F7F7F8F8F8F9F9FAFBFBFCFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFCFCFBFBFBFBFA
FAFAFAF9F9F9F9F9F9F9F9F9F9F9FAFAFAFBFBFCFCFDFDFD
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFCFCFCFCFC
FBFBFBFBFBFAFAFAFAFAFAFBFBFBFBFBFCFCFCFCFDFDFDFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFDFDFD
FCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 65.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 65.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFCFCFCFCFCFDFDFD
FEFEFEFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFCFBFBFBFBFCFCFC
FDFDFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFFFFFFFEFEFDFDFCFCFBFBFAFAFAFAFAFBFB
FCFCFDFEFEFEFEFEFEFDFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFDFCFCFBFAF9F9F9F8F8F9F9FA
FAFBFCFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFD
FDFDFDFDFDFDFDFEFEFEFEFDFCFBFAF9F8F7F7F7F6F7F7F8
F8F9FAFBFCFDFDFDFCFCFCFCFDFDFDFEFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FCFCFCFCFCFCFCFDFDFEFEFDFCFBF9F8F7F6F5F5F4F4F4F5
F6F7F8FAFBFCFCFCFCFBFBFBFCFCFDFDFDFDFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFC
FCFBFBFBFBFBFBFBFCFDFDFDFCFBF9F7F6F4F3F2F2F1F2F2
F3F4F6F7F9FAFBFBFBFBFAFAFBFBFCFCFDFDFDFDFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFB
FAFAF9F9F9F9F9FAFAFBFCFDFCFBF9F7F5F3F1F0EFEEEEEF
F0F1F3F5F7F8F9FAFAFAF9F9FAFAFBFBFCFCFDFDFDFDFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFA
F9F8F8F7F7F7F7F7F8F9FBFCFDFBF9F7F4F2EFEEECEBEBEB
ECEDEFF1F4F6F7F8F9F8F8F8F8F9F9FAFBFCFCFCFDFDFDFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8
F7F6F6F5F4F4F4F4F5F6F8FAFCFCFAF7F4F1EEEBE9E8E7E7
E7E9EBEDF0F3F5F6F7F7F7F6F7F7F8F9FAFBFBFCFCFCFDFD
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7
F6F4F3F2F1F0F0F0F1F3F5F7FAFCFBF8F4F1EDEAE7E5E3E2
E3E4E6E8EBEFF2F4F5F6F5F5F5F6F7F8F9FAFAFBFBFCFCFD
FDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F6F5
F3F2F0EFEEEDECECEDEEF0F3F6FAFCFAF6F1EDE8E5E2DFDE
DEDEE0E3E6EAEEF1F3F4F4F3F3F4F5F6F7F8F9FAFBFBFCFC
FDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F6F5F3
F1EFEDEBEAE8E7E7E7E8EAEDF1F5FAFCF8F3EDE8E3DFDCDA
D9D9DADDE0E5E9EDF0F2F2F2F2F2F3F4F6F7F8F9FAFBFBFC
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F7F6F4F3F1
EFECEAE7E5E3E2E1E1E2E3E7EBF0F5FBFBF5EFE9E3DEDAD6
D4D4D5D7DADFE4E9EDEFF0F0F0F0F1F2F4F6F8F9F9FAFBFC
FCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F7F6F4F3F1EE
ECE9E6E3E1DEDCDAD9DADCDFE3E8EFF6FCF9F2EBE4DED8D4
D1CFCFD1D4D8DEE3E9ECEEEFEEEEEFF1F3F5F6F8F9FAFAFB
FCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F7F6F4F3F0EEEC
E9E6E2DFDCD8D5D3D2D2D3D6DAE0E6EEF7FDF6EEE6DFD8D2
CECBCACBCDD2D7DEE4E9ECEDEDEDEDEFF1F3F5F7F8F9FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F6F4F2F0EEEBE9
E6E2DEDBD7D3CFCCCAC9C9CBD0D5DDE5EFF8FCF3EAE1D9D2
CCC8C6C5C7CBD1D7DFE5E9EBEBEBECEDEFF2F4F6F8F9FAFB
FCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F6F4F3F0EEEBE9E5
E2DEDAD6D1CDC8C4C1BFBFC1C4CAD2DBE5F0FAF9EFE5DCD4
CDC7C3C1C1C5CAD1D9E0E6E9EAEAEAECEEF1F4F6F8F9FAFB
FCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFCFBF9F8F6F5F3F0EEEBE9E5E2
DEDAD6D1CCC7C2BDB9B6B5B5B8BEC5CFDAE6F2FDF6EBE1D7
CEC7C1BEBDBFC4CAD3DBE3E7E9E9EAEBEDF0F3F6F8F9FAFB
FCFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F3F1EEEBE9E5E2DE
DAD6D1CCC7C1BCB6B1ADABAAACB1B8C2CDDAE7F4FEF2E7DC
D2C9C2BCBABABEC4CDD6DFE5E9E9E9EAECEFF2F5F8F9FAFB
FDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F1EFECE9E5E2DEDA
D6D1CCC7C1BBB5B0AAA5A1A0A0A4ABB4C0CDDBE9F7FBEFE3
D8CDC4BDB8B7B9BFC7D1DBE3E8E9E9E9EBEEF2F5F8F9FBFC
FEFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F2EFECE9E6E2DEDAD5
D1CCC7C1BBB6AFA9A39E999696989DA6B2C0CEDEECFAF8EB
DFD3C8BFB8B5B6BBC2CCD7E0E6E9E9E9EBEEF2F6F9FAFCFD
FFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F4F1EEEAE6E2DEDAD5D1
CCC7C1BBB6B0A9A39D97928E8C8D9199A4B2C1D1E1F0FDF4
E7DBCFC4BBB6B4B7BEC7D3DDE6E9EAEAECEFF3F7FAFCFDFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E4DFDAD6D1CB
C6C1BBB5AFA9A39D97918B878483868D97A4B4C4D5E5F3FC
F1E4D7CBC0B8B4B5BAC4D0DCE5EBECECEDF0F4F9FCFDFFFF
FFFFFFFFFEFEFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFDFBFAF8F5F2EFEBE6E1DCD7D1CCC6
C1BBB5AFA9A39D97918B86817E7C7D828B97A7B7C9D9E9F6
F9EEE0D2C5BBB5B5B9C2CEDAE5ECEEEDEEF1F5F9FDFFFFFF
FFFFFEFEFDFDFCFCFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEEAE5DFD9D3CDC7C1
BBB5AFA9A39D96908B85807C7977777A818C9BABBDCFDFEC
F7F6EADBCDC1B9B7BAC1CBD8E3ECEEEEEFF1F6FAFEFFFFFF
FFFEFDFDFCFCFBFBFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFAF8F6F2EEE9E4DED7D0C9C2BB
B5AFA9A39D96908A847F7B77747372757A8491A1B3C5D5E2
EEF6F1E4D6C9C0BBBABFC9D5E2ECF0F0F0F3F8FDFFFFFFFF
FEFDFCFBFBFBFAFAFBFBFBFCFCFDFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFBF9F6F3EFEAE4DDD6CEC6BEB6
AFA8A29C96908A847E797572706F6F71767E8A99AABBCBD9
E5F0F5EDE0D2C6BEBBBFC8D5E3EFF3F3F4F7FDFFFFFFFFFE
FCFBFAFAF9F9F9F9FAFAFBFBFCFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFDFCFAF8F4F0EBE5DED6CDC4BBB2
AAA39C96908B857F79736F6C6B6B6C6F747B8593A2B3C3D2
DFE8F0F2E9DACCC2BEC1CAD8E6F3F9F8F9FDFFFFFFFFFEFC
FBF9F9F8F8F8F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFEFFFEFEFEFEFEFDFDFDFBF9F6F2EDE6DFD7CEC4BAB0
A79E96908A85807A746F6A676566696D737A848F9DADBECD
D9E1E7EDEBE0D3C9C5C8D0DCE9F5FDFDFEFFFFFFFFFDFBFA
F8F7F7F6F6F6F7F7F8F8F9FAFAFBFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFDFDFDFDFDFCFBF8F4EFE9E2D9D0C5BBB0
A59B928B85807C77716C66626060646A717A838E9CABBCCA
D4DAE0E6EBE6DDD4CFCFD3DBE6F1FAFFFFFFFFFFFDFBF9F7
F6F5F5F4F4F5F5F6F6F7F8F9FAFBFBFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFCFCFCFCFCFCFCFAF7F3EDE6DED4C9BDB2
A69B9088817C78746F6A645F5C5B5E656D7783909DACBBC7
D0D6DCE3EBEDE8DFD6D1D2D9E5F1FCFFFFFFFFFCFAF8F6F5
F3F3F2F2F2F3F3F4F5F6F7F8F9FAFBFCFCFDFEFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFDFDFCFCFBFBFAFAFBFBFCFAF7F2EBE3D9CEC3B6
A99D91877F7975726F6A655F5B58595E67738291A0AFBBC6
D0D8DEE2E6E9E9E2D8D1D2DBE9F9FEFFFFFFFCF9F7F5F3F2
F1F0F0F0F0F1F2F3F4F5F6F7F8FAFBFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFEFEFEFDFCFCFBFAF9F9F9F9F9FAFBFAF7F1E9E0D6CABD
B0A2968A817974716F6C68635D585659616E7E90A0AFBDC9
D5DDE0DEDDDFE2E1DAD6DAE6F7FDFFFFFFFCF8F6F3F1EFEE
EDEDEDEDEEEFF0F1F2F4F5F6F8F9FAFBFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF9F8F7F7F6F6F7F8FAFBF7F1E8DED3C6
B9AB9D91857D7672706E6C68635C57575C6877899BAEC0D1
DEE3E1DAD7DAE1E7E5E3E9F7FDFFFFFFFBF8F4F1EFEDECEA
EAEAEAEAEBECEEEFF1F2F4F5F7F8FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFF
FFFEFEFEFDFCFBFAF8F7F6F5F4F3F3F4F6F9FBF8F1E8DED1
C4B6A89B8E847C76737272706B645E5B5C636E7F94ACC4D7
E2E4E1DCDBDFE8F4F8F5FAFDFFFFFEFAF6F3EFEDEAE9E7E6
E6E6E6E7E8EAEBEDEFF1F3F4F6F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFEFEFDFDFCFBF9F8F6F5F3F2F0F0F0F1F3F6FAFAF3E9DE
D1C4B6A89B8F857E7A79797876716B65616168778EA8C0D2
DCE2E7E9EAECECECF0FCFEFFFFFEF9F5F0EDEAE7E5E3E2E2
E1E2E3E4E5E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFEFEFDFDFBFAF9F7F5F4F1EFEEECECECEDF0F4F9FCF5EB
DFD2C5B7AA9D928A8482818282807B736B666A768A9FB2C3
D3E4F3FCFAF1E4D9DBF0F7FDFDF8F2EDEAE6E3E1DFDEDDDC
DDDDDFE0E2E4E7E9EBEEF0F2F4F6F8F9FBFCFCFDFEFEFFFF
FFFFFFFFFF
FFFEFEFEFDFCFAF9F7F5F3F0EEEBE9E8E7E7E9ECF0F6FCF7
EDE1D5C8BBAEA299928E8C8C8E908D857B74757C8693A4B8
D1E6EBE5E6E9DFCFC8CFDCF3F1ECE8E5E1DEDCDAD8D7D7D7
D8D9DADCDFE1E4E7EAECEFF1F4F6F7F9FAFBFCFDFEFEFEFF
FFFFFFFFFF
FFFEFEFEFDFCFAF9F7F5F2EFECE9E7E4E3E2E2E4E7ECF2FA
FAF0E4D8CCBFB4AAA29C99999C9F9E98908A8685868D9FB8
D2DDD5D1D8E6E7D3C3BFC8D5DBDDDBD9D7D5D3D2D1D0D0D1
D2D4D6D8DBDEE1E5E8EBEEF0F3F5F7F8FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFEFEFEFDFCFBF9F7F5F2EFECE8E5E1DFDDDCDCDEE2E7EE
F7FEF4E8DCD1C6BCB3ACA8A7AAADAEACA9A39A908C93A7C0
D0CCC6CBDBEDF4DCC6BBBBC1C7CBCCCCCCCBCAC9C9C9CACB
CDCFD2D4D8DBDFE2E6E9ECEFF2F4F6F8FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFEFEFDFCFBFAF8F5F2EFEBE7E3DFDCD9D7D6D6D9DDE3
EAF3FDF7ECE1D6CCC3BCB8B7B8B9BBBFC1BBAD9F9CA6B9C7
C6C2C6D8F3FBF6E1CBBCB6B5B8BBBDBFC0C0C0C1C1C2C3C5
C7CACDD1D4D8DCE0E4E7EBEEF1F3F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFEFEFDFCFAF8F6F3F0ECE7E3DEDAD6D2D0D0D0D3D8
DEE6EFFAFAF0E5DBD2CBC7C5C3C4C8D0D5CDBEB4B5BEC6C3
BFC4D6F2FBFDFAE6D3C3B8B3B1B1B3B4B6B7B8B9BABBBDC0
C2C6C9CDD1D5DADEE2E6EAEDF0F3F5F7F9FAFBFCFDFEFEFF
FFFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F4F1EDE8E3DED9D4D0CCCAC9CACD
D2D9E2ECF6FCF2E8DFD8D3CFCCCDD4DDE0D8CFCDCFCDC4BE
C3D6F2FBFEFEF9E9DACCC1B8B2AFAEAEAFB0B1B2B4B6B8BB
BEC2C6CACED3D7DCE0E4E8ECEFF2F5F7F9FAFBFCFDFEFEFF
FFFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F5F2EEEAE5DFDAD4CECAC6C4C3C4
C8CDD5DDE8F2F9F3EBE3DCD5D3D5DCE2E2E0E1E2D8C9BFC3
D5F2FBFEFFFCF1E5DAD0C6BEB7B2AFADADADADAEB0B2B4B7
BBBEC3C7CCD0D5DADFE3E7EBEEF1F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFFFFFFFFFEFDFCFBF9F7F4F0ECE7E1DBD5CFC9C4C0BEBD
BFC3C8D0D9E4EEF5F4ECE3DCD9DBDFDFE0E6F1E7D1C3C4D5
F2FBFEFFFDF9F0E3D6CCC4BDB8B4B0AEACACACACADAFB2B5
B8BCC0C5CACFD4D9DDE2E6EAEEF1F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBF8F6F3EFEAE4DED8D1CBC4BFBBB9
B8BABDC3CBD4DEE8F1F2EAE3E1E0DCD9DDEBF8E1CEC9D7F2
FBFEFFFDF7F6F5E9D9CBBFB7B2AFADABAAAAAAAAACADB0B3
B6BABEC3C8CDD2D7DCE1E5E9EDF0F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFAF8F5F1EDE8E2DCD5CEC7C1BBB7
B4B4B5B9BFC6CED9E3EBECEAE9E3DBD7DDEDF7E2D6DAF3FB
FEFFFFF9F0ECEFF2E6D4C3B6ADA7A5A4A4A4A5A7A9ABADB1
B4B8BDC2C7CCD1D6DBE0E5E9EDF0F3F5F7F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFCFBF9F7F4F0ECE7E1DAD3CCC5BEB9
B4B2B1B2B5BAC1CAD4DCE2E9EEE7DDD9E0EEF1E7E5EEFDFF
FEFDFBFAEEE3E0E6EDE5D3C0B1A69F9C9B9C9EA0A3A7AAAE
B2B6BBC0C5CBD0D6DBE0E4E8ECF0F3F5F7F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFEFEFDFCFBFAF9F6F3F0EBE6E0D9D2CBC4BD
B8B4B1B0B0B3B8BFC7CDD5E0EAE8E1E1E9EDE5E0E7F2F3F9
FBF3F0F5F3E3D7D5DCE7E5D4C0AFA29A969596999CA1A5AA
AFB4B9BFC4CACFD5DADFE4E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFEFDFDFCFBFBF9F8F5F3EFEBE6E0D9D3CCC5
BFB9B5B2B1B1B5B9BDC2CBD6E1E3E2E8F4EBDBD1D3D9DDE3
E9E5E1E5F1EBD9CCCAD3E0E4D6C2B0A298939193969A9FA5
ABB1B7BDC3C9CFD4DADFE4E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFEFDFDFCFBFAF9F8F6F4F2EFEBE6E1DBD5CE
C8C2BDB9B6B5B7B8BABEC6D0D7D9DCE8FBEFDDCBC3C3C6CE
D7D8D3D4DFEDE3CFC2C1C9D8E2D9C6B3A49A949293969BA1
A7AEB4BBC1C8CED4D9DFE3E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFCFBFAF9F8F6F5F3F1EEEBE7E3DED8
D3CDC8C3C0BEBEBDBDC0C8CFD2D2D8E6F6FCF4D4C1B9B8BD
C7CCC9C6CCDDE9DAC6B9B8C1D0DDDBCAB8A99E979595999E
A4ABB2B9C0C7CDD3D9DEE3E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFEFDFCFCFBFAF8F7F6F4F3F1EFEDEBE8E5E1
DDD9D4D0CDCBC9C6C6CACFD3D2D4DCECFBFFF9E2CBBBB3B3
BBC2C1BBBCC8DCE4D2BDB2B1BACAD9DBCFBEAFA49D9A9B9E
A3A9B0B8BFC6CDD3D9DEE3E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F4F2F1EFEEECEBE9E7
E5E2DFDCDBD9D6D4D4D8DCDBDADEE9FAFEFFFEF7DBC4B5B0
B3B9BAB4B1B7C8DCDECAB6ABABB4C4D4DBD3C4B6ACA5A2A3
A6ABB1B7BEC6CCD3D9DEE3E8ECEFF2F5F7F9FAFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F2F0EFEDECEBEAE9
E8E8E7E6E6E5E3E2E4E7E9E7E6ECFAFEFFFEFBEEDECABAB0
AFB2B4AFA9A9B4C9DCD8C3B0A6A7B0BFCFD9D6CABEB4AEAB
ACAFB3B9BFC6CDD3D9DFE4E8ECF0F3F5F7F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFAF9F8F6F4F3F1EFEDECEAE9E9
E9E9E9EAECEDEDEEF1F5F5F2F3FBFEFFFFFCF4EADDCDBDB2
ADAEB0ACA5A0A5B5CBDBD2BDACA3A5AEBCCCD8D8D0C6BDB8
B5B6B8BCC2C8CED4DADFE4E9EDF0F3F5F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F4F2F0EEECEBE9E9
E8E8E9EAEDEFF0F2F6FCFDFAFDFEFFFFFDF6EFE6DBCEBFB4
ADACADAAA29B9BA5B7CED9CCB8A9A2A4ADBBCBD7DAD5CDC6
C1BFC0C2C6CBD0D6DBE0E5E9EDF0F3F6F8F9FBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1F0EEECEBEA
E9E9E9EAECEEEFF1F4F9FDFEFFFFFFFDF8F2EBE3D9CDC0B5
AEABABA8A2999599A7BBD0D6C8B5A8A3A5AFBCCBD7DCDAD4
CECAC9C9CCCFD3D8DDE2E6EAEEF1F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFCFBFBF9F8F6F5F3F2F0EEEDEC
EBEBEBECEDEFEFF1F5FAFEFFFFFFFDF9F4EEE7DFD6CCC1B7
AFABAAA8A29993929AAAC0D2D3C5B4A9A5A9B2BECCD8DEDE
DAD6D3D2D2D4D8DBDFE4E8EBEFF2F4F6F8FAFBFCFDFEFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5F4F3F1F0F0
EFEEEEF0F1F2F2F4F9FEFFFFFFFEFAF5F0EBE4DDD4CAC1B7
B0ACAAA7A29B938F929EB0C5D3D1C3B5ACAAAEB6C2CFD9E0
E1DFDCDADADBDCDFE2E6E9EDF0F2F5F7F9FAFBFCFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F7F6F5F4F4F3
F3F2F3F4F5F6F7FAFEFFFFFFFEFAF6F2EDE8E1DAD2C9C0B8
B1ADAAA8A49D958F8F95A3B6C9D4CFC3B7B0AFB4BCC7D2DC
E2E5E4E2E1E1E2E4E6E9EBEEF1F3F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFAF9F8F8F7F6F6F6
F6F6F7F8FAFAFCFEFFFFFFFEFBF7F4EFEBE5DFD8D1C9C1B9
B3AEABA9A59F98918E919BAABDCED5CFC4BBB6B6BBC3CCD6
DFE5E8E8E8E7E7E8EAECEEF0F2F5F6F8FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8F8F8F8
F8F9FAFBFDFEFFFFFFFFFEFBF8F5F1EDE9E3DDD7D0C8C1BA
B4B0ADAAA7A29C95919196A2B2C3D2D6D0C7C0BDBEC2CAD2
DBE3E8EBECECECECEDEFF0F2F4F6F7F9FAFBFCFDFEFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F9F9F9
F9FAFBFDFEFFFFFFFFFEFCF9F6F3EFEBE7E2DCD6D0C9C2BC
B6B2AFACA9A5A09A9593969EAABACAD5D8D2CBC6C4C6CAD1
D9E0E7ECEEF0F0F0F1F2F3F4F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFAFAFAFA
FBFBFCFEFFFFFFFFFFFCFAF7F5F1EEEAE6E1DCD6D0CAC3BE
B9B4B1AFACA9A49F9A97989DA6B3C2D0D9DAD5D0CCCCCED2
D8DFE5EBEFF1F3F3F4F4F5F6F7F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFBFBFBFBFB
FCFDFEFFFFFFFFFFFDFBF8F6F3F0EDE9E5E1DCD6D1CBC5C0
BBB7B4B2B0ADA9A5A09D9C9FA6B0BDCAD6DCDDD9D5D3D3D5
DADFE4EAEEF2F4F5F6F6F7F8F9F9FAFBFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFDFCFCFCFCFCFD
FDFEFFFFFFFFFFFDFBF9F7F5F2EFECE9E5E1DCD7D2CDC8C3
BFBBB8B6B4B1AEABA7A4A2A4A8B0BAC6D1DBE0E0DDDBDADA
DDE0E5E9EEF1F4F6F7F8F9F9FAFAFBFCFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFDFEFE
FFFFFFFFFFFFFEFCFAF8F6F4F2EFECE9E5E1DDD8D4CFCAC6
C2BFBCBAB8B6B4B1AEABA9A9ACB2BAC4CED8E0E3E3E2E0E0
E1E3E6EAEEF1F4F7F8F9FAFAFBFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFF
FFFFFFFFFFFEFDFBFAF8F6F4F1EFECE9E6E2DEDAD6D2CECA
C6C3C1BEBDBBB9B7B4B2B0B0B2B6BCC4CDD6DEE4E7E7E6E5
E6E7E9ECEFF2F5F7F9FAFBFBFCFCFDFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFEFDFCFBF9F7F6F4F1EFECEAE7E4E0DCD9D5D1CE
CAC8C5C3C2C0BFBDBBB9B8B7B8BBBFC6CDD5DDE4E8EBEBEA
EAEBECEEF0F3F5F7F9FAFBFCFDFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFDFBFAF9F7F6F4F2F0EDEBE8E5E2DFDCD8D5D2
CFCCCAC8C7C6C4C3C2C0BFBFBFC1C4C9CFD6DDE3E9ECEEEE
EEEFEFF0F2F4F6F8F9FBFCFCFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFDFCFBFAF9F7F6F4F2F0EEECEAE7E4E2DFDCD9D6
D4D1CFCECCCBCAC9C8C7C6C6C6C8CACED2D8DEE3E9EDF0F1
F2F2F2F3F4F5F7F8FAFBFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFDFCFBFAF9F8F6F5F3F1EFEDEBE9E7E4E2DFDDDA
D8D6D4D3D2D1D0CFCECECDCDCDCED0D3D6DADFE4E9EDF1F3
F4F4F5F5F6F7F8F9FAFBFCFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFDFDFCFBFAF9F8F7F5F4F2F1EFEDEBE9E7E5E3E1DF
DDDBDAD8D7D6D6D5D4D4D3D3D4D4D6D8DADEE2E6EAEEF1F4
F5F6F7F7F8F9F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFCFBFAF9F8F7F6F5F4F2F1EFEEECEAE8E6E5E3
E1E0DEDDDCDBDBDADADAD9D9DADADBDDDFE2E5E8ECEFF2F4
F6F8F8F9F9FAFAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFCFCFBFAF9F8F7F6F5F4F2F1F0EEEDEBEAE8E7
E5E4E3E2E1E0E0E0DFDFDFDFDFE0E1E2E3E5E8EBEDF0F3F5
F7F9FAFAFBFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFDFDFCFCFBFAFAF9F8F7F6F5F4F3F2F1EFEEEDECEA
E9E8E7E6E6E5E5E4E4E4E4E4E4E5E5E6E8E9EBEDEFF2F4F6
F8F9FAFBFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFCFCFBFAFAF9F8F7F7F6F5F4F3F2F1F0EFEE
EDECEBEAEAE9E9E9E8E8E8E9E9E9EAEAEBEDEEF0F2F3F5F7
F8FAFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFDFDFDFCFCFBFBFAF9F9F8F7F6F6F5F4F3F2F2F1
F0EFEFEEEDEDEDEDECECECECEDEDEDEEEFF0F1F2F4F5F7F8
F9FAFBFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFDFDFDFCFCFBFBFAFAF9F9F8F7F7F6F5F5F4F3
F3F2F2F1F1F0F0F0F0F0F0F0F0F0F1F1F2F3F4F5F6F7F8F9
FAFBFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFDFDFDFCFCFCFBFBFAFAF9F9F8F8F7F7F6F6
F5F5F4F4F4F3F3F3F3F3F3F3F3F3F4F4F5F5F6F7F7F8F9FA
FBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFDFDFDFDFCFCFCFBFBFAFAFAF9F9F8F8F8
F7F7F7F6F6F6F6F5F5F5F5F5F6F6F6F6F7F7F8F8F9FAFAFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFDFDFDFDFCFCFCFBFBFBFBFAFAFAF9
F9F9F8F8F8F8F8F8F7F7F8F8F8F8F8F8F9F9F9FAFAFBFBFC
FCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFCFCFCFCFBFBFBFB
FAFAFAFAFAF9F9F9F9F9F9F9F9FAFAFAFAFAFBFBFBFCFCFD
FDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFDFCFCFCFCFC
FCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFDFDFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFDFDFDFDFDFDFD
FDFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFDFDFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFDFDFDFDFDFEFEFEFEFEFEFEFEFEFEFEFE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 70.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 70.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFDFCFCFCFCFCFCFCFCFDFDFDFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFCFBFBFBFBFBFBFBFBFCFCFDFD
FDFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFFFFFEFEFEFEFDFDFCFCFCFBFBFBFBFBFCFCFCFD
FDFDFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFFFFFFFEFEFDFDFCFBFBFAFAF9F9F9F9FAFAFAFB
FCFCFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFD
FDFDFDFEFEFEFEFEFDFCFCFBFAF9F8F8F7F7F7F7F8F8F9F9
FAFBFCFCFCFCFCFCFCFCFCFCFDFDFDFDFEFEFEFEFEFEFEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFC
FCFCFCFDFDFDFEFEFDFDFCFBFAF9F8F7F6F6F5F5F6F6F7F8
F9F9FAFBFBFCFCFCFBFBFCFCFCFCFDFDFDFDFEFEFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFB
FBFBFBFBFCFCFDFEFEFDFCFBF9F8F6F5F4F4F3F3F3F3F4F5
F6F7F8F9FAFAFAFAFAFAFAFBFBFBFCFCFCFDFDFDFDFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFA
FAFAFAFAFAFBFCFDFEFDFCFAF9F7F5F4F2F1F0F0F0F0F1F2
F3F5F6F7F8F9F9F9F9F9F9F9FAFAFBFBFCFCFCFDFDFDFDFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFAFAF9F8
F8F8F8F8F8F9FAFBFDFDFDFBF9F6F4F2F1EFEEEDEDEDEEEF
F0F2F3F5F6F7F8F8F8F8F8F8F9F9FAFAFBFBFCFCFCFDFDFD
FDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFBFBFAF9F8F7F7
F6F5F5F5F5F6F7F9FBFCFDFCF9F6F4F1EFEDEBEAEAE9EAEB
ECEEF0F2F3F5F6F6F6F6F6F7F7F8F8F9FAFAFBFBFCFCFCFD
FDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F8F7F5F4
F3F3F2F2F2F3F4F6F8FAFDFDFAF7F4F1EEEBE9E7E6E6E6E6
E8EAECEEF0F2F4F4F5F5F5F5F5F6F7F8F8F9FAFAFBFBFCFC
FDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F5F3F2
F1F0EFEEEEEFF0F2F4F7FAFDFCF8F4F0EDEAE7E4E3E2E1E2
E3E5E7EAECEFF1F2F3F3F3F3F4F4F5F6F7F8F9F9FAFBFBFC
FCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F6F4F2F1EF
EDECEBEAEAEAEBEDEFF2F6FAFDFBF6F1EDE9E5E2E0DEDDDD
DEE0E2E5E8EBEEEFF1F1F1F1F2F2F3F4F6F7F8F8F9FAFAFB
FCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F5F4F2F0EEEC
EAE8E6E5E4E4E5E6E9ECF1F5FBFEF8F3EEE9E4E0DDDBD9D9
D9DADDE0E3E6EAECEEEFEFEFF0F0F1F3F4F5F6F7F8F9FAFA
FBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFCFBFAF9F8F7F5F4F2F0EEEBE9
E6E4E1DFDEDEDEDFE2E5EAEFF5FCFCF6F0EAE4DFDBD8D6D5
D4D5D7DADDE1E5E9EBEDEDEEEEEEEFF1F2F4F5F6F7F8F9FA
FBFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5F4F2F0EEEBE8E5
E2DFDCDAD8D7D6D7DADDE2E8EFF6FDFAF3ECE5DFDAD6D3D1
D0D0D2D4D8DCE0E5E8EAEBECECECEDEFF1F2F4F5F7F8F8F9
FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5F4F2F0EDEBE8E5E2
DEDAD7D4D1CFCECFD0D4D9DFE6EEF7FFF7EFE7E1DBD6D2CE
CCCCCDCFD2D6DBE0E4E7E9EAEAEBECEDEFF1F3F4F6F7F8F9
FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBFAF9F8F7F5F4F2F0EDEBE8E5E2DE
DAD6D2CECAC7C6C5C7CACED5DCE5EFF8FDF4EBE3DCD6D1CD
CAC8C8CACDD1D6DBE0E4E7E8E9E9EAECEEF0F2F4F5F6F7F9
FAFBFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFEFEFEFDFCFCFBFAF8F7F5F4F2F0EDEBE8E5E2DEDA
D6D1CCC8C3C0BDBCBCBEC3C9D1DBE5F0FAF9F0E7DFD8D2CD
C9C6C5C5C7CBD0D6DCE1E4E6E7E8E9EAECEEF1F3F4F6F7F8
FAFBFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFCFBFAF9F7F6F4F2F0EDEBE8E5E2DEDAD6
D1CCC7C2BDB8B5B2B2B3B7BDC5CFDAE5F1FCF6ECE3DBD4CE
C9C5C3C2C3C6CBD1D7DDE2E5E6E7E8E9EBEDF0F2F4F6F7F8
FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFCFBF9F8F6F4F2F0EDEBE8E5E2DEDAD6D2
CDC8C2BCB7B1ADA9A7A8ABB0B8C2CDDAE7F4FBF2E8E0D8D1
CBC5C2C0C0C2C7CCD3D9DFE3E5E6E7E8EAEDEFF2F4F6F7F9
FAFBFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBFAF8F7F5F3F0EEEBE8E5E1DEDAD6D2CE
C9C3BDB7B1ABA6A19E9D9FA3AAB4C0CDDBE9F6F9EFE5DDD5
CEC7C2BFBEBFC3C8CFD6DCE1E4E5E6E8EAECEFF2F4F6F8F9
FAFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DDDAD6D2CEC9
C4BFB9B3ACA69F9A969494979DA6B2C0CFDEECF8F5ECE3DA
D2CBC5C0BDBDC0C4CBD2DAE0E3E5E6E8E9ECEFF2F5F6F8FA
FBFDFEFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBF9F7F5F2EFECE9E5E1DDD9D5D1CDC9C4
BFBAB4AEA8A19A948F8C8A8C9199A4B2C1D1E1F0F9F3EAE1
D8D0C9C3BEBDBEC2C8CFD7DEE3E6E7E8EAECEFF2F5F7F9FA
FCFDFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFAF9F7F4F1EEEAE6E2DED9D5D0CCC8C3BF
BAB5AFAAA39D96908A858383868D97A4B4C4D5E6F3F8F1E8
DFD7CEC7C1BEBDC0C5CDD5DDE2E6E7E9EAEDF0F3F6F8FAFB
FDFFFFFFFFFFFFFEFEFEFEFDFDFDFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFAF9F6F4F1EDE9E4E0DBD5D0CBC7C2BDB9
B4B0AAA59F99938C86817D7C7D828B97A6B7C9DBEAF6F7EF
E7DED5CCC5C0BEC0C4CBD3DBE2E7E9EAEBEEF1F4F7FAFBFD
FFFFFFFFFFFFFEFEFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFCFBF9F7F4F0ECE8E3DDD7D2CCC6C1BCB7B3
AEAAA5A09B95908A847E7A77777A818C9AABBDCFE0EEF8F6
EEE5DCD3CBC4C0C0C3CAD2DBE2E8EAEBEDEFF2F6F9FBFDFF
FFFFFFFFFFFEFDFDFCFCFCFCFCFCFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFF
FFFFFEFEFEFEFCFBF9F7F4F0ECE7E1DBD5CEC8C1BBB6B1AC
A8A4A09B97928D87827D787574757A8390A0B1C4D6E5F2F9
F5EDE4DBD1C9C4C2C4CAD2DAE3E9ECEDEFF1F4F7FAFDFFFF
FFFFFFFEFEFDFCFCFCFBFBFBFCFCFCFDFDFDFEFEFEFEFFFF
FFFFFFFFFF
FFFFFEFEFFFEFDFCFAF7F4F1ECE7E1DAD3CCC4BDB6B0AAA5
A19D9A96928E8985807C78747273767D8896A7B9CCDCEAF4
F9F4ECE2D8CFC9C6C6CBD2DAE3EAEEEFF0F2F5F8FCFEFFFF
FFFFFEFDFCFCFBFBFBFAFBFBFBFBFCFCFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFEFEFEFFFEFDFCFBF8F5F2EDE8E1DAD2CAC2B9B1AAA49F
9A9793908D8A86827F7B78757373757A838F9FB0C3D4E3EE
F6F8F3EAE0D6CFCAC9CCD2DAE3EBEFF1F2F4F7FAFEFFFFFF
FFFEFDFCFBFAFAFAF9F9FAFAFAFBFBFCFCFDFDFDFEFEFEFF
FFFFFFFFFF
FFFEFDFEFEFEFDFDFCFAF7F3EFE9E3DBD3CAC1B7AEA69E98
93908D8A888683807D7A78767574767A818B99A9BBCCDBE8
F1F6F7F1E8DED5CFCDCED3DBE4ECF2F4F4F6FAFEFFFFFFFF
FEFDFBFAFAF9F9F8F8F8F9F9F9FAFAFBFCFCFDFDFEFEFEFE
FFFFFFFFFF
FFFDFDFEFEFDFDFDFDFBF9F5F1ECE5DDD5CBC1B7ADA39A93
8D89868483817F7D7B7977767677787C828A96A5B5C6D5E2
ECF2F6F5EEE4DBD4D1D1D6DDE6EFF5F7F8FAFEFFFFFFFFFE
FCFBFAF9F8F7F7F7F7F7F7F8F9F9FAFAFBFCFCFDFDFEFEFE
FFFFFFFFFF
FFFDFCFDFDFCFCFDFDFCFBF8F4EFE8E1D8CEC3B8ADA29890
8984807F7E7D7C7B7978767677797B7F858C96A3B1C1D0DD
E7EEF1F3F1EAE1DAD6D6DAE1EAF2F9FBFCFEFFFFFFFFFEFC
FAF9F8F7F6F6F5F5F6F6F6F7F8F8F9FAFBFBFCFDFDFEFEFE
FFFFFFFFFF
FFFDFCFDFCFBFBFCFCFCFCFBF7F3EDE5DDD3C8BCB0A4998F
86807C79797979797877767677797D82889099A4B1BFCDDA
E4EAEDF0F1EEE7E1DDDCDEE4EBF3FAFEFFFFFFFFFFFDFCFA
F8F7F6F5F4F4F4F4F4F4F5F6F7F7F8F9FAFBFCFCFDFDFEFE
FEFFFFFFFF
FFFCFBFCFBFAFAFAFAFBFCFCFBF7F2EBE2D9CEC2B5A89C90
867E79767575767777777676777A7E848B939CA7B3C0CDD8
E1E7EAEDF0F1EEE8E3E1E1E5ECF3FAFEFFFFFFFFFDFBF9F8
F6F5F4F3F2F2F2F2F2F3F4F5F6F7F8F9FAFAFBFCFDFDFEFE
FEFFFFFFFF
FFFCFBFCFBF9F9F9F8F8F9FBFCFBF7F1E9E0D6CABDAFA295
8A8079747272747677787777777A7E848C95A0ABB7C3CED8
E0E6EAECEFF1F1EDE8E4E3E7EDF5FDFFFFFFFFFDFBF9F7F5
F4F2F1F0F0F0F0F0F1F1F2F3F4F6F7F8F9FAFBFCFCFDFEFE
FEFFFFFFFF
FFFBFAFBFAF8F8F7F6F6F6F7F9FBFCF8F1E9DFD3C7B9AB9E
91867D7673727375787A7A7A797A7E838C96A2AEBBC6D1DA
E2E8EBEBEBEDEFEEEAE6E6EAF2FBFEFFFFFFFDFBF8F6F4F3
F1F0EFEEEEEDEEEEEFF0F1F2F3F4F6F7F8F9FAFBFCFDFDFE
FEFFFFFFFF
FFFBFAFBF9F7F6F5F4F3F3F3F5F7FAFDF9F2E9DED2C5B7A9
9B8F847C767474767A7C7E7E7E7D7F838B95A1AFBCC9D5DF
E7ECEDEAE8EAEEF0EFECEDF2FBFEFFFFFFFDFAF8F6F3F1F0
EEEDECEBEBEBEBECEDEEEFF0F2F3F5F6F8F9FAFBFCFDFDFE
FEFFFFFFFF
FFFBFAFBF9F6F5F4F2F1F0F0F0F1F4F7FCFBF3EADED2C4B7
A99B8F857E7978797C808384848383858A939EACBBCBD9E5
EDF0EEEBE8EAEFF5F7F4F6FCFEFFFFFFFDFAF7F5F3F0EEEC
EBEAE9E8E8E8E9EAEBECEDEFF1F2F4F5F7F8FAFBFCFCFDFE
FEFFFFFFFF
FFFBFAFAF8F6F5F3F1EFEDECECECEEF0F5FAFEF5EBE0D3C6
B8AA9E9289837F7F8185898C8C8B8A8A8C929BA8B9CADBE8
F0F3F2EFEDEFF3F8FEFDFEFFFFFFFFFCFAF7F4F1EFEDEAE9
E7E6E5E5E5E5E6E7E8EAECEDEFF1F3F5F6F8F9FAFBFCFDFD
FEFEFEFFFF
FFFBFAFAF8F6F4F2EFEDEBE9E8E7E8EAEDF1F7FEF8EEE2D6
C9BBAEA298908A88898C90949696949291939AA6B5C6D6E4
EEF5F8F8F7F5F2F1F5FDFFFFFFFFFCF9F6F3F0EDEBE8E6E5
E3E2E1E1E1E2E3E4E6E8EAECEEF0F2F4F6F7F9FAFBFCFDFD
FEFEFEFFFF
FFFBFAFAF8F5F4F1EEECE9E6E4E3E3E3E5E8EDF3FAFBF1E6
DACDC0B4A9A099959395989DA0A2A09D9A9A9EA7B3C0CEDC
E9F4FAFBFDF8EFEAECF8FCFEFFFBF8F5F2EFECE9E6E4E2E0
DFDEDDDDDEDFE0E2E3E6E8EAECEFF1F3F5F7F8FAFBFCFDFD
FEFEFEFFFF
FFFBFAFAF8F6F4F1EEEBE7E4E2DFDEDEDEE1E4E9EFF7FCF4
EADED3C7BCB2AAA4A1A0A3A7ABAEAEABA7A5A6AAB1BBC8D7
E6EFEEEEF3F8F0E7E5EAF1FAF9F6F3EFECE9E6E4E1DFDDDB
DAD9D9D9DADBDDDFE1E3E6E8EBEDF0F2F4F6F8F9FAFBFCFD
FEFEFEFEFF
FFFCFBFBF8F6F4F1EDEAE6E3DFDCDAD9D8D9DCE0E5EBF3FA
F8EEE4D9CEC5BCB5B0AEAFB2B7BBBCBAB7B3B1B1B4BBC7D7
E4E7E4E5EEFAF4E8E1E1E6ECEEEDEBE9E6E3E0DEDBD9D7D6
D5D5D5D5D6D8DADCDEE1E4E7E9ECEFF1F3F5F7F9FAFBFCFD
FDFEFEFEFF
FFFCFBFBF9F6F4F1EEEAE6E2DEDAD7D5D3D3D5D7DCE1E8F0
F7FAF2E9DFD6CEC6C1BDBCBEC2C6C9CAC8C4BEBABBC1CDDA
E2E0DFE4EFFCF4E7DEDBDCE0E2E2E2E0DEDCDAD7D5D4D2D1
D0D0D0D1D3D4D7D9DCDFE2E5E8EBEEF0F3F5F7F8FAFBFCFD
FDFEFEFEFF
FFFDFCFBF9F7F5F2EEEBE6E2DDD9D5D2D0CECFD0D4D8DEE5
EDF5FAF5EDE5DDD6D0CCCACBCDD0D5D9D9D3CCC6C7CDD6DE
E0DFE2ECFAFDF4E6DCD7D5D6D7D8D8D7D6D5D3D1D0CECDCC
CCCCCCCDCFD1D3D6D9DCE0E3E6EAEDEFF2F4F6F8FAFBFCFD
FDFEFEFEFF
FFFDFCFCFAF8F6F3F0ECE7E3DED9D4D0CDCACACACCD0D5DC
E3EBF3F9F7F1E9E3DDD9D7D6D7DADFE5E6E0D9D5D6DADEDF
E0E3ECF9FEFEFBEBE0D9D5D3D2D2D1D1D0CFCDCCCAC9C8C8
C8C8C9CACCCED1D4D7DADEE2E5E8ECEFF1F4F6F8F9FBFCFC
FDFEFEFEFF
FFFDFDFDFBF9F7F4F1EDE9E4DFDAD4CFCBC8C6C5C6C9CDD3
D9E1E9F2F8F9F3EDE8E4E0DFDFE2E7EDEFEBE6E4E2E0DFDF
E4ECF9FDFFFEFAEEE5DED9D5D3D1CFCECCCBC9C8C7C6C5C4
C4C5C6C7C9CBCED1D5D8DCE0E4E7EBEEF1F3F5F7F9FAFCFC
FDFEFEFEFF
FFFEFDFDFBFAF8F6F3EFEBE6E1DBD6D0CBC7C4C2C1C3C6CA
D0D7E0E8F0F7F8F4EFEAE7E4E4E7ECF0F2F3F1ECE5DFDDE2
ECF9FEFFFFFDF4EAE2DCD9D7D5D3D0CECCCAC8C6C5C3C2C2
C2C2C3C5C7C9CCCFD3D7DBDFE3E6EAEDF0F3F5F7F9FAFBFC
FDFEFEFEFF
FFFEFEFDFCFBF9F7F4F1EDE8E3DED8D2CCC7C3C0BEBEC0C3
C8CED6DEE7EFF5F7F4EFEAE8E8EAECEEF2F8F7ECE2DDE0EB
F9FDFFFFFEFBF3E8DDD6D2D0D0D0CFCECCCAC8C6C4C2C1C0
C0C1C1C3C5C7CACED1D5D9DDE1E5E9ECF0F2F5F7F9FAFBFC
FDFEFEFEFF
FFFEFEFEFCFCFAF8F6F3EFEBE6E1DBD5CFC9C4C0BDBBBBBD
C1C6CCD4DCE4ECF2F5F2EEEBEBEAEAEBF0FAF8ECE4E3EBF9
FDFFFFFDF8F8F8EEE0D4CBC7C6C6C7C8C8C7C5C4C2C1C0BF
BFBFC0C1C3C6C9CCD0D4D8DCE1E5E8ECEFF2F4F7F8FAFBFC
FDFEFEFEFF
FFFEFEFEFDFCFBF9F7F5F2EEEAE5DFD9D3CDC7C2BEBBBABA
BCBFC4CAD2D9E2E9EFF2F1EFEDEAE8E9EFF9FAF1EDEFFAFE
FFFFFFF9F1EDF1F5ECDCCEC4BEBBBBBCBDBEBFBFBEBEBDBD
BDBEBFC0C2C5C8CBCFD3D7DCE0E4E8EBEFF1F4F6F8FAFBFC
FDFEFEFEFF
FFFEFDFEFDFCFBFAF8F6F4F0EDE8E3DED8D2CCC6C1BDBBB9
B9BBBEC3C9D0D7DFE6EBEFF2F0ECE9EAF0F6F9F8FAFDFEFF
FEFDFCFBEFE6E3E8F1ECDCCCBFB7B2B0B1B2B3B5B6B7B8B9
BABBBDBEC1C3C7CACED2D7DBDFE3E7EBEEF1F4F6F8FAFBFC
FDFEFEFEFF
FFFEFDFEFCFCFBFAF9F7F5F2EFEBE7E2DDD7D2CCC7C2BEBB
BABABCBFC3C8CFD6DCE3E9EFF2EFEDEFF3F3F1F1F4F3F2FA
FCF5F2F8F5E6DBD8DFEBEDDDCCBDB2ABA8A7A7A9ABADB0B2
B4B7B9BCBFC2C5C9CDD2D6DADFE3E7EBEEF1F4F6F8F9FBFC
FDFEFEFEFF
FFFEFDFEFCFCFBFAF9F7F5F3F1EEEAE6E2DDD8D2CDC8C4C0
BEBDBDBEC1C5CACFD5DBE2EAEEEFF1F6F8F1EBE9E8E5E5EA
EEE9E6EAF5EEDCD0CFD6E4ECE0CEBDB0A7A29F9FA1A3A6AA
ADB1B4B8BCC0C4C8CCD1D5DADEE3E7EAEEF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFDFDFCFCFBFAF8F7F6F4F2EFEDEAE6E2DDD9D4D0CBC8
C5C2C1C1C2C5C9CCD1D7DEE5E9ECF0F9FDF4EEE7E1DCDBDE
E3E1DBDCE6F3E6D3C7C5CEDCE9E2D1BFB0A69F9B9A9B9EA1
A5AAAEB3B8BDC1C6CBD0D5D9DEE2E6EAEEF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFDFEFCFCFBFAF8F7F5F4F2F0EEEBE9E6E2DFDBD7D3D0
CDCAC9C8C8C9CBCDD1D6DDE2E5E8EEF6FDFDFAECE3DAD5D7
DCDCD5D0D6E5F0DECABEBDC5D4E3E4D4C3B3A79E9A98989B
9FA3A9AEB4B9BFC4CACFD4D9DEE2E6EAEDF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFDFEFDFCFBFAF8F7F5F4F2F0EEECEAE8E5E3E0DEDBD8
D6D3D2D1D0D1D1D3D6DADFE2E4E8EEF7FEFFFDF4E8DDD5D3
D7D8D2C9C9D4E6EBD6C2B6B5BECDDDE3D8C7B7AAA19B9899
9B9FA4AAB0B6BCC2C8CED3D8DDE2E6EAEDF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFEFEFDFCFBFAF9F7F6F4F2F0EEECEAE9E7E5E4E2E0DF
DDDCDBDADADADADBDEE2E5E6E8ECF4FDFFFFFFFCEEE1D7D2
D3D6D1C7C0C5D3E7E4CEBAAFAEB7C5D6E1DBCCBCAEA59E9B
9B9EA2A7ADB3BAC0C6CDD2D8DDE2E6EAEDF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFEFEFDFCFBFAF9F8F6F4F2F0EEEDEBE9E8E6E5E4E4E3
E3E3E2E3E3E3E4E5E7EBECEDEFF4FCFFFFFFFDF7EFE3D8D2
D1D3D0C6BCBAC3D5E6DEC7B3A9A8B1BFD0DDDCD0C1B4AAA4
A1A0A2A6ACB2B8BFC5CCD2D7DDE1E6EAEDF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E7E6E5E5E5
E6E6E7E9EAEBECEEF1F4F4F4F7FDFFFFFFFEF9F4EDE3D9D2
CFD1D0C7BBB4B6C3D7E5D7C0ADA4A4ACBACBD9DDD4C7BAB1
AAA7A7A9ADB2B8BEC5CBD1D7DDE2E6EAEEF1F3F6F8F9FBFC
FDFEFEFEFF
FFFEFEFEFDFDFCFBFAF9F7F6F4F2F0EEECEAE9E8E7E6E6E6
E7E8E9EBEDEFF1F3F7FBFBFBFEFFFFFFFEFAF6F1EAE2D9D2
CECECEC8BCB1ADB4C4D9E1D0B9A9A0A0A8B6C7D5DCD7CCC1
B8B2AFAFB1B5BABFC5CCD2D7DDE2E6EAEEF1F4F6F8FAFBFC
FDFEFEFEFF
FFFEFEFEFEFDFDFCFBFAF8F7F5F3F2F0EEECEBE9E8E7E7E7
E8E9EAECEEF0F2F5F9FDFFFFFFFFFFFEFBF7F3EEE8E0D8D1
CDCCCCC8BDB1A9A9B4C7DBDDC9B4A59D9EA6B4C4D2DBD9D1
C7BFBAB8B8B9BDC2C7CDD2D8DDE2E7EBEEF1F4F6F8FAFBFC
FDFEFEFEFF
FFFFFEFEFEFDFDFCFBFAF9F8F6F5F3F1F0EEEDEBEAE9E9E9
EAEAECEDEFF1F3F6F9FDFFFFFFFFFEFBF8F4F0EBE5DED6D0
CCCACAC7BEB1A7A3A8B6CADBD8C4B0A29C9EA6B3C2D0DADB
D5CEC7C2C0C0C2C6CACFD4D9DEE3E7EBEFF2F4F6F8FAFBFC
FDFEFEFEFF
FFFFFEFFFEFDFDFCFCFBFAF9F7F6F5F3F2F0EFEEEDECECEC
ECEDEEF0F1F3F5F8FBFFFFFFFFFEFBF8F5F1EDE8E2DBD4CE
CAC8C8C5BEB3A79FA0A9BACEDBD3C0AEA29D9FA7B3C2D0DA
DDD9D4CECBC9C9CBCED2D7DBE0E4E8ECEFF2F5F7F9FAFBFC
FDFEFEFEFF
FFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F3F2F1F0F0EFEFEF
F0F0F1F3F5F6F8FBFEFFFFFFFEFBF9F6F2EFEAE5DFD9D2CD
C9C7C6C4BEB4A89F9B9FABBED1D9CFBDADA29FA1A9B5C3D0
DADFDDD9D5D2D1D1D3D6DADEE2E6E9EDF0F3F5F7F9FAFBFC
FDFEFEFEFF
FFFFFFFFFEFEFEFDFCFCFBFAF9F8F7F6F5F4F3F3F2F2F2F2
F3F4F5F7F8FAFCFFFFFFFFFEFCF9F6F3F0ECE7E2DDD7D1CB
C7C5C4C2BDB5AA9F9999A1AFC2D3D7CBBBADA4A2A5ADB9C5
D2DBE0E1DEDBD9D9D9DBDDE1E4E7EBEEF1F3F6F8F9FBFCFC
FDFEFEFEFF
FFFFFFFFFEFEFEFDFDFCFBFAFAF9F8F7F6F6F5F4F4F4F5F5
F6F7F8FAFBFDFFFFFFFFFEFCFAF7F4F1EDE9E5E0DAD4CFCA
C6C3C2C0BDB6ACA199969AA4B4C6D5D5C9BBAFA8A7ABB3BD
C9D4DDE3E4E3E1E0DFE0E2E4E7EAECEFF2F4F6F8F9FBFCFD
FDFEFEFEFF
FFFFFFFFFEFEFEFDFDFCFCFBFAF9F9F8F7F7F6F6F6F6F6F7
F8F9FAFCFEFFFFFFFFFEFCFAF7F5F2EFEBE7E2DDD8D3CDC9
C5C2C1BFBCB6AEA49B96969DA9BACBD6D4C8BCB2ADADB1B9
C3CED8E0E5E7E7E6E5E5E6E8EAECEEF1F3F5F7F9FAFBFCFD
FEFEFEFEFF
FFFFFFFFFFFEFEFEFDFDFCFBFBFAF9F9F8F8F7F7F7F7F8F9
F9FBFCFEFFFFFFFFFFFCFAF8F6F3F0EDE9E5E0DCD6D1CCC8
C4C1C0BEBBB7B0A79E989699A2AFBFCFD7D3C9BEB7B3B4B9
C0C9D3DCE3E8EAEBEAEAEBEBEDEEF0F2F4F6F8F9FAFBFCFD
FEFEFEFFFF
FFFFFFFFFFFEFEFEFDFDFDFCFBFBFAFAF9F9F9F8F9F9F9FA
FBFCFEFFFFFFFFFFFDFBF9F6F4F1EEEBE7E3DFDAD5D0CBC7
C4C1BFBDBBB7B2AAA29B97989DA8B6C5D2D8D3CBC2BDBABC
C1C7CFD8E0E6EBEDEEEEEEEFF0F1F2F4F6F7F8FAFBFCFDFD
FEFEFEFFFF
FFFFFFFFFFFFFEFEFEFDFDFCFCFBFBFBFAFAFAFAFAFAFBFC
FDFEFFFFFFFFFFFDFBF9F7F5F2F0EDE9E6E2DED9D4D0CBC7
C4C1BFBDBBB8B3ADA69F9A999CA4AFBDCBD6D9D5CEC7C3C2
C4C8CFD6DDE4EAEEF0F1F2F2F3F3F4F6F7F8F9FAFBFCFDFD
FEFEFEFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFBFBFBFBFBFCFCFD
FEFFFFFFFFFFFDFCFAF8F6F4F1EEECE8E5E1DDD9D4D0CBC7
C4C1BFBEBCB9B6B0AAA49F9C9EA2ABB7C4D0D9DBD7D1CCCA
CACCD0D6DCE3E8EDF1F3F4F4F5F6F6F7F8F9FAFBFCFDFDFE
FEFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFCFCFCFDFEFE
FFFFFFFFFFFDFCFAF9F7F5F3F0EEEBE8E4E1DDD8D4D0CCC8
C5C3C0BFBDBBB8B4AEA9A4A1A1A4AAB3BECBD5DCDDDAD6D2
D1D1D4D8DDE2E8ECF0F3F5F6F7F7F8F9F9FAFBFCFCFDFDFE
FEFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFDFDFDFDFEFFFF
FFFFFFFFFEFCFBFAF8F6F4F2EFEDEAE7E4E0DDD9D5D1CDCA
C7C4C2C0BFBDBBB7B3AEAAA7A6A7ABB2BCC6D1DADFE0DDDA
D8D7D9DBDFE3E8ECF0F3F6F7F8F9F9FAFAFBFCFCFDFDFEFE
FEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFEFEFEFFFFFF
FFFFFFFEFDFCFAF9F7F5F3F1EFEDEAE7E4E1DDDAD6D2CFCC
C9C6C4C3C1C0BEBBB8B4B0ADABACAFB4BBC4CED7DFE3E3E1
DFDEDEDFE2E5E9ECF0F3F6F8F9FAFAFBFBFCFCFDFDFEFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFEFDFCFBFAF8F7F5F3F1EFEDEAE8E5E2DEDBD8D4D1CE
CBC9C7C5C4C3C1BFBCB9B6B4B2B2B3B7BDC4CCD5DDE3E6E6
E5E4E3E4E5E8EAEDF0F3F6F8F9FAFBFCFCFDFDFDFEFEFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFFFFFFFFFF
FFFEFEFDFCFBF9F8F6F5F3F1EFEDEBE8E6E3E0DDDAD7D4D1
CECCCAC9C7C6C5C3C1BFBCBAB8B8B9BCC0C6CDD4DCE2E7E9
EAE9E9E9E9EBEDEFF1F4F6F8FAFBFCFCFDFDFDFEFEFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFDFCFBFAF9F8F6F5F3F1F0EEEBE9E7E4E2DFDCD9D7D4
D2D0CECCCBCAC9C8C6C4C2C1BFBFBFC1C4C9CED5DBE2E7EB
EDEDEDEDEDEEEFF1F3F5F7F8FAFBFCFDFDFEFEFEFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFDFCFBFAF9F8F6F5F4F2F0EEECEAE8E6E4E1DFDCDAD7
D5D3D2D0CFCECDCCCBCAC8C7C6C5C6C7C9CDD1D6DCE2E7EB
EEF0F0F0F0F1F2F3F4F6F8F9FAFBFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFBFAF9F8F7F5F4F3F1EFEEECEAE8E6E4E1DFDDDB
D9D7D6D5D3D3D2D1D0CFCECDCCCCCCCDCFD1D5D9DEE2E7EB
EFF1F2F3F3F4F4F5F6F7F8FAFBFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFBFAF9F8F7F6F5F3F2F1EFEDECEAE8E6E4E2E0DF
DDDBDAD9D8D7D6D6D5D4D3D3D2D2D2D3D4D6D9DCE0E4E8EC
EFF2F4F5F6F6F6F7F8F9F9FAFBFCFDFDFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFDFDFCFBFAFAF9F8F7F6F4F3F2F0EFEEECEAE9E7E5E4E2
E1DFDEDDDCDBDBDADAD9D9D8D8D8D8D8D9DBDDE0E3E6EAED
F0F3F5F6F7F8F8F9F9FAFAFBFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFBFBFAF9F8F7F6F5F4F3F2F1EFEEEDEBEAE9E7E6
E5E3E2E1E0E0DFDFDEDEDEDDDDDDDDDEDFE0E1E4E6E9ECEE
F1F4F6F7F8F9FAFAFAFBFBFCFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFCFCFBFBFAF9F8F7F7F6F5F4F2F1F0EFEEEDECEAE9
E8E7E6E5E5E4E4E3E3E3E2E2E2E2E2E3E3E4E6E7E9EBEEF0
F2F4F6F8F9FAFBFBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFDFDFDFCFCFBFAFAF9F8F8F7F6F5F4F3F2F1F0EFEEEDEC
EBEBEAE9E8E8E8E7E7E7E7E6E6E7E7E7E8E8EAEBECEEF0F2
F4F5F7F9FAFBFBFCFCFDFDFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFCFCFCFBFAFAF9F9F8F7F7F6F5F4F3F3F2F1F0EF
EFEEEDEDECECEBEBEBEBEAEAEAEBEBEBECECEDEEEFF1F2F4
F5F7F8F9FAFBFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFCFCFCFBFBFAFAF9F8F8F7F7F6F5F5F4F3F3F2
F1F1F0F0EFEFEFEEEEEEEEEEEEEEEEEFEFF0F0F1F2F3F4F5
F7F8F9FAFBFCFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFDFDFDFDFCFCFBFBFBFAFAF9F9F8F8F7F6F6F5F5F4
F4F3F3F2F2F2F2F1F1F1F1F1F1F1F1F2F2F2F3F4F4F5F6F7
F8F9FAFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFDFDFDFCFCFCFBFBFBFAFAF9F9F8F8F8F7F7F6
F6F6F5F5F5F4F4F4F4F4F4F4F4F4F4F4F5F5F5F6F6F7F8F8
F9FAFBFBFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFDFDFDFDFCFCFCFCFBFBFBFAFAF9F9F9F8F8
F8F8F7F7F7F7F6F6F6F6F6F6F6F6F6F7F7F7F7F8F8F9F9FA
FAFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFDFDFDFDFDFCFCFCFBFBFBFBFAFAFAFA
F9F9F9F9F9F8F8F8F8F8F8F8F8F8F8F8F9F9F9F9FAFAFAFB
FBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFCFBFBFBFB
FBFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFBFBFBFCFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFC
FCFCFCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFCFCFD
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFDFDFDFDFDFDFD
FDFDFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFDFDFDFDFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; endGroup; endGroup; infiniteLoop; loopDistance = -1; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 75.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 75.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFD
FEFEFFFFFEFDFCFBFAFAF9F8F7F6F6F6F6F6F6F7F7F8F9F9
FAFAFBFBFBFBFBFBFBFBFBFCFCFCFCFDFDFDFDFDFEFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFCFCFCFCFC
FDFDFDFEFDFDFCFBF9F8F7F6F5F4F4F3F3F4F4F5F5F6F7F8
F9FAFAFAFAFAFAFAFAFAFBFBFBFCFCFCFCFDFDFDFDFDFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFCFC
FCFCFCFDFDFDFDFDFCFBFAF9F8F8F7F6F6F6F6F6F7F7F8F9
F9FAFBFBFBFBFBFBFBFBFCFCFCFCFCFDFDFDFDFDFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFCFBFBFBFBFB
FBFBFCFCFDFEFFFEFCFBF9F8F6F5F4F3F2F2F2F2F2F3F4F5
F5F6F7F8F8F8F9F9F9F9F9F9FAFAFBFBFBFCFCFCFDFDFDFD
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFAF9F9F9F9
F9F9FAFBFCFDFEFDFBF9F7F5F3F1F0EFEEEEEEEEEEEFF0F2
F3F4F5F6F7F7F7F7F7F7F8F8F8F9F9FAFAFBFBFBFCFCFCFD
FDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFDFDFDFCFCFBFAF9F9F8F7F7F6F6
F6F7F7F8F9FBFCFDFCFAF8F6F4F2F0EEEDEDECECECEDEEEF
F0F2F3F5F6F6F7F7F7F7F7F7F8F8F9F9FAFAFBFBFBFCFCFC
FDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFAF9F8F7F6F6F5F4F4
F3F4F4F5F6F8FAFCFEFDFAF7F4F2EFEDEBEAE9E8E8E9EAEB
ECEEF0F1F2F3F4F4F4F5F5F5F6F6F7F8F8F9F9FAFAFBFBFC
FCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFEFDFDFCFBFBFAF9F8F7F6F4F3F2F1F1
F0F0F1F2F3F5F8FBFEFEFAF7F3F0EDEAE8E6E5E4E4E5E5E7
E8EAECEEEFF1F2F2F2F3F3F3F4F4F5F6F7F8F8F9F9FAFAFB
FBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFEFEFEFDFDFCFBFBFAF9F8F6F5F4F2F1EFEEED
ECECECEDEFF1F3F7FAFEFCF8F4F0EDE9E7E4E3E1E1E1E1E3
E4E6E8EAECEEEFF0F1F1F1F2F2F3F4F5F6F6F7F8F9F9FAFA
FBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFFFEFEFDFDFDFCFBFBFAF9F8F6F5F3F1F0EEECEAE9
E8E7E7E8E9EBEEF1F5FAFFFBF6F2EDE9E5E3E0DEDDDDDDDE
DFE1E3E6E8EBECEEEEEFEFEFF0F1F2F3F4F5F6F7F7F8F9FA
FAFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFEFEFEFDFDFDFCFBFBFAF9F7F6F5F3F1EFEDEBE9E6E4
E3E2E1E2E3E5E8ECF0F5FBFEF9F3EEE9E5E1DEDCDAD9D9D9
DADCDFE1E4E7E9EBECEDEDEDEEEFF0F1F2F3F5F6F6F7F8F9
FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFEFDFDFCFBFBFAF9F7F6F5F3F1EFEDEAE8E5E2E0
DEDCDBDBDCDEE1E4E9EFF5FCFCF6F0EAE5E0DDDAD7D6D5D5
D6D8DADDE0E3E5E8E9EAEBEBECEDEEEFF1F2F3F4F5F6F7F8
F9FAFBFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFEFEFDFDFCFBFBFAF9F7F6F5F3F1EFEDEAE7E4E1DEDB
D8D6D4D3D4D5D8DCE1E7EEF5FCFAF3ECE6E1DCD8D5D3D2D1
D2D3D5D8DBDEE1E4E6E8E9E9EAEBECEDEFF0F2F3F4F5F6F7
F8F9FAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFDFDFCFBFBFAF9F7F6F5F3F1EFEDEAE7E4E1DDDAD6
D2CFCDCCCBCCCFD2D8DEE5EDF6FCF7EFE8E2DDD8D4D2D0CE
CECFD0D3D6DADDE1E3E5E7E8E8E9EAECEDEFF1F2F3F5F6F7
F8F9FAFBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFEFDFDFDFBFBFAF9F7F6F5F3F1EFEDEAE7E4E1DDD9D5D1
CDC9C6C4C3C3C5C8CDD4DCE4EEF6FAF3ECE4DED9D4D1CECC
CBCBCCCFD2D5D9DDE0E3E5E6E7E7E9EAECEEEFF1F3F4F5F6
F8F9FAFBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFDFDFCFBFAF9F8F6F5F3F1EFEDEAE8E5E1DEDAD5D1CC
C7C3BFBCBAB9BABDC2C8D1DAE4EEF7F8F0E8E1DBD6D1CECB
CAC9C9CBCDD1D5D9DDE0E3E4E5E6E7E9EBEDEFF0F2F4F5F6
F7F9FAFBFCFCFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFCFCFAF9F8F6F5F3F1EFECEAE7E5E1DEDAD6D2CDC8
C2BDB8B4B1AFB0B2B6BCC4CED9E4EFF7F4ECE4DED8D3CFCB
C9C7C7C8CACDD1D5DADEE1E3E4E5E6E8EAECEEF0F2F3F5F6
F7F8FAFBFCFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFCFBFAF8F7F5F3F1EFECEAE7E4E1DEDBD7D2CEC9C3
BEB8B2ADA9A7A6A7AAB0B8C1CDD9E5F1F6F1E9E1DBD5D1CD
C9C7C6C6C7CACDD2D7DBDFE1E3E4E5E7E9EBEDEFF1F3F4F6
F7F9FAFBFCFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFCFCFBF9F7F6F4F1EFECEAE7E4E1DEDAD7D3CFCAC5BF
B9B3ADA7A29E9C9C9FA3ABB4C0CCDAE7F2F4EEE6DFD9D4CF
CBC8C6C5C5C7CACFD4D9DDE0E2E4E5E6E8EAEDEFF1F3F5F6
F8F9FAFBFDFDFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFDFBFBFAF8F7F5F2F0EDEAE7E4E0DDDAD6D2CFCBC6C1BC
B6AFA9A29D98949394989EA7B2BFCDDCE9F3F2EBE4DDD8D3
CECAC7C5C4C5C8CCD1D6DBDFE2E3E5E6E8EAEDEFF1F3F5F6
F8F9FBFCFDFEFFFFFFFFFFFFFFFFFFFEFEFEFEFEFFFFFFFF
FFFFFFFFFF
FFFDFBFBFAF8F6F4F1EEEBE8E4E0DDD9D5D2CECAC6C2BDB8
B2ACA59F98928E8B8B8D929AA5B2C0D0DFECF3F0E9E2DCD7
D2CECAC7C5C5C7CACFD5DADEE1E3E5E6E8EAEDEFF2F4F6F7
F9FAFCFDFEFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFFFFFF
FFFFFFFFFF
FFFDFBFBFAF8F5F3F0EDE9E5E1DDD9D4D0CDC9C5C1BDB9B4
AFA9A29C958F89858484888F98A5B3C3D3E2EEF2EEE8E2DC
D7D2CECAC7C6C6C9CED3D9DEE1E4E6E7E9EBEDF0F2F4F6F8
F9FBFCFEFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFFFF
FFFFFFFFFF
FFFDFBFBFAF8F5F2EFEBE7E3DED9D4D0CBC7C3BFBCB8B4B0
ABA6A09A938D87827F7E80858D99A7B7C7D7E6F0F2EDE7E2
DDD8D2CECAC7C7C9CDD2D8DDE1E5E6E8EAECEEF1F3F5F7F9
FAFCFEFFFFFFFFFFFFFEFEFEFDFDFDFDFDFDFEFEFEFEFEFE
FFFFFFFFFF
FFFDFCFBFAF8F5F2EFEAE6E1DCD6D1CBC6C2BDB9B6B2AFAB
A7A39E98928C85807C7A7A7D848E9BABBBCCDCEAF2F1EDE8
E3DED8D3CECAC9CACDD2D7DDE2E5E8E9EBEDEFF2F4F6F8FA
FCFDFFFFFFFFFFFFFEFEFDFDFDFDFDFDFDFDFDFDFEFEFEFE
FFFFFFFFFF
FFFEFCFBFAF8F5F2EEEAE5DFD9D3CDC7C1BCB7B3AFACA9A6
A3A09C97928C86807B7877797E8691A0B0C1D2E1EDF3F2ED
E9E4DED8D3CECCCCCED2D7DDE2E6E9EBECEEF0F3F6F8FAFB
FDFFFFFFFFFFFFFEFDFDFDFCFCFCFCFCFCFDFDFDFDFEFEFE
FEFFFFFFFF
FFFEFDFBFBF9F5F2EFEAE4DED8D1CAC3BDB6B1ACA9A6A3A1
9F9C9995918C87827D7977777A808A97A6B7C8D8E6F1F4F2
EFEAE5DFD8D3CFCECFD3D8DDE3E8EAECEEEFF2F4F7F9FBFD
FFFFFFFFFFFFFEFDFCFCFCFBFBFBFBFCFCFCFCFDFDFDFEFE
FEFFFEFFFF
FFFEFDFCFBFAF6F3EFEBE5DED7D0C8C0B9B2ABA6A29F9C9B
99989693908D88847F7B7978797E85909EAEBFD0DFEBF4F6
F4F0EBE5DED8D4D1D1D4D9DEE4E9ECEEF0F1F3F6F9FBFDFF
FFFFFFFFFEFEFDFCFBFBFBFBFBFBFBFBFBFCFCFCFDFDFEFE
FEFFFEFEFF
FFFEFDFCFCFBF8F4F1ECE6DFD8D0C7BEB6AEA6A09B989594
939392918F8D8A86837F7C7B7B7E848D99A7B7C8D7E5F0F7
F8F5F1EBE5DED8D5D5D6DAE0E5EAEEF0F1F3F5F8FAFCFFFF
FFFFFFFEFDFCFCFBFAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFD
FEFEFEFEFF
FFFDFCFDFEFCF9F6F3EEE8E1D9D1C7BEB4ABA39C96918F8D
8D8D8E8E8D8C8B898683817F7F81858C96A3B1C1D1DFEBF4
F9F9F6F1EBE4DEDAD8D9DCE1E7ECF0F2F3F5F7F9FCFEFFFF
FFFFFEFDFCFBFAFAF9F9F9F9F9F9F9FAFAFAFBFCFCFCFDFD
FEFEFEFEFF
FFFCFBFDFFFDFBF8F5F1EAE4DCD3C9BFB5AAA198918C8887
8687898A8B8B8B8A898786858485888E96A1AEBCCBD9E6F0
F7FAFAF6F0EAE3DFDCDCDEE3E8EEF2F4F5F7F9FBFEFFFFFF
FFFEFDFCFBFAF9F8F8F8F8F8F8F8F8F9F9FAFAFBFCFCFDFD
FDFEFEFEFF
FFFBFAFDFEFDFCFBF8F4EEE7E0D7CDC2B7ACA1978F888381
80818386888A8B8B8B8A8A8A8A8B8E9299A2ADB9C7D5E2EC
F4F8FAF9F5EFE8E3E0DFE1E5EAF0F4F7F8F9FBFEFFFFFFFF
FEFDFBFAF9F8F8F7F7F6F6F6F7F7F7F8F9F9FAFBFBFCFDFD
FDFEFEFEFF
FFFAF9FCFDFBFCFDFCF8F2ECE5DCD2C7BBAFA3988F86807D
7B7C7E8185888A8C8C8D8D8E8F9194989DA5AEB9C5D2DEE9
F1F6F8F9F7F3EDE8E5E3E5E8EDF2F7FAFBFCFEFFFFFFFFFE
FDFBFAF9F8F7F6F6F5F5F5F5F5F6F6F7F8F8F9FAFBFBFCFD
FDFEFEFEFF
FFF9F7FBFBF9FAFDFEFCF7F1EBE2D8CDC1B5A89C9188807B
78787A7D8186898C8E8F90929396999DA3AAB2BBC6D1DCE6
EEF3F5F7F7F5F1EDE9E8E8EBEFF4F9FCFDFFFFFFFFFFFEFC
FBFAF8F7F6F5F4F4F4F3F3F4F4F5F5F6F7F8F9FAFAFBFCFC
FDFEFDFEFF
FFF8F6FAF9F6F8FAFBFDFCF7F1E9E0D5C9BDB0A3978C827C
7776777A7E83888C8F919294969A9EA2A8AFB6BFC8D2DCE5
EDF1F4F5F6F7F5F1EEECECEEF1F6FAFDFFFFFFFFFFFEFCFB
F9F8F7F5F4F3F3F2F2F2F2F2F3F3F4F5F6F7F8F9FAFBFCFC
FDFEFDFEFF
FFF7F4F9F7F4F5F7F7F9FDFEF8F1E8DED3C7B9AC9F93887F
797676787C82878C90939596999CA0A6ACB4BCC4CCD5DDE5
ECF1F3F4F5F7F7F5F2EFEFF0F3F7FBFEFFFFFFFFFEFCFBF9
F8F6F5F3F2F1F1F0F0F0F0F1F1F2F3F4F5F6F7F8F9FAFBFC
FCFEFDFDFF
FFF6F3F8F6F2F3F4F3F4F7FBFFF9F1E8DED2C5B7AA9D9187
7F7A78787C81878C919597999B9EA2A8AFB7C0C9D1D9E0E7
EDF1F3F3F4F5F7F7F4F2F1F2F5F9FEFFFFFFFFFEFCFBF9F7
F6F4F3F1F0EFEFEEEEEEEEEFF0F1F2F3F4F5F6F8F9FAFBFB
FCFDFDFDFF
FFF5F2F7F4F0F0F1EFF0F2F4F8FDFAF2E9DED2C4B7A99D91
88817D7C7D81878D93989B9D9EA0A4A9B0B8C2CCD5DDE4EA
EFF3F4F3F3F4F6F8F7F4F4F5F8FDFFFFFFFFFEFCFBF9F7F5
F4F2F0EFEEEDECECECECEDEDEEEFF0F2F3F4F6F7F8F9FBFB
FCFDFDFDFF
FFF4F2F6F3EEEEEEECECEDEEF1F5FAFCF4EADFD3C6B8AB9F
948B85828285898F969B9FA1A2A4A6AAB0B8C2CDD7E1E9EF
F3F6F6F4F3F4F7FAFAF8F8F9FDFFFFFFFFFEFCFBF9F7F5F3
F1F0EEEDEBEBEAEAEAEAEBEBECEEEFF0F2F3F5F6F8F9FAFB
FCFDFDFDFF
FFF4F1F5F1EDECEBE8E8E8E9EAEDF2F7FBF6ECE1D5C8BBAF
A399918C8A8A8E93999FA4A7A8A9AAACB0B7C0CBD7E3EDF4
F8F9F8F5F4F5F8FCFEFCFCFEFFFFFFFFFEFCFBF9F7F5F3F1
EFEDEBEAE9E8E7E7E7E8E8E9EBECEEEFF1F2F4F6F7F8FAFA
FBFDFCFDFF
FFF4F1F5F1ECEBE9E6E4E4E3E4E6E9EEF3F8F7EFE4D8CCC0
B4A9A099959495999EA4AAADAFB0B0B0B2B7BFC9D5E2EEF6
FBFCFBF9F8F8F9FBFDFEFFFFFFFFFFFEFCFAF9F7F4F2F0EE
ECEAE8E7E6E5E5E4E5E5E6E7E9EAECEEF0F1F3F5F6F8F9FA
FBFDFCFDFF
FFF4F1F4F0EBEAE7E4E2E0DFDFE0E2E5EAEFF5F7F1E8DDD1
C6BBB1A9A39F9FA1A5AAB0B5B7B8B7B7B7B9BEC7D2DEEAF4
FBFEFFFEFCFAF9F9FBFEFFFFFFFFFDFCFAF8F6F4F2EFEDEB
E9E7E5E4E3E2E2E2E2E3E4E5E7E9EAECEEF0F2F4F6F7F9FA
FBFDFCFCFF
FFF4F2F4F0EBE9E6E2DFDDDBDADBDCDEE1E6ECF1F5F3EBE1
D7CCC2B9B2ADABABAEB2B7BDC0C2C1BFBEBEC1C7CFD9E5EF
F7FAF9FAFEFCF8F7F9FDFEFFFFFDFBF9F7F5F3F1EEECEAE7
E5E3E2E0DFDFDFDFDFE0E1E3E5E7E9EBEDEFF1F4F5F7F9F9
FAFCFCFCFF
FFF5F2F5F0EBE9E5E1DEDBD8D7D6D6D8DADEE3E8EEF3F4EE
E6DDD3CAC3BDB9B7B8BBC0C5C9CCCCCAC8C6C6C8CED6E1EC
F4F5F3F5FBFDF8F6F6F8FAFDFCFAF8F6F4F2F0EDEBE8E6E4
E2E0DEDDDCDBDBDCDCDEDFE1E3E5E7EAECEEF1F3F5F6F8F9
FAFCFCFCFF
FFF6F3F5F0ECE9E5E1DDD9D6D4D2D2D2D4D7DBE0E6ECF2F4
F1EBE3DAD3CCC8C5C4C5C8CDD2D6D7D6D4D1CECDCFD5DFEA
F1F1F0F2F9FEF7F3F1F2F4F6F6F5F4F2F0EEECE9E7E4E2E0
DEDCDAD9D9D8D8D9DADBDDDFE1E3E6E8EBEDF0F2F4F6F8F9
FAFCFCFCFF
FFF6F4F6F1ECEAE6E1DDD9D5D2D0CECECFD1D5D9DEE4EAF0
F4F4EFE8E2DBD6D2D0D0D2D5DADEE1E2E1DDD8D5D5D8E0E9
EFEFEFF3FAFDF5EFECECEDEFEFEFEEEDEBEAE7E5E3E1DEDC
DAD8D7D6D5D5D5D6D7D8DADCDFE1E4E7EAECEFF1F3F5F8F9
FAFCFBFCFF
FFF7F5F6F2EEEBE6E2DDD9D4D1CECCCBCBCCCFD3D8DDE3EA
F0F4F6F3EEE8E3DFDCDBDBDDE1E5EAEDECE8E3DFDEE0E4EA
EDEFF2F7FEFEF7EFEBE9E9E9EAEAE9E8E7E5E3E1DFDDDBD9
D7D5D4D3D2D2D2D3D4D6D8DADDE0E3E6E9EBEEF1F3F5F7F8
F9FCFBFCFF
FFF8F7F7F3EFECE8E3DFDAD5D1CDCAC8C8C9CBCED2D7DDE3
EAF0F5F8F6F2EDE9E6E5E4E5E7EBF0F5F5F2EEEAE9E8E9EB
EEF2F7FDFFFFFDF3EDEAE9E8E8E7E7E6E4E2E1DEDCDAD8D6
D4D3D1D0D0D0D0D1D2D4D6D8DBDEE1E4E7EAEDF0F2F4F7F8
F9FCFBFCFF
FFF9F8F8F4F1EEE9E5E0DBD6D1CDCAC7C6C5C7C9CDD2D7DE
E4EBF1F6F9F8F5F1EEECEBEBEDF0F4F9FBF8F5F3F0EEEDEE
F1F6FDFFFFFFFCF5EFECEBEAE9E8E7E6E4E2E0DDDBD9D6D4
D2D1CFCECECDCECFD0D2D4D7DADDE0E3E6E9ECEFF2F4F6F8
F9FCFBFBFF
FFF9F9F9F5F2F0EBE7E3DDD8D3CECAC7C5C3C4C5C8CDD2D8
DEE5ECF2F7FAF9F6F3F1F0EFF0F3F6FAFDFCF8F4F0EEEEF1
F6FCFFFFFFFEF7F1EBE8E7E8E9EAE9E8E6E3E1DEDBD9D6D4
D2D0CECDCCCCCCCDCED0D3D5D8DBDFE2E5E9ECEFF1F4F6F7
F9FBFBFBFF
FFFAF9FAF6F4F2EDE9E5E0DBD6D0CCC8C5C3C2C3C5C8CCD2
D8DFE6ECF2F7FAF9F6F4F2F2F2F4F6F8FCFEF8F2EFEEF0F5
FCFEFFFFFEFDF7EFE7E1DFDFE1E3E6E6E6E4E2DFDCD9D7D4
D2CFCECCCBCBCBCCCDCFD1D4D7DADEE1E5E8EBEEF1F3F6F7
F9FBFBFBFF
FFFAFAFBF7F5F3EFECE8E3DED9D4CFCAC6C3C2C1C2C4C8CC
D2D8DFE6ECF2F7F9F8F5F4F3F3F3F4F6FAFFF9F4F2F2F6FC
FEFFFFFEFAFAFBF4E9E0D9D6D5D7DADDDFE0DFDEDCD9D7D4
D1CFCDCCCBCACACBCCCED0D3D6D9DDE0E4E7EBEEF0F3F6F7
F8FBFAFBFF
FFFAFAFBF7F6F4F1EEEAE6E1DCD7D2CDC9C6C3C2C1C2C5C8
CDD2D8DFE5EBF1F5F7F7F6F4F3F2F2F5F8FDFDFAF9FAFDFF
FFFFFFFBF5F2F4F9F3E7DBD3CECCCDCFD2D4D6D7D7D5D4D2
D0CECCCBCACACACACBCDCFD2D5D9DCE0E3E7EAEDF0F2F5F7
F8FBFAFBFF
FFFAFAFBF8F6F5F2EFECE8E4E0DBD6D1CDC9C6C3C2C2C3C6
C9CDD3D8DEE5EAF0F3F6F7F7F5F3F4F5F8FBFDFEFEFCFEFF
FFFEFEFCF3EBE9EDF5F4E7D9CFC8C4C3C4C6C9CBCCCDCDCD
CCCBCAC9C8C8C9C9CBCCCFD1D4D8DBDFE3E6EAEDF0F2F5F6
F8FBFAFBFF
FFFAFAFBF8F6F6F3F0EEEBE7E3DFDAD6D2CECAC7C5C4C4C5
C7CACFD3D9DEE4E9EEF2F6F8F7F6F7F8FAF9F9F9F7F4F6FC
FDF8F6FBF7EBE2E0E5F0F5E8DACDC4BEBBBBBCBDBFC1C2C3
C4C5C5C5C5C6C7C8C9CBCED1D4D7DBDFE2E6E9EDEFF2F5F6
F8FBFAFBFF
FFFAF9FBF8F6F6F3F1EFECE9E6E2DEDAD6D3CFCCCAC8C7C7
C8CACDD1D5DADFE4E9EEF2F6F8F9FBFDFBF9F8F6F2EFEFF3
F4F0EDF1FAF1E3D9D7DDE9F3EBDCCDC2BAB5B3B2B3B4B6B8
BABCBEBFC1C2C4C5C8CACDD0D3D7DADEE2E5E9ECEFF2F5F6
F8FBFAFBFF
FFFAF9FBF8F6F6F3F1F0EDEAE8E5E2DEDBD8D4D2CFCDCCCB
CBCCCED1D4D8DCE1E5EAEFF3F5F8FBFEFDFBFAF7F1ECEAED
EFEBE5E6EFF9EBDBD1CFD5E2EFEEDECFC2B8B1ADABABACAD
B0B2B5B7BABDBFC2C5C8CBCFD2D6DADEE2E5E9ECEFF2F5F6
F8FBFAFBFF
FFFAFAFBF8F6F6F3F1F0EDEBE9E6E4E1DFDCD9D7D5D3D1D1
D0D1D2D4D6D9DCE0E4E9EDF0F3F5F9FCFEFEFEF9F3ECE9EA
ECE8E1DDE2EFF5E4D3C9C7CEDAEAEFE2D1C3B7AEA9A6A4A5
A6A9ACAFB3B7BABEC2C5C9CDD1D5D9DDE1E5E9ECEFF2F5F6
F8FBFAFBFF
FFFBFAFBF8F7F6F4F2F0EEECEAE8E5E3E1DFDEDCDAD9D8D7
D7D7D7D8DADCDFE2E5E9EDEFF2F5F8FCFFFFFFFBF5EEE9E8
EBE8DFD8D7E0F0F0DCCBC1BFC6D3E3EDE5D4C5B8AEA7A3A1
A1A2A5A8ACB0B5B9BEC2C7CBD0D4D9DDE1E5E8ECEFF2F4F6
F8FBFAFBFF
FFFBFAFBF9F7F6F4F2F0EEECEAE8E6E5E3E2E1DFDFDEDDDD
DDDDDEDFE0E1E3E6E9ECEFF1F3F6FAFEFFFFFFFDF6EFEAE8
EAE9E1D6D1D4E1F1EAD5C4BAB8BFCCDCE9E6D8C8BAAFA7A2
9F9FA0A3A6ABB0B5BABFC4C9CED3D8DCE1E4E8ECEFF2F4F6
F8FBFAFBFF
FFFBFBFCF9F8F7F5F3F1EFEDEBE9E7E5E4E3E2E2E1E1E1E2
E2E3E4E5E6E7E9EBEEF0F2F4F6FAFEFFFFFFFEFBF6F0EAE8
E9EAE3D7CDCBD3E2F1E4CEBDB3B1B8C5D5E4E7DBCCBDB2A9
A3A09FA0A3A7ACB1B6BCC2C7CDD2D7DCE0E4E8ECEFF2F4F6
F8FBFAFBFF
FFFCFBFCF9F8F7F5F3F2F0EDECEAE8E6E5E4E4E3E3E3E4E5
E6E7E8EAEBEDEFF1F3F5F7F8FAFEFFFFFFFEFCF9F5EFEAE7
E8EAE5DACDC6C8D3E5EFDDC7B6ACABB2BFCFDEE5DED0C2B6
ADA6A3A2A3A6AAAEB4BAC0C6CBD1D6DBE0E4E8ECEFF2F5F6
F8FBFAFBFF
FFFCFBFCFAF9F8F6F4F3F1EFEDEBE9E7E6E5E5E4E4E5E6E7
E8EAEBEDEFF1F3F6F8FAFBFCFEFFFFFFFFFDFAF7F3EEE9E6
E6E8E7DDCFC4C1C6D4E7EAD6C0B0A7A6ADB9C9D9E2DFD3C6
BAB1ABA7A6A7AAAEB3B9BEC5CAD0D6DBE0E4E8ECEFF2F5F6
F8FBFAFBFF
FFFCFCFCFAF9F9F7F5F4F2F0EEECEBE9E8E7E6E6E6E6E7E8
EAEBEDEFF1F3F5F8FBFDFEFFFFFFFFFFFDFBF8F5F1EDE8E5
E5E7E7DFD2C5BDBDC6D7E8E5CFBAABA2A2A8B4C4D4DFE0D7
CBBFB7B0ADACADB0B4B9BEC4CAD0D5DBE0E4E8ECEFF2F5F6
F8FBFAFBFF
FFFCFCFDFBFAF9F8F6F5F3F1F0EEECEBEAE9E8E8E8E8E9EA
EBEDEEF0F2F4F7F9FCFEFFFFFFFFFFFDFBF9F6F3EFEBE7E4
E3E4E5E0D5C7BCB7BBC7D9E8DFC9B5A69F9FA5B1C0CFDCE0
D9CFC5BCB7B3B3B4B7BBBFC5CAD0D6DBE0E4E8ECEFF2F5F6
F8FBFAFBFF
FFFDFCFDFBFAFAF8F7F6F4F3F1F0EEEDECEBEAEAEAEAEBEC
EDEEF0F2F4F6F8FAFDFFFFFFFFFFFDFBF9F7F4F1EDE9E5E2
E1E2E3E0D7C9BCB4B3BAC9DBE6D9C3B0A39C9CA3AEBDCCD9
DFDBD3CAC3BEBBBABBBEC2C7CCD1D6DBE0E5E9ECEFF2F5F6
F8FBFAFBFF
FFFDFCFDFCFBFAF9F8F7F5F4F3F1F0EFEEEDEDEDEDEDEEEF
F0F1F3F4F6F8FAFDFFFFFFFFFFFDFBFAF8F5F2EFEBE7E3E0
DEDFE0DFD7CBBEB3AEB1BBCBDDE2D3BEACA09A9BA2ADBBCA
D7DEDDD7CFC9C5C2C2C3C6CACED3D8DCE1E5E9EDF0F3F5F7
F9FBFAFBFF
FFFDFDFDFCFBFBF9F8F7F6F5F4F3F2F1F0F0EFEFEFF0F0F1
F2F4F5F7F9FAFCFFFFFFFFFFFDFBFAF8F5F3F0ECE8E4E1DE
DCDCDDDDD7CCBFB4ACAAB0BDCEDEDECEBAAA9F9A9CA2ADBB
C9D5DDDEDAD5CFCCCACACBCED1D5D9DEE2E6EAEDF0F3F6F7
F9FBFAFBFF
FFFDFDFDFCFBFBFAF9F8F7F6F5F4F3F2F2F1F1F1F2F2F3F4
F5F6F8FAFBFDFFFFFFFFFFFDFBFAF8F6F3F1EDEAE6E2DEDB
DADADADAD6CDC1B5ABA6A8B1C0D1DEDAC9B7A89F9B9DA4AF
BCC9D5DDE0DED9D5D2D1D1D3D5D8DCE0E4E7EBEEF1F4F6F7
F9FBFBFCFF
FFFDFDFEFDFCFBFAF9F9F8F7F6F5F4F4F3F3F3F3F3F4F5F6
F7F9FAFCFEFFFFFFFFFFFDFBFAF8F6F4F1EEEBE7E3E0DCD9
D7D7D7D7D4CDC2B6ACA5A3A8B3C3D4DDD6C6B5A8A09EA0A7
B2BECAD6DEE2E1DEDBD9D8D8DADCDFE2E6E9ECEFF2F4F6F8
FAFCFBFCFF
FFFEFDFEFDFCFCFBFAF9F9F8F7F6F6F5F5F5F5F5F5F6F7F8
F9FBFCFEFFFFFFFFFFFDFBFAF8F6F4F2EFECE9E5E1DDDAD7
D5D4D4D4D2CCC3B8ADA5A0A2AAB7C7D6DCD3C3B5A9A3A2A5
ACB6C1CDD7DFE3E4E2E0DFDEDFE0E2E5E8EBEEF0F2F5F7F8
FAFCFBFCFF
FFFEFEFEFDFCFCFBFBFAF9F9F8F7F7F6F6F6F6F6F7F8F8F9
FBFCFEFFFFFFFFFFFDFBFAF8F6F4F2F0EDEAE6E3DFDBD8D5
D3D2D2D2D0CBC4BAAFA6A09FA3ADBBCAD7DAD0C2B5ACA7A7
AAB1BBC5D0DAE1E6E7E6E5E4E4E5E6E8EAEDEFF1F3F6F7F8
FAFCFBFCFF
FFFEFEFEFDFDFDFCFBFBFAF9F9F8F8F8F7F7F7F8F8F9FAFB
FCFEFFFFFFFFFFFDFCFAF8F7F5F2F0EEEBE8E4E1DDD9D6D3
D1D0CFCFCECAC4BBB1A8A19D9FA6B1BFCED8D8CFC2B7B0AC
ADB1B8C0CAD4DDE4E8EAEAE9E9E9EAEBEDEFF1F3F4F7F8F9
FBFCFCFCFF
FFFEFEFEFEFDFDFCFCFBFBFAFAF9F9F9F9F9F9F9FAFBFCFD
FEFFFFFFFFFFFDFCFAF9F7F5F3F1EEECE9E6E2DFDBD8D4D2
CFCECDCDCCC9C4BCB3AAA39E9DA1A9B5C4D1D9D8CFC4BBB5
B3B4B8BFC7D0D8E0E6EAECEDEDEDEDEEEFF1F2F4F6F7F9FA
FBFCFCFDFF
FFFEFEFEFEFDFDFDFCFCFBFBFAFAFAFAFAFAFAFBFBFCFDFE
FFFFFFFFFFFDFCFBF9F7F6F4F2EFEDEAE7E4E1DDDAD6D3D0
CECDCCCBCAC8C4BDB5ADA5A09E9FA5AEBBC8D4DAD7CFC6BF
BBBABBC0C6CDD5DDE4E9EDEFF0F0F1F1F2F3F4F5F7F8F9FA
FCFDFCFDFF
FFFFFEFFFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFCFDFDFEFF
FFFFFFFFFEFCFBF9F8F6F4F2F0EEECE9E6E3DFDCD8D5D2CF
CDCCCBCAC9C7C4BEB8B0A9A3A0A0A3AAB4C0CDD7DBD8D1CA
C4C1C1C3C7CDD4DBE2E8ECF0F2F3F3F4F4F5F6F7F8F9FAFB
FCFDFCFDFF
FFFFFEFFFEFEFEFDFDFDFCFCFCFCFCFCFCFCFCFDFEFFFFFF
FFFFFFFEFDFBFAF8F7F5F3F1EFEDEAE8E5E2DEDBD8D5D2CF
CDCBCAC9C8C6C4BFBAB3ADA7A3A2A3A8B0BAC6D1DADCD9D4
CECAC8C9CBCFD5DAE1E6EBEFF2F4F5F6F6F7F7F8F9FAFBFB
FCFDFDFDFF
FFFFFFFFFEFEFEFEFDFDFDFDFCFCFCFCFDFDFDFEFFFFFFFF
FFFFFEFDFCFAF9F8F6F4F2F0EEECEAE7E4E1DEDBD8D4D1CF
CDCBCAC9C8C6C4C1BCB7B1ABA7A5A5A9AFB7C1CCD6DDDEDC
D7D3D0CFD0D3D7DBE1E6EBEFF2F4F6F7F8F8F9F9FAFBFBFC
FDFEFDFEFF
FFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFEFEFFFFFFFFFF
FFFEFDFCFBFAF8F7F5F4F2F0EEECE9E7E4E1DEDBD8D5D2CF
CDCBCAC9C8C7C5C2BFBAB5B0ACAAA9ABAFB6BEC8D2DADFE1
DEDBD8D6D6D7DADDE2E6EAEEF2F5F7F8F9FAFAFAFBFCFCFC
FDFEFDFEFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FEFDFCFBFAF9F8F6F5F3F1EFEDEBE9E6E4E1DEDBD8D6D3D0
CECCCBCAC9C8C6C4C1BEB9B5B1AFAEAEB1B6BDC6CFD7DEE2
E3E2DFDDDCDCDEE0E4E7EBEFF2F5F7F8FAFAFBFBFCFCFDFD
FEFEFEFEFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFE
FEFDFCFBFAF9F7F6F4F3F1EFEDEBE9E7E4E2DFDCD9D7D4D2
D0CECDCBCAC9C8C6C4C1BEBAB7B4B3B3B5B9BEC5CDD5DCE2
E5E6E5E3E2E2E2E4E6E9ECEFF2F5F7F9FAFBFCFCFCFDFDFD
FEFEFEFEFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFFFFFFFFFFFFFFFFFFFFFE
FDFCFCFBF9F8F7F6F4F3F1EFEEECE9E7E5E2E0DDDBD8D6D4
D2D0CFCDCCCBCAC9C7C5C2BFBDBAB9B9BABDC1C6CDD4DBE1
E6E9E9E8E7E7E7E8E9EBEEF0F3F5F7F9FAFBFCFDFDFDFEFE
FEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FDFCFBFAF9F8F7F6F4F3F1F0EEECEAE8E6E4E1DFDDDAD8D6
D4D3D1D0CFCECDCCCBC9C7C5C2C0BFBFBFC1C4C9CED4DAE0
E6E9ECECECEBEBECEDEEF0F2F4F6F8F9FBFCFCFDFDFEFEFE
FFFFFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FDFCFBFAF9F8F7F6F5F3F2F0EFEDEBE9E7E5E3E1DFDDDBD9
D7D5D4D3D2D1D0CFCECDCBCAC8C6C5C5C5C6C9CCD0D5DBE0
E5EAEDEEEFEFEFEFF0F1F2F3F5F7F8FAFBFCFDFDFEFEFEFE
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFD
FCFCFBFAF9F8F7F6F5F4F2F1EFEEECEAE9E7E5E3E1DFDDDC
DAD8D7D6D5D4D4D3D2D1D0CECDCCCBCBCBCCCED0D4D8DCE1
E6EAEDF0F1F2F2F2F3F3F4F5F6F8F9FAFBFCFDFDFEFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FCFCFBFAF9F9F8F7F6F4F3F2F0EFEEECEAE9E7E5E4E2E0DF
DDDCDBDAD9D8D7D7D6D5D4D3D2D1D1D0D1D1D3D5D7DBDEE2
E6EAEEF1F3F4F4F5F5F5F6F7F8F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FCFCFBFAFAF9F8F7F6F5F4F3F2F0EFEEECEBE9E8E6E5E3E2
E0DFDEDDDCDCDBDADAD9D9D8D7D7D6D6D6D7D8D9DBDEE1E4
E8EBEEF1F3F5F6F7F7F7F8F8F9FAFBFBFCFDFDFEFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFBFBFAF9F9F8F7F6F5F4F3F2F0EFEEEDEBEAE9E7E6E5
E4E3E2E1E0DFDFDEDEDDDDDDDCDCDBDBDBDCDDDEE0E2E4E7
EAEDEFF2F4F6F7F8F9F9F9FAFAFBFBFCFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFCFBFAFAF9F8F8F7F6F5F4F3F2F1F0EFEEECEBEAE9E8
E7E6E5E4E4E3E3E2E2E2E1E1E1E0E0E0E0E1E1E2E4E5E7E9
ECEEF1F3F5F7F8F9FAFAFBFBFBFCFCFDFDFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFCFCFBFBFAFAF9F8F8F7F6F5F4F4F3F2F1F0EFEEEDECEB
EAE9E9E8E7E7E6E6E6E5E5E5E5E5E4E5E5E5E6E6E7E9EAEC
EEF0F2F4F6F7F9FAFBFBFBFCFCFCFDFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFD
FDFDFCFCFBFBFAFAF9F9F8F7F7F6F5F4F3F3F2F1F0EFEFEE
EDECECEBEBEAEAE9E9E9E9E9E9E9E9E9E9E9EAEAEBECEDEF
F0F2F4F5F7F8F9FAFBFCFCFDFDFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFDFCFCFCFBFBFAFAF9F8F8F7F7F6F5F5F4F3F3F2F1F1
F0EFEFEEEEEEEDEDEDECECECECECECECEDEDEDEEEEEFF0F1
F2F4F5F6F8F9FAFBFCFCFDFDFDFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFDFDFDFCFCFCFBFBFAFAF9F9F8F8F7F7F6F6F5F4F4F3F3
F2F2F1F1F1F0F0F0EFEFEFEFEFEFEFEFEFF0F0F1F1F2F3F3
F4F5F7F8F9FAFBFBFCFDFDFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFDFDFDFCFCFBFBFBFAFAF9F9F9F8F8F7F7F6F6F5F5
F4F4F4F3F3F3F3F2F2F2F2F2F2F2F2F2F3F3F3F3F4F4F5F6
F7F7F8F9FAFBFBFCFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFDFDFDFDFCFCFCFBFBFBFAFAFAF9F9F9F8F8F8F7
F7F7F6F6F6F6F5F5F5F5F5F5F5F5F5F5F5F5F6F6F6F7F7F8
F8F9F9FAFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFDFDFDFDFCFCFCFCFBFBFBFAFAFAF9F9F9F9F8
F8F8F8F7F7F7F7F7F6F6F6F6F6F6F6F6F6F7F7F7F7F8F8F9
F9FAFAFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFDFDFDFDFCFCFCFCFCFBFBFBFBFAFAFAFA
F9F9F9F9F9F8F8F8F8F8F8F8F8F8F8F8F9F9F9F9F9FAFAFA
FBFBFCFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFEFEFEFEFEFEFEFEFDFDFDFDFDFDFCFCFCFCFC
FCFCFCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFC
FCFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFCFCFCFCFCFCFB
FBFBFBFBFBFBFBFAFAFAFAFAFAFAFAFAFAFAFBFBFBFBFBFB
FCFCFCFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFEFEFDFDFDFDFDFDFDFCFCFCFCFC
FCFCFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFCFCFCFCFC
FDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
.004  w
.01923  .94745  m
.41194  .55474  L
.43574  .57854  L
.04303  .97125  L
s
.94745  .01923  m
.55474  .41194  L
.57854  .43574  L
.97125  .04303  L
s
.44526  .52142  m
.46906  .54522  L
.54522  .46906  L
.52142  .44526  L
.44526  .52142  L
s
% End of Graphics
MathPictureEnd
:[font = section; inactive; Cclosed; preserveAspect; startGroup; ]
Experiment 3: Interaction
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Initial condition
:[font = input; preserveAspect; endGroup; ]
ka = { 64.0,64.0}; aa = 0.08^2; xa0 = {0.25, 0.25};
kb = {-64.0,64.0}; ab = 0.08^2; xb0 = {0.75, 0.25};
psi0=Table[Block[{xa={x1,x2}-xa0,xb={x1,x2}-xb0},
                 Exp[I*ka.xa-xa.xa/(2*aa)]+
                 Exp[I*kb.xb-xb.xb/(2*ab)]],
           {x1,0,1,dx[[1]]},{x2,0,1,dx[[2]]}];
psi0=1.4*psi0/Sqrt[Plus@@(Plus@@(psi0*Conjugate[psi0]))*dx[[1]]*dx[[2]]];
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; ]
Potential function
:[font = input; preserveAspect; ]
potential = Function[{x,t}, 0];
:[font = input; preserveAspect; endGroup; ]
drawpot={};
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup; animationSpeed = 0; infiniteLoop; loopDistance = 1; ]
Animation
:[font = input; preserveAspect; animationSpeed = 0; ]
schroed2d[0, $PSI->psi0,$T->0,$VFUNC->potential];
:[font = input; preserveAspect; startGroup; animationSpeed = 0; ]
plotit[];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; animationSpeed = 0; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  0.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  0.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFC
FCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFA
FAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8F8F7
F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8
F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F4
F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5
F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2F1F0
F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2
F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EEEDECEB
EBEBEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EEED
ECEBEBEBEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E7E6E5
E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E7
E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2E0DFDD
DDDCDDDDDFE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2E0
DFDDDDDCDDDDDFE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFDFE
FEFFFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E4E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFDFDFEFF
FFFFFFFFFFFFFEFDFDFCFBF9F8F6F4F1EEEBE8E4E1DEDBD8
D6D4D3D3D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFDFE
FEFEFFFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DDD9D5D1CECBC9
C8C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DDD9D5D1CE
CBC9C8C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFCFD
FEFEFFFFFF
FFFFFEFEFDFCFBFAF8F6F4F0EDE9E4E0DBD5D0CBC6C2BFBC
BABABABCBFC2C6CBD0D5DBE0E4E9EDF0F3F6F8FAFBFCFDFE
FFFFFEFFFFFEFDFCFBFAF8F6F3F0EDE9E4E0DBD5D0CBC6C2
BFBCBABABABCBFC2C6CBD0D5DBE0E4E9EDF0F4F6F8FAFBFC
FDFEFEFFFF
FFFFFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CCC6C0BAB5B1AE
ACABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FAFCFDFE
FEFEFEFEFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CCC6C0BAB5
B1AEACABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FAFC
FDFEFEFFFF
FFFEFEFDFCFBF9F7F5F2EEEAE4DFD8D1CAC2BAB3ACA6A19D
9B9A9B9DA1A6ACB3BAC2CAD1D8DFE4EAEEF2F5F7F9FBFCFD
FEFEFEFEFEFDFCFBF9F7F5F2EEEAE4DFD8D1CAC2BAB3ACA6
A19D9B9A9B9DA1A6ACB3BAC2CAD1D8DFE4EAEEF2F5F7F9FB
FCFDFEFEFF
FFFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C0B7AEA59D96908C
8988898C90969DA5AEB7C0C9D1D9E0E6EBEFF3F6F8FAFCFD
FEFEFEFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C0B7AEA59D96
908C8988898C90969DA5AEB7C0C9D1D9E0E6EBEFF3F6F8FA
FCFDFEFEFF
FEFEFDFCFBF9F7F4F1EDE8E2DBD3CAC0B6ACA1978E857F79
767576797F858E97A1ACB6C0CAD3DBE2E8EDF1F5F7F9FBFD
FEFEFDFEFEFDFBF9F7F5F1EDE8E2DBD3CAC0B6ACA1978E85
7F79767576797F858E97A1ACB6C0CAD3DBE2E8EDF1F4F7F9
FBFCFDFEFE
FEFEFDFCFAF9F6F3EFEAE4DDD5CCC2B7ACA094887E746C66
636163666C747E8894A0ACB7C2CCD5DDE4EAEFF3F6F8FAFC
FDFDFDFDFDFCFAF8F6F3EFEAE4DDD5CCC2B7ACA094887E74
6C66636163666C747E8894A0ACB7C2CCD5DDE4EAEFF3F6F9
FAFCFDFEFE
FEFEFDFBFAF8F5F1EDE7E1D9D0C6BAAEA19486796D635A53
4F4E4F535A636D798694A1AEBAC6D0D9E1E7EDF1F5F8FAFC
FDFDFDFDFDFCFAF8F5F1EDE7E1D9D0C6BAAEA19486796D63
5A534F4E4F535A636D798694A1AEBAC6D0D9E1E7EDF1F5F8
FAFBFDFEFE
FEFDFCFBF9F7F4F0EBE5DED5CBC0B3A59788796B5E524841
3C3B3C4148525E6B798897A5B3C0CBD5DEE5EBF0F4F7F9FB
FDFDFDFDFDFBF9F7F4F0EBE5DED5CBC0B3A59788796B5E52
48413C3B3C4148525E6B798897A5B3C0CBD5DEE5EBF0F4F7
F9FBFCFDFE
FEFDFCFBF9F6F3EEE9E2DBD1C6BAAC9D8E7E6D5E4F423830
2B292B3038424F5E6D7E8E9DACBAC6D1DBE2E9EFF3F6F9FB
FDFDFCFDFDFBF9F6F3EFE9E2DBD1C6BAAC9D8E7E6D5E4F42
38302B292B3038424F5E6D7E8E9DACBAC6D1DBE2E9EEF3F6
F9FBFCFDFE
FEFDFCFAF8F5F2EDE7E0D8CEC2B5A6968574635242352921
1B1A1B212935425263748596A6B5C2CED8E0E7EDF2F5F8FB
FCFCFCFCFCFBF8F5F2EDE7E0D8CEC2B5A696857463524235
29211B1A1B212935425263748596A6B5C2CED8E0E7EDF2F5
F8FAFCFDFE
FEFDFCFAF8F5F1ECE6DFD6CBBFB1A1907F6C5A4838291D14
0F0D0F141D2938485A6C7F90A1B1BFCBD6DFE6ECF1F5F8FA
FCFCFCFCFCFAF8F5F1ECE6DFD6CBBFB1A1907F6C5A483829
1D140F0D0F141D2938485A6C7F90A1B1BFCBD6DFE6ECF1F5
F8FAFCFDFE
FEFDFBFAF7F4F0EBE5DDD4C9BCAE9D8C796653413021140B
0503050B142130415366798C9DAEBCC9D4DDE5EBF0F4F7FA
FCFCFCFCFCFAF7F4F0EBE5DDD4C9BCAE9D8C796653413021
140B0503050B142130415366798C9DAEBCC9D4DDE5EBF0F4
F7FAFBFDFE
FEFDFBFAF7F4F0EBE4DDD3C8BAAC9B8976634F3C2B1B0F05
000000050F1B2B3C4F6376899BACBAC8D3DCE5EBF0F4F7FA
FCFCFCFCFCFAF7F4F0EBE5DCD3C8BAAC9B8976634F3C2B1B
0F05000000050F1B2B3C4F6376899BACBAC8D3DDE4EBF0F4
F7FAFBFDFE
FEFDFBFAF7F4F0EBE4DCD3C7BAAB9A8875614E3B291A0D03
000000030D1A293B4E6175889AABBAC7D3DCE4EBF0F4F7FA
FCFCFCFCFCFAF7F4F0EBE4DCD3C7BAAB9A8875614E3B291A
0D03000000030D1A293B4E6175889AABBAC7D3DCE4EBF0F4
F7FAFBFDFE
FEFDFBFAF7F4F0EBE4DDD3C8BAAC9B8976634F3C2B1B0F05
000000050F1B2B3C4F6376899BACBAC8D3DCE5EBF0F4F7FA
FCFCFCFCFCFAF7F4F0EBE5DCD3C8BAAC9B8976634F3C2B1B
0F05000000050F1B2B3C4F6376899BACBAC8D3DDE4EBF0F4
F7FAFBFDFE
FEFDFBFAF7F4F0EBE5DDD4C9BCAE9D8C796653413021140B
0503050B142130415366798C9DAEBCC9D4DDE5EBF0F4F7FA
FCFCFCFCFCFAF7F4F0EBE5DDD4C9BCAE9D8C796653413021
140B0503050B142130415366798C9DAEBCC9D4DDE5EBF0F4
F7FAFBFDFE
FEFDFCFAF8F5F1ECE6DFD6CBBFB1A1907F6C5A4838291D14
0F0D0F141D2938485A6C7F90A1B1BFCBD6DFE6ECF1F5F8FA
FCFCFCFCFCFAF8F5F1ECE6DFD6CBBFB1A1907F6C5A483829
1D140F0D0F141D2938485A6C7F90A1B1BFCBD6DFE6ECF1F5
F8FAFCFDFE
FEFDFCFAF8F5F2EDE7E0D8CEC2B5A6968574635242352921
1B1A1B212935425263748596A6B5C2CED8E0E7EDF2F5F8FB
FCFCFCFCFCFBF8F5F2EDE7E0D8CEC2B5A696857463524235
29211B1A1B212935425263748596A6B5C2CED8E0E7EDF2F5
F8FAFCFDFE
FEFDFCFBF9F6F3EEE9E2DBD1C6BAAC9D8E7E6D5E4F423830
2B292B3038424F5E6D7E8E9DACBAC6D1DBE2E9EFF3F6F9FB
FDFDFCFDFDFBF9F6F3EFE9E2DBD1C6BAAC9D8E7E6D5E4F42
38302B292B3038424F5E6D7E8E9DACBAC6D1DBE2E9EEF3F6
F9FBFCFDFE
FEFDFCFBF9F7F4F0EBE5DED5CBC0B3A59788796B5E524841
3C3B3C4148525E6B798897A5B3C0CBD5DEE5EBF0F4F7F9FB
FDFDFDFDFDFBF9F7F4F0EBE5DED5CBC0B3A59788796B5E52
48413C3B3C4148525E6B798897A5B3C0CBD5DEE5EBF0F4F7
F9FBFCFDFE
FEFEFDFBFAF8F5F1EDE7E1D9D0C6BAAEA19486796D635A53
4F4E4F535A636D798694A1AEBAC6D0D9E1E7EDF1F5F8FAFC
FDFDFDFDFDFCFAF8F5F1EDE7E1D9D0C6BAAEA19486796D63
5A534F4E4F535A636D798694A1AEBAC6D0D9E1E7EDF1F5F8
FAFBFDFEFE
FEFEFDFCFAF9F6F3EFEAE4DDD5CCC2B7ACA094887E746C66
636163666C747E8894A0ACB7C2CCD5DDE4EAEFF3F6F8FAFC
FDFDFDFDFDFCFAF8F6F3EFEAE4DDD5CCC2B7ACA094887E74
6C66636163666C747E8894A0ACB7C2CCD5DDE4EAEFF3F6F9
FAFCFDFEFE
FEFEFDFCFBF9F7F4F1EDE8E2DBD3CAC0B6ACA1978E857F79
767576797F858E97A1ACB6C0CAD3DBE2E8EDF1F5F7F9FBFD
FEFEFDFEFEFDFBF9F7F5F1EDE8E2DBD3CAC0B6ACA1978E85
7F79767576797F858E97A1ACB6C0CAD3DBE2E8EDF1F4F7F9
FBFCFDFEFE
FFFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C0B7AEA59D96908C
8988898C90969DA5AEB7C0C9D1D9E0E6EBEFF3F6F8FAFCFD
FEFEFEFEFEFDFCFAF8F6F3EFEBE6E0D9D1C9C0B7AEA59D96
908C8988898C90969DA5AEB7C0C9D1D9E0E6EBEFF3F6F8FA
FCFDFEFEFF
FFFEFEFDFCFBF9F7F5F2EEEAE4DFD8D1CAC2BAB3ACA6A19D
9B9A9B9DA1A6ACB3BAC2CAD1D8DFE4EAEEF2F5F7F9FBFCFD
FEFEFEFEFEFDFCFBF9F7F5F2EEEAE4DFD8D1CAC2BAB3ACA6
A19D9B9A9B9DA1A6ACB3BAC2CAD1D8DFE4EAEEF2F5F7F9FB
FCFDFEFEFF
FFFFFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CCC6C0BAB5B1AE
ACABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FAFCFDFE
FEFEFEFEFEFEFDFCFAF9F7F4F1EDE9E4DFD9D3CCC6C0BAB5
B1AEACABACAEB1B5BAC0C6CCD3D9DFE4E9EDF1F4F7F9FAFC
FDFEFEFFFF
FFFFFEFEFDFCFBFAF8F6F4F0EDE9E4E0DBD5D0CBC6C2BFBC
BABABABCBFC2C6CBD0D5DBE0E4E9EDF0F3F6F8FAFBFCFDFE
FFFFFEFFFFFEFDFCFBFAF8F6F3F0EDE9E4E0DBD5D0CBC6C2
BFBCBABABABCBFC2C6CBD0D5DBE0E4E9EDF0F4F6F8FAFBFC
FDFEFEFFFF
FFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DDD9D5D1CECBC9
C8C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFCFDFEFE
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDEAE6E2DDD9D5D1CE
CBC9C8C7C8C9CBCED1D5D9DDE2E6EAEDF0F3F6F8FAFBFCFD
FEFEFFFFFF
FFFFFFFEFEFEFDFCFBF9F8F6F4F1EEEBE8E4E1DEDBD8D6D4
D3D3D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFDFDFEFF
FFFFFFFFFFFFFEFDFDFCFBF9F8F6F4F1EEEBE8E4E1DEDBD8
D6D4D3D3D3D4D6D8DBDEE1E4E8EBEEF1F4F6F8F9FBFCFDFE
FEFEFFFFFF
FFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2E0DFDD
DDDCDDDDDFE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2E0
DFDDDDDCDDDDDFE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFDFE
FEFFFFFFFF
FFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E7E6E5
E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E7
E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EEEDECEB
EBEBEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EEED
ECEBEBEBEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2F1F0
F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2
F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F4
F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5
F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8F8F7
F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8
F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFA
FAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFA
FAFAFAFAFAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFB
FBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFC
FCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
:[font = input; Cclosed; preserveAspect; startGroup; animationSpeed = 0; ]
Do[Do[schroed2d[dt],{5}]; plotit[], {17}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; animationSpeed = 0; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[(  5.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[(  5.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFD
FDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFD
FDFDFDFDFDFDFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFBFB
FBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAF9FAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFAFA
F9FAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8F8F7F7
F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F4F4
F4F4F4F5F5F6F7F8F8F9FAFBFCFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F2
F2F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2F1F0F0
F0F0F0F1F2F2F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECEBEBEAEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFE
FFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EEEDECEBEB
EAEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F5F3F1EFEDEBE9
E7E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFE
FFFEFEFEFFFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E7E6E5E4
E4E4E5E6E7E9EBEDEFF1F3F5F6F8F9FBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F1EFECEAE7E4E2
E0DEDDDCDCDCDDDEE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFE
FEFEFEFEFEFEFDFCFBF9F8F6F4F2EFEDEAE7E5E2E0DEDDDC
DCDCDDDEE0E2E4E7EAECEFF1F4F6F8F9FBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F3F1EEEAE7E4E0DDDA
D7D5D3D2D2D2D3D5D7DADDE1E4E7EBEEF1F3F6F8F9FBFCFD
FEFEFDFEFEFDFCFBF9F8F6F3F1EEEBE7E4E1DDDAD7D5D3D2
D2D2D3D5D7DADDE0E4E7EAEEF1F3F6F8F9FBFCFDFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBF9F8F6F3F0EDE9E5E1DDD8D4D0
CDCAC8C7C6C7C8CACDD1D5D9DDE1E6E9EDF0F3F6F8F9FBFC
FEFDFDFDFEFCFBF9F8F6F3F0EDE9E6E1DDD9D5D1CDCAC8C7
C6C7C8CACDD0D4D8DDE1E5E9EDF0F3F6F8F9FBFCFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E4DFDAD4CFCAC5
C1BEBBBAB9BABBBEC2C6CBD0D5DADFE4E9EDF0F3F6F8FAFC
FDFDFCFDFDFCFAF8F6F3F0EDE9E4DFDAD5D0CBC6C2BEBBBA
B9BABBBEC1C5CACFD4DADFE4E8ECF0F3F6F8FAFBFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F6F4F1EDE8E3DED8D2CBC5BEB9
B4AFACAAAAABADB0B4B9BFC5CCD2D9DEE4E9EDF1F4F6F8FB
FDFCFCFCFDFBF8F6F4F1EDE9E4DED9D2CCC5BFB9B4B0ADAB
AAAAACAFB4B9BEC5CBD2D8DEE3E8EDF1F4F6F9FAFCFDFEFE
FFFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F1EEE9E4DED7D0C9C1B9B2AB
A5A09C9A999A9DA0A6ACB3BAC2C9D1D8DEE4E9EEF2F4F7FA
FCFBFBFBFCFAF7F4F2EEE9E4DED8D1C9C2BAB3ACA6A09D9A
999A9CA0A5ABB2B9C1C9D0D7DEE4E9EEF1F5F7F9FBFCFDFE
FEFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEAE5DFD8D0C8BFB6ADA49C
958F8A8887888B90969DA5AEB7C0C9D1D9DFE6EBEFF2F6F9
FBFBFAFBFBF9F6F2EFEBE6DFD9D1C9C0B7AEA59D96908B88
87888A8F959CA4ADB6BFC8D0D8DFE5EAEFF3F6F8FAFCFDFE
FEFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F4F1ECE7E1DAD2C9BFB5AA9F958C
847D78757475787E858D97A1ABB6C0CAD2DAE1E8EDF0F4F8
FBFAF9FAFBF8F4F0EDE8E1DAD2CAC0B6ABA1978D857E7875
7475787D848C959FAAB5BFC9D2DAE1E7ECF1F4F7F9FBFCFD
FEFFFFFFFF
FFFFFFFFFEFDFCFAF8F6F3EFEAE4DDD4CBC1B6AA9E92867C
726A65616062656C747D88949FABB7C2CCD5DDE4EAEEF2F7
FAF9F8F9FAF7F2EEEAE4DDD5CCC2B7AB9F94887D746C6562
6061656A727C86929EAAB6C1CBD4DDE4EAEFF3F6F8FAFCFD
FEFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE7E0D8CFC5B9AD9F9284776B
6158524E4D4E5259626D798694A1AEBAC6D0D9E1E7ECF1F6
F9F8F7F8F9F6F1ECE7E1D9D0C6BAAEA19486796D6259524E
4D4E5258616B7784929FADB9C5CFD8E0E7EDF1F5F8FAFBFD
FEFFFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE4DDD4CABEB2A4958677695C
50463F3B3A3B4048525E6B798897A6B3C0CBD5DEE5EAEFF5
F9F8F6F8F9F5EFEAE5DED5CBC0B3A69788796B5E5248403B
3A3B3F46505C69778695A4B2BECAD4DDE4EBF0F4F7F9FBFC
FEFFFFFFFF
FFFFFFFEFDFCFBF9F6F2EEE9E2DAD0C5B9AB9C8C7C6B5C4D
41362E2A282A2F37424F5E6E7E8E9EACBAC6D1DBE2E8EEF4
F8F7F6F7F8F4EEE8E2DBD1C6BAAC9E8E7E6E5E4F42372F2A
282A2E36414D5C6B7C8C9CABB9C5D0DAE2E9EEF2F6F9FBFC
FDFEFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D7CDC1B4A5958472615041
33281F1A191B202935435263748697A6B5C2CED8E0E7ECF3
F7F6F5F6F7F3ECE7E0D8CEC2B5A69786746352433529201B
191A1F2833415061728495A5B4C1CDD7E0E7EDF2F5F8FAFC
FDFEFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DED5CABEAFA08F7D6A584636
281C130E0C0E141D2A38495B6D7F91A2B1BFCBD6DFE5EBF2
F7F6F4F6F7F2EBE5DFD6CBBFB1A2917F6D5B49382A1D140E
0C0E131C283646586A7D8FA0AFBECAD5DEE6ECF1F5F8FAFC
FDFEFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE5DDD3C8BBAC9C8A7865523F2E
1F130A0403050B1521314254677A8D9EAEBCC9D4DDE4EBF2
F7F5F4F5F7F2EBE4DDD4C9BCAE9E8D7A6754423121150B05
03040A131F2E3F5265788A9CACBBC8D3DDE5EBF0F4F7FAFB
FDFEFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD2C7BAAA9A8875614E3B2A
1A0E04000000060F1C2C3E5064778A9CACBBC8D3DDE4EAF1
F7F5F4F5F7F1EAE4DDD3C8BBAC9C8A7764503E2C1C0F0600
0000040E1A2A3B4E6175889AAABAC7D2DCE4EBF0F4F7FAFB
FDFEFFFFFF
FFFFFFFEFDFBF9F7F4F0EAE4DCD2C6B9AA998774604D3A28
190C03000000040E1B2B3C4F6376899BABBAC8D3DCE3EAF1
F6F5F3F5F6F1EAE3DCD3C8BAAB9B8976634F3C2B1B0E0400
0000030C19283A4D60748799AAB9C6D2DCE4EAF0F4F7F9FB
FDFEFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE4DCD2C7BAAB9A8875624E3B2A
1B0E0500000006101D2D3E5164778A9CACBBC8D4DDE4EAF1
F7F5F4F5F7F1EAE4DDD4C8BBAC9C8A7764513E2D1D100600
0000050E1B2A3B4E6275889AABBAC7D2DCE4EBF0F4F7FAFB
FDFEFFFFFF
FFFFFFFEFDFBFAF7F4F0EBE5DDD3C8BBAD9D8B786552402F
20140B0604060C1622324355687B8D9EAEBDC9D5DEE4EBF2
F7F6F4F6F7F2EBE4DED5C9BDAE9E8D7B6855433222160C06
04060B14202F405265788B9DADBBC8D3DDE5EBF0F4F7FAFB
FDFEFFFFFF
FFFFFFFEFDFCFAF8F5F1ECE6DED5CABEB0A0907E6C594838
291D150F0E10161F2B3A4A5C6E8092A2B1BFCCD6DFE5ECF2
F7F6F4F6F7F2ECE5DFD6CCBFB1A292806E5C4A3A2B1F1610
0E0F151D293848596C7E90A0B0BECAD5DEE6ECF1F5F8FAFC
FDFEFFFFFF
FFFFFFFEFDFCFAF8F5F2EDE7E0D7CDC2B4A6968574625242
352A211C1B1D222B37445465768798A7B6C3CED9E1E7EDF3
F8F6F5F6F8F3EDE7E1D9CEC3B6A7988776655444372B221D
1B1C212A35425262748596A6B4C2CDD7E0E7EDF2F5F8FAFC
FDFEFFFFFF
FFFFFFFEFDFCFBF9F6F3EEE9E2DAD1C6B9AC9D8D7D6D5E4F
4338312C2B2D323A4451606F7F8F9FADBBC7D2DBE3E9EEF4
F8F7F6F7F8F4EEE9E3DBD2C7BBAD9F8F7F6F6051443A322D
2B2C3138434F5E6D7D8D9DACB9C6D1DAE2E9EEF3F6F9FBFC
FDFEFFFFFF
FFFFFFFFFEFCFBF9F7F4F0EBE5DDD5CBBFB3A59788796B5E
5249423E3C3E434A54606D7B8A98A7B4C0CCD6DEE5EAEFF5
F9F8F6F8F9F5EFEAE5DED6CCC0B4A7988A7B6D60544A433E
3C3E4249525E6B798897A5B3BFCBD5DDE5EBF0F4F7F9FBFC
FEFFFFFFFF
FFFFFFFFFEFDFBFAF8F5F1EDE7E1D9D0C5BAAEA19486796E
635B54504F51555C656F7B8895A2AFBBC7D1DAE1E8ECF1F6
F9F9F7F9F9F6F1ECE8E1DAD1C7BBAFA295887B6F655C5551
4F50545B636E798694A1AEBAC5D0D9E1E7EDF1F5F8FAFBFD
FEFFFFFFFF
FFFFFFFFFEFDFCFAF9F6F3EFEAE4DDD5CCC2B7AB9F94887E
746D67646364686E767F8A95A1ADB8C3CDD6DEE5EAEFF3F7
FAF9F8F9FAF7F3EFEAE5DED6CDC3B8ADA1958A7F766E6864
6364676D747E88949FABB7C2CCD5DDE4EAEFF3F6F9FAFCFD
FEFFFFFFFF
FFFFFFFFFEFDFCFBF9F7F4F1EDE7E1DAD2C9C0B6ABA1978E
867F7A7776777B80878F98A2ADB7C1CBD3DBE2E8EDF1F4F8
FBFAF9FAFBF8F4F1EDE8E2DBD3CBC1B7ADA2988F87807B77
76777A7F868E97A1ABB6C0C9D2DAE1E7EDF1F4F7F9FBFCFD
FEFFFFFFFF
FFFFFFFFFEFEFDFCFAF8F6F3EFEBE6DFD9D1C9C0B7AEA69E
97918D8A898A8D92989FA7AFB8C1CAD2D9E0E6EBF0F3F6F9
FBFBFAFBFBF9F6F3F0EBE6E0D9D2CAC1B8AFA79F98928D8A
898A8D91979EA6AEB7C0C9D1D9DFE6EBEFF3F6F8FAFCFDFE
FEFFFFFFFF
FFFFFFFFFEFEFDFCFBF9F7F5F2EEE9E4DED8D1CAC2BAB3AC
A6A29E9C9B9C9EA2A7ADB4BBC3CBD2D9DFE5EAEEF2F5F7FA
FCFCFBFCFCFAF7F5F2EEEAE5DFD9D2CBC3BBB4ADA7A29E9C
9B9C9EA2A6ACB3BAC2CAD1D8DEE4E9EEF2F5F7F9FBFCFDFE
FEFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF9F7F4F1EDE9E4DED9D2CCC6C0BA
B5B1AEACACACAEB1B6BBC0C7CDD3D9DFE4E9EDF1F4F6F9FB
FDFCFCFCFDFBF9F6F4F1EDE9E4DFD9D3CDC7C0BBB6B1AEAC
ACACAEB1B5BAC0C6CCD2D9DEE4E9EDF1F4F7F9FAFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E4DFDAD5D0CBC6
C2BFBCBBBABBBDBFC3C7CCD1D6DBE0E5E9EDF1F4F6F8FAFC
FDFDFCFDFDFCFAF8F6F4F1EDE9E5E0DBD6D1CCC7C3BFBDBB
BABBBCBFC2C6CBD0D5DADFE4E9EDF0F3F6F8FAFBFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0EDE9E6E1DDD9D5D1
CECBC9C8C7C8C9CBCED2D5DADEE2E6EAEDF1F3F6F8F9FBFC
FEFDFDFDFEFCFBF9F8F6F3F1EDEAE6E2DEDAD5D2CECBC9C8
C7C8C9CBCED1D5D9DDE1E6E9EDF0F3F6F8FAFBFCFDFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFEFDFCFBF9F8F6F3F1EEEBE7E4E1DDDA
D8D6D4D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F6F8F9FBFCFD
FEFEFDFEFEFDFCFBF9F8F6F4F1EEEBE8E5E1DEDBD8D6D4D3
D3D3D4D6D8DADDE1E4E7EBEEF1F3F6F8F9FBFCFDFEFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFDFCFBF9F8F6F4F2EFEDEAE7E5E2
E0DFDDDDDCDDDDDFE1E3E5E8EAEDF0F2F4F6F8FAFBFCFDFE
FEFEFEFEFEFEFDFCFBFAF8F6F4F2F0EDEAE8E5E3E1DFDDDD
DCDDDDDFE0E2E5E7EAEDEFF2F4F6F8F9FBFCFDFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9
E7E6E5E4E4E5E5E6E8E9EBEDEFF1F3F5F7F8FAFBFCFDFDFE
FFFEFEFEFFFEFDFDFCFBFAF8F7F5F3F1EFEDEBE9E8E6E5E5
E4E4E5E6E7E9EBEDEFF1F3F5F7F8FAFBFCFDFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F4F3F1F0EE
EDECEBEBEBEBEBECEDEFF0F1F3F5F6F7F9FAFBFCFDFDFEFE
FFFFFFFFFFFEFEFDFDFCFBFAF9F7F6F5F3F1F0EFEDECEBEB
EBEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3
F2F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFF
FFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6F5F4F3F2F1F0F0
F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8F8F7F6
F5F5F4F4F4F4F4F5F5F6F7F8F9F9FAFBFCFCFDFEFEFEFFFF
FFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9F9F8F7F6F5F5F4F4
F4F4F4F5F5F6F7F8F8F9FAFBFCFCFDFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9
F8F8F7F7F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFDFCFCFBFAFAF9F9F8F8F7F7
F7F7F7F8F8F9F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFB
FAFAFAFAF9FAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFBFAFAFAFA
F9FAFAFAFAFBFBFBFCFCFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFC
FCFCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFBFB
FBFBFBFCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFD
FDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFDFD
FDFDFDFDFDFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FEFEFEFDFDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFD
FDFDFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; animationSpeed = 0; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 10.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 10.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFE
FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFD
FDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFD
FDFCFCFCFCFBFBFBFBFCFCFCFCFCFDFDFDFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFCFCFCFCFCFBFBFBFB
FCFCFCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAF9F9F9F9FAFAFAFAFBFBFCFCFDFDFEFEFEFEFF
FFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFAFAFAF9F9F9F9
FAFAFAFBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
F9F9F8F8F7F7F7F7F7F7F7F8F8F9FAFAFBFCFCFDFDFEFEFE
FFFFFEFFFFFEFEFEFDFDFCFCFBFAFAF9F8F8F7F7F7F7F7F7
F7F8F8F9F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFAF9F8
F7F6F5F5F4F4F4F3F4F4F4F5F6F7F7F8F9FAFBFCFCFDFDFE
FFFEFEFEFFFEFDFDFCFCFBFAF9F8F7F7F6F5F4F4F4F3F4F4
F4F5F5F6F7F8F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFAF9F8F7F5
F4F3F2F1F0F0EFEFEFF0F0F1F2F3F5F6F7F8F9FAFBFCFDFD
FEFEFEFEFEFDFDFCFBFAF9F8F7F6F5F3F2F1F0F0EFEFEFF0
F0F1F2F3F4F5F7F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF8F7F5F4F2
F0EFEDECEBEAEAEAEAEBEBEDEEEFF1F3F4F6F7F9FAFBFCFD
FEFDFDFDFEFDFCFBFAF9F7F6F4F3F1EFEEEDEBEBEAEAEAEA
EBECEDEFF0F2F4F5F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F8F6F4F2F0EE
ECEAE8E6E5E4E3E3E3E4E5E7E8EAECEEF1F3F5F6F8F9FAFC
FDFDFCFDFDFCFAF9F8F6F5F3F1EEECEAE8E7E5E4E3E3E3E4
E5E6E8EAECEEF0F2F4F6F8F9FAFBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1EEECE9
E6E3E1DFDDDCDBDBDBDCDEDFE2E4E7EAECEFF1F4F6F7F9FB
FDFCFBFCFDFBF9F7F6F4F1EFECEAE7E4E2DFDEDCDBDBDBDC
DDDFE1E3E6E9ECEEF1F3F5F7F9FAFBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F7F5F3F0EDEAE6E3
DFDCD9D6D4D2D1D1D1D3D4D7DADDE0E4E7EAEEF1F3F5F7FA
FCFBFAFBFCFAF7F5F3F1EEEAE7E4E0DDDAD7D4D3D1D1D1D2
D4D6D9DCDFE3E6EAEDF0F3F5F7F9FAFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EFECE8E4E0DB
D7D3CFCCC9C7C6C5C6C7CACCD0D4D8DDE1E5E9EDF0F2F5F8
FBFAF8FAFBF8F5F2F0EDE9E5E1DDD8D4D0CCCAC7C6C5C6C7
C9CCCFD3D7DBE0E4E8ECEFF2F5F7F9FBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F5F3EFECE7E3DED8D3
CEC8C4C0BCBAB8B8B8BABDC1C5CACFD4DADFE4E9ECEFF2F7
FAF8F7F8FAF7F2EFECE9E4DFDAD4CFCAC5C1BDBAB8B8B8BA
BCC0C4C8CED3D8DEE3E7ECEFF3F5F8FAFBFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFDFBFAF8F6F3F0ECE7E2DDD7D0CA
C3BDB7B2AEABA9A9A9ACAFB3B9BEC5CBD2D8DEE4E8ECEFF5
F9F7F5F7F9F5EFECE8E4DED8D2CBC5BEB9B3AFACA9A9A9AB
AEB2B7BDC3CAD0D7DDE2E7ECF0F3F6F8FAFBFDFDFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F4F1EDE8E3DDD6CFC7BF
B7B0A9A39E9A9898999B9FA5ABB2B9C1C9D0D7DFE4E8ECF3
F7F5F3F5F7F3ECE8E4DFD7D0C9C1B9B2ABA59F9B9998989A
9EA3A9B0B7BFC7CFD6DDE3E8EDF1F4F7F9FBFCFDFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7CFC6BDB4
ABA29A938D898686878A8F959CA4ADB6BFC8D1D9DFE4E9F0
F6F3F1F3F6F0E9E4DFD9D1C8BFB6ADA49C958F8A87868689
8D939AA2ABB4BDC6CFD7DEE4EAEEF2F5F8FAFBFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F0ECE6E0D8D0C7BDB3A8
9D938A827B76737374777D848C96A0ABB5BFC9D3DADFE5EE
F5F1EEF1F5EEE5DFDAD3C9BFB5ABA0968C847D7774737376
7B828A939DA8B3BDC7D0D8E0E6ECF0F4F7F9FBFCFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F5F2EEE9E3DBD3CABFB4A89C
90847A706963605F61656B737D87939FABB6C2CCD5DBE2EC
F3EFECEFF3ECE2DBD5CCC2B6AB9F93877D736B65615F6063
69707A84909CA8B4BFCAD3DBE3E9EEF2F5F8FAFCFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBF9F7F4F0ECE6DFD7CEC3B7AB9D90
8275695F57504D4C4D5259626D798693A1ADBAC6D0D7DEE9
F2EDE9EDF2E9DED7D0C6BAADA19386796D6259524D4C4D50
575F697582909DABB7C3CED7DFE6ECF0F4F7F9FBFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F6F3EFEAE3DCD3C8BDB0A29384
75675A4E453E3A393B4048525D6B798897A5B3C0CBD2DBE7
F0EBE7EBF0E7DBD2CBC0B3A59788796B5D5248403B393A3E
454E5A67758493A2B0BDC8D3DCE3EAEFF3F6F9FBFCFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F2EDE8E1D9CFC4B7A99A8A7A
695A4C3F352D29282A2F38434F5E6E7E8E9DACBBC6CED8E5
EFEAE5EAEFE5D8CEC6BBAC9D8E7E6E5E4F43382F2A28292D
353F4C5A697A8A9AA9B7C4CFD9E1E8EDF2F5F8FAFCFDFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1ECE6DFD6CCC0B2A3938270
5F4E3F32271F1A191B212A35435364758696A7B6C2CBD5E3
EEE8E3E8EEE3D5CBC2B6A7968675645343352A211B191A1F
27323F4E5F708293A3B2C0CCD6DFE6ECF1F5F8FAFCFDFEFF
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DDD4C9BCAE9E8D7B69
574535271B130E0D0F151E2B394A5B6E7F91A2B2BFC8D3E2
EDE7E2E7EDE2D3C8BFB2A2917F6E5B4A392B1E150F0D0E13
1B27354557697B8D9EAEBCC9D4DDE5EBF0F4F7FAFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4F0EAE4DCD2C7BAAB9A897663
503E2D1F130A0504060C1623324355687B8C9EAFBDC6D1E0
ECE6E1E6ECE0D1C6BDAF9E8C7B6855433223160C0604050A
131F2D3E506376899AABBAC7D2DCE4EAF0F4F7F9FBFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4EFEAE3DBD1C6B8A998867360
4D3A291A0E0500000107111E2E3F5265788A9CAEBBC5D0E0
ECE5E0E5ECE0D0C5BBAE9C8A7865523F2E1E110701000005
0E1A293A4D60738698A9B8C6D1DBE3EAEFF4F7F9FBFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F3EFEAE3DBD1C5B8A99886735F
4C3928190D0400000006101D2C3E516477899CADBBC5D0E0
EBE5E0E5EBE0D0C5BBAD9C897764513E2C1D100600000004
0D1928394C5F738698A9B8C5D1DBE3EAEFF3F7F9FBFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFBF9F7F4EFEAE3DBD1C6B8A999877461
4D3B2A1B0F0601000208121F2E405366788B9DAEBCC5D0E0
ECE5E0E5ECE0D0C5BCAE9D8B786653402E1F120802000106
0F1B2A3B4D61748799A9B8C6D1DBE3EAEFF4F7F9FBFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DCD3C7BAAC9B8A7765
52402F21150C0706080F18253445576A7C8D9FB0BDC7D1E1
ECE6E1E6ECE1D1C7BDB09F8D7C6A57453425180F0806070C
15212F405265778A9BACBAC7D3DCE4EBF0F4F7FAFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DED4CABDAF9F8F7D6B
5948382A1E1611101218212D3C4C5E708192A3B3C0C9D3E2
EDE7E2E7EDE2D3C9C0B3A39281705E4C3C2D211812101116
1E2A3848596B7D8F9FAFBDCAD4DEE5EBF0F4F7FAFCFDFEFE
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F5F1EDE7DFD7CCC1B3A5958473
625243352B231E1D1F252D39475666778898A8B7C3CCD6E4
EEE8E4E8EEE4D6CCC3B7A8988877665647392D251F1D1E23
2B35435262738495A5B3C1CCD7DFE7EDF1F5F8FAFCFDFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFDFCFAF8F6F2EEE8E2DAD0C5B9AB9C8C7D
6D5E504339322E2C2F343C4753627181909FAEBCC8CFD9E5
EFEAE6EAEFE5D9CFC8BCAE9F9081716253473C342F2C2E32
3943505E6D7D8C9CABB9C5D0DAE2E8EEF2F6F8FAFCFDFEFF
FFFFFFFFFF
FFFFFFFFFFFFFEFEFCFBF9F7F3EFEAE4DDD4CABEB2A49687
796B5E534A433F3E40454C56626F7D8B99A7B5C2CCD3DCE8
F0ECE8ECF0E8DCD3CCC2B5A7998B7D6F62564C45403E3F43
4A535E6B798796A4B2BECAD4DDE4EAEFF3F7F9FBFCFEFEFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFBFAF7F5F1ECE7E0D8CFC5B9ADA093
86796E645B55525152575E66717D8997A3B0BCC8D1D8DFEA
F2EEEAEEF2EADFD8D1C8BCB0A397897D71665E5752515255
5B646E798693A0ADB9C5CFD8E0E7ECF1F5F7FAFBFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFAF8F6F3EEE9E4DCD4CBC1B6AB9F
93887E756D68656466696F77818B97A2ADB8C4CED6DCE3EC
F3F0ECF0F3ECE3DCD6CEC4B8ADA2978B81776F6966646568
6D757E88939FABB6C1CBD4DCE4E9EEF3F6F8FAFCFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFDFCFBF9F7F4F1ECE7E1DAD2C9BFB5AB
A1978E86807B7877797C8188909AA4AEB8C1CBD4DBE0E6EF
F5F2EFF2F5EFE6E0DBD4CBC1B8AEA49A9088817C7977787B
80868E97A1ABB5BFC9D2DAE1E7ECF1F4F7F9FBFCFDFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEAE5DFD8D0C8BFB7
AEA59D97918D8B8A8B8E9398A0A8B0B9C1CAD2DAE0E5EAF1
F6F4F1F4F6F1EAE5E0DAD2CAC1B9B0A8A098938E8B8A8B8D
91979DA5AEB7BFC8D0D8DFE5EAEFF3F6F8FAFCFDFEFEFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFCFBF9F7F5F1EEE9E4DED7D0C9C1
BAB3ACA6A29E9C9C9D9FA3A8AEB5BCC3CBD2D9E0E5E9EDF3
F8F5F3F5F8F3EDE9E5E0D9D2CBC3BCB5AEA8A39F9D9C9C9E
A2A6ACB3BAC1C9D0D7DEE4E9EEF1F5F7F9FBFCFDFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFDFDFCFAF9F6F4F0EDE8E3DED8D2CC
C5BFBAB5B1AEACACADAFB2B6BBC1C7CDD3D9DFE5E9ECF0F5
F9F7F5F7F9F5F0ECE9E5DFD9D3CDC7C1BBB6B2AFADACACAE
B1B5BABFC5CCD2D8DEE3E8EDF0F4F6F9FAFCFDFDFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F6F3F0ECE8E4DFDAD5
CFCBC6C2BFBCBBBABBBDC0C3C7CCD1D6DBE0E5EAEDF0F3F7
FAF8F7F8FAF7F3F0EDEAE5E0DBD6D1CCC7C3C0BDBBBABBBC
BFC2C6CBCFD5DADFE4E8ECF0F3F6F8FAFBFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3F0EDE9E5E1DD
D8D4D1CDCBC9C8C7C8C9CCCED2D6DADEE2E6EAEEF1F3F5F9
FBFAF9FAFBF9F5F3F1EEEAE6E2DEDAD6D2CECCC9C8C7C8C9
CBCDD1D4D8DDE1E5E9EDF0F3F5F8F9FBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFDFCFBF9F7F5F3F0EDEAE7E4
E0DDDAD7D5D4D3D3D3D4D6D8DBDEE1E5E8EBEEF1F4F5F7FA
FCFBFAFBFCFAF7F5F4F1EEEBE8E5E1DEDBD8D6D4D3D3D3D4
D5D7DADDE0E4E7EAEDF0F3F5F7F9FBFCFDFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFAF9F8F6F4F1EFECEA
E7E4E2E0DEDDDCDCDCDDDFE0E3E5E8EAEDEFF2F4F6F7F9FB
FDFCFBFCFDFBF9F7F6F4F2EFEDEAE8E5E3E0DFDDDCDCDCDD
DEE0E2E4E7EAECEFF1F4F6F8F9FAFCFDFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFCFBF9F8F6F4F3F1EE
ECEAE9E7E6E5E4E4E4E5E6E7E9EBEDEFF1F3F5F7F8F9FAFC
FDFDFCFDFDFCFAF9F8F7F5F3F1EFEDEBE9E7E6E5E4E4E4E5
E6E7E9EAECEEF1F3F4F6F8F9FBFCFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF8F7F6F4F2
F1EFEEEDECEBEBEAEBEBECEDEEF0F1F3F4F6F7F9FAFBFCFD
FEFDFDFDFEFDFCFBFAF9F7F6F4F3F1F0EEEDECEBEBEAEBEB
ECEDEEEFF1F2F4F6F7F8FAFBFCFDFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFBFAF9F8F7F6
F4F3F2F1F1F0F0F0F0F0F1F2F3F4F5F6F7F8F9FAFBFCFDFE
FEFEFEFEFEFEFDFCFBFAF9F8F7F6F5F4F3F2F1F0F0F0F0F0
F1F1F2F3F4F6F7F8F9FAFBFCFDFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFDFCFCFBFAF9F8
F7F6F6F5F4F4F4F4F4F4F5F5F6F7F8F8F9FAFBFCFCFDFDFE
FFFEFEFEFFFEFDFDFCFCFBFAF9F8F8F7F6F5F5F4F4F4F4F4
F4F5F6F6F7F8F9FAFBFCFCFDFDFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFBFA
F9F9F8F8F7F7F7F7F7F7F7F8F8F9FAFAFBFCFCFDFDFEFEFE
FFFFFEFFFFFEFEFEFDFDFCFCFBFAFAF9F8F8F7F7F7F7F7F7
F7F8F8F9F9FAFBFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFDFCFC
FBFBFAFAFAF9F9F9F9F9FAFAFAFBFBFCFCFDFDFEFEFEFEFF
FFFFFFFFFFFFFEFEFEFEFDFDFCFCFBFBFAFAFAF9F9F9F9F9
FAFAFAFBFBFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFD
FCFCFCFCFBFBFBFBFBFBFBFCFCFCFDFDFDFDFEFEFEFEFFFF
FFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFCFCFCFBFBFBFBFBFB
FBFCFCFCFCFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFE
FDFDFDFDFDFCFCFCFCFDFDFDFDFDFDFEFEFEFEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFEFEFDFDFDFDFDFDFCFCFCFC
FDFDFDFDFDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FEFEFEFEFDFDFDFDFDFDFEFEFEFEFEFEFEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFDFDFDFDFD
FDFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; animationSpeed = 0; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 15.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 15.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE
FEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFDFDFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFDFDFDFDFDFDFDFD
FDFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFE
FDFDFDFDFCFCFCFCFBFBFBFBFBFCFCFCFCFDFDFDFEFEFEFF
FFFFFEFFFFFFFEFEFEFDFDFDFCFCFCFCFBFBFBFBFBFCFCFC
FCFDFDFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFBFBFAFAF9F9F9F9F9F9FAFAFAFBFBFCFCFDFDFDFE
FFFEFEFEFFFEFDFDFDFCFCFBFBFAFAFAF9F9F9F9F9F9FAFA
FBFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAFAF9F8F8F7F7F7F6F6F6F7F7F7F8F9F9FAFBFBFCFCFD
FEFDFDFDFEFDFCFCFBFBFAF9F9F8F7F7F7F6F6F6F7F7F7F8
F8F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFA
F9F8F8F7F6F5F4F4F3F3F3F3F3F4F4F5F6F7F8F9FAFAFBFC
FEFDFCFDFEFCFBFAFAF9F8F7F6F5F4F4F3F3F3F3F3F4F4F5
F6F7F8F8F9FAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF8
F7F6F5F3F2F1F0EFEFEEEEEFEFF0F1F2F3F4F5F7F8F8F9FB
FDFCFBFCFDFBF9F8F8F7F5F4F3F2F1F0EFEFEEEEEFEFF0F1
F2F3F5F6F7F8FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F6
F5F3F1F0EEECEBEAE9E9E9E9EAEBECEDEFF0F2F4F5F6F7FA
FCFAF9FAFCFAF7F6F5F4F2F0EFEDECEBEAE9E9E9E9EAEBEC
EEF0F1F3F5F6F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F5F3
F1EFEDEBE9E7E5E4E3E2E2E2E3E4E6E8E9EBEEF0F2F3F5F8
FBF9F7F9FBF8F5F3F2F0EEEBE9E8E6E4E3E2E2E2E3E4E5E7
E9EBEDEFF1F3F5F7F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F5F2F0
EDEAE8E5E2E0DDDCDADADADADBDCDEE1E3E6E9ECEEF0F2F6
FAF7F5F7FAF6F2F0EEECE9E6E3E1DEDCDBDADADADADCDDE0
E2E5E8EAEDF0F2F5F7F8FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF8F7F4F2EFEC
E8E5E1DEDAD7D4D2D1D0D0D0D1D3D6D9DBDFE3E7EAEBEEF4
F8F5F2F5F8F4EEEBEAE7E3DFDBD9D6D3D1D0D0D0D1D2D4D7
DADEE1E5E8ECEFF2F4F7F8FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFAF9F7F4F2EEEBE7
E3DEDAD5D1CDCAC7C5C4C4C4C6C8CBCFD3D7DCE1E5E6EAF1
F7F2EFF2F7F1EAE6E5E1DCD7D3CFCBC8C6C4C4C4C5C7CACD
D1D5DADEE3E7EBEEF2F4F7F9FAFCFDFDFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F5F2EEEAE6E1
DCD7D1CCC7C2BEBAB8B6B6B7B9BCBFC4C8CDD3DADFE1E5EE
F5EFEBEFF5EEE5E1DFDAD3CDC8C4BFBCB9B7B6B6B8BABEC2
C7CCD1D7DCE1E6EAEEF2F5F7F9FBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFCFBFAF8F5F2EFEBE6E1DB
D5CEC8C1BBB5B0ACA9A7A7A8AAADB2B8BDC3CAD2D8DAE0EA
F2EBE7EBF2EAE0DAD8D2CAC3BDB8B2ADAAA8A7A7A9ACB0B5
BBC1C8CED5DBE1E6EBEFF2F5F8FAFBFCFDFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3F0ECE7E1DBD4
CDC5BDB5AEA7A19C989796979A9EA4AAB0B7C0CAD0D3D9E6
F0E8E2E8F0E6D9D3D0CAC0B7B0AAA49E9A979697989CA1A7
AEB5BDC5CDD4DBE1E7ECF0F3F6F8FAFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFDFCFBF9F7F5F1EDE8E3DCD5CD
C4BBB2A8A098918B87858485888D949BA3ABB5C1C8CCD3E2
EDE4DDE4EDE2D3CCC8C1B5ABA39B948D88858485878B9198
A0A8B2BBC4CDD5DCE3E8EDF1F5F7F9FBFCFDFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F6F3EFEAE5DED7CEC5
BBB0A69B9188807974727173767C838C959EAAB7C0C4CCDE
EBDFD8DFEBDECCC4C0B7AA9E958C837C7673717274798088
919BA6B0BBC5CED7DEE5EAEFF3F6F8FAFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFBFAF8F5F1EDE8E1DAD1C8BD
B2A69A8E82786E67625F5E60646A737C86919EADB7BCC5D9
E8DBD2DBE8D9C5BCB7AD9E91867C736A64605E5F62676E78
828E9AA6B2BDC8D1DAE1E8EDF1F5F8FAFBFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFBF9F7F3F0EBE5DED5CCC1B5
A89B8E8073685D554F4C4B4D5158626D788493A3AEB4BED4
E5D7CDD7E5D4BEB4AEA39384786D6258514D4B4C4F555D68
73808E9BA8B5C1CCD5DEE5EBF0F3F7F9FBFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF8F6F2EEE9E2DAD1C7BBAE
A091827365584D443D39393B4047525E6A77889AA6ACB8D0
E2D2C8D2E2D0B8ACA69A88776A5E5247403B39393D444D58
65738291A0AEBBC7D1DAE2E9EEF2F6F8FBFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F1ECE7E0D7CDC2B5A7
98887868584A3E342D29282A2F3843515E6C7E929FA5B2CC
E0CFC3CFE0CCB2A59F927E6C5E5143382F2A28292D343E4A
5868788898A7B5C2CDD7E0E7ECF1F5F8FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE5DDD4CABEB0A1
91806E5D4D3E31261F1A1A1C212A37455362758A989FADC9
DECBBFCBDEC9AD9F988A75625345372A211C1A1A1F26313E
4D5D6E8091A1B0BECAD4DDE5EBF0F4F7FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCF9F7F4EFEAE4DCD2C7BAAC9C
8B7967554434261B130F0E1016202D3B4A5A6E84939AA8C6
DCC9BCC9DCC6A89A93846E5A4A3B2D2016100E0F131B2634
445567798B9CACBAC7D2DCE4EAEFF4F7F9FCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFE9E3DAD1C5B8A999
8774624F3D2D1F130B0605080E182534445469808F96A5C4
DBC7B9C7DBC4A5968F806954443425180E0805060B131F2D
3D4F62748799A9B8C5D1DAE3E9EFF3F7F9FBFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EEE9E2DAD0C4B6A796
85725F4C39291A0F06010003091321304051667D8D94A3C3
DAC6B8C6DAC3A3948D7D66514030211309030001060F1A29
394C5F728596A7B6C4D0DAE2E9EEF3F6F9FBFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EEE9E2DAD0C4B6A796
84715E4B3928190E050000020812202F3F50667D8C94A3C2
DAC5B8C5DAC2A3948C7D66503F2F201208020000050E1928
394B5E718496A7B6C4D0DAE2E9EEF3F6F9FBFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F6F3EFE9E2DAD0C4B7A897
8573604D3B2A1C10080302050B1522324152677E8E95A4C3
DAC6B8C6DAC3A4958E7E6752413222150B05020308101C2A
3B4D60738597A8B7C4D0DAE2E9EFF3F6F9FBFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFBF9F7F3EFEAE3DBD1C6B9AA9A
88766451403022160E09090B111B283746566B829198A6C5
DBC8BAC8DBC5A69891826B564637281B110B09090E162230
40516476889AAAB9C6D1DBE3EAEFF3F7F9FBFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F0EBE4DCD3C8BCAD9E
8D7C6A5848382B20181312151B24313F4E5D7187959CAAC7
DDCABDCADDC7AA9C9587715D4E3F31241B15121318202B38
48586A7C8D9EADBCC8D3DCE4EBF0F4F7FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF7F4F1ECE6DED6CBBFB2A3
948372625243362C24201F2227303C4A5766798D9BA1AFCA
DECDC1CDDECAAFA19B8D7966574A3C3027221F20242C3643
5262728394A3B2BFCBD6DEE6ECF1F4F7FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EDE7E1D8CFC4B7AA
9B8C7C6C5E50443A34302F31363E495663718295A2A8B4CE
E1D0C5D0E1CEB4A8A29582716356493E36312F30343A4450
5E6C7C8C9BAAB7C4CFD8E1E7EDF2F5F8FAFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F3EFE9E3DCD3C9BDB1
A39587786B5E544B44414042474E5864707C8C9EA9AFBAD2
E3D4CAD4E3D2BAAFA99E8C7C7064584E47424041444B545E
6B788795A3B1BDC9D3DCE3E9EFF3F6F9FBFCFDFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFDFBF9F7F4F0ECE6DFD7CEC4B8
AC9F9285796E645C56535254585F68737E8998A7B2B7C1D6
E6D8CFD8E6D6C1B7B2A798897E73685F58545253565C646E
7985929FACB8C4CED7DFE6ECF0F4F7F9FBFDFEFEFEFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFAF8F5F2EEE9E3DCD3CAC0
B5AA9E93887E756E696665676B7179828C96A3B1BABFC8DB
E9DDD4DDE9DBC8BFBAB1A3968C8279716B676566696E757E
88939EAAB5C0CAD3DCE3E9EEF2F5F8FAFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F6F4F0EBE6E0D9D1C8
BEB4AAA0978E86807B79787A7D8289929AA3AEBBC3C7CFDF
ECE1DAE1ECDFCFC7C3BBAEA39A9289827D7A78797B80868E
97A0AAB4BEC8D1D9E0E6EBF0F4F6F9FBFCFDFEFEFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFBFAF8F5F2EEEAE4DED7CF
C7BFB6ADA59D96918D8B8B8C8F9399A1A8AFB9C4CBCED5E4
EEE5DFE5EEE4D5CECBC4B9AFA8A199938F8C8B8B8D91969D
A5ADB6BFC7CFD7DEE4EAEEF2F5F8FAFBFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F7F4F1EDE8E3DDD6
CFC8C1B9B2ACA6A19E9C9C9D9FA3A9AFB5BBC4CDD3D6DCE8
F1E9E4E9F1E8DCD6D3CDC4BBB5AFA9A39F9D9C9C9EA1A6AC
B2B9C1C8CFD6DDE3E8EDF1F4F7F9FBFCFDFEFEFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFDFDFBFAF8F6F3F0ECE8E3DD
D7D1CBC5BFB9B4B1AEACACADAFB2B6BCC1C6CDD5DADCE1EC
F3EDE8EDF3ECE1DCDAD5CDC6C1BCB6B2AFADACACAEB1B4B9
BFC5CBD1D7DDE3E8ECF0F3F6F8FAFBFDFDFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBF9F8F5F3EFECE8E3
DED9D4CFCAC5C1BEBCBBBABBBDBFC3C7CCD0D6DCE0E2E7EF
F5F0ECF0F5EFE7E2E0DCD6D0CCC7C3BFBDBBBABBBCBEC1C5
CACFD4D9DEE3E8ECEFF3F5F8F9FBFCFDFEFEFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFDFDFCFBF9F7F5F2EFECE8
E4E0DCD8D4D0CDCAC8C7C7C8C9CBCED2D5D9DEE3E6E8EBF2
F7F3F0F3F7F2EBE8E6E3DED9D5D2CECBC9C8C7C7C8CACDD0
D4D8DCE0E4E8ECEFF2F5F7F9FBFCFDFDFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F0ED
EAE6E3E0DCD9D7D5D3D2D2D3D4D5D8DBDDE0E4E8EBECEFF5
F9F5F3F5F9F5EFECEBE8E4E0DDDBD8D5D4D3D2D2D3D5D7D9
DCE0E3E6EAEDF0F3F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFDFCFBFAF9F7F5F3F1
EEECE9E6E4E1DFDEDCDCDCDCDDDEE0E2E5E7EAEDEFF0F3F7
FAF7F5F7FAF7F3F0EFEDEAE7E5E2E0DEDDDCDCDCDCDEDFE1
E4E6E9ECEEF1F3F5F7F9FAFBFCFDFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F7F6F4
F2F0EEECEAE8E6E5E4E4E3E4E4E6E7E9EAECEFF1F3F4F5F9
FBF9F8F9FBF9F5F4F3F1EFECEAE9E7E6E4E4E3E4E4E5E6E8
EAECEEF0F2F4F6F7F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFBFAF9F8F7
F5F4F2F0EFEDECEBEAEAEAEAEBECEDEEEFF1F3F4F6F6F8FA
FCFBF9FBFCFAF8F6F6F4F3F1EFEEEDECEBEAEAEAEAEBECED
EFF0F2F4F5F7F8F9FAFBFCFDFEFEFEFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFCFCFBFAF9
F8F6F5F4F3F2F1F0F0EFEFEFF0F0F1F2F3F4F6F7F8F9FAFC
FDFCFBFCFDFCFAF9F8F7F6F4F3F2F1F0F0EFEFEFF0F0F1F2
F3F4F5F6F8F9FAFBFCFCFDFEFEFEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFBFA
FAF9F8F7F6F5F5F4F4F3F3F3F4F4F5F6F6F7F8F9FAFAFBFD
FEFDFCFDFEFDFBFAFAF9F8F7F6F6F5F4F4F3F3F3F4F4F5F5
F6F7F8F9FAFAFBFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFDFCFC
FBFAFAF9F8F8F7F7F7F7F6F7F7F7F8F8F9F9FAFBFBFCFCFD
FEFDFDFDFEFDFCFCFBFBFAF9F9F8F8F7F7F7F6F7F7F7F7F8
F8F9FAFAFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFDFD
FCFCFBFBFAFAFAF9F9F9F9F9F9F9FAFAFBFBFCFCFDFDFDFE
FFFEFEFEFFFEFDFDFDFCFCFBFBFAFAF9F9F9F9F9F9F9FAFA
FAFBFBFCFCFDFDFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFE
FDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFCFCFCFDFDFDFEFEFE
FFFEFEFEFFFEFEFEFDFDFDFCFCFCFBFBFBFBFBFBFBFBFBFC
FCFCFDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFE
FEFEFDFDFDFDFDFCFCFCFCFCFCFCFDFDFDFDFEFEFEFEFEFF
FFFFFFFFFFFFFEFEFEFEFEFDFDFDFDFCFCFCFCFCFCFCFDFD
FDFDFDFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFEFEFEFEFEFEFFFFFF
FFFFFFFFFFFFFFFFFEFEFEFEFEFEFDFDFDFDFDFDFDFDFDFE
FEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFEFEFEFEFEFEFE
FEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFEFEFEFEFEFEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFEFEFEFEFEFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; animationSpeed = 0; ]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00952018 0.0192308 0.00952018 [
[(0)] .01923  0 0 2 Msboxa
[(20)] .20963  0 0 2 Msboxa
[(40)] .40004  0 0 2 Msboxa
[(60)] .59044  0 0 2 Msboxa
[(80)] .78085  0 0 2 Msboxa
[(100)] .97125  0 0 2 Msboxa
[(0)] -0.0125 .01923  1 0 Msboxa
[(20)] -0.0125 .20963  1 0 Msboxa
[(40)] -0.0125 .40004  1 0 Msboxa
[(60)] -0.0125 .59044  1 0 Msboxa
[(80)] -0.0125 .78085  1 0 Msboxa
[(100)] -0.0125 .97125  1 0 Msboxa
[( 20.0)] .5  1 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002  w
.01923  0 m
.01923  .00625  L
s
P
[(0)] .01923  0 0 2 Mshowa
p
.002  w
.20963  0 m
.20963  .00625  L
s
P
[(20)] .20963  0 0 2 Mshowa
p
.002  w
.40004  0 m
.40004  .00625  L
s
P
[(40)] .40004  0 0 2 Mshowa
p
.002  w
.59044  0 m
.59044  .00625  L
s
P
[(60)] .59044  0 0 2 Mshowa
p
.002  w
.78085  0 m
.78085  .00625  L
s
P
[(80)] .78085  0 0 2 Mshowa
p
.002  w
.97125  0 m
.97125  .00625  L
s
P
[(100)] .97125  0 0 2 Mshowa
p
.001  w
.05731  0 m
.05731  .00375  L
s
P
p
.001  w
.09539  0 m
.09539  .00375  L
s
P
p
.001  w
.13347  0 m
.13347  .00375  L
s
P
p
.001  w
.17155  0 m
.17155  .00375  L
s
P
p
.001  w
.24772  0 m
.24772  .00375  L
s
P
p
.001  w
.2858  0 m
.2858  .00375  L
s
P
p
.001  w
.32388  0 m
.32388  .00375  L
s
P
p
.001  w
.36196  0 m
.36196  .00375  L
s
P
p
.001  w
.43812  0 m
.43812  .00375  L
s
P
p
.001  w
.4762  0 m
.4762  .00375  L
s
P
p
.001  w
.51428  0 m
.51428  .00375  L
s
P
p
.001  w
.55236  0 m
.55236  .00375  L
s
P
p
.001  w
.62852  0 m
.62852  .00375  L
s
P
p
.001  w
.6666  0 m
.6666  .00375  L
s
P
p
.001  w
.70468  0 m
.70468  .00375  L
s
P
p
.001  w
.74276  0 m
.74276  .00375  L
s
P
p
.001  w
.81893  0 m
.81893  .00375  L
s
P
p
.001  w
.85701  0 m
.85701  .00375  L
s
P
p
.001  w
.89509  0 m
.89509  .00375  L
s
P
p
.001  w
.93317  0 m
.93317  .00375  L
s
P
p
.002  w
0 0 m
1 0 L
s
P
p
.002  w
0 .01923  m
.00625  .01923  L
s
P
[(0)] -0.0125 .01923  1 0 Mshowa
p
.002  w
0 .20963  m
.00625  .20963  L
s
P
[(20)] -0.0125 .20963  1 0 Mshowa
p
.002  w
0 .40004  m
.00625  .40004  L
s
P
[(40)] -0.0125 .40004  1 0 Mshowa
p
.002  w
0 .59044  m
.00625  .59044  L
s
P
[(60)] -0.0125 .59044  1 0 Mshowa
p
.002  w
0 .78085  m
.00625  .78085  L
s
P
[(80)] -0.0125 .78085  1 0 Mshowa
p
.002  w
0 .97125  m
.00625  .97125  L
s
P
[(100)] -0.0125 .97125  1 0 Mshowa
p
.001  w
0 .05731  m
.00375  .05731  L
s
P
p
.001  w
0 .09539  m
.00375  .09539  L
s
P
p
.001  w
0 .13347  m
.00375  .13347  L
s
P
p
.001  w
0 .17155  m
.00375  .17155  L
s
P
p
.001  w
0 .24772  m
.00375  .24772  L
s
P
p
.001  w
0 .2858  m
.00375  .2858  L
s
P
p
.001  w
0 .32388  m
.00375  .32388  L
s
P
p
.001  w
0 .36196  m
.00375  .36196  L
s
P
p
.001  w
0 .43812  m
.00375  .43812  L
s
P
p
.001  w
0 .4762  m
.00375  .4762  L
s
P
p
.001  w
0 .51428  m
.00375  .51428  L
s
P
p
.001  w
0 .55236  m
.00375  .55236  L
s
P
p
.001  w
0 .62852  m
.00375  .62852  L
s
P
p
.001  w
0 .6666  m
.00375  .6666  L
s
P
p
.001  w
0 .70468  m
.00375  .70468  L
s
P
p
.001  w
0 .74276  m
.00375  .74276  L
s
P
p
.001  w
0 .81893  m
.00375  .81893  L
s
P
p
.001  w
0 .85701  m
.00375  .85701  L
s
P
p
.001  w
0 .89509  m
.00375  .89509  L
s
P
p
.001  w
0 .93317  m
.00375  .93317  L
s
P
p
.002  w
0 0 m
0 1 L
s
P
P
p
p
.002  w
.01923  .99375  m
.01923  1 L
s
P
p
.002  w
.20963  .99375  m
.20963  1 L
s
P
p
.002  w
.40004  .99375  m
.40004  1 L
s
P
p
.002  w
.59044  .99375  m
.59044  1 L
s
P
p
.002  w
.78085  .99375  m
.78085  1 L
s
P
p
.002  w
.97125  .99375  m
.97125  1 L
s
P
p
.001  w
.05731  .99625  m
.05731  1 L
s
P
p
.001  w
.09539  .99625  m
.09539  1 L
s
P
p
.001  w
.13347  .99625  m
.13347  1 L
s
P
p
.001  w
.17155  .99625  m
.17155  1 L
s
P
p
.001  w
.24772  .99625  m
.24772  1 L
s
P
p
.001  w
.2858  .99625  m
.2858  1 L
s
P
p
.001  w
.32388  .99625  m
.32388  1 L
s
P
p
.001  w
.36196  .99625  m
.36196  1 L
s
P
p
.001  w
.43812  .99625  m
.43812  1 L
s
P
p
.001  w
.4762  .99625  m
.4762  1 L
s
P
p
.001  w
.51428  .99625  m
.51428  1 L
s
P
p
.001  w
.55236  .99625  m
.55236  1 L
s
P
p
.001  w
.62852  .99625  m
.62852  1 L
s
P
p
.001  w
.6666  .99625  m
.6666  1 L
s
P
p
.001  w
.70468  .99625  m
.70468  1 L
s
P
p
.001  w
.74276  .99625  m
.74276  1 L
s
P
p
.001  w
.81893  .99625  m
.81893  1 L
s
P
p
.001  w
.85701  .99625  m
.85701  1 L
s
P
p
.001  w
.89509  .99625  m
.89509  1 L
s
P
p
.001  w
.93317  .99625  m
.93317  1 L
s
P
p
.002  w
0 1 m
1 1 L
s
P
[( 20.0)] .5  1 0 -2 Mshowa
p
.002  w
.99375  .01923  m
1 .01923  L
s
P
p
.002  w
.99375  .20963  m
1 .20963  L
s
P
p
.002  w
.99375  .40004  m
1 .40004  L
s
P
p
.002  w
.99375  .59044  m
1 .59044  L
s
P
p
.002  w
.99375  .78085  m
1 .78085  L
s
P
p
.002  w
.99375  .97125  m
1 .97125  L
s
P
p
.001  w
.99625  .05731  m
1 .05731  L
s
P
p
.001  w
.99625  .09539  m
1 .09539  L
s
P
p
.001  w
.99625  .13347  m
1 .13347  L
s
P
p
.001  w
.99625  .17155  m
1 .17155  L
s
P
p
.001  w
.99625  .24772  m
1 .24772  L
s
P
p
.001  w
.99625  .2858  m
1 .2858  L
s
P
p
.001  w
.99625  .32388  m
1 .32388  L
s
P
p
.001  w
.99625  .36196  m
1 .36196  L
s
P
p
.001  w
.99625  .43812  m
1 .43812  L
s
P
p
.001  w
.99625  .4762  m
1 .4762  L
s
P
p
.001  w
.99625  .51428  m
1 .51428  L
s
P
p
.001  w
.99625  .55236  m
1 .55236  L
s
P
p
.001  w
.99625  .62852  m
1 .62852  L
s
P
p
.001  w
.99625  .6666  m
1 .6666  L
s
P
p
.001  w
.99625  .70468  m
1 .70468  L
s
P
p
.001  w
.99625  .74276  m
1 .74276  L
s
P
p
.001  w
.99625  .81893  m
1 .81893  L
s
P
p
.001  w
.99625  .85701  m
1 .85701  L
s
P
p
.001  w
.99625  .89509  m
1 .89509  L
s
P
p
.001  w
.99625  .93317  m
1 .93317  L
s
P
p
.002  w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923  .01923  translate
.96154  .96154  scale
101 string
101 101 8 [101 0 0 101 0 0] {
	currentfile
	1 index
	readhexstring
	pop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF